/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.archive;

import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.models.ServiceId;
import org.signal.core.models.backup.BackupKey;
import org.signal.core.models.backup.MediaRootBackupKey;
import org.signal.core.models.backup.MessageBackupKey;
import org.signal.core.util.StringExtensionsKt;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.zkgroup.GenericServerPublicParams;
import org.signal.libsignal.zkgroup.backups.BackupAuthCredential;
import org.signal.libsignal.zkgroup.backups.BackupAuthCredentialRequest;
import org.signal.libsignal.zkgroup.backups.BackupAuthCredentialRequestContext;
import org.signal.libsignal.zkgroup.backups.BackupAuthCredentialResponse;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.archive.ArchiveCredentialPresentation;
import org.whispersystems.signalservice.api.archive.ArchiveGetBackupInfoResponse;
import org.whispersystems.signalservice.api.archive.ArchiveGetMediaItemsResponse;
import org.whispersystems.signalservice.api.archive.ArchiveKeyRotationLimitResponse;
import org.whispersystems.signalservice.api.archive.ArchiveMediaRequest;
import org.whispersystems.signalservice.api.archive.ArchiveMediaResponse;
import org.whispersystems.signalservice.api.archive.ArchiveServiceAccess;
import org.whispersystems.signalservice.api.archive.ArchiveServiceCredentialsResponse;
import org.whispersystems.signalservice.api.archive.ArchiveSetBackupIdRequest;
import org.whispersystems.signalservice.api.archive.ArchiveSetPublicKeyRequest;
import org.whispersystems.signalservice.api.archive.BatchArchiveMediaRequest;
import org.whispersystems.signalservice.api.archive.BatchArchiveMediaResponse;
import org.whispersystems.signalservice.api.archive.DeleteArchivedMediaRequest;
import org.whispersystems.signalservice.api.archive.GetArchiveCdnCredentialsResponse;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.push.AttachmentUploadForm;
import org.whispersystems.signalservice.internal.push.AuthCredentials;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001JB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018J*\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\r2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\"\u001a\u00020\u0010J \u0010#\u001a\b\u0012\u0004\u0012\u00020$0\r2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018J \u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018J \u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\r2\u0006\u0010)\u001a\u00020!J8\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\u0006\u0010)\u001a\u00020!2\u0006\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00102\n\b\u0002\u0010/\u001a\u0004\u0018\u000100J\"\u00101\u001a\b\u0012\u0004\u0012\u00020!0\r2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018J(\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000204030\r2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018J4\u00105\u001a\b\u0012\u0004\u0012\u0002060\r2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00182\u0006\u00107\u001a\u00020\u00142\b\u00108\u001a\u0004\u0018\u00010(J*\u00109\u001a\b\u0012\u0004\u0012\u00020:0\r2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00182\u0006\u0010;\u001a\u00020<J0\u00109\u001a\b\u0012\u0004\u0012\u00020=0\r2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00182\f\u0010>\u001a\b\u0012\u0004\u0012\u00020<03J0\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001a0\r2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00182\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A03J\"\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\r2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0018J\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\rJ\"\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\r2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J\u001a\u0010H\u001a\u00020I2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lorg/whispersystems/signalservice/api/archive/ArchiveApi;", "", "authWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "unauthWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;", "pushServiceSocket", "Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;)V", "backupServerPublicParams", "Lorg/signal/libsignal/zkgroup/GenericServerPublicParams;", "getServiceCredentials", "Lorg/whispersystems/signalservice/api/NetworkResult;", "Lorg/whispersystems/signalservice/api/archive/ArchiveServiceCredentialsResponse;", "currentTime", "", "getCdnReadCredentials", "Lorg/whispersystems/signalservice/api/archive/GetArchiveCdnCredentialsResponse;", "cdnNumber", "", "aci", "Lorg/signal/core/models/ServiceId$ACI;", "archiveServiceAccess", "Lorg/whispersystems/signalservice/api/archive/ArchiveServiceAccess;", "triggerBackupIdReservation", "", "messageBackupKey", "Lorg/signal/core/models/backup/MessageBackupKey;", "mediaRootBackupKey", "Lorg/signal/core/models/backup/MediaRootBackupKey;", "setPublicKey", "getMessageBackupUploadForm", "Lorg/whispersystems/signalservice/internal/push/AttachmentUploadForm;", "backupFileSize", "getBackupInfo", "Lorg/whispersystems/signalservice/api/archive/ArchiveGetBackupInfoResponse;", "refreshBackup", "deleteBackup", "getBackupResumableUploadUrl", "", "uploadForm", "uploadBackupFile", "resumableUploadUrl", "data", "Ljava/io/InputStream;", "dataLength", "progressListener", "Lorg/whispersystems/signalservice/api/messages/SignalServiceAttachment$ProgressListener;", "getMediaUploadForm", "debugGetUploadedMediaItemMetadata", "", "Lorg/whispersystems/signalservice/api/archive/ArchiveGetMediaItemsResponse$StoredMediaObject;", "getArchiveMediaItemsPage", "Lorg/whispersystems/signalservice/api/archive/ArchiveGetMediaItemsResponse;", "limit", "cursor", "copyAttachmentToArchive", "Lorg/whispersystems/signalservice/api/archive/ArchiveMediaResponse;", "item", "Lorg/whispersystems/signalservice/api/archive/ArchiveMediaRequest;", "Lorg/whispersystems/signalservice/api/archive/BatchArchiveMediaResponse;", "items", "deleteArchivedMedia", "mediaToDelete", "Lorg/whispersystems/signalservice/api/archive/DeleteArchivedMediaRequest$ArchivedMediaObject;", "getSvrBAuthorization", "Lorg/whispersystems/signalservice/internal/push/AuthCredentials;", "getKeyRotationLimit", "Lorg/whispersystems/signalservice/api/archive/ArchiveKeyRotationLimitResponse;", "getCredentialPresentation", "Lorg/whispersystems/signalservice/api/archive/ArchiveApi$CredentialPresentationData;", "getZkCredential", "Lorg/signal/libsignal/zkgroup/backups/BackupAuthCredential;", "CredentialPresentationData", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nArchiveApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArchiveApi.kt\norg/whispersystems/signalservice/api/archive/ArchiveApi\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,450:1\n1#2:451\n*E\n"})
public final class ArchiveApi {
    @NotNull
    private final SignalWebSocket.AuthenticatedWebSocket authWebSocket;
    @NotNull
    private final SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket;
    @NotNull
    private final PushServiceSocket pushServiceSocket;
    @NotNull
    private final GenericServerPublicParams backupServerPublicParams;

    public ArchiveApi(@NotNull SignalWebSocket.AuthenticatedWebSocket authWebSocket, @NotNull SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket, @NotNull PushServiceSocket pushServiceSocket) {
        Intrinsics.checkNotNullParameter((Object)authWebSocket, (String)"authWebSocket");
        Intrinsics.checkNotNullParameter((Object)unauthWebSocket, (String)"unauthWebSocket");
        Intrinsics.checkNotNullParameter((Object)pushServiceSocket, (String)"pushServiceSocket");
        this.authWebSocket = authWebSocket;
        this.unauthWebSocket = unauthWebSocket;
        this.pushServiceSocket = pushServiceSocket;
        this.backupServerPublicParams = new GenericServerPublicParams(this.pushServiceSocket.getConfiguration().getBackupServerPublicParams());
    }

    @NotNull
    public final NetworkResult<ArchiveServiceCredentialsResponse> getServiceCredentials(long currentTime) {
        long roundedToNearestDay = DurationKt.toDuration((long)Duration.getInWholeDays-impl((long)DurationKt.toDuration((long)currentTime, (DurationUnit)DurationUnit.MILLISECONDS)), (DurationUnit)DurationUnit.DAYS);
        long endTime = Duration.plus-LRDsOJo((long)roundedToNearestDay, (long)DurationKt.toDuration((int)7, (DurationUnit)DurationUnit.DAYS));
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/archives/auth?redemptionStartSeconds=" + Duration.getInWholeSeconds-impl((long)roundedToNearestDay) + "&redemptionEndSeconds=" + Duration.getInWholeSeconds-impl((long)endTime), null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.authWebSocket, request2, Reflection.getOrCreateKotlinClass(ArchiveServiceCredentialsResponse.class), 0L, 8, null);
    }

    @NotNull
    public final NetworkResult<GetArchiveCdnCredentialsResponse> getCdnReadCredentials(int cdnNumber, @NotNull ServiceId.ACI aci, @NotNull ArchiveServiceAccess<?> archiveServiceAccess) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter(archiveServiceAccess, (String)"archiveServiceAccess");
        return this.getCredentialPresentation(aci, archiveServiceAccess).map(ArchiveApi::getCdnReadCredentials$lambda$0).then(arg_0 -> ArchiveApi.getCdnReadCredentials$lambda$1(cdnNumber, this, arg_0));
    }

    @NotNull
    public final NetworkResult<Unit> triggerBackupIdReservation(@Nullable MessageBackupKey messageBackupKey, @Nullable MediaRootBackupKey mediaRootBackupKey, @NotNull ServiceId.ACI aci) {
        BackupAuthCredentialRequestContext backupAuthCredentialRequestContext;
        BackupAuthCredentialRequestContext backupAuthCredentialRequestContext2;
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        MessageBackupKey messageBackupKey2 = messageBackupKey;
        if (messageBackupKey2 != null) {
            MessageBackupKey it = messageBackupKey2;
            boolean bl = false;
            backupAuthCredentialRequestContext2 = BackupAuthCredentialRequestContext.create((byte[])messageBackupKey.getValue(), (UUID)aci.getRawUuid());
        } else {
            backupAuthCredentialRequestContext2 = null;
        }
        BackupAuthCredentialRequestContext messageBackupRequestContext = backupAuthCredentialRequestContext2;
        MediaRootBackupKey mediaRootBackupKey2 = mediaRootBackupKey;
        if (mediaRootBackupKey2 != null) {
            MediaRootBackupKey it = mediaRootBackupKey2;
            boolean bl = false;
            backupAuthCredentialRequestContext = BackupAuthCredentialRequestContext.create((byte[])mediaRootBackupKey.getValue(), (UUID)aci.getRawUuid());
        } else {
            backupAuthCredentialRequestContext = null;
        }
        BackupAuthCredentialRequestContext mediaBackupRequestContext = backupAuthCredentialRequestContext;
        BackupAuthCredentialRequestContext backupAuthCredentialRequestContext3 = messageBackupRequestContext;
        BackupAuthCredentialRequestContext backupAuthCredentialRequestContext4 = mediaBackupRequestContext;
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v1/archives/backupid", new ArchiveSetBackupIdRequest((BackupAuthCredentialRequest)(backupAuthCredentialRequestContext3 != null ? backupAuthCredentialRequestContext3.getRequest() : null), (BackupAuthCredentialRequest)(backupAuthCredentialRequestContext4 != null ? backupAuthCredentialRequestContext4.getRequest() : null)), null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<Unit> setPublicKey(@NotNull ServiceId.ACI aci, @NotNull ArchiveServiceAccess<?> archiveServiceAccess) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter(archiveServiceAccess, (String)"archiveServiceAccess");
        return this.getCredentialPresentation(aci, archiveServiceAccess).then(arg_0 -> ArchiveApi.setPublicKey$lambda$4(this, arg_0));
    }

    @NotNull
    public final NetworkResult<AttachmentUploadForm> getMessageBackupUploadForm(@NotNull ServiceId.ACI aci, @NotNull ArchiveServiceAccess<MessageBackupKey> archiveServiceAccess, long backupFileSize) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter(archiveServiceAccess, (String)"archiveServiceAccess");
        return this.getCredentialPresentation(aci, archiveServiceAccess).map(ArchiveApi::getMessageBackupUploadForm$lambda$5).then(arg_0 -> ArchiveApi.getMessageBackupUploadForm$lambda$6(backupFileSize, this, arg_0));
    }

    @NotNull
    public final NetworkResult<ArchiveGetBackupInfoResponse> getBackupInfo(@NotNull ServiceId.ACI aci, @NotNull ArchiveServiceAccess<?> archiveServiceAccess) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter(archiveServiceAccess, (String)"archiveServiceAccess");
        return this.getCredentialPresentation(aci, archiveServiceAccess).map(ArchiveApi::getBackupInfo$lambda$7).then(arg_0 -> ArchiveApi.getBackupInfo$lambda$8(this, arg_0));
    }

    @NotNull
    public final NetworkResult<Unit> refreshBackup(@NotNull ServiceId.ACI aci, @NotNull ArchiveServiceAccess<?> archiveServiceAccess) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter(archiveServiceAccess, (String)"archiveServiceAccess");
        return this.getCredentialPresentation(aci, archiveServiceAccess).map(ArchiveApi::refreshBackup$lambda$9).then(arg_0 -> ArchiveApi.refreshBackup$lambda$10(this, arg_0));
    }

    @NotNull
    public final NetworkResult<Unit> deleteBackup(@NotNull ServiceId.ACI aci, @NotNull ArchiveServiceAccess<?> archiveServiceAccess) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter(archiveServiceAccess, (String)"archiveServiceAccess");
        return this.getCredentialPresentation(aci, archiveServiceAccess).map(ArchiveApi::deleteBackup$lambda$11).then(arg_0 -> ArchiveApi.deleteBackup$lambda$12(this, arg_0));
    }

    @NotNull
    public final NetworkResult<String> getBackupResumableUploadUrl(@NotNull AttachmentUploadForm uploadForm) {
        Intrinsics.checkNotNullParameter((Object)uploadForm, (String)"uploadForm");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.getBackupResumableUploadUrl$lambda$13(this, uploadForm));
    }

    @NotNull
    public final NetworkResult<Unit> uploadBackupFile(@NotNull AttachmentUploadForm uploadForm, @NotNull String resumableUploadUrl, @NotNull InputStream data, long dataLength, @Nullable SignalServiceAttachment.ProgressListener progressListener) {
        Intrinsics.checkNotNullParameter((Object)uploadForm, (String)"uploadForm");
        Intrinsics.checkNotNullParameter((Object)resumableUploadUrl, (String)"resumableUploadUrl");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.uploadBackupFile$lambda$14(this, uploadForm, resumableUploadUrl, data, dataLength, progressListener));
    }

    public static /* synthetic */ NetworkResult uploadBackupFile$default(ArchiveApi archiveApi, AttachmentUploadForm attachmentUploadForm, String string, InputStream inputStream, long l, SignalServiceAttachment.ProgressListener progressListener, int n, Object object) {
        if ((n & 0x10) != 0) {
            progressListener = null;
        }
        return archiveApi.uploadBackupFile(attachmentUploadForm, string, inputStream, l, progressListener);
    }

    @NotNull
    public final NetworkResult<AttachmentUploadForm> getMediaUploadForm(@NotNull ServiceId.ACI aci, @NotNull ArchiveServiceAccess<MediaRootBackupKey> archiveServiceAccess) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter(archiveServiceAccess, (String)"archiveServiceAccess");
        return this.getCredentialPresentation(aci, archiveServiceAccess).map(ArchiveApi::getMediaUploadForm$lambda$15).then(arg_0 -> ArchiveApi.getMediaUploadForm$lambda$16(this, arg_0));
    }

    @NotNull
    public final NetworkResult<List<ArchiveGetMediaItemsResponse.StoredMediaObject>> debugGetUploadedMediaItemMetadata(@NotNull ServiceId.ACI aci, @NotNull ArchiveServiceAccess<MediaRootBackupKey> archiveServiceAccess) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter(archiveServiceAccess, (String)"archiveServiceAccess");
        return NetworkResult.Companion.fromFetch(() -> ArchiveApi.debugGetUploadedMediaItemMetadata$lambda$17(this, aci, archiveServiceAccess));
    }

    @NotNull
    public final NetworkResult<ArchiveGetMediaItemsResponse> getArchiveMediaItemsPage(@NotNull ServiceId.ACI aci, @NotNull ArchiveServiceAccess<MediaRootBackupKey> archiveServiceAccess, int limit, @Nullable String cursor) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter(archiveServiceAccess, (String)"archiveServiceAccess");
        return this.getCredentialPresentation(aci, archiveServiceAccess).map(ArchiveApi::getArchiveMediaItemsPage$lambda$18).then(arg_0 -> ArchiveApi.getArchiveMediaItemsPage$lambda$19(limit, cursor, this, arg_0));
    }

    @NotNull
    public final NetworkResult<ArchiveMediaResponse> copyAttachmentToArchive(@NotNull ServiceId.ACI aci, @NotNull ArchiveServiceAccess<MediaRootBackupKey> archiveServiceAccess, @NotNull ArchiveMediaRequest item) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter(archiveServiceAccess, (String)"archiveServiceAccess");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.getCredentialPresentation(aci, archiveServiceAccess).map(ArchiveApi::copyAttachmentToArchive$lambda$20).then(arg_0 -> ArchiveApi.copyAttachmentToArchive$lambda$21(item, this, arg_0));
    }

    @NotNull
    public final NetworkResult<BatchArchiveMediaResponse> copyAttachmentToArchive(@NotNull ServiceId.ACI aci, @NotNull ArchiveServiceAccess<MediaRootBackupKey> archiveServiceAccess, @NotNull List<ArchiveMediaRequest> items) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter(archiveServiceAccess, (String)"archiveServiceAccess");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        return this.getCredentialPresentation(aci, archiveServiceAccess).map(ArchiveApi::copyAttachmentToArchive$lambda$22).then(arg_0 -> ArchiveApi.copyAttachmentToArchive$lambda$23(items, this, arg_0));
    }

    @NotNull
    public final NetworkResult<Unit> deleteArchivedMedia(@NotNull ServiceId.ACI aci, @NotNull ArchiveServiceAccess<MediaRootBackupKey> archiveServiceAccess, @NotNull List<DeleteArchivedMediaRequest.ArchivedMediaObject> mediaToDelete) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter(archiveServiceAccess, (String)"archiveServiceAccess");
        Intrinsics.checkNotNullParameter(mediaToDelete, (String)"mediaToDelete");
        return this.getCredentialPresentation(aci, archiveServiceAccess).map(ArchiveApi::deleteArchivedMedia$lambda$24).then(arg_0 -> ArchiveApi.deleteArchivedMedia$lambda$25(mediaToDelete, this, arg_0));
    }

    @NotNull
    public final NetworkResult<AuthCredentials> getSvrBAuthorization(@NotNull ServiceId.ACI aci, @NotNull ArchiveServiceAccess<MessageBackupKey> archiveServiceAccess) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter(archiveServiceAccess, (String)"archiveServiceAccess");
        return this.getCredentialPresentation(aci, archiveServiceAccess).map(ArchiveApi::getSvrBAuthorization$lambda$26).then(arg_0 -> ArchiveApi.getSvrBAuthorization$lambda$27(this, arg_0));
    }

    @NotNull
    public final NetworkResult<ArchiveKeyRotationLimitResponse> getKeyRotationLimit() {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/archives/backupid/limits", null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.authWebSocket, request2, Reflection.getOrCreateKotlinClass(ArchiveKeyRotationLimitResponse.class), 0L, 8, null);
    }

    private final NetworkResult<CredentialPresentationData> getCredentialPresentation(ServiceId.ACI aci, ArchiveServiceAccess<?> archiveServiceAccess) {
        return NetworkResult.Companion.fromLocal(() -> ArchiveApi.getCredentialPresentation$lambda$28(this, aci, archiveServiceAccess));
    }

    @NotNull
    public final BackupAuthCredential getZkCredential(@NotNull ServiceId.ACI aci, @NotNull ArchiveServiceAccess<?> archiveServiceAccess) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter(archiveServiceAccess, (String)"archiveServiceAccess");
        BackupAuthCredentialResponse backupAuthResponse = new BackupAuthCredentialResponse(archiveServiceAccess.getCredential().getCredential());
        BackupAuthCredentialRequestContext backupRequestContext = BackupAuthCredentialRequestContext.create((byte[])archiveServiceAccess.getBackupKey().getValue(), (UUID)aci.getRawUuid());
        BackupAuthCredential backupAuthCredential = backupRequestContext.receiveResponse(backupAuthResponse, Instant.ofEpochSecond(archiveServiceAccess.getCredential().getRedemptionTime()), this.backupServerPublicParams);
        Intrinsics.checkNotNullExpressionValue((Object)backupAuthCredential, (String)"receiveResponse(...)");
        return backupAuthCredential;
    }

    private static final Map getCdnReadCredentials$lambda$0(CredentialPresentationData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toArchiveCredentialPresentation().toHeaders();
    }

    private static final NetworkResult getCdnReadCredentials$lambda$1(int $cdnNumber, ArchiveApi this$0, Map headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get(WebSocketRequestMessage.Companion, "/v1/archives/auth/read?cdn=" + $cdnNumber, headers);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this$0.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(GetArchiveCdnCredentialsResponse.class), 0L, 8, null);
    }

    private static final NetworkResult setPublicKey$lambda$4(ArchiveApi this$0, CredentialPresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Map<String, String> headers = presentation.toArchiveCredentialPresentation().toHeaders();
        ECPublicKey publicKey = presentation.getPublicKey();
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put(WebSocketRequestMessage.Companion, "/v1/archives/keys", new ArchiveSetPublicKeyRequest(publicKey), headers);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this$0.unauthWebSocket, request2, 0L, 4, null);
    }

    private static final Map getMessageBackupUploadForm$lambda$5(CredentialPresentationData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toArchiveCredentialPresentation().toHeaders();
    }

    private static final NetworkResult getMessageBackupUploadForm$lambda$6(long $backupFileSize, ArchiveApi this$0, Map headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get(WebSocketRequestMessage.Companion, "/v1/archives/upload/form?uploadLength=" + $backupFileSize, headers);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this$0.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(AttachmentUploadForm.class), 0L, 8, null);
    }

    private static final Map getBackupInfo$lambda$7(CredentialPresentationData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toArchiveCredentialPresentation().toHeaders();
    }

    private static final NetworkResult getBackupInfo$lambda$8(ArchiveApi this$0, Map headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get(WebSocketRequestMessage.Companion, "/v1/archives", headers);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this$0.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(ArchiveGetBackupInfoResponse.class), 0L, 8, null);
    }

    private static final Map refreshBackup$lambda$9(CredentialPresentationData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toArchiveCredentialPresentation().toHeaders();
    }

    private static final NetworkResult refreshBackup$lambda$10(ArchiveApi this$0, Map headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post(WebSocketRequestMessage.Companion, "/v1/archives", null, headers);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this$0.unauthWebSocket, request2, 0L, 4, null);
    }

    private static final Map deleteBackup$lambda$11(CredentialPresentationData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toArchiveCredentialPresentation().toHeaders();
    }

    private static final NetworkResult deleteBackup$lambda$12(ArchiveApi this$0, Map headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.delete(WebSocketRequestMessage.Companion, "/v1/archives", headers);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this$0.unauthWebSocket, request2, 0L, 4, null);
    }

    private static final String getBackupResumableUploadUrl$lambda$13(ArchiveApi this$0, AttachmentUploadForm $uploadForm) {
        String string = this$0.pushServiceSocket.getResumableUploadUrl($uploadForm);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResumableUploadUrl(...)");
        return string;
    }

    private static final Unit uploadBackupFile$lambda$14(ArchiveApi this$0, AttachmentUploadForm $uploadForm, String $resumableUploadUrl, InputStream $data, long $dataLength, SignalServiceAttachment.ProgressListener $progressListener) {
        this$0.pushServiceSocket.uploadBackupFile($uploadForm, $resumableUploadUrl, $data, $dataLength, $progressListener);
        return Unit.INSTANCE;
    }

    private static final Map getMediaUploadForm$lambda$15(CredentialPresentationData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toArchiveCredentialPresentation().toHeaders();
    }

    private static final NetworkResult getMediaUploadForm$lambda$16(ArchiveApi this$0, Map headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get(WebSocketRequestMessage.Companion, "/v1/archives/media/upload/form", headers);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this$0.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(AttachmentUploadForm.class), 0L, 8, null);
    }

    private static final List debugGetUploadedMediaItemMetadata$lambda$17(ArchiveApi this$0, ServiceId.ACI $aci, ArchiveServiceAccess $archiveServiceAccess) {
        ArchiveGetMediaItemsResponse response;
        List mediaObjects = new ArrayList();
        String cursor = null;
        do {
            response = this$0.getArchiveMediaItemsPage($aci, $archiveServiceAccess, 10000, cursor).successOrThrow();
            CollectionsKt.addAll((Collection)mediaObjects, (Iterable)response.getStoredMediaObjects());
        } while ((cursor = response.getCursor()) != null);
        return mediaObjects;
    }

    private static final Map getArchiveMediaItemsPage$lambda$18(CredentialPresentationData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toArchiveCredentialPresentation().toHeaders();
    }

    private static final NetworkResult getArchiveMediaItemsPage$lambda$19(int $limit, String $cursor, ArchiveApi this$0, Map headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get(WebSocketRequestMessage.Companion, "/v1/archives/media?limit=" + $limit + (String)(StringExtensionsKt.isNotNullOrBlank((CharSequence)$cursor) ? "&cursor=" + $cursor : ""), headers);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this$0.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(ArchiveGetMediaItemsResponse.class), 0L, 8, null);
    }

    private static final Map copyAttachmentToArchive$lambda$20(CredentialPresentationData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toArchiveCredentialPresentation().toHeaders();
    }

    private static final NetworkResult copyAttachmentToArchive$lambda$21(ArchiveMediaRequest $item, ArchiveApi this$0, Map headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put(WebSocketRequestMessage.Companion, "/v1/archives/media", $item, headers);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this$0.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(ArchiveMediaResponse.class), 0L, 8, null);
    }

    private static final Map copyAttachmentToArchive$lambda$22(CredentialPresentationData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toArchiveCredentialPresentation().toHeaders();
    }

    private static final NetworkResult copyAttachmentToArchive$lambda$23(List $items, ArchiveApi this$0, Map headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put(WebSocketRequestMessage.Companion, "/v1/archives/media/batch", new BatchArchiveMediaRequest($items), headers);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this$0.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(BatchArchiveMediaResponse.class), 0L, 8, null);
    }

    private static final Map deleteArchivedMedia$lambda$24(CredentialPresentationData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toArchiveCredentialPresentation().toHeaders();
    }

    private static final NetworkResult deleteArchivedMedia$lambda$25(List $mediaToDelete, ArchiveApi this$0, Map headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post(WebSocketRequestMessage.Companion, "/v1/archives/media/delete", new DeleteArchivedMediaRequest($mediaToDelete), headers);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA(this$0.unauthWebSocket, request2, DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS));
    }

    private static final Map getSvrBAuthorization$lambda$26(CredentialPresentationData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toArchiveCredentialPresentation().toHeaders();
    }

    private static final NetworkResult getSvrBAuthorization$lambda$27(ArchiveApi this$0, Map headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get(WebSocketRequestMessage.Companion, "/v1/archives/auth/svrb", headers);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this$0.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(AuthCredentials.class), 0L, 8, null);
    }

    private static final CredentialPresentationData getCredentialPresentation$lambda$28(ArchiveApi this$0, ServiceId.ACI $aci, ArchiveServiceAccess $archiveServiceAccess) {
        BackupAuthCredential zkCredential = this$0.getZkCredential($aci, $archiveServiceAccess);
        return CredentialPresentationData.Companion.from((BackupKey)$archiveServiceAccess.getBackupKey(), $aci, zkCredential, this$0.backupServerPublicParams);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lorg/whispersystems/signalservice/api/archive/ArchiveApi$CredentialPresentationData;", "", "privateKey", "Lorg/signal/libsignal/protocol/ecc/ECPrivateKey;", "presentation", "", "signedPresentation", "<init>", "(Lorg/signal/libsignal/protocol/ecc/ECPrivateKey;[B[B)V", "getPrivateKey", "()Lorg/signal/libsignal/protocol/ecc/ECPrivateKey;", "getPresentation", "()[B", "getSignedPresentation", "publicKey", "Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "getPublicKey", "()Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "toArchiveCredentialPresentation", "Lorg/whispersystems/signalservice/api/archive/ArchiveCredentialPresentation;", "Companion", "signal-service-java"})
    private static final class CredentialPresentationData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ECPrivateKey privateKey;
        @NotNull
        private final byte[] presentation;
        @NotNull
        private final byte[] signedPresentation;
        @NotNull
        private final ECPublicKey publicKey;

        public CredentialPresentationData(@NotNull ECPrivateKey privateKey, @NotNull byte[] presentation, @NotNull byte[] signedPresentation) {
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)signedPresentation, (String)"signedPresentation");
            this.privateKey = privateKey;
            this.presentation = presentation;
            this.signedPresentation = signedPresentation;
            this.publicKey = this.privateKey.publicKey();
        }

        @NotNull
        public final ECPrivateKey getPrivateKey() {
            return this.privateKey;
        }

        @NotNull
        public final byte[] getPresentation() {
            return this.presentation;
        }

        @NotNull
        public final byte[] getSignedPresentation() {
            return this.signedPresentation;
        }

        @NotNull
        public final ECPublicKey getPublicKey() {
            return this.publicKey;
        }

        @NotNull
        public final ArchiveCredentialPresentation toArchiveCredentialPresentation() {
            return new ArchiveCredentialPresentation(this.presentation, this.signedPresentation);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/whispersystems/signalservice/api/archive/ArchiveApi$CredentialPresentationData$Companion;", "", "<init>", "()V", "from", "Lorg/whispersystems/signalservice/api/archive/ArchiveApi$CredentialPresentationData;", "backupKey", "Lorg/signal/core/models/backup/BackupKey;", "aci", "Lorg/signal/core/models/ServiceId$ACI;", "credential", "Lorg/signal/libsignal/zkgroup/backups/BackupAuthCredential;", "backupServerPublicParams", "Lorg/signal/libsignal/zkgroup/GenericServerPublicParams;", "signal-service-java"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CredentialPresentationData from(@NotNull BackupKey backupKey, @NotNull ServiceId.ACI aci, @NotNull BackupAuthCredential credential, @NotNull GenericServerPublicParams backupServerPublicParams) {
                Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
                Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
                Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
                Intrinsics.checkNotNullParameter((Object)backupServerPublicParams, (String)"backupServerPublicParams");
                ECPrivateKey privateKey = backupKey.deriveAnonymousCredentialPrivateKey(aci);
                byte[] byArray = credential.present(backupServerPublicParams).serialize();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"serialize(...)");
                byte[] presentation = byArray;
                byte[] signedPresentation = privateKey.calculateSignature(presentation);
                return new CredentialPresentationData(privateKey, presentation, signedPresentation);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

