/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kotlin.Pair;
import kotlin.Unit;
import okio.ByteString;
import okio.Utf8;
import org.signal.core.models.ServiceId;
import org.signal.core.util.Base64;
import org.signal.core.util.UuidUtil;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidRegistrationIdException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.SessionBuilder;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.groups.GroupSessionBuilder;
import org.signal.libsignal.protocol.groups.state.SenderKeyStore;
import org.signal.libsignal.protocol.kdf.HKDF;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.protocol.message.DecryptionErrorMessage;
import org.signal.libsignal.protocol.message.PlaintextContent;
import org.signal.libsignal.protocol.message.SenderKeyDistributionMessage;
import org.signal.libsignal.protocol.state.PreKeyBundle;
import org.signal.libsignal.protocol.state.SessionRecord;
import org.signal.libsignal.protocol.state.SignalProtocolStore;
import org.signal.libsignal.zkgroup.groupsend.GroupSendFullToken;
import org.whispersystems.signalservice.api.ContentTooLargeException;
import org.whispersystems.signalservice.api.InvalidPreKeyException;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.NetworkResultUtil;
import org.whispersystems.signalservice.api.SignalServiceAccountDataStore;
import org.whispersystems.signalservice.api.SignalServiceDataStore;
import org.whispersystems.signalservice.api.SignalSessionLock;
import org.whispersystems.signalservice.api.attachment.AttachmentApi;
import org.whispersystems.signalservice.api.crypto.AttachmentCipherStreamUtil;
import org.whispersystems.signalservice.api.crypto.ContentHint;
import org.whispersystems.signalservice.api.crypto.EnvelopeContent;
import org.whispersystems.signalservice.api.crypto.SealedSenderAccess;
import org.whispersystems.signalservice.api.crypto.SignalGroupSessionBuilder;
import org.whispersystems.signalservice.api.crypto.SignalServiceCipher;
import org.whispersystems.signalservice.api.crypto.SignalSessionBuilder;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccess;
import org.whispersystems.signalservice.api.crypto.UntrustedIdentityException;
import org.whispersystems.signalservice.api.groupsv2.GroupSendEndorsements;
import org.whispersystems.signalservice.api.keys.KeysApi;
import org.whispersystems.signalservice.api.message.MessageApi;
import org.whispersystems.signalservice.api.messages.SendMessageResult;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentPointer;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentRemoteId;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentStream;
import org.whispersystems.signalservice.api.messages.SignalServiceDataMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceEditMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceGroup;
import org.whispersystems.signalservice.api.messages.SignalServiceGroupContext;
import org.whispersystems.signalservice.api.messages.SignalServiceGroupV2;
import org.whispersystems.signalservice.api.messages.SignalServicePreview;
import org.whispersystems.signalservice.api.messages.SignalServiceReceiptMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceStickerManifest;
import org.whispersystems.signalservice.api.messages.SignalServiceStickerManifestUpload;
import org.whispersystems.signalservice.api.messages.SignalServiceStoryMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceStoryMessageRecipient;
import org.whispersystems.signalservice.api.messages.SignalServiceTextAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceTypingMessage;
import org.whispersystems.signalservice.api.messages.calls.AnswerMessage;
import org.whispersystems.signalservice.api.messages.calls.IceUpdateMessage;
import org.whispersystems.signalservice.api.messages.calls.OfferMessage;
import org.whispersystems.signalservice.api.messages.calls.OpaqueMessage;
import org.whispersystems.signalservice.api.messages.calls.SignalServiceCallMessage;
import org.whispersystems.signalservice.api.messages.multidevice.BlockedListMessage;
import org.whispersystems.signalservice.api.messages.multidevice.ConfigurationMessage;
import org.whispersystems.signalservice.api.messages.multidevice.KeysMessage;
import org.whispersystems.signalservice.api.messages.multidevice.MessageRequestResponseMessage;
import org.whispersystems.signalservice.api.messages.multidevice.OutgoingPaymentMessage;
import org.whispersystems.signalservice.api.messages.multidevice.ReadMessage;
import org.whispersystems.signalservice.api.messages.multidevice.SentTranscriptMessage;
import org.whispersystems.signalservice.api.messages.multidevice.SignalServiceSyncMessage;
import org.whispersystems.signalservice.api.messages.multidevice.StickerPackOperationMessage;
import org.whispersystems.signalservice.api.messages.multidevice.VerifiedMessage;
import org.whispersystems.signalservice.api.messages.multidevice.ViewOnceOpenMessage;
import org.whispersystems.signalservice.api.messages.multidevice.ViewedMessage;
import org.whispersystems.signalservice.api.messages.shared.SharedContact;
import org.whispersystems.signalservice.api.push.DistributionId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.push.exceptions.AuthorizationFailedException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.push.exceptions.NotFoundException;
import org.whispersystems.signalservice.api.push.exceptions.ProofRequiredException;
import org.whispersystems.signalservice.api.push.exceptions.PushNetworkException;
import org.whispersystems.signalservice.api.push.exceptions.RateLimitException;
import org.whispersystems.signalservice.api.push.exceptions.ServerRejectedException;
import org.whispersystems.signalservice.api.push.exceptions.UnregisteredUserException;
import org.whispersystems.signalservice.api.util.AttachmentPointerUtil;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.api.util.Preconditions;
import org.whispersystems.signalservice.api.util.Uint64RangeException;
import org.whispersystems.signalservice.api.util.Uint64Util;
import org.whispersystems.signalservice.api.websocket.WebSocketUnavailableException;
import org.whispersystems.signalservice.internal.crypto.AttachmentDigest;
import org.whispersystems.signalservice.internal.crypto.PaddingInputStream;
import org.whispersystems.signalservice.internal.push.AttachmentPointer;
import org.whispersystems.signalservice.internal.push.AttachmentUploadForm;
import org.whispersystems.signalservice.internal.push.BodyRange;
import org.whispersystems.signalservice.internal.push.CallMessage;
import org.whispersystems.signalservice.internal.push.Content;
import org.whispersystems.signalservice.internal.push.DataMessage;
import org.whispersystems.signalservice.internal.push.EditMessage;
import org.whispersystems.signalservice.internal.push.GroupContext;
import org.whispersystems.signalservice.internal.push.GroupContextV2;
import org.whispersystems.signalservice.internal.push.GroupMismatchedDevices;
import org.whispersystems.signalservice.internal.push.GroupStaleDevices;
import org.whispersystems.signalservice.internal.push.MismatchedDevices;
import org.whispersystems.signalservice.internal.push.NullMessage;
import org.whispersystems.signalservice.internal.push.OutgoingPushMessage;
import org.whispersystems.signalservice.internal.push.OutgoingPushMessageList;
import org.whispersystems.signalservice.internal.push.PniSignatureMessage;
import org.whispersystems.signalservice.internal.push.Preview;
import org.whispersystems.signalservice.internal.push.ProvisioningVersion;
import org.whispersystems.signalservice.internal.push.PushAttachmentData;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.push.ReceiptMessage;
import org.whispersystems.signalservice.internal.push.SendGroupMessageResponse;
import org.whispersystems.signalservice.internal.push.SendMessageResponse;
import org.whispersystems.signalservice.internal.push.StaleDevices;
import org.whispersystems.signalservice.internal.push.StickerUploadAttributes;
import org.whispersystems.signalservice.internal.push.StickerUploadAttributesResponse;
import org.whispersystems.signalservice.internal.push.StoryMessage;
import org.whispersystems.signalservice.internal.push.SyncMessage;
import org.whispersystems.signalservice.internal.push.TextAttachment;
import org.whispersystems.signalservice.internal.push.TypingMessage;
import org.whispersystems.signalservice.internal.push.Verified;
import org.whispersystems.signalservice.internal.push.exceptions.GroupMismatchedDevicesException;
import org.whispersystems.signalservice.internal.push.exceptions.GroupStaleDevicesException;
import org.whispersystems.signalservice.internal.push.exceptions.InvalidUnidentifiedAccessHeaderException;
import org.whispersystems.signalservice.internal.push.exceptions.MismatchedDevicesException;
import org.whispersystems.signalservice.internal.push.exceptions.StaleDevicesException;
import org.whispersystems.signalservice.internal.push.http.AttachmentCipherOutputStreamFactory;
import org.whispersystems.signalservice.internal.push.http.CancelationSignal;
import org.whispersystems.signalservice.internal.push.http.PartialSendBatchCompleteListener;
import org.whispersystems.signalservice.internal.push.http.PartialSendCompleteListener;
import org.whispersystems.signalservice.internal.push.http.ResumableUploadSpec;
import org.whispersystems.signalservice.internal.sticker.Pack;
import org.whispersystems.signalservice.internal.util.Util;

public class SignalServiceMessageSender {
    private static final String TAG = SignalServiceMessageSender.class.getSimpleName();
    private static final int RETRY_COUNT = 4;
    private final PushServiceSocket socket;
    private final SignalServiceAccountDataStore aciStore;
    private final SignalSessionLock sessionLock;
    private final SignalServiceAddress localAddress;
    private final int localDeviceId;
    private final ServiceId.PNI localPni;
    private final Optional<EventListener> eventListener;
    private final IdentityKeyPair localPniIdentity;
    private final AttachmentApi attachmentApi;
    private final MessageApi messageApi;
    private final KeysApi keysApi;
    private final Scheduler scheduler;
    private final long maxEnvelopeSize;
    private final BooleanSupplier useRestFallback;
    private final boolean useBinaryId;
    private final boolean useStringId;

    public SignalServiceMessageSender(PushServiceSocket pushServiceSocket, SignalServiceDataStore store, SignalSessionLock sessionLock, AttachmentApi attachmentApi, MessageApi messageApi, KeysApi keysApi, Optional<EventListener> eventListener, ExecutorService executor, long maxEnvelopeSize, BooleanSupplier useRestFallback, boolean useBinaryId, boolean useStringId) {
        CredentialsProvider credentialsProvider = pushServiceSocket.getCredentialsProvider();
        this.socket = pushServiceSocket;
        this.aciStore = store.aci();
        this.sessionLock = sessionLock;
        this.localAddress = new SignalServiceAddress((ServiceId)credentialsProvider.getAci(), credentialsProvider.getE164());
        this.localDeviceId = credentialsProvider.getDeviceId();
        this.localPni = credentialsProvider.getPni();
        this.attachmentApi = attachmentApi;
        this.messageApi = messageApi;
        this.eventListener = eventListener;
        this.maxEnvelopeSize = maxEnvelopeSize;
        this.localPniIdentity = store.pni().getIdentityKeyPair();
        this.scheduler = Schedulers.from((Executor)executor, (boolean)false, (boolean)false);
        this.keysApi = keysApi;
        this.useRestFallback = useRestFallback;
        this.useBinaryId = useBinaryId;
        this.useStringId = useStringId;
    }

    public SendMessageResult sendReceipt(SignalServiceAddress recipient, @Nullable SealedSenderAccess sealedSenderAccess, SignalServiceReceiptMessage message, boolean includePniSignature) throws IOException, UntrustedIdentityException {
        Log.d((String)TAG, (String)("[" + message.getWhen() + "] Sending a receipt."));
        Content content = this.createReceiptContent(message);
        if (includePniSignature) {
            content = content.newBuilder().pniSignatureMessage(this.createPniSignatureMessage()).build();
        }
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted(content, ContentHint.IMPLICIT, Optional.empty());
        return this.sendMessage(recipient, sealedSenderAccess, message.getWhen(), envelopeContent, false, null, null, false, false);
    }

    public SendMessageResult sendRetryReceipt(SignalServiceAddress recipient, @Nullable SealedSenderAccess sealedSenderAccess, Optional<byte[]> groupId, DecryptionErrorMessage errorMessage) throws IOException, UntrustedIdentityException {
        long timestamp = System.currentTimeMillis();
        Log.d((String)TAG, (String)("[" + timestamp + "] Sending a retry receipt for target message " + errorMessage.getTimestamp()));
        PlaintextContent content = new PlaintextContent(errorMessage);
        EnvelopeContent envelopeContent = EnvelopeContent.plaintext(content, groupId);
        return this.sendMessage(recipient, sealedSenderAccess, timestamp, envelopeContent, false, null, null, false, false);
    }

    public List<SendMessageResult> sendTyping(List<SignalServiceAddress> recipients, List<SealedSenderAccess> sealedSenderAccesses, SignalServiceTypingMessage message, CancelationSignal cancelationSignal) throws IOException {
        Log.d((String)TAG, (String)("[" + message.getTimestamp() + "] Sending a typing message to " + recipients.size() + " recipient(s) using 1:1 messages."));
        Content content = this.createTypingContent(message);
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted(content, ContentHint.IMPLICIT, Optional.empty());
        return this.sendMessage(recipients, sealedSenderAccesses, message.getTimestamp(), envelopeContent, true, null, cancelationSignal, null, false, false);
    }

    public List<SendMessageResult> sendGroupTyping(DistributionId distributionId, List<SignalServiceAddress> recipients, List<UnidentifiedAccess> unidentifiedAccess, @Nonnull GroupSendEndorsements groupSendEndorsements, SignalServiceTypingMessage message) throws IOException, UntrustedIdentityException, InvalidKeyException, NoSessionException, InvalidRegistrationIdException {
        Log.d((String)TAG, (String)("[" + message.getTimestamp() + "] Sending a typing message to " + recipients.size() + " recipient(s) using sender key."));
        Content content = this.createTypingContent(message);
        return this.sendGroupMessage(distributionId, recipients, unidentifiedAccess, groupSendEndorsements, message.getTimestamp(), content, ContentHint.IMPLICIT, message.getGroupId(), true, SenderKeyGroupEvents.EMPTY, false, false);
    }

    public void sendStorySyncMessage(SignalServiceStoryMessage message, long timestamp, boolean isRecipientUpdate, Set<SignalServiceStoryMessageRecipient> manifest) throws IOException, UntrustedIdentityException {
        Log.d((String)TAG, (String)("[" + timestamp + "] Sending a story sync message."));
        if (manifest.isEmpty() && !message.getGroupContext().isPresent()) {
            Log.w((String)TAG, (String)"Refusing to send sync message for empty manifest in non-group story.");
            return;
        }
        SignalServiceSyncMessage syncMessage = this.createSelfSendSyncMessageForStory(message, timestamp, isRecipientUpdate, manifest);
        this.sendSyncMessage(syncMessage);
    }

    public List<SendMessageResult> sendGroupStory(DistributionId distributionId, Optional<byte[]> groupId, List<SignalServiceAddress> recipients, List<UnidentifiedAccess> unidentifiedAccess, @Nullable GroupSendEndorsements groupSendEndorsements, boolean isRecipientUpdate, SignalServiceStoryMessage message, long timestamp, Set<SignalServiceStoryMessageRecipient> manifest, PartialSendBatchCompleteListener partialListener) throws IOException, UntrustedIdentityException, InvalidKeyException, NoSessionException, InvalidRegistrationIdException {
        Log.d((String)TAG, (String)("[" + timestamp + "] Sending a story."));
        Content content = this.createStoryContent(message);
        List<SendMessageResult> sendMessageResults = this.sendGroupMessage(distributionId, recipients, unidentifiedAccess, groupSendEndorsements, timestamp, content, ContentHint.IMPLICIT, groupId, false, SenderKeyGroupEvents.EMPTY, false, true);
        if (partialListener != null) {
            partialListener.onPartialSendComplete(sendMessageResults);
        }
        if (this.aciStore.isMultiDevice()) {
            this.sendStorySyncMessage(message, timestamp, isRecipientUpdate, manifest);
        }
        return sendMessageResults;
    }

    public void sendCallMessage(SignalServiceAddress recipient, @Nullable SealedSenderAccess sealedSenderAccess, SignalServiceCallMessage message) throws IOException, UntrustedIdentityException {
        long timestamp = System.currentTimeMillis();
        Log.d((String)TAG, (String)("[" + timestamp + "] Sending a call message (single recipient)."));
        Content content = this.createCallContent(message);
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted(content, ContentHint.DEFAULT, Optional.empty());
        this.sendMessage(recipient, sealedSenderAccess, timestamp, envelopeContent, false, null, null, message.isUrgent(), false);
    }

    public List<SendMessageResult> sendCallMessage(List<SignalServiceAddress> recipients, List<SealedSenderAccess> sealedSenderAccesses, SignalServiceCallMessage message) throws IOException {
        long timestamp = System.currentTimeMillis();
        Log.d((String)TAG, (String)("[" + timestamp + "] Sending a call message (multiple recipients)."));
        Content content = this.createCallContent(message);
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted(content, ContentHint.DEFAULT, Optional.empty());
        return this.sendMessage(recipients, sealedSenderAccesses, timestamp, envelopeContent, false, null, null, null, message.isUrgent(), false);
    }

    public List<SendMessageResult> sendCallMessage(DistributionId distributionId, List<SignalServiceAddress> recipients, List<UnidentifiedAccess> unidentifiedAccess, @Nonnull GroupSendEndorsements groupSendEndorsements, SignalServiceCallMessage message, PartialSendBatchCompleteListener partialListener) throws IOException, UntrustedIdentityException, InvalidKeyException, NoSessionException, InvalidRegistrationIdException {
        Log.d((String)TAG, (String)("[" + String.valueOf(message.getTimestamp().get()) + "] Sending a call message (sender key)."));
        Content content = this.createCallContent(message);
        List<SendMessageResult> results = this.sendGroupMessage(distributionId, recipients, unidentifiedAccess, groupSendEndorsements, message.getTimestamp().get(), content, ContentHint.IMPLICIT, message.getGroupId(), false, SenderKeyGroupEvents.EMPTY, message.isUrgent(), false);
        if (partialListener != null) {
            partialListener.onPartialSendComplete(results);
        }
        return results;
    }

    public SendMessageResult sendDataMessage(SignalServiceAddress recipient, @Nullable SealedSenderAccess sealedSenderAccess, ContentHint contentHint, SignalServiceDataMessage message, IndividualSendEvents sendEvents, boolean urgent, boolean includePniSignature) throws UntrustedIdentityException, IOException {
        Log.d((String)TAG, (String)("[" + message.getTimestamp() + "] Sending a data message."));
        Content content = this.createMessageContent(message);
        return this.sendContent(recipient, sealedSenderAccess, contentHint, message, sendEvents, urgent, includePniSignature, content);
    }

    public SendMessageResult sendEditMessage(SignalServiceAddress recipient, @Nullable SealedSenderAccess sealedSenderAccess, ContentHint contentHint, SignalServiceDataMessage message, IndividualSendEvents sendEvents, boolean urgent, long targetSentTimestamp) throws UntrustedIdentityException, IOException {
        Log.d((String)TAG, (String)("[" + message.getTimestamp() + "] Sending an edit message for " + targetSentTimestamp + "."));
        Content content = this.createEditMessageContent(new SignalServiceEditMessage(targetSentTimestamp, message));
        return this.sendContent(recipient, sealedSenderAccess, contentHint, message, sendEvents, urgent, false, content);
    }

    private SendMessageResult sendContent(SignalServiceAddress recipient, @Nullable SealedSenderAccess sealedSenderAccess, ContentHint contentHint, SignalServiceDataMessage message, IndividualSendEvents sendEvents, boolean urgent, boolean includePniSignature, Content content) throws UntrustedIdentityException, IOException {
        if (includePniSignature) {
            Log.d((String)TAG, (String)("[" + message.getTimestamp() + "] Including PNI signature."));
            content = content.newBuilder().pniSignatureMessage(this.createPniSignatureMessage()).build();
        }
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted(content, contentHint, message.getGroupId());
        long timestamp = message.getTimestamp();
        SendMessageResult result2 = this.sendMessage(recipient, sealedSenderAccess, timestamp, envelopeContent, false, null, sendEvents, urgent, false);
        sendEvents.onMessageSent();
        if (result2.getSuccess() != null && result2.getSuccess().isNeedsSync() && !this.localAddress.matches(recipient)) {
            Content syncMessage = this.createMultiDeviceSentTranscriptContent(content, Optional.of(recipient), timestamp, Collections.singletonList(result2), false, Collections.emptySet());
            EnvelopeContent syncMessageContent = EnvelopeContent.encrypted(syncMessage, ContentHint.IMPLICIT, Optional.empty());
            this.sendMessage(this.localAddress, SealedSenderAccess.NONE, timestamp, syncMessageContent, false, null, null, false, false);
        }
        sendEvents.onSyncMessageSent();
        return result2;
    }

    public SenderKeyDistributionMessage getOrCreateNewGroupSession(DistributionId distributionId) {
        SignalProtocolAddress self = new SignalProtocolAddress(this.localAddress.getIdentifier(), this.localDeviceId);
        return new SignalGroupSessionBuilder(this.sessionLock, new GroupSessionBuilder((SenderKeyStore)this.aciStore)).create(self, distributionId.asUuid());
    }

    public List<SendMessageResult> sendSenderKeyDistributionMessage(DistributionId distributionId, List<SignalServiceAddress> recipients, List<SealedSenderAccess> sealedSenderAccesses, SenderKeyDistributionMessage message, Optional<byte[]> groupId, boolean urgent, boolean story) throws IOException {
        ByteString distributionBytes = ByteString.of((byte[])message.serialize());
        Content content = new Content.Builder().senderKeyDistributionMessage(distributionBytes).build();
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted(content, ContentHint.IMPLICIT, groupId);
        long timestamp = System.currentTimeMillis();
        Log.d((String)TAG, (String)("[" + timestamp + "] Sending SKDM to " + recipients.size() + " recipients for DistributionId " + String.valueOf(distributionId)));
        return this.sendMessage(recipients, sealedSenderAccesses, timestamp, envelopeContent, false, null, null, null, urgent, story);
    }

    public SendMessageResult resendContent(SignalServiceAddress address, @Nullable SealedSenderAccess sealedSenderAccess, long timestamp, Content content, ContentHint contentHint, Optional<byte[]> groupId, boolean urgent) throws UntrustedIdentityException, IOException {
        Log.d((String)TAG, (String)("[" + timestamp + "] Resending content."));
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted(content, contentHint, groupId);
        if (address.getServiceId().equals(this.localAddress.getServiceId())) {
            sealedSenderAccess = SealedSenderAccess.NONE;
        }
        return this.sendMessage(address, sealedSenderAccess, timestamp, envelopeContent, false, null, null, urgent, false);
    }

    public List<SendMessageResult> sendGroupDataMessage(DistributionId distributionId, List<SignalServiceAddress> recipients, List<UnidentifiedAccess> unidentifiedAccess, @Nullable GroupSendEndorsements groupSendEndorsements, boolean isRecipientUpdate, ContentHint contentHint, SignalServiceDataMessage message, SenderKeyGroupEvents sendEvents, boolean urgent, boolean isForStory, SignalServiceEditMessage editMessage, PartialSendBatchCompleteListener partialListener) throws IOException, UntrustedIdentityException, NoSessionException, InvalidKeyException, InvalidRegistrationIdException {
        Log.d((String)TAG, (String)("[" + message.getTimestamp() + "] Sending a group " + (editMessage != null ? "edit data message" : "data message") + " to " + recipients.size() + " recipients using DistributionId " + String.valueOf(distributionId)));
        Content content = editMessage != null ? this.createEditMessageContent(editMessage) : this.createMessageContent(message);
        Optional<byte[]> groupId = message.getGroupId();
        List<SendMessageResult> results = this.sendGroupMessage(distributionId, recipients, unidentifiedAccess, groupSendEndorsements, message.getTimestamp(), content, contentHint, groupId, false, sendEvents, urgent, isForStory);
        if (partialListener != null) {
            partialListener.onPartialSendComplete(results);
        }
        sendEvents.onMessageSent();
        if (this.aciStore.isMultiDevice() && !recipients.contains(this.localAddress)) {
            Content syncMessage = this.createMultiDeviceSentTranscriptContent(content, Optional.empty(), message.getTimestamp(), results, isRecipientUpdate, Collections.emptySet());
            EnvelopeContent syncMessageContent = EnvelopeContent.encrypted(syncMessage, ContentHint.IMPLICIT, Optional.empty());
            this.sendMessage(this.localAddress, SealedSenderAccess.NONE, message.getTimestamp(), syncMessageContent, false, null, null, false, false);
        }
        sendEvents.onSyncMessageSent();
        return results;
    }

    public List<SendMessageResult> sendDataMessage(List<SignalServiceAddress> recipients, List<SealedSenderAccess> sealedSenderAccesses, boolean isRecipientUpdate, ContentHint contentHint, SignalServiceDataMessage message, LegacyGroupEvents sendEvents, PartialSendCompleteListener partialListener, CancelationSignal cancelationSignal, boolean urgent) throws IOException, UntrustedIdentityException {
        Log.d((String)TAG, (String)("[" + message.getTimestamp() + "] Sending a data message to " + recipients.size() + " recipients."));
        Content content = this.createMessageContent(message);
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted(content, contentHint, message.getGroupId());
        long timestamp = message.getTimestamp();
        List<SendMessageResult> results = this.sendMessage(recipients, sealedSenderAccesses, timestamp, envelopeContent, false, partialListener, cancelationSignal, sendEvents, urgent, false);
        boolean needsSyncInResults = false;
        sendEvents.onMessageSent();
        for (SendMessageResult result2 : results) {
            if (result2.getSuccess() == null || !result2.getSuccess().isNeedsSync()) continue;
            needsSyncInResults = true;
            break;
        }
        if ((needsSyncInResults || this.aciStore.isMultiDevice()) && !recipients.contains(this.localAddress)) {
            Optional<SignalServiceAddress> recipient = Optional.empty();
            if (!message.getGroupContext().isPresent() && recipients.size() == 1) {
                recipient = Optional.of(recipients.get(0));
            }
            Content syncMessage = this.createMultiDeviceSentTranscriptContent(content, recipient, timestamp, results, isRecipientUpdate, Collections.emptySet());
            EnvelopeContent syncMessageContent = EnvelopeContent.encrypted(syncMessage, ContentHint.IMPLICIT, Optional.empty());
            this.sendMessage(this.localAddress, SealedSenderAccess.NONE, timestamp, syncMessageContent, false, null, null, false, false);
        }
        sendEvents.onSyncMessageSent();
        return results;
    }

    public List<SendMessageResult> sendEditMessage(List<SignalServiceAddress> recipients, List<SealedSenderAccess> sealedSenderAccesses, boolean isRecipientUpdate, ContentHint contentHint, SignalServiceDataMessage message, LegacyGroupEvents sendEvents, PartialSendCompleteListener partialListener, CancelationSignal cancelationSignal, boolean urgent, long targetSentTimestamp) throws IOException, UntrustedIdentityException {
        Log.d((String)TAG, (String)("[" + message.getTimestamp() + "] Sending a edit message to " + recipients.size() + " recipients."));
        Content content = this.createEditMessageContent(new SignalServiceEditMessage(targetSentTimestamp, message));
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted(content, contentHint, message.getGroupId());
        long timestamp = message.getTimestamp();
        List<SendMessageResult> results = this.sendMessage(recipients, sealedSenderAccesses, timestamp, envelopeContent, false, partialListener, cancelationSignal, null, urgent, false);
        boolean needsSyncInResults = false;
        sendEvents.onMessageSent();
        for (SendMessageResult result2 : results) {
            if (result2.getSuccess() == null || !result2.getSuccess().isNeedsSync()) continue;
            needsSyncInResults = true;
            break;
        }
        if (needsSyncInResults || this.aciStore.isMultiDevice()) {
            Optional<SignalServiceAddress> recipient = Optional.empty();
            if (!message.getGroupContext().isPresent() && recipients.size() == 1) {
                recipient = Optional.of(recipients.get(0));
            }
            Content syncMessage = this.createMultiDeviceSentTranscriptContent(content, recipient, timestamp, results, isRecipientUpdate, Collections.emptySet());
            EnvelopeContent syncMessageContent = EnvelopeContent.encrypted(syncMessage, ContentHint.IMPLICIT, Optional.empty());
            this.sendMessage(this.localAddress, SealedSenderAccess.NONE, timestamp, syncMessageContent, false, null, null, false, false);
        }
        sendEvents.onSyncMessageSent();
        return results;
    }

    public SendMessageResult sendSyncMessage(SignalServiceDataMessage dataMessage) throws IOException, UntrustedIdentityException {
        Log.d((String)TAG, (String)("[" + dataMessage.getTimestamp() + "] Sending self-sync message."));
        return this.sendSyncMessage(this.createSelfSendSyncMessage(dataMessage));
    }

    public SendMessageResult sendSelfSyncEditMessage(SignalServiceEditMessage editMessage) throws IOException, UntrustedIdentityException {
        Log.d((String)TAG, (String)("[" + editMessage.getDataMessage().getTimestamp() + "] Sending self-sync edit message for " + editMessage.getTargetSentTimestamp() + "."));
        return this.sendSyncMessage(this.createSelfSendSyncEditMessage(editMessage));
    }

    public SendMessageResult sendSyncMessage(SignalServiceSyncMessage message) throws IOException, UntrustedIdentityException {
        Content content;
        boolean urgent = false;
        if (!this.aciStore.isMultiDevice()) {
            Log.d((String)TAG, (String)"We do not have any linked devices. Skipping.");
            return SendMessageResult.success(this.localAddress, Collections.emptyList(), false, false, 0L, Optional.empty());
        }
        if (message.getContacts().isPresent()) {
            content = this.createMultiDeviceContactsContent(message.getContacts().get().getContactsStream().asStream(), message.getContacts().get().isComplete());
        } else if (message.getGroups().isPresent()) {
            content = this.createMultiDeviceGroupsContent(message.getGroups().get().asStream());
        } else if (message.getRead().isPresent()) {
            content = this.createMultiDeviceReadContent(message.getRead().get());
            urgent = true;
        } else if (message.getViewed().isPresent()) {
            content = this.createMultiDeviceViewedContent(message.getViewed().get());
        } else if (message.getViewOnceOpen().isPresent()) {
            content = this.createMultiDeviceViewOnceOpenContent(message.getViewOnceOpen().get());
        } else if (message.getBlockedList().isPresent()) {
            content = this.createMultiDeviceBlockedContent(message.getBlockedList().get());
        } else if (message.getConfiguration().isPresent()) {
            content = this.createMultiDeviceConfigurationContent(message.getConfiguration().get());
        } else if (message.getSent().isPresent()) {
            content = this.createMultiDeviceSentTranscriptContent(message.getSent().get());
        } else if (message.getStickerPackOperations().isPresent()) {
            content = this.createMultiDeviceStickerPackOperationContent(message.getStickerPackOperations().get());
        } else if (message.getFetchType().isPresent()) {
            content = this.createMultiDeviceFetchTypeContent(message.getFetchType().get());
        } else if (message.getMessageRequestResponse().isPresent()) {
            content = this.createMultiDeviceMessageRequestResponseContent(message.getMessageRequestResponse().get());
        } else if (message.getOutgoingPaymentMessage().isPresent()) {
            content = this.createMultiDeviceOutgoingPaymentContent(message.getOutgoingPaymentMessage().get());
        } else if (message.getKeys().isPresent()) {
            content = this.createMultiDeviceSyncKeysContent(message.getKeys().get());
        } else {
            if (message.getVerified().isPresent()) {
                return this.sendVerifiedSyncMessage(message.getVerified().get());
            }
            if (message.getRequest().isPresent()) {
                content = this.createRequestContent(message.getRequest().get().getRequest());
                urgent = message.getRequest().get().isUrgent();
            } else if (message.getCallEvent().isPresent()) {
                content = this.createCallEventContent(message.getCallEvent().get());
            } else if (message.getCallLinkUpdate().isPresent()) {
                content = this.createCallLinkUpdateContent(message.getCallLinkUpdate().get());
            } else if (message.getCallLogEvent().isPresent()) {
                content = this.createCallLogEventContent(message.getCallLogEvent().get());
            } else if (message.getDeviceNameChange().isPresent()) {
                content = this.createDeviceNameChangeContent(message.getDeviceNameChange().get());
            } else if (message.getAttachmentBackfillResponse().isPresent()) {
                content = this.createAttachmentBackfillResponseContent(message.getAttachmentBackfillResponse().get());
            } else {
                throw new IOException("Unsupported sync message!");
            }
        }
        Optional<Long> timestamp = message.getSent().map(SentTranscriptMessage::getTimestamp);
        return this.sendSyncMessage(content, urgent, timestamp);
    }

    @Nonnull
    public SendMessageResult sendSyncMessage(Content content, boolean urgent, Optional<Long> sent) throws IOException, UntrustedIdentityException {
        long timestamp = sent.orElseGet(System::currentTimeMillis);
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted(content, ContentHint.IMPLICIT, Optional.empty());
        return this.sendMessage(this.localAddress, SealedSenderAccess.NONE, timestamp, envelopeContent, false, null, null, urgent, false);
    }

    @Nonnull
    public OutgoingPushMessage getEncryptedSyncPniInitializeDeviceMessage(int deviceId, @Nonnull SyncMessage.PniChangeNumber pniChangeNumber) throws UntrustedIdentityException, IOException, InvalidKeyException {
        SyncMessage.Builder syncMessage = this.createSyncMessageBuilder().pniChangeNumber(pniChangeNumber);
        Content.Builder content = new Content.Builder().syncMessage(syncMessage.build());
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted(content.build(), ContentHint.IMPLICIT, Optional.empty());
        return this.getEncryptedMessage(this.localAddress, SealedSenderAccess.NONE, deviceId, envelopeContent, false);
    }

    public void cancelInFlightRequests() {
        this.socket.cancelInFlightRequests();
    }

    public SignalServiceAttachmentPointer uploadAttachment(SignalServiceAttachmentStream attachment) throws IOException {
        byte[] attachmentKey = attachment.getResumableUploadSpec().map(ResumableUploadSpec::getAttachmentKey).orElseGet(() -> Util.getSecretBytes(64));
        byte[] attachmentIV = attachment.getResumableUploadSpec().map(ResumableUploadSpec::getAttachmentIv).orElseGet(() -> Util.getSecretBytes(16));
        long paddedLength = PaddingInputStream.getPaddedSize(attachment.getLength());
        PaddingInputStream dataStream = new PaddingInputStream(attachment.getInputStream(), attachment.getLength());
        long ciphertextLength = AttachmentCipherStreamUtil.getCiphertextLength(paddedLength);
        PushAttachmentData attachmentData = new PushAttachmentData(attachment.getContentType(), dataStream, ciphertextLength, attachment.isFaststart(), new AttachmentCipherOutputStreamFactory(attachmentKey, attachmentIV), attachment.getListener(), attachment.getCancelationSignal(), attachment.getResumableUploadSpec().get());
        if (attachment.getResumableUploadSpec().isEmpty()) {
            throw new IllegalStateException("Attachment must have a resumable upload spec.");
        }
        return this.uploadAttachmentV4(attachment, attachmentKey, attachmentData);
    }

    public ResumableUploadSpec getResumableUploadSpec() throws IOException {
        Log.d((String)TAG, (String)"Using pipe to retrieve attachment upload attributes...");
        AttachmentUploadForm v4UploadAttributes = NetworkResultUtil.toBasicLegacy(this.attachmentApi.getAttachmentV4UploadForm());
        return this.socket.getResumableUploadSpec(v4UploadAttributes);
    }

    private SignalServiceAttachmentPointer uploadAttachmentV4(SignalServiceAttachmentStream attachment, byte[] attachmentKey, PushAttachmentData attachmentData) throws IOException {
        AttachmentDigest digest = this.socket.uploadAttachment(attachmentData);
        return new SignalServiceAttachmentPointer(attachmentData.getResumableUploadSpec().getCdnNumber(), new SignalServiceAttachmentRemoteId.V4(attachmentData.getResumableUploadSpec().getCdnKey()), attachment.getContentType(), attachmentKey, Optional.of(Util.toIntExact(attachment.getLength())), attachment.getPreview(), attachment.getWidth(), attachment.getHeight(), Optional.of(digest.getDigest()), Optional.ofNullable(digest.getIncrementalDigest()), digest.getIncrementalDigest() != null ? digest.getIncrementalMacChunkSize() : 0, attachment.getFileName(), attachment.getVoiceNote(), attachment.isBorderless(), attachment.isGif(), attachment.getCaption(), attachment.getBlurHash(), attachment.getUploadTimestamp(), attachment.getUuid());
    }

    public String uploadStickerManifest(SignalServiceStickerManifestUpload manifest, byte[] packKey) throws IOException {
        if (manifest.getStickers().isEmpty()) {
            throw new AssertionError((Object)"Must have stickers!");
        }
        if (packKey.length != 32) {
            throw new AssertionError((Object)"Size of packKey must be 32!");
        }
        int stickerCount = manifest.getStickers().size() + (manifest.getCover().isPresent() ? 1 : 0);
        StickerUploadAttributesResponse stickerUploadAttributes = this.socket.getStickerUploadAttributes(stickerCount);
        byte[] content = this.createStickerManifestContent(manifest.toManifest());
        byte[] expandedKey = HKDF.deriveSecrets((byte[])packKey, (byte[])"Sticker Pack".getBytes(), (int)64);
        this.socket.uploadStickerContent(new ByteArrayInputStream(content), content.length, expandedKey, stickerUploadAttributes.getManifest());
        HashMap<Integer, StickerUploadAttributes> stickerUploadAttributesById = new HashMap<Integer, StickerUploadAttributes>();
        for (StickerUploadAttributes attr : stickerUploadAttributes.getStickers()) {
            stickerUploadAttributesById.put(attr.getId(), attr);
        }
        ArrayList<SignalServiceStickerManifestUpload.StickerInfo> stickerUploads = new ArrayList<SignalServiceStickerManifestUpload.StickerInfo>(manifest.getStickers());
        if (manifest.getCover().isPresent()) {
            SignalServiceStickerManifestUpload.StickerInfo cover = manifest.getCover().get();
            stickerUploads.add(cover);
        }
        this.uploadStickers(stickerUploads, packKey, stickerUploadAttributesById);
        return stickerUploadAttributes.getPackId();
    }

    private void uploadStickers(List<SignalServiceStickerManifestUpload.StickerInfo> stickers, byte[] packKey, Map<Integer, StickerUploadAttributes> stickerUploadAttributes) throws NonSuccessfulResponseCodeException, PushNetworkException {
        if (stickers.size() != stickerUploadAttributes.size()) {
            throw new AssertionError((Object)"Size of sickers and upload attributes must be the same.");
        }
        int i = 0;
        for (SignalServiceStickerManifestUpload.StickerInfo sticker : stickers) {
            StickerUploadAttributes uploadAttributes = stickerUploadAttributes.get(i);
            if (uploadAttributes == null) {
                throw new AssertionError((Object)("Upload attributes missing for sticker id: " + i));
            }
            this.uploadSticker(sticker.getInputStream(), sticker.getLength(), packKey, uploadAttributes);
            ++i;
        }
    }

    private void uploadSticker(InputStream data, long length, byte[] packKey, StickerUploadAttributes stickerUploadAttributes) throws NonSuccessfulResponseCodeException, PushNetworkException {
        byte[] expandedKey = HKDF.deriveSecrets((byte[])packKey, (byte[])"Sticker Pack".getBytes(), (int)64);
        this.socket.uploadStickerContent(data, length, expandedKey, stickerUploadAttributes);
    }

    private SendMessageResult sendVerifiedSyncMessage(VerifiedMessage message) throws IOException, UntrustedIdentityException {
        byte[] nullMessageBody = new DataMessage.Builder().body(Base64.encodeWithPadding((byte[])Util.getRandomLengthSecretBytes(140))).build().encode();
        NullMessage nullMessage = new NullMessage.Builder().padding(ByteString.of((byte[])nullMessageBody)).build();
        Content content = new Content.Builder().nullMessage(nullMessage).build();
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted(content, ContentHint.IMPLICIT, Optional.empty());
        SendMessageResult result2 = this.sendMessage(message.getDestination(), null, message.getTimestamp(), envelopeContent, false, null, null, false, false);
        if (result2.getSuccess().isNeedsSync()) {
            Content syncMessage = this.createMultiDeviceVerifiedContent(message, nullMessage.encode());
            EnvelopeContent syncMessageContent = EnvelopeContent.encrypted(syncMessage, ContentHint.IMPLICIT, Optional.empty());
            this.sendMessage(this.localAddress, SealedSenderAccess.NONE, message.getTimestamp(), syncMessageContent, false, null, null, false, false);
        }
        return result2;
    }

    public SendMessageResult sendNullMessage(SignalServiceAddress address, @Nullable SealedSenderAccess sealedSenderAccess) throws UntrustedIdentityException, IOException {
        byte[] nullMessageBody = new DataMessage.Builder().body(Base64.encodeWithPadding((byte[])Util.getRandomLengthSecretBytes(140))).build().encode();
        NullMessage nullMessage = new NullMessage.Builder().padding(ByteString.of((byte[])nullMessageBody)).build();
        Content content = new Content.Builder().nullMessage(nullMessage).build();
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted(content, ContentHint.IMPLICIT, Optional.empty());
        return this.sendMessage(address, sealedSenderAccess, System.currentTimeMillis(), envelopeContent, false, null, null, false, false);
    }

    private PniSignatureMessage createPniSignatureMessage() {
        byte[] signature = this.localPniIdentity.signAlternateIdentity(this.aciStore.getIdentityKeyPair().getPublicKey());
        return new PniSignatureMessage.Builder().pni(UuidUtil.toByteString((UUID)this.localPni.getRawUuid())).signature(ByteString.of((byte[])signature)).build();
    }

    private Content createTypingContent(SignalServiceTypingMessage message) {
        Content.Builder container = new Content.Builder();
        TypingMessage.Builder builder = new TypingMessage.Builder();
        builder.timestamp(message.getTimestamp());
        if (message.isTypingStarted()) {
            builder.action(TypingMessage.Action.STARTED);
        } else if (message.isTypingStopped()) {
            builder.action(TypingMessage.Action.STOPPED);
        } else {
            throw new IllegalArgumentException("Unknown typing indicator");
        }
        if (message.getGroupId().isPresent()) {
            builder.groupId(ByteString.of((byte[])message.getGroupId().get()));
        }
        return container.typingMessage(builder.build()).build();
    }

    private Content createStoryContent(SignalServiceStoryMessage message) throws IOException {
        Content.Builder container = new Content.Builder();
        StoryMessage.Builder builder = new StoryMessage.Builder();
        if (message.getProfileKey().isPresent()) {
            builder.profileKey(ByteString.of((byte[])message.getProfileKey().get()));
        }
        if (message.getGroupContext().isPresent()) {
            builder.group(SignalServiceMessageSender.createGroupContent(message.getGroupContext().get()));
        }
        if (message.getFileAttachment().isPresent()) {
            if (message.getFileAttachment().get().isStream()) {
                builder.fileAttachment(this.createAttachmentPointer(message.getFileAttachment().get().asStream()));
            } else {
                builder.fileAttachment(this.createAttachmentPointer(message.getFileAttachment().get().asPointer()));
            }
        }
        if (message.getTextAttachment().isPresent()) {
            builder.textAttachment(this.createTextAttachment(message.getTextAttachment().get()));
        }
        if (message.getBodyRanges().isPresent()) {
            builder.bodyRanges(message.getBodyRanges().get());
        }
        builder.allowsReplies(message.getAllowsReplies().orElse(true));
        return container.storyMessage(builder.build()).build();
    }

    private Content createReceiptContent(SignalServiceReceiptMessage message) {
        Content.Builder container = new Content.Builder();
        ReceiptMessage.Builder builder = new ReceiptMessage.Builder();
        builder.timestamp = message.getTimestamps();
        if (message.isDeliveryReceipt()) {
            builder.type(ReceiptMessage.Type.DELIVERY);
        } else if (message.isReadReceipt()) {
            builder.type(ReceiptMessage.Type.READ);
        } else if (message.isViewedReceipt()) {
            builder.type(ReceiptMessage.Type.VIEWED);
        }
        return container.receiptMessage(builder.build()).build();
    }

    private Content createMessageContent(SentTranscriptMessage transcriptMessage) throws IOException {
        if (transcriptMessage.getStoryMessage().isPresent()) {
            return this.createStoryContent(transcriptMessage.getStoryMessage().get());
        }
        if (transcriptMessage.getDataMessage().isPresent()) {
            return this.createMessageContent(transcriptMessage.getDataMessage().get());
        }
        if (transcriptMessage.getEditMessage().isPresent()) {
            return this.createEditMessageContent(transcriptMessage.getEditMessage().get());
        }
        return null;
    }

    private Content createMessageContent(SignalServiceDataMessage message) throws IOException {
        Content.Builder container = new Content.Builder();
        DataMessage.Builder dataMessage = this.createDataMessage(message);
        if (dataMessage.body != null && Utf8.size((String)dataMessage.body) > 2048L) {
            throw new ContentTooLargeException(Utf8.size((String)dataMessage.body), "UTF-8 size of the data message body was over 2048 bytes!");
        }
        return this.enforceMaxContentSize(container.dataMessage(dataMessage.build()).build());
    }

    private Content createEditMessageContent(SignalServiceEditMessage editMessage) throws IOException {
        Content.Builder container = new Content.Builder();
        DataMessage.Builder dataMessage = this.createDataMessage(editMessage.getDataMessage());
        EditMessage.Builder editMessageProto = new EditMessage.Builder().dataMessage(dataMessage.build()).targetSentTimestamp(editMessage.getTargetSentTimestamp());
        return this.enforceMaxContentSize(container.editMessage(editMessageProto.build()).build());
    }

    private DataMessage.Builder createDataMessage(SignalServiceDataMessage message) throws IOException {
        ArrayList<BodyRange> bodyRanges;
        DataMessage.Builder builder = new DataMessage.Builder();
        List<AttachmentPointer> pointers = this.createAttachmentPointers(message.getAttachments());
        builder.requiredProtocolVersion = 0;
        if (!pointers.isEmpty()) {
            builder.attachments(pointers);
            for (AttachmentPointer attachmentPointer : pointers) {
            }
        }
        if (message.getBody().isPresent()) {
            builder.body(message.getBody().get());
        }
        if (message.getGroupContext().isPresent()) {
            SignalServiceGroupContext groupContext = message.getGroupContext().get();
            if (groupContext.getGroupV1().isPresent()) {
                builder.group(this.createGroupContent(groupContext.getGroupV1().get()));
            }
            if (groupContext.getGroupV2().isPresent()) {
                builder.groupV2(SignalServiceMessageSender.createGroupContent(groupContext.getGroupV2().get()));
            }
        }
        if (message.isEndSession()) {
            builder.flags(DataMessage.Flags.END_SESSION.getValue());
        }
        if (message.isExpirationUpdate()) {
            builder.flags(DataMessage.Flags.EXPIRATION_TIMER_UPDATE.getValue());
        }
        if (message.isProfileKeyUpdate()) {
            builder.flags(DataMessage.Flags.PROFILE_KEY_UPDATE.getValue());
        }
        if (message.getExpiresInSeconds() > 0) {
            builder.expireTimer(message.getExpiresInSeconds());
        }
        builder.expireTimerVersion(message.getExpireTimerVersion());
        if (message.getProfileKey().isPresent()) {
            builder.profileKey(ByteString.of((byte[])message.getProfileKey().get()));
        }
        if (message.getQuote().isPresent()) {
            List<SignalServiceDataMessage.Quote.QuotedAttachment> attachments;
            List<BodyRange> bodyRanges2;
            DataMessage.Quote.Builder quoteBuilder = new DataMessage.Quote.Builder().id(message.getQuote().get().getId()).text(message.getQuote().get().getText()).authorAci(this.useStringId ? message.getQuote().get().getAuthor().toString() : null).authorAciBinary(this.useBinaryId ? message.getQuote().get().getAuthor().toByteString() : null).type(message.getQuote().get().getType().getProtoType());
            List<SignalServiceDataMessage.Mention> mentions = message.getQuote().get().getMentions();
            if (mentions != null && !mentions.isEmpty()) {
                bodyRanges2 = new ArrayList<BodyRange>(quoteBuilder.bodyRanges);
                for (SignalServiceDataMessage.Mention mention : mentions) {
                    if (this.useStringId) {
                        bodyRanges2.add(new BodyRange.Builder().start(mention.getStart()).length(mention.getLength()).mentionAci(mention.getServiceId().toString()).build());
                        continue;
                    }
                    bodyRanges2.add(new BodyRange.Builder().start(mention.getStart()).length(mention.getLength()).mentionAciBinary(mention.getServiceId().toByteString()).build());
                }
                quoteBuilder.bodyRanges(bodyRanges2);
                builder.requiredProtocolVersion(Math.max(DataMessage.ProtocolVersion.MENTIONS.getValue(), builder.requiredProtocolVersion));
            }
            if ((bodyRanges2 = message.getQuote().get().getBodyRanges()) != null) {
                ArrayList<BodyRange> quoteBodyRanges = new ArrayList<BodyRange>(quoteBuilder.bodyRanges);
                quoteBodyRanges.addAll(bodyRanges2);
                quoteBuilder.bodyRanges(quoteBodyRanges);
            }
            if ((attachments = message.getQuote().get().getAttachments()) != null) {
                ArrayList<DataMessage.Quote.QuotedAttachment> quotedAttachments = new ArrayList<DataMessage.Quote.QuotedAttachment>(attachments.size());
                for (SignalServiceDataMessage.Quote.QuotedAttachment attachment : attachments) {
                    DataMessage.Quote.QuotedAttachment.Builder quotedAttachment = new DataMessage.Quote.QuotedAttachment.Builder();
                    quotedAttachment.contentType(attachment.getContentType());
                    if (attachment.getFileName() != null) {
                        quotedAttachment.fileName(attachment.getFileName());
                    }
                    if (attachment.getThumbnail() != null) {
                        if (attachment.getThumbnail().isStream()) {
                            quotedAttachment.thumbnail(this.createAttachmentPointer(attachment.getThumbnail().asStream()));
                        } else {
                            quotedAttachment.thumbnail(this.createAttachmentPointer(attachment.getThumbnail().asPointer()));
                        }
                    }
                    quotedAttachments.add(quotedAttachment.build());
                }
                quoteBuilder.attachments(quotedAttachments);
            }
            builder.quote(quoteBuilder.build());
        }
        if (message.getSharedContacts().isPresent()) {
            builder.contact = this.createSharedContactContent(message.getSharedContacts().get());
        }
        if (message.getPreviews().isPresent()) {
            ArrayList<Preview> previews = new ArrayList<Preview>(message.getPreviews().get().size());
            for (SignalServicePreview preview : message.getPreviews().get()) {
                previews.add(this.createPreview(preview));
            }
            builder.preview(previews);
        }
        if (message.getMentions().isPresent()) {
            bodyRanges = new ArrayList<BodyRange>(builder.bodyRanges);
            for (SignalServiceDataMessage.Mention mention : message.getMentions().get()) {
                if (this.useStringId) {
                    bodyRanges.add(new BodyRange.Builder().start(mention.getStart()).length(mention.getLength()).mentionAci(mention.getServiceId().toString()).build());
                    continue;
                }
                bodyRanges.add(new BodyRange.Builder().start(mention.getStart()).length(mention.getLength()).mentionAciBinary(mention.getServiceId().toByteString()).build());
            }
            builder.bodyRanges(bodyRanges);
            builder.requiredProtocolVersion(Math.max(DataMessage.ProtocolVersion.MENTIONS.getValue(), builder.requiredProtocolVersion));
        }
        if (message.getSticker().isPresent()) {
            DataMessage.Sticker.Builder stickerBuilder = new DataMessage.Sticker.Builder();
            stickerBuilder.packId(ByteString.of((byte[])message.getSticker().get().getPackId()));
            stickerBuilder.packKey(ByteString.of((byte[])message.getSticker().get().getPackKey()));
            stickerBuilder.stickerId(message.getSticker().get().getStickerId());
            if (message.getSticker().get().getEmoji() != null) {
                stickerBuilder.emoji(message.getSticker().get().getEmoji());
            }
            if (message.getSticker().get().getAttachment().isStream()) {
                stickerBuilder.data_(this.createAttachmentPointer(message.getSticker().get().getAttachment().asStream()));
            } else {
                stickerBuilder.data_(this.createAttachmentPointer(message.getSticker().get().getAttachment().asPointer()));
            }
            builder.sticker(stickerBuilder.build());
        }
        if (message.isViewOnce()) {
            builder.isViewOnce(message.isViewOnce());
            builder.requiredProtocolVersion(Math.max(DataMessage.ProtocolVersion.VIEW_ONCE_VIDEO.getValue(), builder.requiredProtocolVersion));
        }
        if (message.getReaction().isPresent()) {
            DataMessage.Reaction.Builder reactionBuilder = new DataMessage.Reaction.Builder().emoji(message.getReaction().get().getEmoji()).remove(message.getReaction().get().isRemove()).targetSentTimestamp(message.getReaction().get().getTargetSentTimestamp()).targetAuthorAci(this.useStringId ? message.getReaction().get().getTargetAuthor().toString() : null).targetAuthorAciBinary(this.useBinaryId ? message.getReaction().get().getTargetAuthor().toByteString() : null);
            builder.reaction(reactionBuilder.build());
            builder.requiredProtocolVersion(Math.max(DataMessage.ProtocolVersion.REACTIONS.getValue(), builder.requiredProtocolVersion));
        }
        if (message.getRemoteDelete().isPresent()) {
            DataMessage.Delete delete = new DataMessage.Delete.Builder().targetSentTimestamp(message.getRemoteDelete().get().getTargetSentTimestamp()).build();
            builder.delete(delete);
        }
        if (message.getGroupCallUpdate().isPresent()) {
            String eraId = message.getGroupCallUpdate().get().getEraId();
            if (eraId != null) {
                builder.groupCallUpdate(new DataMessage.GroupCallUpdate.Builder().eraId(eraId).build());
            } else {
                builder.groupCallUpdate(new DataMessage.GroupCallUpdate());
            }
        }
        if (message.getPayment().isPresent()) {
            SignalServiceDataMessage.Payment payment = message.getPayment().get();
            if (payment.getPaymentNotification().isPresent()) {
                SignalServiceDataMessage.PaymentNotification paymentNotification = payment.getPaymentNotification().get();
                DataMessage.Payment.Notification.MobileCoin.Builder mobileCoinPayment = new DataMessage.Payment.Notification.MobileCoin.Builder().receipt(ByteString.of((byte[])paymentNotification.getReceipt()));
                DataMessage.Payment.Notification.Builder paymentBuilder = new DataMessage.Payment.Notification.Builder().note(paymentNotification.getNote()).mobileCoin(mobileCoinPayment.build());
                builder.payment(new DataMessage.Payment.Builder().notification(paymentBuilder.build()).build());
            } else if (payment.getPaymentActivation().isPresent()) {
                DataMessage.Payment.Activation.Builder activationBuilder = new DataMessage.Payment.Activation.Builder().type(payment.getPaymentActivation().get().getType());
                builder.payment(new DataMessage.Payment.Builder().activation(activationBuilder.build()).build());
            }
            builder.requiredProtocolVersion(Math.max(DataMessage.ProtocolVersion.PAYMENTS.getValue(), builder.requiredProtocolVersion));
        }
        if (message.getStoryContext().isPresent()) {
            SignalServiceDataMessage.StoryContext storyContext = message.getStoryContext().get();
            builder.storyContext(new DataMessage.StoryContext.Builder().authorAci(this.useStringId ? storyContext.getAuthorServiceId().toString() : null).authorAciBinary(this.useBinaryId ? storyContext.getAuthorServiceId().toByteString() : null).sentTimestamp(storyContext.getSentTimestamp()).build());
        }
        if (message.getGiftBadge().isPresent()) {
            SignalServiceDataMessage.GiftBadge giftBadge = message.getGiftBadge().get();
            builder.giftBadge(new DataMessage.GiftBadge.Builder().receiptCredentialPresentation(ByteString.of((byte[])giftBadge.getReceiptCredentialPresentation().serialize())).build());
        }
        if (message.getBodyRanges().isPresent()) {
            bodyRanges = new ArrayList<BodyRange>(builder.bodyRanges);
            bodyRanges.addAll((Collection<BodyRange>)message.getBodyRanges().get());
            builder.bodyRanges(bodyRanges);
        }
        if (message.getPollCreate().isPresent()) {
            SignalServiceDataMessage.PollCreate pollCreate = message.getPollCreate().get();
            builder.pollCreate(new DataMessage.PollCreate.Builder().question(pollCreate.getQuestion()).allowMultiple(pollCreate.getAllowMultiple()).options(pollCreate.getOptions()).build());
            builder.requiredProtocolVersion(Math.max(DataMessage.ProtocolVersion.POLLS.getValue(), builder.requiredProtocolVersion));
        }
        if (message.getPollVote().isPresent()) {
            SignalServiceDataMessage.PollVote pollVote = message.getPollVote().get();
            builder.pollVote(new DataMessage.PollVote.Builder().targetSentTimestamp(pollVote.getTargetSentTimestamp()).targetAuthorAciBinary(pollVote.getTargetAuthor().toByteString()).voteCount(pollVote.getVoteCount()).optionIndexes(pollVote.getOptionIndexes()).build());
        }
        if (message.getPollTerminate().isPresent()) {
            SignalServiceDataMessage.PollTerminate pollTerminate = message.getPollTerminate().get();
            builder.pollTerminate(new DataMessage.PollTerminate.Builder().targetSentTimestamp(pollTerminate.getTargetSentTimestamp()).build());
        }
        if (message.getPinnedMessage().isPresent()) {
            SignalServiceDataMessage.PinnedMessage pinnedMessage = message.getPinnedMessage().get();
            if (Boolean.TRUE.equals(pinnedMessage.getForever())) {
                builder.pinMessage(new DataMessage.PinMessage.Builder().targetAuthorAciBinary(pinnedMessage.getTargetAuthor().toByteString()).targetSentTimestamp(pinnedMessage.getTargetSentTimestamp()).pinDurationForever(true).build());
            } else {
                builder.pinMessage(new DataMessage.PinMessage.Builder().targetAuthorAciBinary(pinnedMessage.getTargetAuthor().toByteString()).targetSentTimestamp(pinnedMessage.getTargetSentTimestamp()).pinDurationSeconds(pinnedMessage.getPinDurationInSeconds()).build());
            }
        }
        if (message.getUnpinnedMessage().isPresent()) {
            SignalServiceDataMessage.UnpinnedMessage unpinnedMessage = message.getUnpinnedMessage().get();
            builder.unpinMessage(new DataMessage.UnpinMessage.Builder().targetAuthorAciBinary(unpinnedMessage.getTargetAuthor().toByteString()).targetSentTimestamp(unpinnedMessage.getTargetSentTimestamp()).build());
        }
        builder.timestamp(message.getTimestamp());
        return builder;
    }

    private Preview createPreview(SignalServicePreview preview) throws IOException {
        Preview.Builder previewBuilder = new Preview.Builder().title(preview.getTitle()).description(preview.getDescription()).date(preview.getDate()).url(preview.getUrl());
        if (preview.getImage().isPresent()) {
            if (preview.getImage().get().isStream()) {
                previewBuilder.image(this.createAttachmentPointer(preview.getImage().get().asStream()));
            } else {
                previewBuilder.image(this.createAttachmentPointer(preview.getImage().get().asPointer()));
            }
        }
        return previewBuilder.build();
    }

    private Content createCallContent(SignalServiceCallMessage callMessage) {
        Content.Builder container = new Content.Builder();
        CallMessage.Builder builder = new CallMessage.Builder();
        if (callMessage.getOfferMessage().isPresent()) {
            OfferMessage offer = callMessage.getOfferMessage().get();
            CallMessage.Offer.Builder offerBuilder = new CallMessage.Offer.Builder().id(offer.getId()).type(offer.getType().getProtoType());
            if (offer.getOpaque() != null) {
                offerBuilder.opaque(ByteString.of((byte[])offer.getOpaque()));
            }
            builder.offer(offerBuilder.build());
        } else if (callMessage.getAnswerMessage().isPresent()) {
            AnswerMessage answer = callMessage.getAnswerMessage().get();
            CallMessage.Answer.Builder answerBuilder = new CallMessage.Answer.Builder().id(answer.getId());
            if (answer.getOpaque() != null) {
                answerBuilder.opaque(ByteString.of((byte[])answer.getOpaque()));
            }
            builder.answer(answerBuilder.build());
        } else if (callMessage.getIceUpdateMessages().isPresent()) {
            List<IceUpdateMessage> updates = callMessage.getIceUpdateMessages().get();
            ArrayList<CallMessage.IceUpdate> iceUpdates = new ArrayList<CallMessage.IceUpdate>(updates.size());
            for (IceUpdateMessage update : updates) {
                CallMessage.IceUpdate.Builder iceBuilder = new CallMessage.IceUpdate.Builder().id(update.getId());
                if (update.getOpaque() != null) {
                    iceBuilder.opaque(ByteString.of((byte[])update.getOpaque()));
                }
                iceUpdates.add(iceBuilder.build());
            }
            builder.iceUpdate(iceUpdates);
        } else if (callMessage.getHangupMessage().isPresent()) {
            CallMessage.Hangup.Type protoType = callMessage.getHangupMessage().get().getType().getProtoType();
            CallMessage.Hangup.Builder builderForHangup = new CallMessage.Hangup.Builder().type(protoType).id(callMessage.getHangupMessage().get().getId());
            if (protoType != CallMessage.Hangup.Type.HANGUP_NORMAL) {
                builderForHangup.deviceId(callMessage.getHangupMessage().get().getDeviceId());
            }
            builder.hangup(builderForHangup.build());
        } else if (callMessage.getBusyMessage().isPresent()) {
            builder.busy(new CallMessage.Busy.Builder().id(callMessage.getBusyMessage().get().getId()).build());
        } else if (callMessage.getOpaqueMessage().isPresent()) {
            OpaqueMessage opaqueMessage = callMessage.getOpaqueMessage().get();
            ByteString data = ByteString.of((byte[])opaqueMessage.getOpaque());
            CallMessage.Opaque.Urgency urgency = opaqueMessage.getUrgency().toProto();
            builder.opaque(new CallMessage.Opaque.Builder().data_(data).urgency(urgency).build());
        }
        if (callMessage.getDestinationDeviceId().isPresent()) {
            builder.destinationDeviceId(callMessage.getDestinationDeviceId().get());
        }
        container.callMessage(builder.build());
        return container.build();
    }

    private Content createMultiDeviceContactsContent(SignalServiceAttachmentStream contacts, boolean complete) throws IOException {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder builder = this.createSyncMessageBuilder();
        builder.contacts(new SyncMessage.Contacts.Builder().blob(this.createAttachmentPointer(contacts)).complete(complete).build());
        return container.syncMessage(builder.build()).build();
    }

    private Content createMultiDeviceGroupsContent(SignalServiceAttachmentStream groups) throws IOException {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder builder = this.createSyncMessageBuilder();
        builder.groups(new SyncMessage.Groups.Builder().blob(this.createAttachmentPointer(groups)).build());
        return container.syncMessage(builder.build()).build();
    }

    private Content createMultiDeviceSentTranscriptContent(SentTranscriptMessage transcript) throws IOException {
        SignalServiceAddress address = transcript.getDestination().get();
        Content content = this.createMessageContent(transcript);
        SendMessageResult result2 = SendMessageResult.success(address, Collections.emptyList(), false, true, -1L, Optional.ofNullable(content));
        return this.createMultiDeviceSentTranscriptContent(content, Optional.of(address), transcript.getTimestamp(), Collections.singletonList(result2), transcript.isRecipientUpdate(), transcript.getStoryMessageRecipients());
    }

    private Content createMultiDeviceSentTranscriptContent(Content content, Optional<SignalServiceAddress> recipient, long timestamp, List<SendMessageResult> sendMessageResults, boolean isRecipientUpdate, Set<SignalServiceStoryMessageRecipient> storyMessageRecipients) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder syncMessage = this.createSyncMessageBuilder();
        SyncMessage.Sent.Builder sentMessage = new SyncMessage.Sent.Builder();
        DataMessage dataMessage = content != null && content.dataMessage != null ? content.dataMessage : null;
        StoryMessage storyMessage = content != null && content.storyMessage != null ? content.storyMessage : null;
        EditMessage editMessage = content != null && content.editMessage != null ? content.editMessage : null;
        sentMessage.timestamp(timestamp);
        ArrayList<SyncMessage.Sent.UnidentifiedDeliveryStatus> unidentifiedDeliveryStatuses = new ArrayList<SyncMessage.Sent.UnidentifiedDeliveryStatus>(sendMessageResults.size());
        for (SendMessageResult result2 : sendMessageResults) {
            if (result2.getSuccess() == null) continue;
            ByteString identity = null;
            if (result2.getAddress().getServiceId() instanceof ServiceId.PNI) {
                IdentityKey identityKey = this.aciStore.getIdentity(result2.getAddress().getServiceId().toProtocolAddress(1));
                if (identityKey != null) {
                    identity = ByteString.of((byte[])identityKey.getPublicKey().serialize());
                } else {
                    Log.w((String)TAG, (String)("[" + timestamp + "] Could not find an identity for PNI when sending sync message! " + String.valueOf(result2.getAddress().getServiceId())));
                }
            }
            unidentifiedDeliveryStatuses.add(new SyncMessage.Sent.UnidentifiedDeliveryStatus.Builder().destinationServiceId(this.useStringId ? result2.getAddress().getServiceId().toString() : null).destinationServiceIdBinary(this.useBinaryId ? result2.getAddress().getServiceId().toByteString() : null).unidentified(false).destinationPniIdentityKey(identity).build());
        }
        sentMessage.unidentifiedStatus(unidentifiedDeliveryStatuses);
        if (recipient.isPresent()) {
            sentMessage.destinationServiceId(this.useStringId ? recipient.get().getServiceId().toString() : null);
            sentMessage.destinationServiceIdBinary(this.useBinaryId ? recipient.get().getServiceId().toByteString() : null);
            if (recipient.get().getNumber().isPresent()) {
                sentMessage.destinationE164(recipient.get().getNumber().get());
            }
        }
        if (dataMessage != null) {
            sentMessage.message(dataMessage);
            if (dataMessage.expireTimer != null && dataMessage.expireTimer > 0) {
                sentMessage.expirationStartTimestamp(System.currentTimeMillis());
            }
            if (dataMessage.isViewOnce != null && dataMessage.isViewOnce.booleanValue()) {
                dataMessage = dataMessage.newBuilder().attachments(Collections.emptyList()).build();
                sentMessage.message(dataMessage);
            }
        }
        if (storyMessage != null) {
            sentMessage.storyMessage(storyMessage);
        }
        if (editMessage != null) {
            sentMessage.editMessage(editMessage);
        }
        Set storyMessageRecipientsSet = storyMessageRecipients.stream().map(this::createStoryMessageRecipient).collect(Collectors.toSet());
        sentMessage.storyMessageRecipients(new ArrayList<SyncMessage.Sent.StoryMessageRecipient>(storyMessageRecipientsSet));
        sentMessage.isRecipientUpdate(isRecipientUpdate);
        return container.syncMessage(syncMessage.sent(sentMessage.build()).build()).build();
    }

    private SyncMessage.Sent.StoryMessageRecipient createStoryMessageRecipient(SignalServiceStoryMessageRecipient storyMessageRecipient) {
        return new SyncMessage.Sent.StoryMessageRecipient.Builder().distributionListIds(storyMessageRecipient.getDistributionListIds()).destinationServiceId(this.useStringId ? storyMessageRecipient.getSignalServiceAddress().getIdentifier() : null).destinationServiceIdBinary(this.useBinaryId ? storyMessageRecipient.getSignalServiceAddress().getServiceId().toByteString() : null).isAllowedToReply(storyMessageRecipient.isAllowedToReply()).build();
    }

    private Content createMultiDeviceReadContent(List<ReadMessage> readMessages) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder builder = this.createSyncMessageBuilder();
        builder.read(readMessages.stream().map(readMessage -> new SyncMessage.Read.Builder().timestamp(readMessage.getTimestamp()).senderAci(this.useStringId ? readMessage.getSenderAci().toString() : null).senderAciBinary(this.useBinaryId ? readMessage.getSenderAci().toByteString() : null).build()).collect(Collectors.toList()));
        return container.syncMessage(builder.build()).build();
    }

    private Content createMultiDeviceViewedContent(List<ViewedMessage> readMessages) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder builder = this.createSyncMessageBuilder();
        builder.viewed(readMessages.stream().map(readMessage -> new SyncMessage.Viewed.Builder().timestamp(readMessage.getTimestamp()).senderAci(this.useStringId ? readMessage.getSender().toString() : null).senderAciBinary(this.useBinaryId ? readMessage.getSender().toByteString() : null).build()).collect(Collectors.toList()));
        return container.syncMessage(builder.build()).build();
    }

    private Content createMultiDeviceViewOnceOpenContent(ViewOnceOpenMessage readMessage) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder builder = this.createSyncMessageBuilder();
        builder.viewOnceOpen(new SyncMessage.ViewOnceOpen.Builder().timestamp(readMessage.getTimestamp()).senderAci(this.useStringId ? readMessage.getSender().toString() : null).senderAciBinary(this.useBinaryId ? readMessage.getSender().toByteString() : null).build());
        return container.syncMessage(builder.build()).build();
    }

    private Content createMultiDeviceBlockedContent(BlockedListMessage blocked) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder syncMessage = this.createSyncMessageBuilder();
        SyncMessage.Blocked.Builder blockedMessage = new SyncMessage.Blocked.Builder();
        blockedMessage.acis(this.useStringId ? blocked.individuals.stream().filter(a -> a.getAci() != null).map(a -> a.getAci().toString()).collect(Collectors.toList()) : Collections.emptyList());
        blockedMessage.acisBinary(this.useBinaryId ? blocked.individuals.stream().filter(a -> a.getAci() != null).map(a -> a.getAci().toByteString()).collect(Collectors.toList()) : Collections.emptyList());
        blockedMessage.numbers(blocked.individuals.stream().filter(a -> a.getE164() != null).map(a -> a.getE164()).collect(Collectors.toList()));
        blockedMessage.groupIds(blocked.groupIds.stream().map(ByteString::of).collect(Collectors.toList()));
        return container.syncMessage(syncMessage.blocked(blockedMessage.build()).build()).build();
    }

    private Content createMultiDeviceConfigurationContent(ConfigurationMessage configuration) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder syncMessage = this.createSyncMessageBuilder();
        SyncMessage.Configuration.Builder configurationMessage = new SyncMessage.Configuration.Builder();
        if (configuration.getReadReceipts().isPresent()) {
            configurationMessage.readReceipts(configuration.getReadReceipts().get());
        }
        if (configuration.getUnidentifiedDeliveryIndicators().isPresent()) {
            configurationMessage.unidentifiedDeliveryIndicators(configuration.getUnidentifiedDeliveryIndicators().get());
        }
        if (configuration.getTypingIndicators().isPresent()) {
            configurationMessage.typingIndicators(configuration.getTypingIndicators().get());
        }
        if (configuration.getLinkPreviews().isPresent()) {
            configurationMessage.linkPreviews(configuration.getLinkPreviews().get());
        }
        configurationMessage.provisioningVersion(ProvisioningVersion.CURRENT.getValue());
        return container.syncMessage(syncMessage.configuration(configurationMessage.build()).build()).build();
    }

    private Content createMultiDeviceStickerPackOperationContent(List<StickerPackOperationMessage> stickerPackOperations) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder syncMessage = this.createSyncMessageBuilder();
        ArrayList<SyncMessage.StickerPackOperation> stickerPackOperationProtos = new ArrayList<SyncMessage.StickerPackOperation>(stickerPackOperations.size());
        for (StickerPackOperationMessage stickerPackOperation : stickerPackOperations) {
            SyncMessage.StickerPackOperation.Builder builder = new SyncMessage.StickerPackOperation.Builder();
            if (stickerPackOperation.getPackId().isPresent()) {
                builder.packId(ByteString.of((byte[])stickerPackOperation.getPackId().get()));
            }
            if (stickerPackOperation.getPackKey().isPresent()) {
                builder.packKey(ByteString.of((byte[])stickerPackOperation.getPackKey().get()));
            }
            if (stickerPackOperation.getType().isPresent()) {
                switch (stickerPackOperation.getType().get()) {
                    case INSTALL: {
                        builder.type(SyncMessage.StickerPackOperation.Type.INSTALL);
                        break;
                    }
                    case REMOVE: {
                        builder.type(SyncMessage.StickerPackOperation.Type.REMOVE);
                    }
                }
            }
            stickerPackOperationProtos.add(builder.build());
        }
        return container.syncMessage(syncMessage.stickerPackOperation(stickerPackOperationProtos).build()).build();
    }

    private Content createMultiDeviceFetchTypeContent(SignalServiceSyncMessage.FetchType fetchType) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder syncMessage = this.createSyncMessageBuilder();
        SyncMessage.FetchLatest.Builder fetchMessage = new SyncMessage.FetchLatest.Builder();
        switch (fetchType) {
            case LOCAL_PROFILE: {
                fetchMessage.type(SyncMessage.FetchLatest.Type.LOCAL_PROFILE);
                break;
            }
            case STORAGE_MANIFEST: {
                fetchMessage.type(SyncMessage.FetchLatest.Type.STORAGE_MANIFEST);
                break;
            }
            case SUBSCRIPTION_STATUS: {
                fetchMessage.type(SyncMessage.FetchLatest.Type.SUBSCRIPTION_STATUS);
                break;
            }
            default: {
                Log.w((String)TAG, (String)"Unknown fetch type!");
            }
        }
        return container.syncMessage(syncMessage.fetchLatest(fetchMessage.build()).build()).build();
    }

    private Content createMultiDeviceMessageRequestResponseContent(MessageRequestResponseMessage message) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder syncMessage = this.createSyncMessageBuilder();
        SyncMessage.MessageRequestResponse.Builder responseMessage = new SyncMessage.MessageRequestResponse.Builder();
        if (message.getGroupId().isPresent()) {
            responseMessage.groupId(ByteString.of((byte[])message.getGroupId().get()));
        }
        if (message.getPerson().isPresent()) {
            responseMessage.threadAci(this.useStringId ? message.getPerson().get().toString() : null);
            responseMessage.threadAciBinary(this.useBinaryId ? message.getPerson().get().toByteString() : null);
        }
        switch (message.getType()) {
            case ACCEPT: {
                responseMessage.type(SyncMessage.MessageRequestResponse.Type.ACCEPT);
                break;
            }
            case DELETE: {
                responseMessage.type(SyncMessage.MessageRequestResponse.Type.DELETE);
                break;
            }
            case BLOCK: {
                responseMessage.type(SyncMessage.MessageRequestResponse.Type.BLOCK);
                break;
            }
            case BLOCK_AND_DELETE: {
                responseMessage.type(SyncMessage.MessageRequestResponse.Type.BLOCK_AND_DELETE);
                break;
            }
            case SPAM: {
                responseMessage.type(SyncMessage.MessageRequestResponse.Type.SPAM);
                break;
            }
            case BLOCK_AND_SPAM: {
                responseMessage.type(SyncMessage.MessageRequestResponse.Type.BLOCK_AND_SPAM);
                break;
            }
            default: {
                Log.w((String)TAG, (String)"Unknown type!");
                responseMessage.type(SyncMessage.MessageRequestResponse.Type.UNKNOWN);
            }
        }
        syncMessage.messageRequestResponse(responseMessage.build());
        return container.syncMessage(syncMessage.build()).build();
    }

    private Content createMultiDeviceOutgoingPaymentContent(OutgoingPaymentMessage message) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder syncMessage = this.createSyncMessageBuilder();
        SyncMessage.OutgoingPayment.Builder paymentMessage = new SyncMessage.OutgoingPayment.Builder();
        if (message.getRecipient().isPresent()) {
            paymentMessage.recipientServiceId(message.getRecipient().get().toString());
        }
        if (message.getNote().isPresent()) {
            paymentMessage.note(message.getNote().get());
        }
        try {
            SyncMessage.OutgoingPayment.MobileCoin.Builder mobileCoinBuilder = new SyncMessage.OutgoingPayment.MobileCoin.Builder();
            if (message.getAddress().isPresent()) {
                mobileCoinBuilder.recipientAddress(ByteString.of((byte[])message.getAddress().get()));
            }
            mobileCoinBuilder.amountPicoMob(Uint64Util.bigIntegerToUInt64(message.getAmount().toPicoMobBigInteger())).feePicoMob(Uint64Util.bigIntegerToUInt64(message.getFee().toPicoMobBigInteger())).receipt(message.getReceipt()).ledgerBlockTimestamp(message.getBlockTimestamp()).ledgerBlockIndex(message.getBlockIndex()).outputPublicKeys(message.getPublicKeys()).spentKeyImages(message.getKeyImages());
            paymentMessage.mobileCoin(mobileCoinBuilder.build());
        }
        catch (Uint64RangeException e) {
            throw new AssertionError((Object)e);
        }
        syncMessage.outgoingPayment(paymentMessage.build());
        return container.syncMessage(syncMessage.build()).build();
    }

    private Content createMultiDeviceSyncKeysContent(KeysMessage keysMessage) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder syncMessage = this.createSyncMessageBuilder();
        SyncMessage.Keys.Builder builder = new SyncMessage.Keys.Builder();
        if (keysMessage.getMaster() != null) {
            builder.master(ByteString.of((byte[])keysMessage.getMaster().serialize()));
        }
        if (keysMessage.getAccountEntropyPool() != null) {
            builder.accountEntropyPool(keysMessage.getAccountEntropyPool().getValue());
        }
        if (keysMessage.getMediaRootBackupKey() != null) {
            builder.mediaRootBackupKey(ByteString.of((byte[])keysMessage.getMediaRootBackupKey().getValue()));
        }
        return container.syncMessage(syncMessage.keys(builder.build()).build()).build();
    }

    private Content createMultiDeviceVerifiedContent(VerifiedMessage verifiedMessage, byte[] nullMessage) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder syncMessage = this.createSyncMessageBuilder();
        Verified.Builder verifiedMessageBuilder = new Verified.Builder();
        verifiedMessageBuilder.nullMessage(ByteString.of((byte[])nullMessage));
        verifiedMessageBuilder.identityKey(ByteString.of((byte[])verifiedMessage.getIdentityKey().serialize()));
        verifiedMessageBuilder.destinationAci(this.useStringId ? verifiedMessage.getDestination().getServiceId().toString() : null);
        verifiedMessageBuilder.destinationAciBinary(this.useBinaryId ? verifiedMessage.getDestination().getServiceId().toByteString() : null);
        switch (verifiedMessage.getVerified()) {
            case DEFAULT: {
                verifiedMessageBuilder.state(Verified.State.DEFAULT);
                break;
            }
            case VERIFIED: {
                verifiedMessageBuilder.state(Verified.State.VERIFIED);
                break;
            }
            case UNVERIFIED: {
                verifiedMessageBuilder.state(Verified.State.UNVERIFIED);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown: " + String.valueOf((Object)verifiedMessage.getVerified())));
            }
        }
        syncMessage.verified(verifiedMessageBuilder.build());
        return container.syncMessage(syncMessage.build()).build();
    }

    private Content createRequestContent(SyncMessage.Request request2) throws IOException {
        if (this.localDeviceId == 1) {
            throw new IOException("Sync requests should only be sent from a linked device");
        }
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder builder = this.createSyncMessageBuilder().request(request2);
        return container.syncMessage(builder.build()).build();
    }

    private Content createCallEventContent(SyncMessage.CallEvent proto) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder builder = this.createSyncMessageBuilder().callEvent(proto);
        return container.syncMessage(builder.build()).build();
    }

    private Content createCallLinkUpdateContent(SyncMessage.CallLinkUpdate proto) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder builder = this.createSyncMessageBuilder().callLinkUpdate(proto);
        return container.syncMessage(builder.build()).build();
    }

    private Content createCallLogEventContent(SyncMessage.CallLogEvent proto) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder builder = this.createSyncMessageBuilder().callLogEvent(proto);
        return container.syncMessage(builder.build()).build();
    }

    private Content createDeviceNameChangeContent(SyncMessage.DeviceNameChange proto) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder builder = this.createSyncMessageBuilder().deviceNameChange(proto);
        return container.syncMessage(builder.build()).build();
    }

    private Content createAttachmentBackfillResponseContent(SyncMessage.AttachmentBackfillResponse proto) {
        Content.Builder container = new Content.Builder();
        SyncMessage.Builder builder = this.createSyncMessageBuilder().attachmentBackfillResponse(proto);
        return container.syncMessage(builder.build()).build();
    }

    private SyncMessage.Builder createSyncMessageBuilder() {
        byte[] padding = Util.getRandomLengthSecretBytes(512);
        SyncMessage.Builder builder = new SyncMessage.Builder();
        builder.padding(ByteString.of((byte[])padding));
        return builder;
    }

    private GroupContext createGroupContent(SignalServiceGroup group) throws IOException {
        GroupContext.Builder builder = new GroupContext.Builder();
        builder.id(ByteString.of((byte[])group.getGroupId()));
        if (group.getType() != SignalServiceGroup.Type.DELIVER) {
            if (group.getType() == SignalServiceGroup.Type.UPDATE) {
                builder.type(GroupContext.Type.UPDATE);
            } else if (group.getType() == SignalServiceGroup.Type.QUIT) {
                builder.type(GroupContext.Type.QUIT);
            } else if (group.getType() == SignalServiceGroup.Type.REQUEST_INFO) {
                builder.type(GroupContext.Type.REQUEST_INFO);
            } else {
                throw new AssertionError((Object)("Unknown type: " + String.valueOf((Object)group.getType())));
            }
            if (group.getName().isPresent()) {
                builder.name(group.getName().get());
            }
            if (group.getMembers().isPresent()) {
                List<String> members = group.getMembers().get().stream().filter(address -> address.getNumber().isPresent()).map(address -> address.getNumber().get()).collect(Collectors.toList());
                builder.membersE164(members);
                builder.members(members.stream().map(number -> new GroupContext.Member.Builder().e164((String)number).build()).collect(Collectors.toList()));
            }
            if (group.getAvatar().isPresent()) {
                if (group.getAvatar().get().isStream()) {
                    builder.avatar(this.createAttachmentPointer(group.getAvatar().get().asStream()));
                } else {
                    builder.avatar(this.createAttachmentPointer(group.getAvatar().get().asPointer()));
                }
            }
        } else {
            builder.type(GroupContext.Type.DELIVER);
        }
        return builder.build();
    }

    private static GroupContextV2 createGroupContent(SignalServiceGroupV2 group) {
        GroupContextV2.Builder builder = new GroupContextV2.Builder().masterKey(ByteString.of((byte[])group.getMasterKey().serialize())).revision(group.getRevision());
        byte[] signedGroupChange = group.getSignedGroupChange();
        if (signedGroupChange != null && signedGroupChange.length <= 2048) {
            builder.groupChange(ByteString.of((byte[])signedGroupChange));
        }
        return builder.build();
    }

    private List<DataMessage.Contact> createSharedContactContent(List<SharedContact> contacts) throws IOException {
        LinkedList<DataMessage.Contact> results = new LinkedList<DataMessage.Contact>();
        for (SharedContact contact : contacts) {
            DataMessage.Contact.Name.Builder nameBuilder = new DataMessage.Contact.Name.Builder();
            if (contact.getName().getFamily().isPresent()) {
                nameBuilder.familyName(contact.getName().getFamily().get());
            }
            if (contact.getName().getGiven().isPresent()) {
                nameBuilder.givenName(contact.getName().getGiven().get());
            }
            if (contact.getName().getMiddle().isPresent()) {
                nameBuilder.middleName(contact.getName().getMiddle().get());
            }
            if (contact.getName().getPrefix().isPresent()) {
                nameBuilder.prefix(contact.getName().getPrefix().get());
            }
            if (contact.getName().getSuffix().isPresent()) {
                nameBuilder.suffix(contact.getName().getSuffix().get());
            }
            if (contact.getName().getNickname().isPresent()) {
                nameBuilder.nickname(contact.getName().getNickname().get());
            }
            DataMessage.Contact.Builder contactBuilder = new DataMessage.Contact.Builder().name(nameBuilder.build());
            if (contact.getAddress().isPresent()) {
                ArrayList<DataMessage.Contact.PostalAddress> postalAddresses = new ArrayList<DataMessage.Contact.PostalAddress>(contact.getAddress().get().size());
                for (SharedContact.PostalAddress address : contact.getAddress().get()) {
                    DataMessage.Contact.PostalAddress.Builder addressBuilder = new DataMessage.Contact.PostalAddress.Builder();
                    switch (address.getType()) {
                        case HOME: {
                            addressBuilder.type(DataMessage.Contact.PostalAddress.Type.HOME);
                            break;
                        }
                        case WORK: {
                            addressBuilder.type(DataMessage.Contact.PostalAddress.Type.WORK);
                            break;
                        }
                        case CUSTOM: {
                            addressBuilder.type(DataMessage.Contact.PostalAddress.Type.CUSTOM);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unknown type: " + String.valueOf((Object)address.getType())));
                        }
                    }
                    if (address.getCity().isPresent()) {
                        addressBuilder.city(address.getCity().get());
                    }
                    if (address.getCountry().isPresent()) {
                        addressBuilder.country(address.getCountry().get());
                    }
                    if (address.getLabel().isPresent()) {
                        addressBuilder.label(address.getLabel().get());
                    }
                    if (address.getNeighborhood().isPresent()) {
                        addressBuilder.neighborhood(address.getNeighborhood().get());
                    }
                    if (address.getPobox().isPresent()) {
                        addressBuilder.pobox(address.getPobox().get());
                    }
                    if (address.getPostcode().isPresent()) {
                        addressBuilder.postcode(address.getPostcode().get());
                    }
                    if (address.getRegion().isPresent()) {
                        addressBuilder.region(address.getRegion().get());
                    }
                    if (address.getStreet().isPresent()) {
                        addressBuilder.street(address.getStreet().get());
                    }
                    postalAddresses.add(addressBuilder.build());
                }
                contactBuilder.address(postalAddresses);
            }
            if (contact.getEmail().isPresent()) {
                ArrayList<DataMessage.Contact.Email> emails = new ArrayList<DataMessage.Contact.Email>(contact.getEmail().get().size());
                for (SharedContact.Email email : contact.getEmail().get()) {
                    DataMessage.Contact.Email.Builder emailBuilder = new DataMessage.Contact.Email.Builder().value_(email.getValue());
                    switch (email.getType()) {
                        case HOME: {
                            emailBuilder.type(DataMessage.Contact.Email.Type.HOME);
                            break;
                        }
                        case WORK: {
                            emailBuilder.type(DataMessage.Contact.Email.Type.WORK);
                            break;
                        }
                        case MOBILE: {
                            emailBuilder.type(DataMessage.Contact.Email.Type.MOBILE);
                            break;
                        }
                        case CUSTOM: {
                            emailBuilder.type(DataMessage.Contact.Email.Type.CUSTOM);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unknown type: " + String.valueOf((Object)email.getType())));
                        }
                    }
                    if (email.getLabel().isPresent()) {
                        emailBuilder.label(email.getLabel().get());
                    }
                    emails.add(emailBuilder.build());
                }
                contactBuilder.email(emails);
            }
            if (contact.getPhone().isPresent()) {
                ArrayList<DataMessage.Contact.Phone> phones = new ArrayList<DataMessage.Contact.Phone>(contact.getPhone().get().size());
                for (SharedContact.Phone phone : contact.getPhone().get()) {
                    DataMessage.Contact.Phone.Builder phoneBuilder = new DataMessage.Contact.Phone.Builder().value_(phone.getValue());
                    switch (phone.getType()) {
                        case HOME: {
                            phoneBuilder.type(DataMessage.Contact.Phone.Type.HOME);
                            break;
                        }
                        case WORK: {
                            phoneBuilder.type(DataMessage.Contact.Phone.Type.WORK);
                            break;
                        }
                        case MOBILE: {
                            phoneBuilder.type(DataMessage.Contact.Phone.Type.MOBILE);
                            break;
                        }
                        case CUSTOM: {
                            phoneBuilder.type(DataMessage.Contact.Phone.Type.CUSTOM);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unknown type: " + String.valueOf((Object)phone.getType())));
                        }
                    }
                    if (phone.getLabel().isPresent()) {
                        phoneBuilder.label(phone.getLabel().get());
                    }
                    phones.add(phoneBuilder.build());
                }
                contactBuilder.number(phones);
            }
            if (contact.getAvatar().isPresent()) {
                AttachmentPointer pointer = contact.getAvatar().get().getAttachment().isStream() ? this.createAttachmentPointer(contact.getAvatar().get().getAttachment().asStream()) : this.createAttachmentPointer(contact.getAvatar().get().getAttachment().asPointer());
                contactBuilder.avatar(new DataMessage.Contact.Avatar.Builder().avatar(pointer).isProfile(contact.getAvatar().get().isProfile()).build());
            }
            if (contact.getOrganization().isPresent()) {
                contactBuilder.organization(contact.getOrganization().get());
            }
            results.add(contactBuilder.build());
        }
        return results;
    }

    private byte[] createStickerManifestContent(SignalServiceStickerManifest manifest) {
        ArrayList<Pack.Sticker> stickers = new ArrayList<Pack.Sticker>();
        for (SignalServiceStickerManifest.StickerInfo sticker : manifest.getStickers()) {
            stickers.add(new Pack.Sticker.Builder().id(sticker.getId()).emoji(sticker.getEmoji()).build());
        }
        Pack.Builder builder = new Pack.Builder().stickers(stickers);
        if (manifest.getTitle().isPresent()) {
            builder.title(manifest.getTitle().get());
        }
        if (manifest.getAuthor().isPresent()) {
            builder.author(manifest.getAuthor().get());
        }
        if (manifest.getCover().isPresent()) {
            builder.cover(new Pack.Sticker.Builder().id(manifest.getCover().get().getId()).emoji(manifest.getCover().get().getEmoji()).build());
        }
        return builder.build().encode();
    }

    private SignalServiceSyncMessage createSelfSendSyncMessageForStory(SignalServiceStoryMessage message, long sentTimestamp, boolean isRecipientUpdate, Set<SignalServiceStoryMessageRecipient> manifest) {
        SentTranscriptMessage transcript = new SentTranscriptMessage(Optional.of(this.localAddress), sentTimestamp, Optional.empty(), 0L, Collections.singletonMap(this.localAddress.getServiceId(), false), isRecipientUpdate, Optional.of(message), manifest, Optional.empty());
        return SignalServiceSyncMessage.forSentTranscript(transcript);
    }

    private SignalServiceSyncMessage createSelfSendSyncMessage(SignalServiceDataMessage message) {
        SentTranscriptMessage transcript = new SentTranscriptMessage(Optional.of(this.localAddress), message.getTimestamp(), Optional.of(message), message.getExpiresInSeconds(), Collections.singletonMap(this.localAddress.getServiceId(), false), false, Optional.empty(), Collections.emptySet(), Optional.empty());
        return SignalServiceSyncMessage.forSentTranscript(transcript);
    }

    private SignalServiceSyncMessage createSelfSendSyncEditMessage(SignalServiceEditMessage message) {
        SentTranscriptMessage transcript = new SentTranscriptMessage(Optional.of(this.localAddress), message.getDataMessage().getTimestamp(), Optional.empty(), message.getDataMessage().getExpiresInSeconds(), Collections.singletonMap(this.localAddress.getServiceId(), false), false, Optional.empty(), Collections.emptySet(), Optional.of(message));
        return SignalServiceSyncMessage.forSentTranscript(transcript);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SendMessageResult sendMessage(SignalServiceAddress recipient, @Nullable SealedSenderAccess sealedSenderAccess, long timestamp, EnvelopeContent content, boolean online, CancelationSignal cancelationSignal, SendEvents sendEvents, boolean urgent, boolean story) throws UntrustedIdentityException, IOException {
        this.enforceMaxEnvelopeContentSize(content);
        long startTime = System.currentTimeMillis();
        int i = 0;
        while (i < 4) {
            block27: {
                if (cancelationSignal != null && cancelationSignal.isCanceled()) {
                    return SendMessageResult.canceledFailure(recipient);
                }
                try {
                    OutgoingPushMessageList messages;
                    block25: {
                        messages = this.getEncryptedMessages(recipient, sealedSenderAccess, timestamp, content, online, urgent, story);
                        if (i == 0 && sendEvents != null) {
                            sendEvents.onMessageEncrypted();
                        }
                        if (content.getContent().isPresent() && content.getContent().get().syncMessage != null && content.getContent().get().syncMessage.sent != null) {
                            Log.d((String)TAG, (String)("[sendMessage][" + timestamp + "] Sending a sent sync message to devices: " + String.valueOf(messages.getDevices())));
                        } else if (content.getContent().isPresent() && content.getContent().get().senderKeyDistributionMessage != null) {
                            Log.d((String)TAG, (String)("[sendMessage][" + timestamp + "] Sending a SKDM to " + messages.getDestination() + " for devices: " + String.valueOf(messages.getDevices()) + (content.getContent().get().dataMessage != null ? " (it's piggy-backing on a DataMessage)" : "")));
                        }
                        if (cancelationSignal == null || !cancelationSignal.isCanceled()) break block25;
                        return SendMessageResult.canceledFailure(recipient);
                    }
                    try {
                        boolean bl;
                        SendMessageResponse response = NetworkResultUtil.toMessageSendLegacy(messages.getDestination(), this.messageApi.sendMessage(messages, sealedSenderAccess, story));
                        List<Integer> list = messages.getDevices();
                        boolean bl2 = response.sentUnidentified();
                        if (!response.getNeedsSync() && !this.aciStore.isMultiDevice()) {
                            bl = false;
                            return SendMessageResult.success(recipient, list, bl2, bl, System.currentTimeMillis() - startTime, content.getContent());
                        }
                        bl = true;
                        return SendMessageResult.success(recipient, list, bl2, bl, System.currentTimeMillis() - startTime, content.getContent());
                    }
                    catch (AuthorizationFailedException | ProofRequiredException | RateLimitException | ServerRejectedException | UnregisteredUserException | MismatchedDevicesException | StaleDevicesException e) {
                        try {
                            boolean bl;
                            block26: {
                                throw e;
                                catch (WebSocketUnavailableException e2) {
                                    String pipe;
                                    String string = pipe = sealedSenderAccess == null ? "Pipe" : "Unidentified pipe";
                                    if (!this.useRestFallback.getAsBoolean()) {
                                        Log.i((String)TAG, (String)("[sendMessage][" + timestamp + "] " + pipe + " unavailable (" + e2.getClass().getSimpleName() + ": " + e2.getMessage() + ")"));
                                        throw e2;
                                    }
                                    Log.i((String)TAG, (String)("[sendMessage][" + timestamp + "] " + pipe + " unavailable, falling back... (" + e2.getClass().getSimpleName() + ": " + e2.getMessage() + ")"));
                                    break block26;
                                }
                                catch (IOException e3) {
                                    IOException iOException;
                                    String pipe = sealedSenderAccess == null ? "Pipe" : "Unidentified pipe";
                                    Throwable cause = e3;
                                    if (e3.getCause() != null) {
                                        cause = e3.getCause();
                                    }
                                    if (this.useRestFallback.getAsBoolean()) {
                                        Log.w((String)TAG, (String)("[sendMessage][" + timestamp + "] " + pipe + " failed, falling back... (" + cause.getClass().getSimpleName() + ": " + cause.getMessage() + ")"));
                                        break block26;
                                    }
                                    Log.w((String)TAG, (String)("[sendMessage][" + timestamp + "] " + pipe + " failed (" + cause.getClass().getSimpleName() + ": " + cause.getMessage() + ")"));
                                    if (cause instanceof IOException) {
                                        iOException = (IOException)cause;
                                        throw iOException;
                                    }
                                    iOException = e3;
                                    throw iOException;
                                }
                            }
                            if (cancelationSignal != null && cancelationSignal.isCanceled()) {
                                return SendMessageResult.canceledFailure(recipient);
                            }
                            SendMessageResponse response = this.socket.sendMessage(messages, sealedSenderAccess, story);
                            List<Integer> list = messages.getDevices();
                            boolean bl3 = response.sentUnidentified();
                            if (!response.getNeedsSync() && !this.aciStore.isMultiDevice()) {
                                bl = false;
                                return SendMessageResult.success(recipient, list, bl3, bl, System.currentTimeMillis() - startTime, content.getContent());
                            }
                            bl = true;
                            return SendMessageResult.success(recipient, list, bl3, bl, System.currentTimeMillis() - startTime, content.getContent());
                        }
                        catch (AuthorizationFailedException afe) {
                            if (sealedSenderAccess == null) {
                                Log.w((String)TAG, (String)"Got an AuthorizationFailedException without using sealed sender!", (Throwable)afe);
                                throw afe;
                            }
                            Log.w((String)TAG, (String)"Got an AuthorizationFailedException when trying to send using sealed sender. Falling back.");
                            sealedSenderAccess = sealedSenderAccess.switchToFallback();
                        }
                        catch (MismatchedDevicesException mde) {
                            Log.w((String)TAG, (String)("[sendMessage][" + timestamp + "] Handling mismatched devices. (" + mde.getMessage() + ")"));
                            this.handleMismatchedDevices(recipient, mde.getMismatchedDevices());
                        }
                        catch (StaleDevicesException ste) {
                            Log.w((String)TAG, (String)("[sendMessage][" + timestamp + "] Handling stale devices. (" + ste.getMessage() + ")"));
                            this.handleStaleDevices(recipient, ste.getStaleDevices());
                        }
                    }
                }
                catch (InvalidKeyException ike) {
                    Log.w((String)TAG, (Throwable)ike);
                    if (sealedSenderAccess == null) break block27;
                    sealedSenderAccess = sealedSenderAccess.switchToFallback();
                }
            }
            ++i;
        }
        throw new IOException("Failed to resolve conflicts after 4 attempts!");
    }

    private List<SendMessageResult> sendMessage(List<SignalServiceAddress> recipients, List<SealedSenderAccess> sealedSenderAccesses, long timestamp, EnvelopeContent content, boolean online, PartialSendCompleteListener partialListener, CancelationSignal cancelationSignal, @Nullable SendEvents sendEvents, boolean urgent, boolean story) throws IOException {
        List results;
        Log.d((String)TAG, (String)("[" + timestamp + "] Sending to " + recipients.size() + " recipients."));
        this.enforceMaxEnvelopeContentSize(content);
        long startTime = System.currentTimeMillis();
        this.eagerlyFetchMissingPreKeys(recipients, sealedSenderAccesses, story);
        LinkedList<Observable> singleResults = new LinkedList<Observable>();
        Iterator<SignalServiceAddress> recipientIterator = recipients.iterator();
        Iterator<SealedSenderAccess> sealedSenderAccessIterator = sealedSenderAccesses.iterator();
        while (recipientIterator.hasNext()) {
            SignalServiceAddress recipient = recipientIterator.next();
            SealedSenderAccess sealedSenderAccess = sealedSenderAccessIterator.next();
            singleResults.add(this.sendMessageRx(recipient, sealedSenderAccess, timestamp, content, online, cancelationSignal, sendEvents, urgent, story, 0).toObservable());
        }
        try {
            results = (List)Observable.mergeDelayError(singleResults, (int)Integer.MAX_VALUE, (int)1).observeOn(this.scheduler, true).scan(new ArrayList(singleResults.size()), (state, result2) -> {
                state.add(result2);
                if (partialListener != null) {
                    partialListener.onPartialSendComplete((SendMessageResult)result2);
                }
                return state;
            }).lastOrError().blockingGet();
        }
        catch (RuntimeException e) {
            Throwable cause;
            Throwable throwable = cause = e instanceof CompositeException ? (Throwable)((CompositeException)e).getExceptions().get(0) : e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof InterruptedException) {
                ArrayList<SendMessageResult> canceledResults = new ArrayList<SendMessageResult>(recipients.size());
                for (SignalServiceAddress recipient : recipients) {
                    canceledResults.add(SendMessageResult.canceledFailure(recipient));
                }
                return canceledResults;
            }
            throw e;
        }
        double sendsForAverage = 0.0;
        for (SendMessageResult result3 : results) {
            if (result3.getSuccess() == null || result3.getSuccess().getDuration() == -1L) continue;
            sendsForAverage += 1.0;
        }
        double average = 0.0;
        if (sendsForAverage > 0.0) {
            for (SendMessageResult result4 : results) {
                if (result4.getSuccess() == null || result4.getSuccess().getDuration() == -1L) continue;
                average += (double)result4.getSuccess().getDuration() / sendsForAverage;
            }
        }
        Log.d((String)TAG, (String)("[" + timestamp + "] Completed send to " + recipients.size() + " recipients in " + (System.currentTimeMillis() - startTime) + " ms, with an average time of " + Math.round(average) + " ms per send via Rx."));
        return results;
    }

    private Single<SendMessageResult> sendMessageRx(SignalServiceAddress recipient, @Nullable SealedSenderAccess sealedSenderAccess, long timestamp, EnvelopeContent content, boolean online, CancelationSignal cancelationSignal, @Nullable SendEvents sendEvents, boolean urgent, boolean story, int retryCount) {
        long startTime = System.currentTimeMillis();
        this.enforceMaxEnvelopeContentSize(content);
        Single messagesSingle = Single.fromCallable(() -> {
            OutgoingPushMessageList messages = this.getEncryptedMessages(recipient, sealedSenderAccess, timestamp, content, online, urgent, story);
            if (retryCount == 0 && sendEvents != null) {
                sendEvents.onMessageEncrypted();
            }
            if (content.getContent().isPresent() && content.getContent().get().syncMessage != null && content.getContent().get().syncMessage.sent != null) {
                Log.d((String)TAG, (String)("[sendMessage][" + timestamp + "] Sending a sent sync message to devices: " + String.valueOf(messages.getDevices()) + " via Rx"));
            } else if (content.getContent().isPresent() && content.getContent().get().senderKeyDistributionMessage != null) {
                Log.d((String)TAG, (String)("[sendMessage][" + timestamp + "] Sending a SKDM to " + messages.getDestination() + " for devices: " + String.valueOf(messages.getDevices()) + (content.getContent().get().dataMessage != null ? " (it's piggy-backing on a DataMessage) via Rx" : " via Rx")));
            }
            return messages;
        });
        Single sendWithFallback = messagesSingle.flatMap(messages -> {
            if (cancelationSignal != null && cancelationSignal.isCanceled()) {
                return Single.just((Object)new Pair(messages, new NetworkResult.NetworkError(new IOException("Canceled"))));
            }
            return Single.fromCallable(() -> this.messageApi.sendMessage((OutgoingPushMessageList)messages, sealedSenderAccess, story)).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).onErrorReturn(NetworkResult.ApplicationError::new).map(r -> new Pair(messages, r));
        }).observeOn(this.scheduler).flatMap(pair -> {
            OutgoingPushMessageList messages = (OutgoingPushMessageList)pair.getFirst();
            NetworkResult networkResult = (NetworkResult)pair.getSecond();
            try {
                SendMessageResponse response = NetworkResultUtil.toMessageSendLegacy(messages.getDestination(), networkResult);
                SendMessageResult result2 = SendMessageResult.success(recipient, messages.getDevices(), response.sentUnidentified(), response.getNeedsSync() || this.aciStore.isMultiDevice(), System.currentTimeMillis() - startTime, content.getContent());
                return Single.just((Object)result2);
            }
            catch (IOException throwable) {
                Throwable throwable2;
                Throwable cause;
                if (cancelationSignal != null && cancelationSignal.isCanceled()) {
                    return Single.just((Object)SendMessageResult.canceledFailure(recipient));
                }
                if (throwable instanceof AuthorizationFailedException) return Single.error((Throwable)throwable);
                if (throwable instanceof UnregisteredUserException) return Single.error((Throwable)throwable);
                if (throwable instanceof MismatchedDevicesException) return Single.error((Throwable)throwable);
                if (throwable instanceof StaleDevicesException) return Single.error((Throwable)throwable);
                if (throwable instanceof ProofRequiredException) return Single.error((Throwable)throwable);
                if (throwable instanceof ServerRejectedException) return Single.error((Throwable)throwable);
                if (throwable instanceof RateLimitException) {
                    return Single.error((Throwable)throwable);
                }
                if (throwable instanceof WebSocketUnavailableException) {
                    if (this.useRestFallback.getAsBoolean()) {
                        Log.i((String)TAG, (String)("[sendMessage][" + timestamp + "] " + (sealedSenderAccess != null ? "Unidentified " : "") + "pipe unavailable, falling back... (" + throwable.getClass().getSimpleName() + ": " + throwable.getMessage() + ")"));
                        return Single.fromCallable(() -> {
                            SendMessageResponse response = this.socket.sendMessage(messages, sealedSenderAccess, story);
                            return SendMessageResult.success(recipient, messages.getDevices(), response.sentUnidentified(), response.getNeedsSync() || this.aciStore.isMultiDevice(), System.currentTimeMillis() - startTime, content.getContent());
                        }).subscribeOn(this.scheduler);
                    }
                    Log.i((String)TAG, (String)("[sendMessage][" + timestamp + "] " + (sealedSenderAccess != null ? "Unidentified " : "") + "pipe unavailable (" + throwable.getClass().getSimpleName() + ": " + throwable.getMessage() + ")"));
                    return Single.error((Throwable)throwable);
                }
                Throwable throwable3 = cause = throwable.getCause() != null ? throwable.getCause() : throwable;
                if (this.useRestFallback.getAsBoolean()) {
                    Log.w((String)TAG, (String)("[sendMessage][" + timestamp + "] " + (sealedSenderAccess != null ? "Unidentified " : "") + "pipe failed, falling back... (" + cause.getClass().getSimpleName() + ": " + cause.getMessage() + ")"));
                    return Single.fromCallable(() -> {
                        SendMessageResponse response = this.socket.sendMessage(messages, sealedSenderAccess, story);
                        return SendMessageResult.success(recipient, messages.getDevices(), response.sentUnidentified(), response.getNeedsSync() || this.aciStore.isMultiDevice(), System.currentTimeMillis() - startTime, content.getContent());
                    }).subscribeOn(this.scheduler);
                }
                Log.w((String)TAG, (String)("[sendMessage][" + timestamp + "] " + (sealedSenderAccess != null ? "Unidentified " : "") + "pipe failed (" + cause.getClass().getSimpleName() + ": " + cause.getMessage() + ")"));
                if (cause instanceof IOException) {
                    throwable2 = cause;
                    return Single.error((Throwable)throwable2);
                }
                throwable2 = throwable;
                return Single.error((Throwable)throwable2);
            }
        });
        return sendWithFallback.onErrorResumeNext(t -> {
            if (cancelationSignal != null && cancelationSignal.isCanceled()) {
                return Single.just((Object)SendMessageResult.canceledFailure(recipient));
            }
            if (retryCount >= 4) {
                return Single.error((Throwable)t);
            }
            if (t instanceof InvalidKeyException) {
                Log.w((String)TAG, (Throwable)t);
                return this.sendMessageRx(recipient, SealedSenderAccess.NONE, timestamp, content, online, cancelationSignal, sendEvents, urgent, story, retryCount + 1);
            }
            if (t instanceof AuthorizationFailedException) {
                if (sealedSenderAccess != null) {
                    Log.w((String)TAG, (String)"Got an AuthorizationFailedException when trying to send using sealed sender. Falling back.");
                    return this.sendMessageRx(recipient, sealedSenderAccess.switchToFallback(), timestamp, content, online, cancelationSignal, sendEvents, urgent, story, retryCount + 1);
                }
                Log.w((String)TAG, (String)"Got an AuthorizationFailedException without using sealed sender!", (Throwable)t);
                return Single.error((Throwable)t);
            }
            if (t instanceof MismatchedDevicesException) {
                MismatchedDevicesException mde = (MismatchedDevicesException)t;
                Log.w((String)TAG, (String)("[sendMessage][" + timestamp + "] Handling mismatched devices. (" + mde.getMessage() + ")"));
                return Single.fromCallable(() -> {
                    this.handleMismatchedDevices(recipient, mde.getMismatchedDevices());
                    return Unit.INSTANCE;
                }).flatMap(unused -> this.sendMessageRx(recipient, sealedSenderAccess, timestamp, content, online, cancelationSignal, sendEvents, urgent, story, retryCount + 1));
            }
            if (t instanceof StaleDevicesException) {
                StaleDevicesException ste = (StaleDevicesException)t;
                Log.w((String)TAG, (String)("[sendMessage][" + timestamp + "] Handling stale devices. (" + ste.getMessage() + ")"));
                return Single.fromCallable(() -> {
                    this.handleStaleDevices(recipient, ste.getStaleDevices());
                    return Unit.INSTANCE;
                }).flatMap(unused -> this.sendMessageRx(recipient, sealedSenderAccess, timestamp, content, online, cancelationSignal, sendEvents, urgent, story, retryCount + 1));
            }
            return Single.error((Throwable)t);
        }).onErrorResumeNext(t -> {
            try {
                SendMessageResult result2 = SignalServiceMessageSender.mapSendErrorToSendResult(t, timestamp, recipient);
                return Single.just((Object)result2);
            }
            catch (IOException e) {
                return Single.error((Throwable)e);
            }
        });
    }

    @Nonnull
    public static SendMessageResult mapSendErrorToSendResult(@Nonnull Throwable t, long timestamp, @Nonnull SignalServiceAddress recipient) throws IOException {
        if (t instanceof UntrustedIdentityException) {
            Log.w((String)TAG, (String)("[" + timestamp + "] Hit identity mismatch: " + recipient.getIdentifier()), (Throwable)t);
            return SendMessageResult.identityFailure(recipient, ((UntrustedIdentityException)t).getIdentityKey());
        }
        if (t instanceof UnregisteredUserException) {
            Log.w((String)TAG, (String)("[" + timestamp + "] Hit unregistered user: " + recipient.getIdentifier()));
            return SendMessageResult.unregisteredFailure(recipient);
        }
        if (t instanceof PushNetworkException) {
            Log.w((String)TAG, (String)("[" + timestamp + "] Hit network failure: " + recipient.getIdentifier()), (Throwable)t);
            return SendMessageResult.networkFailure(recipient);
        }
        if (t instanceof ServerRejectedException) {
            Log.w((String)TAG, (String)("[" + timestamp + "] Hit server rejection: " + recipient.getIdentifier()), (Throwable)t);
            throw (ServerRejectedException)t;
        }
        if (t instanceof ProofRequiredException) {
            Log.w((String)TAG, (String)("[" + timestamp + "] Hit proof required: " + recipient.getIdentifier()), (Throwable)t);
            return SendMessageResult.proofRequiredFailure(recipient, (ProofRequiredException)t);
        }
        if (t instanceof RateLimitException) {
            Log.w((String)TAG, (String)("[" + timestamp + "] Hit rate limit: " + recipient.getIdentifier()), (Throwable)t);
            return SendMessageResult.rateLimitFailure(recipient, (RateLimitException)t);
        }
        if (t instanceof InvalidPreKeyException) {
            Log.w((String)TAG, (String)("[" + timestamp + "] Hit invalid prekey: " + recipient.getIdentifier()), (Throwable)t);
            return SendMessageResult.invalidPreKeyFailure(recipient);
        }
        Log.w((String)TAG, (String)("[" + timestamp + "] Hit unknown exception: " + recipient.getIdentifier()), (Throwable)t);
        throw new IOException(t);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<SendMessageResult> sendGroupMessage(DistributionId distributionId, List<SignalServiceAddress> recipients, List<UnidentifiedAccess> unidentifiedAccess, @Nullable GroupSendEndorsements groupSendEndorsements, long timestamp, Content content, ContentHint contentHint, Optional<byte[]> groupId, boolean online, SenderKeyGroupEvents sendEvents, boolean urgent, boolean story) throws IOException, UntrustedIdentityException, NoSessionException, InvalidKeyException, InvalidRegistrationIdException {
        if (recipients.isEmpty()) {
            Log.w((String)TAG, (String)("[sendGroupMessage][" + timestamp + "] Empty recipient list!"));
            return Collections.emptyList();
        }
        Preconditions.checkArgument(groupSendEndorsements != null || story, "[" + timestamp + "] GSE is null and not sending a story");
        Preconditions.checkArgument(recipients.size() == unidentifiedAccess.size(), "[" + timestamp + "] Unidentified access mismatch!");
        HashMap<ServiceId, UnidentifiedAccess> accessBySid = new HashMap<ServiceId, UnidentifiedAccess>();
        Iterator<SignalServiceAddress> addressIterator = recipients.iterator();
        Iterator<UnidentifiedAccess> accessIterator = unidentifiedAccess.iterator();
        while (addressIterator.hasNext()) {
            accessBySid.put(addressIterator.next().getServiceId(), accessIterator.next());
        }
        SenderCertificate senderCertificate = unidentifiedAccess.stream().filter(Objects::nonNull).findFirst().map(UnidentifiedAccess::getUnidentifiedCertificate).orElse(null);
        SealedSenderAccess sealedSenderAccess = SealedSenderAccess.forGroupSend(senderCertificate, groupSendEndorsements, story);
        int i = 0;
        while (true) {
            block20: {
                byte[] ciphertext;
                GroupTargetInfo targetInfo;
                if (i >= 4) {
                    throw new IOException("Failed to resolve conflicts after 4 attempts!");
                }
                GroupTargetInfo targetInfoSnapshot = targetInfo = this.buildGroupTargetInfo(recipients);
                Set sharedWith = this.aciStore.getSenderKeySharedWith(distributionId);
                List<SignalServiceAddress> needsSenderKeyTargets = targetInfo.destinations.stream().filter(a -> !sharedWith.contains(a) || targetInfoSnapshot.sessions.get(a) == null).map(a -> ServiceId.parseOrThrow((String)a.getName())).distinct().map(SignalServiceAddress::new).collect(Collectors.toList());
                if (needsSenderKeyTargets.size() > 0) {
                    Log.i((String)TAG, (String)("[sendGroupMessage][" + timestamp + "] Need to send the distribution message to " + needsSenderKeyTargets.size() + " addresses."));
                    SenderKeyDistributionMessage senderKeyDistributionMessage = this.getOrCreateNewGroupSession(distributionId);
                    List needsSenderKeyAccesses = needsSenderKeyTargets.stream().map(r -> (UnidentifiedAccess)accessBySid.get(r.getServiceId())).collect(Collectors.toList());
                    List<GroupSendFullToken> needsSenderKeyGroupSendTokens = groupSendEndorsements != null ? groupSendEndorsements.forIndividuals(needsSenderKeyTargets) : null;
                    List<SealedSenderAccess> needsSenderKeySealedSenderAccesses = SealedSenderAccess.forFanOutGroupSend(needsSenderKeyGroupSendTokens, sealedSenderAccess.getSenderCertificate(), needsSenderKeyAccesses);
                    List<SendMessageResult> results = this.sendSenderKeyDistributionMessage(distributionId, needsSenderKeyTargets, needsSenderKeySealedSenderAccesses, senderKeyDistributionMessage, groupId, urgent, story && groupId.isEmpty());
                    List successes = results.stream().filter(SendMessageResult::isSuccess).map(SendMessageResult::getAddress).collect(Collectors.toList());
                    Set successSids = successes.stream().map(a -> a.getServiceId().toString()).collect(Collectors.toSet());
                    Set successAddresses = targetInfo.destinations.stream().filter(a -> successSids.contains(a.getName())).collect(Collectors.toSet());
                    this.aciStore.markSenderKeySharedWith(distributionId, successAddresses);
                    Log.i((String)TAG, (String)("[sendGroupMessage][" + timestamp + "] Successfully sent sender keys to " + successes.size() + "/" + needsSenderKeyTargets.size() + " recipients."));
                    int failureCount = results.size() - successes.size();
                    if (failureCount > 0) {
                        Log.w((String)TAG, (String)("[sendGroupMessage][" + timestamp + "] Failed to send sender keys to " + failureCount + " recipients. Sending back failed results now."));
                        List trueFailures = results.stream().filter(r -> !r.isSuccess()).collect(Collectors.toList());
                        Set failedAddresses = trueFailures.stream().map(result2 -> result2.getAddress().getServiceId()).collect(Collectors.toSet());
                        List fakeNetworkFailures = recipients.stream().filter(r -> !failedAddresses.contains(r.getServiceId())).map(SendMessageResult::networkFailure).collect(Collectors.toList());
                        LinkedList<SendMessageResult> modifiedResults = new LinkedList<SendMessageResult>();
                        modifiedResults.addAll(trueFailures);
                        modifiedResults.addAll(fakeNetworkFailures);
                        return modifiedResults;
                    }
                    targetInfo = this.buildGroupTargetInfo(recipients);
                }
                sendEvents.onSenderKeyShared();
                SignalServiceCipher cipher = new SignalServiceCipher(this.localAddress, this.localDeviceId, this.aciStore, this.sessionLock, null);
                try {
                    ciphertext = cipher.encryptForGroup(distributionId, targetInfo.destinations, targetInfo.sessions, sealedSenderAccess.getSenderCertificate(), content.encode(), contentHint, groupId);
                }
                catch (org.signal.libsignal.protocol.UntrustedIdentityException e) {
                    throw new UntrustedIdentityException("Untrusted during group encrypt", e.getName(), e.getUntrustedIdentity());
                }
                sendEvents.onMessageEncrypted();
                try {
                    SendGroupMessageResponse response = NetworkResultUtil.toGroupMessageSendLegacy(this.messageApi.sendGroupMessage(ciphertext, sealedSenderAccess, timestamp, online, urgent, story));
                    return this.transformGroupResponseToMessageResults(targetInfo.devices, response, content);
                }
                catch (NotFoundException | RateLimitException | ServerRejectedException | GroupMismatchedDevicesException | GroupStaleDevicesException | InvalidUnidentifiedAccessHeaderException e) {
                    SignalServiceAddress address;
                    try {
                        throw e;
                        catch (WebSocketUnavailableException e2) {
                            if (!this.useRestFallback.getAsBoolean()) {
                                Log.i((String)TAG, (String)("[sendGroupMessage][" + timestamp + "] Pipe unavailable (" + e2.getClass().getSimpleName() + ": " + e2.getMessage() + ")"));
                                throw e2;
                            }
                            Log.i((String)TAG, (String)("[sendGroupMessage][" + timestamp + "] Pipe unavailable, falling back... (" + e2.getClass().getSimpleName() + ": " + e2.getMessage() + ")"));
                        }
                        catch (IOException e3) {
                            if (!this.useRestFallback.getAsBoolean()) {
                                Log.w((String)TAG, (String)("[sendGroupMessage][" + timestamp + "] Pipe failed (" + e3.getClass().getSimpleName() + ": " + e3.getMessage() + ")"));
                                throw e3;
                            }
                            Log.w((String)TAG, (String)("[sendGroupMessage][" + timestamp + "] Pipe failed, falling back... (" + e3.getClass().getSimpleName() + ": " + e3.getMessage() + ")"));
                        }
                    }
                    catch (GroupMismatchedDevicesException e4) {
                        Log.w((String)TAG, (String)("[sendGroupMessage][" + timestamp + "] Handling mismatched devices. (" + e4.getMessage() + ")"));
                        for (GroupMismatchedDevices mismatched : e4.getMismatchedDevices()) {
                            address = new SignalServiceAddress(ServiceId.parseOrThrow((String)mismatched.getUuid()), Optional.empty());
                            this.handleMismatchedDevices(address, mismatched.getDevices());
                        }
                        break block20;
                    }
                    catch (GroupStaleDevicesException e5) {
                        Log.w((String)TAG, (String)("[sendGroupMessage][" + timestamp + "] Handling stale devices. (" + e5.getMessage() + ")"));
                        for (GroupStaleDevices stale : e5.getStaleDevices()) {
                            address = new SignalServiceAddress(ServiceId.parseOrThrow((String)stale.getUuid()), Optional.empty());
                            this.handleStaleDevices(address, stale.getDevices());
                        }
                        break block20;
                    }
                    catch (InvalidUnidentifiedAccessHeaderException e6) {
                        Log.w((String)TAG, (String)("[sendGroupMessage][" + timestamp + "] Invalid access header. (" + e6.getMessage() + ")"));
                        throw e6;
                    }
                }
                SendGroupMessageResponse response = this.socket.sendGroupMessage(ciphertext, sealedSenderAccess, timestamp, online, urgent, story);
                return this.transformGroupResponseToMessageResults(targetInfo.devices, response, content);
            }
            Log.w((String)TAG, (String)("[sendGroupMessage][" + timestamp + "] Attempt failed (i = " + i + ")"));
            ++i;
        }
    }

    private GroupTargetInfo buildGroupTargetInfo(List<SignalServiceAddress> recipients) {
        List addressNames = recipients.stream().map(SignalServiceAddress::getIdentifier).collect(Collectors.toList());
        Map sessionMap = this.aciStore.getAllAddressesWithActiveSessions(addressNames);
        HashMap devicesByAddressName = new HashMap();
        HashSet destinations = new HashSet(sessionMap.keySet());
        destinations.addAll(recipients.stream().map(a -> new SignalProtocolAddress(a.getIdentifier(), 1)).collect(Collectors.toList()));
        for (SignalProtocolAddress destination : destinations) {
            LinkedList<Integer> devices = devicesByAddressName.containsKey(destination.getName()) ? (List)devicesByAddressName.get(destination.getName()) : new LinkedList<Integer>();
            devices.add(destination.getDeviceId());
            devicesByAddressName.put(destination.getName(), devices);
        }
        HashMap<SignalServiceAddress, List<Integer>> recipientDevices = new HashMap<SignalServiceAddress, List<Integer>>();
        for (SignalServiceAddress recipient : recipients) {
            if (!devicesByAddressName.containsKey(recipient.getIdentifier())) continue;
            recipientDevices.put(recipient, (List)devicesByAddressName.get(recipient.getIdentifier()));
        }
        return new GroupTargetInfo(new ArrayList<SignalProtocolAddress>(destinations), recipientDevices, sessionMap);
    }

    private List<SendMessageResult> transformGroupResponseToMessageResults(Map<SignalServiceAddress, List<Integer>> recipients, SendGroupMessageResponse response, Content content) {
        Set<ServiceId> unregistered = response.getUnsentTargets();
        List failures = unregistered.stream().map(SignalServiceAddress::new).map(SendMessageResult::unregisteredFailure).collect(Collectors.toList());
        List success = recipients.keySet().stream().filter(r -> !unregistered.contains(r.getServiceId())).map(a -> SendMessageResult.success(a, (List)recipients.get(a), true, this.aciStore.isMultiDevice(), -1L, Optional.of(content))).collect(Collectors.toList());
        ArrayList<SendMessageResult> results = new ArrayList<SendMessageResult>(success.size() + failures.size());
        results.addAll(success);
        results.addAll(failures);
        return results;
    }

    private List<AttachmentPointer> createAttachmentPointers(Optional<List<SignalServiceAttachment>> attachments) throws IOException {
        LinkedList<AttachmentPointer> pointers = new LinkedList<AttachmentPointer>();
        if (!attachments.isPresent() || attachments.get().isEmpty()) {
            return pointers;
        }
        for (SignalServiceAttachment attachment : attachments.get()) {
            if (attachment.isStream()) {
                Log.i((String)TAG, (String)"Found attachment, creating pointer...");
                pointers.add(this.createAttachmentPointer(attachment.asStream()));
                continue;
            }
            if (!attachment.isPointer()) continue;
            Log.i((String)TAG, (String)"Including existing attachment pointer...");
            pointers.add(this.createAttachmentPointer(attachment.asPointer()));
        }
        return pointers;
    }

    private AttachmentPointer createAttachmentPointer(SignalServiceAttachmentPointer attachment) {
        return AttachmentPointerUtil.createAttachmentPointer(attachment);
    }

    private AttachmentPointer createAttachmentPointer(SignalServiceAttachmentStream attachment) throws IOException {
        return this.createAttachmentPointer(this.uploadAttachment(attachment));
    }

    private TextAttachment createTextAttachment(SignalServiceTextAttachment attachment) throws IOException {
        TextAttachment.Builder builder = new TextAttachment.Builder();
        if (attachment.getStyle().isPresent()) {
            switch (attachment.getStyle().get()) {
                case DEFAULT: {
                    builder.textStyle(TextAttachment.Style.DEFAULT);
                    break;
                }
                case REGULAR: {
                    builder.textStyle(TextAttachment.Style.REGULAR);
                    break;
                }
                case BOLD: {
                    builder.textStyle(TextAttachment.Style.BOLD);
                    break;
                }
                case SERIF: {
                    builder.textStyle(TextAttachment.Style.SERIF);
                    break;
                }
                case SCRIPT: {
                    builder.textStyle(TextAttachment.Style.SCRIPT);
                    break;
                }
                case CONDENSED: {
                    builder.textStyle(TextAttachment.Style.CONDENSED);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown type: " + String.valueOf((Object)attachment.getStyle().get())));
                }
            }
        }
        TextAttachment.Gradient.Builder gradientBuilder = new TextAttachment.Gradient.Builder();
        if (attachment.getBackgroundGradient().isPresent()) {
            SignalServiceTextAttachment.Gradient gradient = attachment.getBackgroundGradient().get();
            if (gradient.getAngle().isPresent()) {
                gradientBuilder.angle(gradient.getAngle().get());
            }
            if (!gradient.getColors().isEmpty()) {
                gradientBuilder.startColor(gradient.getColors().get(0));
                gradientBuilder.endColor(gradient.getColors().get(gradient.getColors().size() - 1));
            }
            gradientBuilder.colors = gradient.getColors();
            gradientBuilder.positions = gradient.getPositions();
            builder.gradient(gradientBuilder.build());
        }
        if (attachment.getText().isPresent()) {
            builder.text(attachment.getText().get());
        }
        if (attachment.getTextForegroundColor().isPresent()) {
            builder.textForegroundColor(attachment.getTextForegroundColor().get());
        }
        if (attachment.getTextBackgroundColor().isPresent()) {
            builder.textBackgroundColor(attachment.getTextBackgroundColor().get());
        }
        if (attachment.getPreview().isPresent()) {
            builder.preview(this.createPreview(attachment.getPreview().get()));
        }
        if (attachment.getBackgroundColor().isPresent()) {
            builder.color(attachment.getBackgroundColor().get());
        }
        return builder.build();
    }

    private OutgoingPushMessageList getEncryptedMessages(SignalServiceAddress recipient, @Nullable SealedSenderAccess sealedSenderAccess, long timestamp, EnvelopeContent plaintext, boolean online, boolean urgent, boolean story) throws IOException, InvalidKeyException, UntrustedIdentityException {
        LinkedList<OutgoingPushMessage> messages = new LinkedList<OutgoingPushMessage>();
        List subDevices = this.aciStore.getSubDeviceSessions(recipient.getIdentifier());
        ArrayList<Integer> deviceIds = new ArrayList<Integer>(subDevices.size() + 1);
        deviceIds.add(1);
        deviceIds.addAll(subDevices);
        if (sealedSenderAccess == null && recipient.matches(this.localAddress)) {
            deviceIds.remove((Object)this.localDeviceId);
        }
        Iterator iterator = deviceIds.iterator();
        while (iterator.hasNext()) {
            int deviceId = (Integer)iterator.next();
            if (deviceId != 1 && !this.aciStore.containsSession(new SignalProtocolAddress(recipient.getIdentifier(), deviceId))) continue;
            messages.add(this.getEncryptedMessage(recipient, sealedSenderAccess, deviceId, plaintext, story));
        }
        return new OutgoingPushMessageList(recipient.getIdentifier(), timestamp, messages, online, urgent);
    }

    public OutgoingPushMessage getEncryptedMessage(SignalServiceAddress recipient, @Nullable SealedSenderAccess sealedSenderAccess, int deviceId, EnvelopeContent plaintext, boolean story) throws IOException, InvalidKeyException, UntrustedIdentityException {
        SignalProtocolAddress signalProtocolAddress = new SignalProtocolAddress(recipient.getIdentifier(), deviceId);
        SignalServiceCipher cipher = new SignalServiceCipher(this.localAddress, this.localDeviceId, this.aciStore, this.sessionLock, null);
        if (!this.aciStore.containsSession(signalProtocolAddress)) {
            try {
                List<PreKeyBundle> preKeys = this.getPreKeys(recipient, sealedSenderAccess, deviceId, story);
                for (PreKeyBundle preKey : preKeys) {
                    try {
                        SignalProtocolAddress preKeyAddress = new SignalProtocolAddress(recipient.getIdentifier(), preKey.getDeviceId());
                        Log.d((String)TAG, (String)("Initializing prekey session for " + String.valueOf(preKeyAddress)));
                        SignalSessionBuilder sessionBuilder = new SignalSessionBuilder(this.sessionLock, new SessionBuilder((SignalProtocolStore)this.aciStore, preKeyAddress));
                        sessionBuilder.process(preKey);
                    }
                    catch (org.signal.libsignal.protocol.UntrustedIdentityException e) {
                        throw new UntrustedIdentityException("Untrusted identity key!", recipient.getIdentifier(), preKey.getIdentityKey());
                    }
                }
                if (this.eventListener.isPresent()) {
                    this.eventListener.get().onSecurityEvent(recipient);
                }
            }
            catch (InvalidKeyException e) {
                throw new InvalidPreKeyException(signalProtocolAddress, e);
            }
        }
        try {
            return cipher.encrypt(signalProtocolAddress, sealedSenderAccess, plaintext);
        }
        catch (org.signal.libsignal.protocol.UntrustedIdentityException e) {
            throw new UntrustedIdentityException("Untrusted on send", recipient.getIdentifier(), e.getUntrustedIdentity());
        }
    }

    private void eagerlyFetchMissingPreKeys(List<SignalServiceAddress> recipients, List<SealedSenderAccess> sealedSenderAccesses, boolean story) {
        long start2 = System.currentTimeMillis();
        Iterator<SignalServiceAddress> recipientIterator = recipients.iterator();
        Iterator<SealedSenderAccess> sealedSenderAccessIterator = sealedSenderAccesses.iterator();
        LinkedList<Observable> eagerFetches = new LinkedList<Observable>();
        while (recipientIterator.hasNext()) {
            SignalServiceAddress recipient = recipientIterator.next();
            SealedSenderAccess sealedSenderAccess = sealedSenderAccessIterator.next();
            SignalProtocolAddress signalProtocolAddress = new SignalProtocolAddress(recipient.getIdentifier(), 1);
            if (this.aciStore.containsSession(signalProtocolAddress)) continue;
            Observable thing = Single.fromCallable(() -> {
                this.eagerlyFetchMissingPreKeys(recipient, sealedSenderAccess, story);
                return true;
            }).subscribeOn(this.scheduler).toObservable();
            eagerFetches.add(thing);
        }
        if (eagerFetches.isEmpty()) {
            return;
        }
        Log.i((String)TAG, (String)("[eagerPrefetch] Attempting to fetch prekeys for " + eagerFetches.size() + " recipients"));
        try {
            Observable.mergeDelayError(eagerFetches, (int)Integer.MAX_VALUE, (int)1).observeOn(this.scheduler).lastOrError().blockingGet();
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)"[eagerPrefetch] Unexpectedly failed eager fetching prekeys", (Throwable)e);
            return;
        }
        Log.i((String)TAG, (String)("[eagerPrefetch] Completed in " + (System.currentTimeMillis() - start2) + "ms"));
    }

    private void eagerlyFetchMissingPreKeys(SignalServiceAddress recipient, SealedSenderAccess sealedSenderAccess, boolean story) {
        SignalProtocolAddress signalProtocolAddress = new SignalProtocolAddress(recipient.getIdentifier(), 1);
        try {
            List<PreKeyBundle> preKeys = this.getPreKeys(recipient, sealedSenderAccess, 1, story);
            for (PreKeyBundle preKey : preKeys) {
                Log.d((String)TAG, (String)("[eagerFetch] Initializing prekey session for " + String.valueOf(signalProtocolAddress)));
                try {
                    SignalProtocolAddress preKeyAddress = new SignalProtocolAddress(recipient.getIdentifier(), preKey.getDeviceId());
                    SignalSessionBuilder sessionBuilder = new SignalSessionBuilder(this.sessionLock, new SessionBuilder((SignalProtocolStore)this.aciStore, preKeyAddress));
                    sessionBuilder.process(preKey);
                }
                catch (org.signal.libsignal.protocol.UntrustedIdentityException e) {
                    Log.i((String)TAG, (String)"[eagerPrefetch] Untrusted identity for recipient");
                    return;
                }
            }
            if (this.eventListener.isPresent()) {
                this.eventListener.get().onSecurityEvent(recipient);
            }
        }
        catch (IOException e) {
            Log.i((String)TAG, (String)"[eagerPrefetch] Network issue encountered");
        }
        catch (InvalidKeyException e) {
            Log.i((String)TAG, (String)"[eagerPrefetch] Invalid pre-key");
            return;
        }
    }

    private List<PreKeyBundle> getPreKeys(SignalServiceAddress recipient, @Nullable SealedSenderAccess sealedSenderAccess, int deviceId, boolean story) throws IOException {
        try {
            if (story && SealedSenderAccess.isUnrestrictedForStory(sealedSenderAccess)) {
                sealedSenderAccess = null;
            }
            return NetworkResultUtil.toPreKeysLegacy(this.keysApi.getPreKeys(recipient, sealedSenderAccess, deviceId));
        }
        catch (NonSuccessfulResponseCodeException e) {
            if (e.code == 401 && story) {
                Log.d((String)TAG, (String)"Got 401 when fetching prekey for story. Trying without UD.");
                return NetworkResultUtil.toPreKeysLegacy(this.keysApi.getPreKeys(recipient, null, deviceId));
            }
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleMismatchedDevices(SignalServiceAddress recipient, MismatchedDevices mismatchedDevices) throws IOException, UntrustedIdentityException {
        try {
            Log.w((String)TAG, (String)("[handleMismatchedDevices] Address: " + recipient.getIdentifier() + ", ExtraDevices: " + String.valueOf(mismatchedDevices.getExtraDevices()) + ", MissingDevices: " + String.valueOf(mismatchedDevices.getMissingDevices())));
            this.archiveSessions(recipient, mismatchedDevices.getExtraDevices());
            for (int missingDeviceId : mismatchedDevices.getMissingDevices()) {
                PreKeyBundle preKey = NetworkResultUtil.toPreKeysLegacy(this.keysApi.getPreKey(recipient, missingDeviceId));
                try {
                    SignalSessionBuilder sessionBuilder = new SignalSessionBuilder(this.sessionLock, new SessionBuilder((SignalProtocolStore)this.aciStore, new SignalProtocolAddress(recipient.getIdentifier(), missingDeviceId)));
                    sessionBuilder.process(preKey);
                }
                catch (org.signal.libsignal.protocol.UntrustedIdentityException e) {
                    throw new UntrustedIdentityException("Untrusted identity key!", recipient.getIdentifier(), preKey.getIdentityKey());
                    return;
                }
            }
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
    }

    private void handleStaleDevices(SignalServiceAddress recipient, StaleDevices staleDevices) {
        Log.w((String)TAG, (String)("[handleStaleDevices] Address: " + recipient.getIdentifier() + ", StaleDevices: " + String.valueOf(staleDevices.getStaleDevices())));
        this.archiveSessions(recipient, staleDevices.getStaleDevices());
    }

    public void handleChangeNumberMismatchDevices(@Nonnull MismatchedDevices mismatchedDevices) throws IOException, UntrustedIdentityException {
        this.handleMismatchedDevices(this.localAddress, mismatchedDevices);
    }

    private void archiveSessions(SignalServiceAddress recipient, List<Integer> devices) {
        List<SignalProtocolAddress> addressesToClear = this.convertToProtocolAddresses(recipient, devices);
        for (SignalProtocolAddress address : addressesToClear) {
            this.aciStore.archiveSession(address);
        }
    }

    private List<SignalProtocolAddress> convertToProtocolAddresses(SignalServiceAddress recipient, List<Integer> devices) {
        ArrayList<SignalProtocolAddress> addresses = new ArrayList<SignalProtocolAddress>(devices.size());
        for (int staleDeviceId : devices) {
            addresses.add(new SignalProtocolAddress(recipient.getServiceId().toString(), staleDeviceId));
            if (!recipient.getNumber().isPresent()) continue;
            addresses.add(new SignalProtocolAddress(recipient.getNumber().get(), staleDeviceId));
        }
        return addresses;
    }

    private void enforceMaxEnvelopeContentSize(EnvelopeContent content) {
        int size = content.size();
        if (this.maxEnvelopeSize > 0L && (long)size > this.maxEnvelopeSize) {
            String message = content.getContent().isEmpty() ? "Empty content" : this.buildContentTooLargeBreadcrumbs(content.getContent().get());
            throw new ContentTooLargeException(size, message);
        }
    }

    private Content enforceMaxContentSize(Content content) {
        int size = content.encode().length;
        if (this.maxEnvelopeSize > 0L && (long)size > this.maxEnvelopeSize) {
            throw new ContentTooLargeException(size, this.buildContentTooLargeBreadcrumbs(content));
        }
        return content;
    }

    private String buildContentTooLargeBreadcrumbs(Content content) {
        StringBuilder message = new StringBuilder();
        if (content.dataMessage != null) {
            message.append("Data message;");
            if (content.dataMessage.body != null && !content.dataMessage.body.isEmpty()) {
                message.append("Body(").append(content.dataMessage.body.length()).append(");");
            }
            if (content.dataMessage.groupV2 != null) {
                if (content.dataMessage.groupV2.groupChange != null) {
                    message.append("GroupV2Change(").append(content.dataMessage.groupV2.groupChange.size()).append(");");
                } else {
                    message.append("GroupV2NoChange;");
                }
            }
            if (content.dataMessage.giftBadge != null) {
                message.append("GiftBadge;");
            }
            if (content.dataMessage.pollCreate != null) {
                message.append("PollCreate;");
            }
            if (content.dataMessage.pollTerminate != null) {
                message.append("PollTerminate;");
            }
            if (content.dataMessage.pollVote != null) {
                message.append("PollVote;");
            }
            if (content.dataMessage.pinMessage != null) {
                message.append("PinMessage;");
            }
            if (content.dataMessage.unpinMessage != null) {
                message.append("UnpinMessage;");
            }
            if (content.dataMessage.reaction != null) {
                message.append("Reaction;");
            }
            if (content.dataMessage.profileKey != null && content.dataMessage.profileKey.size() > 0) {
                message.append("ProfileKey(").append(content.dataMessage.profileKey.size()).append(");");
            }
            if (content.dataMessage.payment != null) {
                message.append("Payment;");
            }
            if (!content.dataMessage.attachments.isEmpty()) {
                message.append("Attachments(").append(content.dataMessage.attachments.size()).append(");");
            }
            if (!content.dataMessage.contact.isEmpty()) {
                message.append("Contacts(").append(content.dataMessage.contact.size()).append(");");
            }
            if (!content.dataMessage.bodyRanges.isEmpty()) {
                message.append("Ranges(").append(content.dataMessage.bodyRanges.size()).append(");");
            }
            if (content.dataMessage.quote != null) {
                if (content.dataMessage.quote.text != null) {
                    message.append("Quote(").append(content.dataMessage.quote.text.length()).append(");");
                } else {
                    message.append("Quote(No text);");
                }
            }
        }
        if (content.syncMessage != null) {
            message.append("Sync message;");
            if (content.syncMessage.sent != null) {
                if (content.syncMessage.sent.storyMessage != null) {
                    message.append("StoryMessage(").append(content.syncMessage.sent.storyMessageRecipients.size()).append(");");
                }
                if (!content.syncMessage.sent.storyMessageRecipients.isEmpty()) {
                    message.append("StoryRecipients(").append(content.syncMessage.sent.storyMessageRecipients.size()).append(");");
                }
                if (content.syncMessage.blocked != null) {
                    message.append("Blocked-AciString(").append(content.syncMessage.blocked.acis.size()).append(");");
                    message.append("Blocked-AciBinary(").append(content.syncMessage.blocked.acisBinary.size()).append(");");
                    message.append("Blocked-GroupIds(").append(content.syncMessage.blocked.groupIds.size()).append(");");
                    message.append("Blocked-Numbers(").append(content.syncMessage.blocked.numbers.size()).append(");");
                }
                if (content.syncMessage.outgoingPayment != null) {
                    message.append("OutgoingPayment");
                }
                if (content.syncMessage.deleteForMe != null) {
                    message.append("DeleteForMe-Messages(").append(content.syncMessage.deleteForMe.messageDeletes.size()).append(");");
                    message.append("DeleteForMe-Attachments(").append(content.syncMessage.deleteForMe.attachmentDeletes.size()).append(");");
                    message.append("DeleteForMe-Conversations(").append(content.syncMessage.deleteForMe.conversationDeletes.size()).append(");");
                }
                if (!content.syncMessage.read.isEmpty()) {
                    message.append("Read(").append(content.syncMessage.read.size()).append(");");
                }
                if (!content.syncMessage.viewed.isEmpty()) {
                    message.append("Viewed(").append(content.syncMessage.read.size()).append(");");
                }
            }
        }
        if (content.receiptMessage != null) {
            message.append("ReceiptMessage(").append(content.receiptMessage.timestamp.size()).append(");");
            message.append("ReceiptMessage(").append(content.receiptMessage.type.getValue()).append(");");
        }
        return message.toString();
    }

    public static interface SendEvents {
        public void onMessageEncrypted();

        public void onMessageSent();

        public void onSyncMessageSent();
    }

    public static interface SenderKeyGroupEvents
    extends SendEvents {
        public static final SenderKeyGroupEvents EMPTY = new SenderKeyGroupEvents(){

            @Override
            public void onSenderKeyShared() {
            }

            @Override
            public void onMessageEncrypted() {
            }

            @Override
            public void onMessageSent() {
            }

            @Override
            public void onSyncMessageSent() {
            }
        };

        public void onSenderKeyShared();
    }

    public static interface IndividualSendEvents
    extends SendEvents {
        public static final IndividualSendEvents EMPTY = new IndividualSendEvents(){

            @Override
            public void onMessageEncrypted() {
            }

            @Override
            public void onMessageSent() {
            }

            @Override
            public void onSyncMessageSent() {
            }
        };
    }

    public static interface LegacyGroupEvents
    extends SendEvents {
        public static final LegacyGroupEvents EMPTY = new LegacyGroupEvents(){

            @Override
            public void onMessageEncrypted() {
            }

            @Override
            public void onMessageSent() {
            }

            @Override
            public void onSyncMessageSent() {
            }
        };
    }

    private static final class GroupTargetInfo {
        private final List<SignalProtocolAddress> destinations;
        private final Map<SignalServiceAddress, List<Integer>> devices;
        private final Map<SignalProtocolAddress, SessionRecord> sessions;

        private GroupTargetInfo(List<SignalProtocolAddress> destinations, Map<SignalServiceAddress, List<Integer>> devices, Map<SignalProtocolAddress, SessionRecord> sessions) {
            this.destinations = destinations;
            this.devices = devices;
            this.sessions = sessions;
        }
    }

    public static interface EventListener {
        public void onSecurityEvent(SignalServiceAddress var1);
    }
}

