/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.signal.core.models.ServiceId;
import org.signal.libsignal.net.Network;
import org.whispersystems.signalservice.api.NetworkResultUtil;
import org.whispersystems.signalservice.api.account.AccountApi;
import org.whispersystems.signalservice.api.groupsv2.ClientZkOperations;
import org.whispersystems.signalservice.api.groupsv2.GroupsV2Api;
import org.whispersystems.signalservice.api.groupsv2.GroupsV2Operations;
import org.whispersystems.signalservice.api.registration.RegistrationApi;
import org.whispersystems.signalservice.api.svr.SecureValueRecoveryV2;
import org.whispersystems.signalservice.api.svr.SecureValueRecoveryV3;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.push.WhoAmIResponse;
import org.whispersystems.signalservice.internal.util.StaticCredentialsProvider;

public class SignalServiceAccountManager {
    private static final String TAG = SignalServiceAccountManager.class.getSimpleName();
    private final PushServiceSocket pushServiceSocket;
    private final GroupsV2Operations groupsV2Operations;
    private final SignalServiceConfiguration configuration;
    private final SignalWebSocket.AuthenticatedWebSocket authWebSocket;
    private final AccountApi accountApi;

    public static SignalServiceAccountManager createWithStaticCredentials(SignalServiceConfiguration configuration, ServiceId.ACI aci, ServiceId.PNI pni, String e164, int deviceId, String password, String signalAgent, boolean automaticNetworkRetry, int maxGroupSize) {
        StaticCredentialsProvider credentialProvider = new StaticCredentialsProvider(aci, pni, e164, deviceId, password);
        GroupsV2Operations gv2Operations = new GroupsV2Operations(ClientZkOperations.create(configuration), maxGroupSize);
        return new SignalServiceAccountManager(null, null, new PushServiceSocket(configuration, credentialProvider, signalAgent, automaticNetworkRetry), gv2Operations);
    }

    public SignalServiceAccountManager(@Nullable SignalWebSocket.AuthenticatedWebSocket authWebSocket, @Nullable AccountApi accountApi, @Nonnull PushServiceSocket pushServiceSocket, @Nonnull GroupsV2Operations groupsV2Operations) {
        this.authWebSocket = authWebSocket;
        this.accountApi = accountApi;
        this.groupsV2Operations = groupsV2Operations;
        this.pushServiceSocket = pushServiceSocket;
        this.configuration = pushServiceSocket.getConfiguration();
    }

    public SecureValueRecoveryV2 getSecureValueRecoveryV2(String mrEnclave) {
        return new SecureValueRecoveryV2(this.configuration, mrEnclave, this.authWebSocket);
    }

    public SecureValueRecoveryV3 getSecureValueRecoveryV3(Network network) {
        return new SecureValueRecoveryV3(network, this.authWebSocket);
    }

    public WhoAmIResponse getWhoAmI() throws IOException {
        return NetworkResultUtil.toBasicLegacy(this.accountApi.whoAmI());
    }

    public void requestRegistrationPushChallenge(String sessionId, String gcmRegistrationId) throws IOException {
        this.pushServiceSocket.requestPushChallenge(sessionId, gcmRegistrationId);
    }

    public void checkNetworkConnection() throws IOException {
        this.pushServiceSocket.pingStorageService();
    }

    public void cancelInFlightRequests() {
        this.pushServiceSocket.cancelInFlightRequests();
    }

    public GroupsV2Api getGroupsV2Api() {
        return new GroupsV2Api(this.authWebSocket, this.pushServiceSocket, this.groupsV2Operations);
    }

    public RegistrationApi getRegistrationApi() {
        return new RegistrationApi(this.pushServiceSocket);
    }
}

