/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Function;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.concurrent.JvmRxExtensions;
import org.whispersystems.signalservice.api.push.exceptions.MalformedRequestException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.push.exceptions.PushNetworkException;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.util.JsonUtil;
import org.whispersystems.signalservice.internal.websocket.WebSocketConnection;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;
import org.whispersystems.signalservice.internal.websocket.WebsocketResponse;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\u00020\u0002:\t\"#$%&'()*BQ\b\u0004\u0012\"\b\u0002\u0010\u0003\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b0\u0004\u0012\"\b\u0002\u0010\t\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\u000b0\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u000b\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fJ\r\u0010\u0010\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0000\"\u0004\b\u0001\u0010\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00140\u0005J<\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001a\b\u0002\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\u00180\u00052\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u0019J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0000\"\u0004\b\u0001\u0010\u00142\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00140\u00000\u0005J \u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0005J(\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001a\u0010\u001e\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\bJ0\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002 \u0010\u001f\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b0 H\u0002J(\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001a\u0010\u001e\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\u000bJ0\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002 \u0010\u001f\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\u000b0 H\u0002R(\u0010\u0003\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u001c\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0004\n+\u0006,\u00a8\u0006-"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult;", "T", "", "statusCodeErrorActions", "", "Lkotlin/Function1;", "Lorg/whispersystems/signalservice/api/NetworkResult$StatusCodeError;", "", "Lorg/whispersystems/signalservice/api/StatusCodeErrorAction;", "applicationErrorActions", "Lorg/whispersystems/signalservice/api/NetworkResult$ApplicationError;", "Lorg/whispersystems/signalservice/api/ApplicationErrorAction;", "<init>", "(Ljava/util/Set;Ljava/util/Set;)V", "successOrThrow", "()Ljava/lang/Object;", "successOrNull", "getCause", "", "map", "R", "transform", "fallback", "predicate", "", "Lkotlin/Function0;", "then", "result", "runIfSuccessful", "runOnStatusCodeError", "action", "actions", "", "runOnApplicationError", "Companion", "Success", "NetworkError", "StatusCodeError", "ApplicationError", "Fetcher", "WebSocketResponseConverter", "DefaultWebSocketConverter", "LongPollingWebSocketConverter", "Lorg/whispersystems/signalservice/api/NetworkResult$NetworkError;", "Lorg/whispersystems/signalservice/api/NetworkResult$Success;", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nNetworkResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkResult.kt\norg/whispersystems/signalservice/api/NetworkResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,483:1\n1869#2,2:484\n1869#2,2:486\n*S KotlinDebug\n*F\n+ 1 NetworkResult.kt\norg/whispersystems/signalservice/api/NetworkResult\n*L\n399#1:484,2\n434#1:486,2\n*E\n"})
public abstract class NetworkResult<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Function1<StatusCodeError<?>, Unit>> statusCodeErrorActions;
    @NotNull
    private final Set<Function1<ApplicationError<?>, Unit>> applicationErrorActions;

    private NetworkResult(Set<Function1<StatusCodeError<?>, Unit>> statusCodeErrorActions, Set<Function1<ApplicationError<?>, Unit>> applicationErrorActions) {
        this.statusCodeErrorActions = statusCodeErrorActions;
        this.applicationErrorActions = applicationErrorActions;
    }

    public /* synthetic */ NetworkResult(Set set, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = new LinkedHashSet();
        }
        if ((n & 2) != 0) {
            set2 = new LinkedHashSet();
        }
        this(set, set2, null);
    }

    public final T successOrThrow() throws NonSuccessfulResponseCodeException, IOException, Throwable {
        NetworkResult networkResult = this;
        if (networkResult instanceof Success) {
            return ((Success)this).getResult();
        }
        if (networkResult instanceof NetworkError) {
            throw ((NetworkError)this).getException();
        }
        if (networkResult instanceof StatusCodeError) {
            throw ((StatusCodeError)this).getException();
        }
        if (networkResult instanceof ApplicationError) {
            throw ((ApplicationError)this).getThrowable();
        }
        throw new NoWhenBranchMatchedException();
    }

    @Nullable
    public final T successOrNull() {
        return this instanceof Success ? (T)((Success)this).getResult() : null;
    }

    @Nullable
    public final Throwable getCause() {
        Throwable throwable;
        NetworkResult networkResult = this;
        if (networkResult instanceof Success) {
            throwable = null;
        } else if (networkResult instanceof NetworkError) {
            throwable = ((NetworkError)this).getException();
        } else if (networkResult instanceof StatusCodeError) {
            throwable = ((StatusCodeError)this).getException();
        } else if (networkResult instanceof ApplicationError) {
            throwable = ((ApplicationError)this).getThrowable();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return throwable;
    }

    @NotNull
    public final <R> NetworkResult<R> map(@NotNull Function1<? super T, ? extends R> transform) {
        NetworkResult networkResult;
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        NetworkResult networkResult2 = this;
        if (networkResult2 instanceof Success) {
            NetworkResult networkResult3;
            try {
                networkResult3 = new Success<Object>(transform.invoke(((Success)this).getResult()));
            }
            catch (Throwable e) {
                networkResult3 = new ApplicationError(e);
            }
            networkResult = networkResult3;
        } else if (networkResult2 instanceof NetworkError) {
            networkResult = new NetworkError(((NetworkError)this).getException());
        } else if (networkResult2 instanceof ApplicationError) {
            networkResult = new ApplicationError(((ApplicationError)this).getThrowable());
        } else if (networkResult2 instanceof StatusCodeError) {
            networkResult = new StatusCodeError((StatusCodeError)this);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        NetworkResult map = networkResult;
        return super.runOnApplicationError((Collection)this.applicationErrorActions);
    }

    @NotNull
    public final NetworkResult<T> fallback(@NotNull Function1<? super NetworkResult<T>, Boolean> predicate, @NotNull Function0<? extends NetworkResult<T>> fallback) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Intrinsics.checkNotNullParameter(fallback, (String)"fallback");
        if (this instanceof Success) {
            return this;
        }
        return (Boolean)predicate.invoke((Object)this) != false ? (NetworkResult)fallback.invoke() : this;
    }

    public static /* synthetic */ NetworkResult fallback$default(NetworkResult networkResult, Function1 function1, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fallback");
        }
        if ((n & 1) != 0) {
            function1 = NetworkResult::fallback$lambda$0;
        }
        return networkResult.fallback(function1, function0);
    }

    @NotNull
    public final <R> NetworkResult<R> then(@NotNull Function1<? super T, ? extends NetworkResult<R>> result2) {
        NetworkResult networkResult;
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        NetworkResult networkResult2 = this;
        if (networkResult2 instanceof Success) {
            networkResult = (NetworkResult)result2.invoke(((Success)this).getResult());
        } else if (networkResult2 instanceof NetworkError) {
            networkResult = new NetworkError(((NetworkError)this).getException());
        } else if (networkResult2 instanceof ApplicationError) {
            networkResult = new ApplicationError(((ApplicationError)this).getThrowable());
        } else if (networkResult2 instanceof StatusCodeError) {
            networkResult = new StatusCodeError((StatusCodeError)this);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        NetworkResult then = networkResult;
        return super.runOnApplicationError((Collection)this.applicationErrorActions);
    }

    @NotNull
    public final NetworkResult<T> runIfSuccessful(@NotNull Function1<? super T, Unit> result2) {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (this instanceof Success) {
            result2.invoke(((Success)this).getResult());
        }
        return this;
    }

    @NotNull
    public final NetworkResult<T> runOnStatusCodeError(@NotNull Function1<? super StatusCodeError<?>, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return this.runOnStatusCodeError(SetsKt.setOf(action2));
    }

    private final NetworkResult<T> runOnStatusCodeError(Collection<? extends Function1<? super StatusCodeError<?>, Unit>> actions) {
        if (actions.isEmpty()) {
            return this;
        }
        CollectionsKt.addAll((Collection)this.statusCodeErrorActions, (Iterable)actions);
        if (this instanceof StatusCodeError) {
            Iterable $this$forEach$iv = this.statusCodeErrorActions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)this);
            }
            this.statusCodeErrorActions.clear();
        }
        return this;
    }

    @NotNull
    public final NetworkResult<T> runOnApplicationError(@NotNull Function1<? super ApplicationError<?>, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return this.runOnApplicationError(SetsKt.setOf(action2));
    }

    private final NetworkResult<T> runOnApplicationError(Collection<? extends Function1<? super ApplicationError<?>, Unit>> actions) {
        if (actions.isEmpty()) {
            return this;
        }
        CollectionsKt.addAll((Collection)this.applicationErrorActions, (Iterable)actions);
        if (this instanceof ApplicationError) {
            Iterable $this$forEach$iv = this.applicationErrorActions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)this);
            }
            this.applicationErrorActions.clear();
        }
        return this;
    }

    private static final boolean fallback$lambda$0(NetworkResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    @JvmStatic
    @NotNull
    public static final <T> NetworkResult<T> fromFetch(@NotNull Fetcher<T> fetcher) {
        return Companion.fromFetch(fetcher);
    }

    @JvmStatic
    @NotNull
    public static final NetworkResult<Unit> fromWebSocketRequest-SxA4cEA(@NotNull SignalWebSocket signalWebSocket, @NotNull WebSocketRequestMessage request2, long timeout) {
        return Companion.fromWebSocketRequest-SxA4cEA(signalWebSocket, request2, timeout);
    }

    @JvmStatic
    @NotNull
    public static final <T> NetworkResult<T> fromWebSocketRequest-Wn2Vu4Y(@NotNull SignalWebSocket signalWebSocket, @NotNull WebSocketRequestMessage request2, @NotNull KClass<T> clazz, long timeout) {
        return Companion.fromWebSocketRequest-Wn2Vu4Y(signalWebSocket, request2, clazz, timeout);
    }

    @JvmStatic
    @NotNull
    public static final <T> NetworkResult<T> fromWebSocketRequest-exY8QGI(@NotNull SignalWebSocket signalWebSocket, @NotNull WebSocketRequestMessage request2, long timeout, @NotNull WebSocketResponseConverter<T> webSocketResponseConverter) {
        return Companion.fromWebSocketRequest-exY8QGI(signalWebSocket, request2, timeout, webSocketResponseConverter);
    }

    public /* synthetic */ NetworkResult(Set statusCodeErrorActions, Set applicationErrorActions, DefaultConstructorMarker $constructor_marker) {
        this(statusCodeErrorActions, applicationErrorActions);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\t\u001a\u00020\u0004H\u00c6\u0003J\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$ApplicationError;", "T", "Lorg/whispersystems/signalservice/api/NetworkResult;", "throwable", "", "<init>", "(Ljava/lang/Throwable;)V", "getThrowable", "()Ljava/lang/Throwable;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
    public static final class ApplicationError<T>
    extends NetworkResult<T> {
        @NotNull
        private final Throwable throwable;

        public ApplicationError(@NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            super(null, null, 3, null);
            this.throwable = throwable;
        }

        @NotNull
        public final Throwable getThrowable() {
            return this.throwable;
        }

        @NotNull
        public final Throwable component1() {
            return this.throwable;
        }

        @NotNull
        public final ApplicationError<T> copy(@NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            return new ApplicationError<T>(throwable);
        }

        public static /* synthetic */ ApplicationError copy$default(ApplicationError applicationError, Throwable throwable, int n, Object object) {
            if ((n & 1) != 0) {
                throwable = applicationError.throwable;
            }
            return applicationError.copy(throwable);
        }

        @NotNull
        public String toString() {
            return "ApplicationError(throwable=" + this.throwable + ")";
        }

        public int hashCode() {
            return this.throwable.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ApplicationError)) {
                return false;
            }
            ApplicationError applicationError = (ApplicationError)other;
            return Intrinsics.areEqual((Object)this.throwable, (Object)applicationError.throwable);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0007J/\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\n\b\u0001\u0010\u0006\u0018\u0001*\u00020\u00012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bH\u0086\bJ4\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\r2\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bJ/\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017JG\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00192\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJG\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\rH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ$\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00060 J\u008c\u0001\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\n\b\u0001\u0010\u0006*\u0004\u0018\u00010\u00012\b\b\u0002\u0010\"\u001a\u00020#2\u001a\b\u0002\u0010$\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u0005\u0012\u0004\u0012\u00020&0%28\b\u0002\u0010'\u001a2\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u000f0(2\u0012\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00050 \u00a8\u0006-"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$Companion;", "", "<init>", "()V", "fromFetch", "Lorg/whispersystems/signalservice/api/NetworkResult;", "T", "fetcher", "Lorg/whispersystems/signalservice/api/NetworkResult$Fetcher;", "fromWebSocket", "Lio/reactivex/rxjava3/core/Single;", "Lorg/whispersystems/signalservice/internal/websocket/WebsocketResponse;", "webSocketResponseConverter", "Lorg/whispersystems/signalservice/api/NetworkResult$WebSocketResponseConverter;", "fromWebSocketRequest", "", "signalWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket;", "request", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;", "timeout", "Lkotlin/time/Duration;", "fromWebSocketRequest-SxA4cEA", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket;Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;J)Lorg/whispersystems/signalservice/api/NetworkResult;", "clazz", "Lkotlin/reflect/KClass;", "fromWebSocketRequest-Wn2Vu4Y", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket;Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;Lkotlin/reflect/KClass;J)Lorg/whispersystems/signalservice/api/NetworkResult;", "fromWebSocketRequest-exY8QGI", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket;Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;JLorg/whispersystems/signalservice/api/NetworkResult$WebSocketResponseConverter;)Lorg/whispersystems/signalservice/api/NetworkResult;", "fromLocal", "block", "Lkotlin/Function0;", "withRetry", "maxAttempts", "", "shouldRetry", "Lkotlin/Function1;", "", "logAttempt", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "attempt", "operation", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> NetworkResult<T> fromFetch(@NotNull Fetcher<T> fetcher) {
            NetworkResult networkResult;
            Intrinsics.checkNotNullParameter(fetcher, (String)"fetcher");
            try {
                networkResult = new Success<T>(fetcher.fetch());
            }
            catch (NonSuccessfulResponseCodeException e) {
                networkResult = new StatusCodeError(e);
            }
            catch (IOException e) {
                networkResult = new NetworkError(e);
            }
            catch (Throwable e) {
                networkResult = new ApplicationError(e);
            }
            return networkResult;
        }

        public final /* synthetic */ <T> NetworkResult<T> fromWebSocket(Fetcher<Single<WebsocketResponse>> fetcher) {
            Intrinsics.checkNotNullParameter(fetcher, (String)"fetcher");
            boolean $i$f$fromWebSocket = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            return this.fromWebSocket(new DefaultWebSocketConverter(Reflection.getOrCreateKotlinClass(Object.class)), fetcher);
        }

        @NotNull
        public final <T> NetworkResult<T> fromWebSocket(@NotNull WebSocketResponseConverter<T> webSocketResponseConverter, @NotNull Fetcher<Single<WebsocketResponse>> fetcher) {
            NetworkResult networkResult;
            Intrinsics.checkNotNullParameter(webSocketResponseConverter, (String)"webSocketResponseConverter");
            Intrinsics.checkNotNullParameter(fetcher, (String)"fetcher");
            try {
                Object result2;
                Single single = fetcher.fetch().map(new Function(webSocketResponseConverter){
                    final /* synthetic */ WebSocketResponseConverter<T> $webSocketResponseConverter;
                    {
                        this.$webSocketResponseConverter = $webSocketResponseConverter;
                    }

                    public final Object apply-IoAF18A(WebsocketResponse response) {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        return Result.constructor-impl(this.$webSocketResponseConverter.convert(response));
                    }
                }).onErrorReturn(Companion::fromWebSocket$lambda$0);
                Intrinsics.checkNotNullExpressionValue((Object)single, (String)"onErrorReturn(...)");
                Object object = JvmRxExtensions.safeBlockingGet((Single)single);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"safeBlockingGet(...)");
                object = result2 = ((Result)object).unbox-impl();
                ResultKt.throwOnFailure((Object)object);
                networkResult = (NetworkResult)object;
            }
            catch (NonSuccessfulResponseCodeException e) {
                networkResult = new StatusCodeError(e);
            }
            catch (IOException e) {
                networkResult = new NetworkError(e);
            }
            catch (TimeoutException e) {
                networkResult = new NetworkError(new PushNetworkException(e));
            }
            catch (InterruptedException e) {
                networkResult = new NetworkError(new PushNetworkException(e));
            }
            catch (Throwable e) {
                networkResult = new ApplicationError(e);
            }
            return networkResult;
        }

        @JvmStatic
        @NotNull
        public final NetworkResult<Unit> fromWebSocketRequest-SxA4cEA(@NotNull SignalWebSocket signalWebSocket, @NotNull WebSocketRequestMessage request2, long timeout) {
            Intrinsics.checkNotNullParameter((Object)signalWebSocket, (String)"signalWebSocket");
            Intrinsics.checkNotNullParameter((Object)((Object)request2), (String)"request");
            return this.fromWebSocketRequest-Wn2Vu4Y(signalWebSocket, request2, Reflection.getOrCreateKotlinClass(Unit.class), timeout);
        }

        public static /* synthetic */ NetworkResult fromWebSocketRequest-SxA4cEA$default(Companion companion, SignalWebSocket signalWebSocket, WebSocketRequestMessage webSocketRequestMessage, long l, int n, Object object) {
            if ((n & 4) != 0) {
                l = WebSocketConnection.Companion.getDEFAULT_SEND_TIMEOUT-UwyO8pc();
            }
            return companion.fromWebSocketRequest-SxA4cEA(signalWebSocket, webSocketRequestMessage, l);
        }

        @JvmStatic
        @NotNull
        public final <T> NetworkResult<T> fromWebSocketRequest-Wn2Vu4Y(@NotNull SignalWebSocket signalWebSocket, @NotNull WebSocketRequestMessage request2, @NotNull KClass<T> clazz, long timeout) {
            Intrinsics.checkNotNullParameter((Object)signalWebSocket, (String)"signalWebSocket");
            Intrinsics.checkNotNullParameter((Object)((Object)request2), (String)"request");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            return this.fromWebSocketRequest-exY8QGI(signalWebSocket, request2, timeout, new DefaultWebSocketConverter<T>(clazz));
        }

        public static /* synthetic */ NetworkResult fromWebSocketRequest-Wn2Vu4Y$default(Companion companion, SignalWebSocket signalWebSocket, WebSocketRequestMessage webSocketRequestMessage, KClass kClass, long l, int n, Object object) {
            if ((n & 8) != 0) {
                l = WebSocketConnection.Companion.getDEFAULT_SEND_TIMEOUT-UwyO8pc();
            }
            return companion.fromWebSocketRequest-Wn2Vu4Y(signalWebSocket, webSocketRequestMessage, kClass, l);
        }

        @JvmStatic
        @NotNull
        public final <T> NetworkResult<T> fromWebSocketRequest-exY8QGI(@NotNull SignalWebSocket signalWebSocket, @NotNull WebSocketRequestMessage request2, long timeout, @NotNull WebSocketResponseConverter<T> webSocketResponseConverter) {
            Intrinsics.checkNotNullParameter((Object)signalWebSocket, (String)"signalWebSocket");
            Intrinsics.checkNotNullParameter((Object)((Object)request2), (String)"request");
            Intrinsics.checkNotNullParameter(webSocketResponseConverter, (String)"webSocketResponseConverter");
            return this.fromWebSocket(webSocketResponseConverter, () -> Companion.fromWebSocketRequest_exY8QGI$lambda$1(signalWebSocket, request2, timeout));
        }

        public static /* synthetic */ NetworkResult fromWebSocketRequest-exY8QGI$default(Companion companion, SignalWebSocket signalWebSocket, WebSocketRequestMessage webSocketRequestMessage, long l, WebSocketResponseConverter webSocketResponseConverter, int n, Object object) {
            if ((n & 4) != 0) {
                l = WebSocketConnection.Companion.getDEFAULT_SEND_TIMEOUT-UwyO8pc();
            }
            return companion.fromWebSocketRequest-exY8QGI(signalWebSocket, webSocketRequestMessage, l, webSocketResponseConverter);
        }

        @NotNull
        public final <T> NetworkResult<T> fromLocal(@NotNull Function0<? extends T> block) {
            NetworkResult networkResult;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            try {
                networkResult = new Success<Object>(block.invoke());
            }
            catch (Throwable e) {
                networkResult = new ApplicationError(e);
            }
            return networkResult;
        }

        @NotNull
        public final <T> NetworkResult<T> withRetry(int maxAttempts, @NotNull Function1<? super NetworkResult<T>, Boolean> shouldRetry, @NotNull Function2<? super Integer, ? super Integer, Unit> logAttempt, @NotNull Function0<? extends NetworkResult<T>> operation) {
            Intrinsics.checkNotNullParameter(shouldRetry, (String)"shouldRetry");
            Intrinsics.checkNotNullParameter(logAttempt, (String)"logAttempt");
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            if (!(maxAttempts > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            NetworkResult result2 = null;
            for (int attempt = 0; attempt < maxAttempts; ++attempt) {
                logAttempt.invoke((Object)attempt, (Object)maxAttempts);
                result2 = (NetworkResult)operation.invoke();
                NetworkResult networkResult = result2;
                if (networkResult == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"result");
                    networkResult = null;
                }
                if (((Boolean)shouldRetry.invoke((Object)networkResult)).booleanValue()) continue;
                return result2;
            }
            NetworkResult networkResult = result2;
            if (networkResult == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"result");
                networkResult = null;
            }
            return networkResult;
        }

        public static /* synthetic */ NetworkResult withRetry$default(Companion companion, int n, Function1 function1, Function2 function2, Function0 function0, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 5;
            }
            if ((n2 & 2) != 0) {
                function1 = Companion::withRetry$lambda$2;
            }
            if ((n2 & 4) != 0) {
                function2 = Companion::withRetry$lambda$3;
            }
            return companion.withRetry(n, function1, (Function2<? super Integer, ? super Integer, Unit>)function2, function0);
        }

        private static final Result fromWebSocket$lambda$0(Throwable it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it)));
        }

        private static final Single fromWebSocketRequest_exY8QGI$lambda$1(SignalWebSocket $signalWebSocket, WebSocketRequestMessage $request, long $timeout) {
            return $signalWebSocket.request-HG0u8IE($request, $timeout);
        }

        private static final boolean withRetry$lambda$2(NetworkResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof NetworkError;
        }

        private static final Unit withRetry$lambda$3(int n, int n2) {
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$DefaultWebSocketConverter;", "T", "", "Lorg/whispersystems/signalservice/api/NetworkResult$WebSocketResponseConverter;", "responseJsonClass", "Lkotlin/reflect/KClass;", "<init>", "(Lkotlin/reflect/KClass;)V", "convert", "Lorg/whispersystems/signalservice/api/NetworkResult;", "response", "Lorg/whispersystems/signalservice/internal/websocket/WebsocketResponse;", "signal-service-java"})
    public static final class DefaultWebSocketConverter<T>
    implements WebSocketResponseConverter<T> {
        @NotNull
        private final KClass<T> responseJsonClass;

        public DefaultWebSocketConverter(@NotNull KClass<T> responseJsonClass) {
            Intrinsics.checkNotNullParameter(responseJsonClass, (String)"responseJsonClass");
            this.responseJsonClass = responseJsonClass;
        }

        @Override
        @NotNull
        public NetworkResult<T> convert(@NotNull WebsocketResponse response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            return response.getStatus() < 200 || response.getStatus() > 299 ? this.toStatusCodeError(response) : this.toSuccess(response, this.responseJsonClass);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\r\u0010\u0003\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$Fetcher;", "T", "", "fetch", "()Ljava/lang/Object;", "signal-service-java"})
    public static interface Fetcher<T> {
        public T fetch() throws Exception;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$LongPollingWebSocketConverter;", "T", "", "Lorg/whispersystems/signalservice/api/NetworkResult$WebSocketResponseConverter;", "responseJsonClass", "Lkotlin/reflect/KClass;", "<init>", "(Lkotlin/reflect/KClass;)V", "convert", "Lorg/whispersystems/signalservice/api/NetworkResult;", "response", "Lorg/whispersystems/signalservice/internal/websocket/WebsocketResponse;", "signal-service-java"})
    public static final class LongPollingWebSocketConverter<T>
    implements WebSocketResponseConverter<T> {
        @NotNull
        private final KClass<T> responseJsonClass;

        public LongPollingWebSocketConverter(@NotNull KClass<T> responseJsonClass) {
            Intrinsics.checkNotNullParameter(responseJsonClass, (String)"responseJsonClass");
            this.responseJsonClass = responseJsonClass;
        }

        @Override
        @NotNull
        public NetworkResult<T> convert(@NotNull WebsocketResponse response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            return response.getStatus() == 204 || response.getStatus() < 200 || response.getStatus() > 299 ? this.toStatusCodeError(response) : this.toSuccess(response, this.responseJsonClass);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\t\u001a\u00020\u0004H\u00c6\u0003J\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$NetworkError;", "T", "Lorg/whispersystems/signalservice/api/NetworkResult;", "exception", "Ljava/io/IOException;", "<init>", "(Ljava/io/IOException;)V", "getException", "()Ljava/io/IOException;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
    public static final class NetworkError<T>
    extends NetworkResult<T> {
        @NotNull
        private final IOException exception;

        public NetworkError(@NotNull IOException exception) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            super(null, null, 3, null);
            this.exception = exception;
        }

        @NotNull
        public final IOException getException() {
            return this.exception;
        }

        @NotNull
        public final IOException component1() {
            return this.exception;
        }

        @NotNull
        public final NetworkError<T> copy(@NotNull IOException exception) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            return new NetworkError<T>(exception);
        }

        public static /* synthetic */ NetworkError copy$default(NetworkError networkError, IOException iOException, int n, Object object) {
            if ((n & 1) != 0) {
                iOException = networkError.exception;
            }
            return networkError.copy(iOException);
        }

        @NotNull
        public String toString() {
            return "NetworkError(exception=" + this.exception + ")";
        }

        public int hashCode() {
            return this.exception.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NetworkError)) {
                return false;
            }
            NetworkError networkError = (NetworkError)other;
            return Intrinsics.areEqual((Object)this.exception, (Object)networkError.exception);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u0010B\u0015\b\u0016\u0012\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0000\u00a2\u0006\u0004\b\r\u0010\u0012J\u0018\u0010\u001b\u001a\u0004\u0018\u0001H\u0001\"\u0006\b\u0002\u0010\u0001\u0018\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u0006J\r\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\u0002\b!J\t\u0010\"\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u0015\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\nH\u00c2\u0003J\t\u0010&\u001a\u00020\fH\u00c6\u0003JQ\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u00d6\u0003J\t\u0010,\u001a\u00020\u0004H\u00d6\u0001J\t\u0010-\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$StatusCodeError;", "T", "Lorg/whispersystems/signalservice/api/NetworkResult;", "code", "", "stringBody", "", "binaryBody", "", "headers", "", "exception", "Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;", "<init>", "(ILjava/lang/String;[BLjava/util/Map;Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;)V", "e", "(Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;)V", "result", "(Lorg/whispersystems/signalservice/api/NetworkResult$StatusCodeError;)V", "getCode", "()I", "getStringBody", "()Ljava/lang/String;", "getBinaryBody", "()[B", "getException", "()Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;", "parseJsonBody", "()Ljava/lang/Object;", "header", "key", "retryAfter", "Lkotlin/time/Duration;", "retryAfter-FghU774", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "signal-service-java"})
    public static final class StatusCodeError<T>
    extends NetworkResult<T> {
        private final int code;
        @Nullable
        private final String stringBody;
        @Nullable
        private final byte[] binaryBody;
        @NotNull
        private final Map<String, String> headers;
        @NotNull
        private final NonSuccessfulResponseCodeException exception;

        public StatusCodeError(int code, @Nullable String stringBody, @Nullable byte[] binaryBody, @NotNull Map<String, String> headers, @NotNull NonSuccessfulResponseCodeException exception) {
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            super(null, null, 3, null);
            this.code = code;
            this.stringBody = stringBody;
            this.binaryBody = binaryBody;
            this.headers = headers;
            this.exception = exception;
        }

        public final int getCode() {
            return this.code;
        }

        @Nullable
        public final String getStringBody() {
            return this.stringBody;
        }

        @Nullable
        public final byte[] getBinaryBody() {
            return this.binaryBody;
        }

        @NotNull
        public final NonSuccessfulResponseCodeException getException() {
            return this.exception;
        }

        public StatusCodeError(@NotNull NonSuccessfulResponseCodeException e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this(e.code, e.getStringBody(), e.getBinaryBody(), e.getHeaders(), e);
        }

        public StatusCodeError(@NotNull StatusCodeError<?> result2) {
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            this(result2.code, result2.stringBody, result2.binaryBody, result2.headers, result2.exception);
        }

        public final /* synthetic */ <T> T parseJsonBody() {
            Object object;
            boolean $i$f$parseJsonBody = false;
            try {
                Object object2;
                if (this.getStringBody() != null) {
                    String string = this.getStringBody();
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    object2 = JsonUtil.fromJsonResponse(string, Object.class);
                } else if (this.getBinaryBody() != null) {
                    byte[] byArray = this.getBinaryBody();
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    object2 = JsonUtil.fromJsonResponse(byArray, Object.class);
                } else {
                    object2 = null;
                }
                object = object2;
            }
            catch (MalformedRequestException malformedRequestException) {
                object = null;
            }
            return (T)object;
        }

        @Nullable
        public final String header(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String string = key.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return this.headers.get(string);
        }

        @Nullable
        public final Duration retryAfter-FghU774() {
            Long l;
            String string = this.header("retry-after");
            return string != null && (l = StringsKt.toLongOrNull((String)string)) != null ? Duration.box-impl((long)DurationKt.toDuration((long)l, (DurationUnit)DurationUnit.SECONDS)) : null;
        }

        public final int component1() {
            return this.code;
        }

        @Nullable
        public final String component2() {
            return this.stringBody;
        }

        @Nullable
        public final byte[] component3() {
            return this.binaryBody;
        }

        private final Map<String, String> component4() {
            return this.headers;
        }

        @NotNull
        public final NonSuccessfulResponseCodeException component5() {
            return this.exception;
        }

        @NotNull
        public final StatusCodeError<T> copy(int code, @Nullable String stringBody, @Nullable byte[] binaryBody, @NotNull Map<String, String> headers, @NotNull NonSuccessfulResponseCodeException exception) {
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            return new StatusCodeError<T>(code, stringBody, binaryBody, headers, exception);
        }

        public static /* synthetic */ StatusCodeError copy$default(StatusCodeError statusCodeError, int n, String string, byte[] byArray, Map map, NonSuccessfulResponseCodeException nonSuccessfulResponseCodeException, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = statusCodeError.code;
            }
            if ((n2 & 2) != 0) {
                string = statusCodeError.stringBody;
            }
            if ((n2 & 4) != 0) {
                byArray = statusCodeError.binaryBody;
            }
            if ((n2 & 8) != 0) {
                map = statusCodeError.headers;
            }
            if ((n2 & 0x10) != 0) {
                nonSuccessfulResponseCodeException = statusCodeError.exception;
            }
            return statusCodeError.copy(n, string, byArray, map, nonSuccessfulResponseCodeException);
        }

        @NotNull
        public String toString() {
            return "StatusCodeError(code=" + this.code + ", stringBody=" + this.stringBody + ", binaryBody=" + Arrays.toString(this.binaryBody) + ", headers=" + this.headers + ", exception=" + this.exception + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.code);
            result2 = result2 * 31 + (this.stringBody == null ? 0 : this.stringBody.hashCode());
            result2 = result2 * 31 + (this.binaryBody == null ? 0 : Arrays.hashCode(this.binaryBody));
            result2 = result2 * 31 + ((Object)this.headers).hashCode();
            result2 = result2 * 31 + this.exception.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StatusCodeError)) {
                return false;
            }
            StatusCodeError statusCodeError = (StatusCodeError)other;
            if (this.code != statusCodeError.code) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stringBody, (Object)statusCodeError.stringBody)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.binaryBody, (Object)statusCodeError.binaryBody)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.headers, statusCodeError.headers)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.exception, (Object)statusCodeError.exception);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$Success;", "T", "Lorg/whispersystems/signalservice/api/NetworkResult;", "result", "<init>", "(Ljava/lang/Object;)V", "getResult", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lorg/whispersystems/signalservice/api/NetworkResult$Success;", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
    public static final class Success<T>
    extends NetworkResult<T> {
        private final T result;

        public Success(T result2) {
            super(null, null, 3, null);
            this.result = result2;
        }

        public final T getResult() {
            return this.result;
        }

        public final T component1() {
            return this.result;
        }

        @NotNull
        public final Success<T> copy(T result2) {
            return new Success<T>(result2);
        }

        public static /* synthetic */ Success copy$default(Success success, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = success.result;
            }
            return success.copy(object);
        }

        @NotNull
        public String toString() {
            return "Success(result=" + this.result + ")";
        }

        public int hashCode() {
            return this.result == null ? 0 : this.result.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Success)) {
                return false;
            }
            Success success = (Success)other;
            return Intrinsics.areEqual(this.result, success.result);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0004\"\b\b\u0002\u0010\u0001*\u00020\u0002*\u00020\u0006H\u0016J*\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0004\"\b\b\u0002\u0010\u0001*\u00020\u0002*\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00010\nH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lorg/whispersystems/signalservice/api/NetworkResult$WebSocketResponseConverter;", "T", "", "convert", "Lorg/whispersystems/signalservice/api/NetworkResult;", "response", "Lorg/whispersystems/signalservice/internal/websocket/WebsocketResponse;", "toStatusCodeError", "toSuccess", "responseJsonClass", "Lkotlin/reflect/KClass;", "signal-service-java"})
    public static interface WebSocketResponseConverter<T> {
        @NotNull
        public NetworkResult<T> convert(@NotNull WebsocketResponse var1) throws Exception;

        @NotNull
        default public <T> NetworkResult<T> toStatusCodeError(@NotNull WebsocketResponse $this$toStatusCodeError) {
            Intrinsics.checkNotNullParameter((Object)$this$toStatusCodeError, (String)"<this>");
            int n = $this$toStatusCodeError.getStatus();
            String string = $this$toStatusCodeError.getBody();
            Map<String, String> map = $this$toStatusCodeError.getHeaders();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getHeaders(...)");
            return new StatusCodeError(new NonSuccessfulResponseCodeException(n, "", string, map));
        }

        @NotNull
        default public <T> NetworkResult<T> toSuccess(@NotNull WebsocketResponse $this$toSuccess, @NotNull KClass<T> responseJsonClass) {
            Intrinsics.checkNotNullParameter((Object)$this$toSuccess, (String)"<this>");
            Intrinsics.checkNotNullParameter(responseJsonClass, (String)"responseJsonClass");
            KClass<T> kClass = responseJsonClass;
            return Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Unit.class)) ? (NetworkResult)new Success<Object>(KClasses.cast(responseJsonClass, (Object)Unit.INSTANCE)) : (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(String.class)) ? (NetworkResult)new Success<Object>(KClasses.cast(responseJsonClass, (Object)$this$toSuccess.getBody())) : (NetworkResult)new Success(JsonUtil.fromJson($this$toSuccess.getBody(), JvmClassMappingKt.getJavaClass(responseJsonClass))));
        }
    }
}

