/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.models.storageservice;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.models.storageservice.StorageItemKey;
import org.signal.core.models.storageservice.StorageManifestKey;
import org.signal.core.util.Base64;
import org.signal.core.util.CryptoUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010\u0012\u001a\u00020\u0003J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/signal/core/models/storageservice/StorageKey;", "", "key", "", "<init>", "([B)V", "getKey", "()[B", "deriveManifestKey", "Lorg/signal/core/models/storageservice/StorageManifestKey;", "version", "", "deriveItemKey", "Lorg/signal/core/models/storageservice/StorageItemKey;", "rawId", "derive", "keyName", "", "serialize", "equals", "", "other", "hashCode", "", "models-jvm"})
public final class StorageKey {
    @NotNull
    private final byte[] key;

    public StorageKey(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
        if (!(this.key.length == 32)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @NotNull
    public final byte[] getKey() {
        return this.key;
    }

    @NotNull
    public final StorageManifestKey deriveManifestKey(long version) {
        return new StorageManifestKey(this.derive("Manifest_" + version));
    }

    @NotNull
    public final StorageItemKey deriveItemKey(@NotNull byte[] rawId) {
        Intrinsics.checkNotNullParameter((Object)rawId, (String)"rawId");
        return new StorageItemKey(this.derive("Item_" + Base64.encodeWithPadding$default((byte[])rawId, (int)0, (int)0, (int)6, null)));
    }

    private final byte[] derive(String keyName) {
        byte[] byArray = keyName.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = CryptoUtil.hmacSha256((byte[])this.key, (byte[])byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"hmacSha256(...)");
        return byArray2;
    }

    @NotNull
    public final byte[] serialize() {
        return (byte[])this.key.clone();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.signal.core.models.storageservice.StorageKey");
        StorageKey cfr_ignored_0 = (StorageKey)other;
        return Arrays.equals(this.key, ((StorageKey)other).key);
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }
}

