/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.models;

import java.security.SecureRandom;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.models.storageservice.StorageKey;
import org.signal.core.util.Base64;
import org.signal.core.util.CryptoUtil;
import org.signal.core.util.Hex;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0006\u0010\u000e\u001a\u00020\u0003J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/signal/core/models/MasterKey;", "", "masterKey", "", "<init>", "([B)V", "deriveRegistrationLock", "", "deriveRegistrationRecoveryPassword", "deriveStorageServiceKey", "Lorg/signal/core/models/storageservice/StorageKey;", "deriveLoggingKey", "derive", "keyName", "serialize", "equals", "", "o", "hashCode", "", "toString", "Companion", "models-jvm"})
@SourceDebugExtension(value={"SMAP\nMasterKey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MasterKey.kt\norg/signal/core/models/MasterKey\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class MasterKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] masterKey;
    private static final int LENGTH = 32;

    public MasterKey(@NotNull byte[] masterKey) {
        Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
        if (!(masterKey.length == 32)) {
            boolean bl = false;
            String string = "Master key must be 32 bytes long (actualSize: " + masterKey.length + ")";
            throw new IllegalStateException(string.toString());
        }
        this.masterKey = masterKey;
    }

    @NotNull
    public final String deriveRegistrationLock() {
        String string = Hex.toStringCondensed((byte[])this.derive("Registration Lock"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toStringCondensed(...)");
        return string;
    }

    @NotNull
    public final String deriveRegistrationRecoveryPassword() {
        byte[] byArray = this.derive("Registration Recovery");
        Intrinsics.checkNotNull((Object)byArray);
        return Base64.encodeWithPadding$default((byte[])byArray, (int)0, (int)0, (int)6, null);
    }

    @NotNull
    public final StorageKey deriveStorageServiceKey() {
        byte[] byArray = this.derive("Storage Service Encryption");
        Intrinsics.checkNotNull((Object)byArray);
        return new StorageKey(byArray);
    }

    @Nullable
    public final byte[] deriveLoggingKey() {
        return this.derive("Logging Key");
    }

    private final byte[] derive(String keyName) {
        byte[] byArray = keyName.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return CryptoUtil.hmacSha256((byte[])this.masterKey, (byte[])byArray);
    }

    @NotNull
    public final byte[] serialize() {
        return (byte[])this.masterKey.clone();
    }

    public boolean equals(@Nullable Object o) {
        if (o == null || !Intrinsics.areEqual(o.getClass(), this.getClass())) {
            return false;
        }
        return Arrays.equals(((MasterKey)o).masterKey, this.masterKey);
    }

    public int hashCode() {
        return Arrays.hashCode(this.masterKey);
    }

    @NotNull
    public String toString() {
        return "MasterKey(xxx)";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/signal/core/models/MasterKey$Companion;", "", "<init>", "()V", "LENGTH", "", "createNew", "Lorg/signal/core/models/MasterKey;", "secureRandom", "Ljava/security/SecureRandom;", "models-jvm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MasterKey createNew(@NotNull SecureRandom secureRandom) {
            Intrinsics.checkNotNullParameter((Object)secureRandom, (String)"secureRandom");
            byte[] key = new byte[32];
            secureRandom.nextBytes(key);
            return new MasterKey(key);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

