/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.models;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.models.MasterKey;
import org.signal.core.models.backup.MessageBackupKey;
import org.signal.libsignal.messagebackup.BackupKey;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/signal/core/models/AccountEntropyPool;", "", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "displayValue", "getDisplayValue", "deriveMasterKey", "Lorg/signal/core/models/MasterKey;", "deriveMessageBackupKey", "Lorg/signal/core/models/backup/MessageBackupKey;", "Companion", "models-jvm"})
public final class AccountEntropyPool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    private final String displayValue;
    @NotNull
    private static final Regex INVALID_CHARACTERS = new Regex("[^0-9a-zA-Z]");
    public static final int LENGTH = 64;

    public AccountEntropyPool(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.value = string;
        String string2 = value.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        this.displayValue = string2;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final String getDisplayValue() {
        return this.displayValue;
    }

    @NotNull
    public final MasterKey deriveMasterKey() {
        byte[] byArray = org.signal.libsignal.messagebackup.AccountEntropyPool.deriveSvrKey((String)this.value);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"deriveSvrKey(...)");
        return new MasterKey(byArray);
    }

    @NotNull
    public final MessageBackupKey deriveMessageBackupKey() {
        BackupKey libSignalBackupKey = org.signal.libsignal.messagebackup.AccountEntropyPool.deriveBackupKey((String)this.value);
        byte[] byArray = libSignalBackupKey.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"serialize(...)");
        return new MessageBackupKey(byArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/signal/core/models/AccountEntropyPool$Companion;", "", "<init>", "()V", "INVALID_CHARACTERS", "Lkotlin/text/Regex;", "LENGTH", "", "generate", "Lorg/signal/core/models/AccountEntropyPool;", "parseOrNull", "input", "", "isFullyValid", "", "removeIllegalCharacters", "models-jvm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AccountEntropyPool generate() {
            String string = org.signal.libsignal.messagebackup.AccountEntropyPool.generate();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generate(...)");
            return new AccountEntropyPool(string);
        }

        @Nullable
        public final AccountEntropyPool parseOrNull(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            String stripped = this.removeIllegalCharacters(input);
            if (stripped.length() != 64) {
                return null;
            }
            return new AccountEntropyPool(stripped);
        }

        public final boolean isFullyValid(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return org.signal.libsignal.messagebackup.AccountEntropyPool.isValid((String)input);
        }

        @NotNull
        public final String removeIllegalCharacters(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            CharSequence charSequence = input;
            Regex regex = INVALID_CHARACTERS;
            String string = "";
            return regex.replace(charSequence, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

