/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import okio.ByteString;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.util.DataURI;
import org.asamk.signal.manager.util.MimeUtils;
import org.signal.core.models.ServiceId;
import org.signal.libsignal.net.BadRequestError;
import org.signal.libsignal.net.RequestResult;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.fingerprint.Fingerprint;
import org.signal.libsignal.protocol.fingerprint.NumericFingerprintGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.NetworkResultUtil;
import org.whispersystems.signalservice.api.util.StreamDetails;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static Pair<StreamDetails, Optional<String>> createStreamDetailsFromDataURI(String dataURI) {
        DataURI uri = DataURI.of(dataURI);
        return new Pair<StreamDetails, Optional<String>>(new StreamDetails((InputStream)new ByteArrayInputStream(uri.data()), uri.mediaType(), (long)uri.data().length), Optional.ofNullable(uri.parameter().get("filename")));
    }

    public static StreamDetails createStreamDetailsFromFile(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        long size = file.length();
        String mime = MimeUtils.getFileMimeType(file).orElse("application/octet-stream");
        return new StreamDetails((InputStream)stream, mime, size);
    }

    public static Pair<StreamDetails, Optional<String>> createStreamDetails(String value) throws IOException {
        try {
            return Utils.createStreamDetailsFromDataURI(value);
        }
        catch (IllegalArgumentException e) {
            File f = new File(value);
            return new Pair<StreamDetails, Optional<String>>(Utils.createStreamDetailsFromFile(f), Optional.of(f.getName()));
        }
    }

    public static Fingerprint computeSafetyNumberForNumber(String ownNumber, IdentityKey ownIdentityKey, String theirNumber, IdentityKey theirIdentityKey) {
        boolean version = true;
        byte[] ownId = ownNumber.getBytes(StandardCharsets.UTF_8);
        byte[] theirId = theirNumber.getBytes(StandardCharsets.UTF_8);
        return Utils.getFingerprint(1, ownId, ownIdentityKey, theirId, theirIdentityKey);
    }

    public static Fingerprint computeSafetyNumberForUuid(ServiceId ownServiceId, IdentityKey ownIdentityKey, ServiceId theirServiceId, IdentityKey theirIdentityKey) {
        int version = 2;
        byte[] ownId = ownServiceId.toByteArray();
        byte[] theirId = theirServiceId.toByteArray();
        return Utils.getFingerprint(2, ownId, ownIdentityKey, theirId, theirIdentityKey);
    }

    private static Fingerprint getFingerprint(int version, byte[] ownId, IdentityKey ownIdentityKey, byte[] theirId, IdentityKey theirIdentityKey) {
        return new NumericFingerprintGenerator(5200).createFor(version, ownId, ownIdentityKey, theirId, theirIdentityKey);
    }

    public static Locale getDefaultLocale(Locale fallback) {
        Locale locale = Locale.getDefault();
        if (locale == null) {
            logger.debug("No default locale found, using fallback: {}", (Object)fallback);
            return fallback;
        }
        String localeString = locale.getLanguage() + "-" + locale.getCountry();
        try {
            Locale.LanguageRange.parse(localeString);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Invalid locale '{}', using fallback: {}", (Object)locale, (Object)fallback);
            return fallback;
        }
        logger.trace("Using default locale: {} ({})", (Object)locale, (Object)localeString);
        return locale;
    }

    public static <L, R, T> Stream<T> zip(Stream<L> leftStream, Stream<R> rightStream, final BiFunction<L, R, T> combiner) {
        final Spliterator lefts = leftStream.spliterator();
        final Spliterator rights = rightStream.spliterator();
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.min(lefts.estimateSize(), rights.estimateSize()), lefts.characteristics() & rights.characteristics()){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                return lefts.tryAdvance(left -> rights.tryAdvance(right -> action.accept((Object)combiner.apply(left, right))));
            }
        }, leftStream.isParallel() || rightStream.isParallel());
    }

    public static <OK, NK, V> Map<NK, V> mapKeys(Map<OK, V> map, Function<OK, NK> keyMapper) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> keyMapper.apply(e.getKey()), Map.Entry::getValue));
    }

    public static Map<String, String> getQueryMap(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String[] paramParts = param.split("=", 2);
            String name = URLDecoder.decode(paramParts[0], StandardCharsets.UTF_8);
            String value = paramParts.length == 1 ? null : URLDecoder.decode(paramParts[1], StandardCharsets.UTF_8);
            map.put(name, value);
        }
        return map;
    }

    public static <T> T handleResponseException(NetworkResult<T> response) throws IOException {
        return (T)NetworkResultUtil.toBasicLegacy(response);
    }

    public static <T, E extends BadRequestError> T handleResponseException(RequestResult<T, E> result) throws IOException {
        if (result instanceof RequestResult.Success) {
            RequestResult.Success success = (RequestResult.Success)result;
            return (T)success.getResult();
        }
        if (result instanceof RequestResult.ApplicationError) {
            Throwable cause;
            RequestResult.ApplicationError e = (RequestResult.ApplicationError)result;
            Throwable throwable = cause = e.getCause();
            Objects.requireNonNull(throwable);
            Throwable throwable2 = throwable;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IOException.class, RuntimeException.class}, (Object)throwable2, n)) {
                case 0: {
                    IOException io = (IOException)throwable2;
                    throw io;
                }
                case 1: {
                    RuntimeException rt = (RuntimeException)throwable2;
                    throw rt;
                }
            }
            throw new RuntimeException(cause);
        }
        if (result instanceof RequestResult.RetryableNetworkError) {
            RequestResult.RetryableNetworkError e = (RequestResult.RetryableNetworkError)result;
            throw e.getNetworkError();
        }
        if (result instanceof RequestResult.NonSuccess) {
            throw new AssertionError();
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(result));
    }

    public static ByteString firstNonEmpty(ByteString ... strings) {
        for (ByteString s : strings) {
            if (s.size() <= 0) continue;
            return s;
        }
        return ByteString.EMPTY;
    }

    @SafeVarargs
    public static <T> List<T> firstNonEmpty(List<T> ... values) {
        for (List<T> s : values) {
            if (s.isEmpty()) continue;
            return s;
        }
        return List.of();
    }

    public static String firstNonEmpty(String ... strings) {
        for (String s : strings) {
            if (s.isEmpty()) continue;
            return s;
        }
        return "";
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... values) {
        for (T v : values) {
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public static String nullIfEmpty(String string) {
        return string == null || string.isEmpty() ? null : string;
    }

    public static Proxy getHttpsProxy() {
        URI uri;
        try {
            uri = new URI("https://example");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        List<Proxy> proxies = ProxySelector.getDefault().select(uri);
        if (proxies.isEmpty()) {
            return Proxy.NO_PROXY;
        }
        return proxies.getFirst();
    }
}

