/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import org.signal.core.models.ServiceId;
import org.signal.core.util.UuidUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.messages.SignalServiceEnvelope;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.internal.push.Envelope;

public class MessageCacheUtils {
    private static final Logger logger = LoggerFactory.getLogger(MessageCacheUtils.class);
    static final int CURRENT_VERSION = 9;

    public static SignalServiceEnvelope loadEnvelope(File file) throws IOException {
        try (FileInputStream f = new FileInputStream(file);){
            int legacyMessageLen;
            DataInputStream in = new DataInputStream(f);
            int version = in.readInt();
            logger.trace("Reading cached envelope file with version {} (current: {})", (Object)version, (Object)9);
            if (version > 9) {
                logger.warn("Unsupported envelope version {} (current: {})", (Object)version, (Object)9);
                SignalServiceEnvelope signalServiceEnvelope = null;
                return signalServiceEnvelope;
            }
            if (version >= 9) {
                long serverReceivedTimestamp = in.readLong();
                Envelope envelope = (Envelope)Envelope.ADAPTER.decode(in.readAllBytes());
                SignalServiceEnvelope signalServiceEnvelope = new SignalServiceEnvelope(envelope, serverReceivedTimestamp);
                return signalServiceEnvelope;
            }
            int type = in.readInt();
            String source = in.readUTF();
            ServiceId sourceServiceId = null;
            if (version >= 3) {
                sourceServiceId = ServiceId.parseOrNull((String)in.readUTF());
            }
            int sourceDevice = in.readInt();
            if (version == 1) {
                in.readUTF();
            }
            String destinationUuid = null;
            if (version >= 5) {
                destinationUuid = in.readUTF();
            }
            long timestamp = in.readLong();
            byte[] content = null;
            int contentLen = in.readInt();
            if (contentLen > 0) {
                content = new byte[contentLen];
                in.readFully(content);
            }
            if ((legacyMessageLen = in.readInt()) > 0) {
                byte[] legacyMessage = new byte[legacyMessageLen];
                in.readFully(legacyMessage);
            }
            long serverReceivedTimestamp = 0L;
            String uuid = null;
            if (version >= 2) {
                serverReceivedTimestamp = in.readLong();
                uuid = in.readUTF();
                if (uuid.isEmpty()) {
                    uuid = null;
                }
            }
            long serverDeliveredTimestamp = 0L;
            if (version >= 4) {
                serverDeliveredTimestamp = in.readLong();
            }
            boolean isUrgent = true;
            if (version >= 6) {
                isUrgent = in.readBoolean();
            }
            boolean isStory = true;
            if (version >= 7) {
                isStory = in.readBoolean();
            }
            String updatedPni = null;
            if (version >= 8) {
                updatedPni = in.readUTF();
            }
            Optional addressOptional = sourceServiceId == null ? Optional.empty() : Optional.of(new SignalServiceAddress(sourceServiceId, source));
            SignalServiceEnvelope signalServiceEnvelope = new SignalServiceEnvelope(Integer.valueOf(type), addressOptional, Integer.valueOf(sourceDevice), Long.valueOf(timestamp), content, Long.valueOf(serverReceivedTimestamp), Long.valueOf(serverDeliveredTimestamp), uuid, destinationUuid == null ? UuidUtil.UNKNOWN_UUID.toString() : destinationUuid, isUrgent, isStory, null, updatedPni == null ? "" : updatedPni);
            return signalServiceEnvelope;
        }
    }

    public static void storeEnvelope(SignalServiceEnvelope envelope, File file) throws IOException {
        try (FileOutputStream f = new FileOutputStream(file);
             DataOutputStream out = new DataOutputStream(f);){
            out.writeInt(9);
            out.writeLong(envelope.getServerDeliveredTimestamp());
            envelope.getProto().encode((OutputStream)out);
        }
    }
}

