/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.syncStorage;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import okio.ByteString;
import org.asamk.signal.manager.api.Contact;
import org.asamk.signal.manager.api.Profile;
import org.asamk.signal.manager.api.TrustLevel;
import org.asamk.signal.manager.internal.JobExecutor;
import org.asamk.signal.manager.jobs.DownloadProfileJob;
import org.asamk.signal.manager.jobs.RefreshRecipientsJob;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.identities.IdentityInfo;
import org.asamk.signal.manager.storage.recipients.Recipient;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.syncStorage.DefaultStorageRecordProcessor;
import org.asamk.signal.manager.syncStorage.StorageRecordUpdate;
import org.asamk.signal.manager.syncStorage.StorageSyncModels;
import org.asamk.signal.manager.util.KeyUtils;
import org.asamk.signal.manager.util.Utils;
import org.signal.core.models.ServiceId;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.storage.SignalContactRecord;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.internal.storage.protos.ContactRecord;

public class ContactRecordProcessor
extends DefaultStorageRecordProcessor<SignalContactRecord> {
    private static final Logger logger = LoggerFactory.getLogger(ContactRecordProcessor.class);
    private static final Pattern E164_PATTERN = Pattern.compile("^\\+[1-9]\\d{6,18}$");
    private final ServiceId.ACI selfAci;
    private final ServiceId.PNI selfPni;
    private final String selfNumber;
    private final SignalAccount account;
    private final Connection connection;
    private final JobExecutor jobExecutor;

    public ContactRecordProcessor(SignalAccount account, Connection connection, JobExecutor jobExecutor) {
        this.account = account;
        this.connection = connection;
        this.jobExecutor = jobExecutor;
        this.selfAci = account.getAci();
        this.selfPni = account.getPni();
        this.selfNumber = account.getNumber();
    }

    @Override
    protected boolean isInvalid(SignalContactRecord remoteRecord) {
        boolean hasPni;
        ContactRecord remote = remoteRecord.getProto();
        ServiceId.ACI aci = ServiceId.ACI.parseOrNull((String)remote.aci, (ByteString)remote.aciBinary);
        ServiceId.PNI pni = ServiceId.PNI.parseOrNull((String)remote.pni, (ByteString)remote.pniBinary);
        String e164 = Utils.nullIfEmpty(remote.e164);
        boolean hasAci = aci != null && aci.isValid();
        boolean bl = hasPni = pni != null && pni.isValid();
        if (!hasAci && !hasPni) {
            logger.debug("Found a ContactRecord with neither an ACI nor a PNI -- marking as invalid.");
            return true;
        }
        if (this.selfAci != null && this.selfAci.equals((Object)aci) || this.selfPni != null && this.selfPni.equals((Object)pni) || this.selfNumber != null && this.selfNumber.equals(e164)) {
            logger.debug("Found a ContactRecord for ourselves -- marking as invalid.");
            return true;
        }
        if (e164 != null && !ContactRecordProcessor.isValidE164(e164)) {
            logger.debug("Found a record with an invalid E164 ({}). Marking as invalid.", (Object)e164);
            return true;
        }
        return false;
    }

    @Override
    protected Optional<SignalContactRecord> getMatching(SignalContactRecord remote) throws SQLException {
        RecipientAddress address = ContactRecordProcessor.getRecipientAddress(remote.getProto());
        RecipientId recipientId = this.account.getRecipientStore().resolveRecipient(this.connection, address);
        Recipient recipient = this.account.getRecipientStore().getRecipient(this.connection, recipientId);
        String identifier = recipient.getAddress().getIdentifier();
        IdentityInfo identity = this.account.getIdentityKeyStore().getIdentityInfo(this.connection, identifier);
        StorageId storageId = this.account.getRecipientStore().getStorageId(this.connection, recipientId);
        return Optional.of(new SignalContactRecord(storageId, StorageSyncModels.localToRemoteRecord(recipient, identity)));
    }

    @Override
    protected SignalContactRecord merge(SignalContactRecord remoteRecord, SignalContactRecord localRecord) {
        String e164;
        String pni;
        ByteString identityKey;
        ContactRecord.IdentityState identityState;
        String profileFamilyName;
        String profileGivenName;
        ContactRecord remote = remoteRecord.getProto();
        ContactRecord local = localRecord.getProto();
        if (!remote.givenName.isEmpty() || !remote.familyName.isEmpty()) {
            profileGivenName = remote.givenName;
            profileFamilyName = remote.familyName;
        } else {
            profileGivenName = local.givenName;
            profileFamilyName = local.familyName;
        }
        if (!(remote.identityKey.size() <= 0 || this.account.isPrimaryDevice() && remote.identityState == local.identityState && local.identityKey.size() != 0)) {
            identityState = remote.identityState;
            identityKey = remote.identityKey;
        } else {
            identityState = local.identityState;
            ByteString byteString = identityKey = local.identityKey.size() > 0 ? local.identityKey : ByteString.EMPTY;
        }
        if (!(local.aci.isEmpty() && local.aciBinary.size() <= 0 || local.identityKey.size() <= 0 || remote.identityKey.size() <= 0 || local.identityKey.equals((Object)remote.identityKey))) {
            logger.debug("The local and remote identity keys do not match for {}. Enqueueing a profile fetch.", (Object)local.aci);
            RecipientAddress address = ContactRecordProcessor.getRecipientAddress(local);
            this.jobExecutor.enqueueJob(new DownloadProfileJob(address));
        }
        if (this.account.isPrimaryDevice()) {
            boolean pnisMatchButE164sDont;
            boolean e164sMatchButPnisDont = !local.e164.isEmpty() && local.e164.equals(remote.e164) && !local.pni.isEmpty() && !remote.pni.isEmpty() && !local.pni.equals(remote.pni);
            boolean bl = pnisMatchButE164sDont = !local.pni.isEmpty() && local.pni.equals(remote.pni) && !local.e164.isEmpty() && !remote.e164.isEmpty() && !local.e164.equals(remote.e164);
            if (e164sMatchButPnisDont || pnisMatchButE164sDont) {
                if (e164sMatchButPnisDont) {
                    logger.debug("Matching E164s, but the PNIs differ! Trusting our local pair.");
                } else if (pnisMatchButE164sDont) {
                    logger.debug("Matching PNIs, but the E164s differ! Trusting our local pair.");
                }
                this.jobExecutor.enqueueJob(new RefreshRecipientsJob());
                pni = local.pni;
                e164 = local.e164;
            } else {
                pni = Utils.firstNonEmpty(remote.pni, local.pni);
                e164 = Utils.firstNonEmpty(remote.e164, local.e164);
            }
        } else {
            pni = Utils.firstNonEmpty(remote.pni, local.pni);
            e164 = Utils.firstNonEmpty(remote.e164, local.e164);
        }
        ByteString remoteProfileKey = remote.profileKey.size() == 0 || KeyUtils.profileKeyOrNull(remote.profileKey.toByteArray()) == null ? ByteString.EMPTY : remote.profileKey;
        ContactRecord.Builder mergedBuilder = remote.newBuilder().aci(local.aci.isEmpty() ? remote.aci : local.aci).aciBinary(Utils.firstNonEmpty(local.aciBinary, remote.aciBinary)).e164(e164).pni(pni).pniBinary(pni.isEmpty() ? ByteString.EMPTY : ServiceId.PNI.parseOrThrow((String)pni).toByteStringWithoutPrefix()).givenName(profileGivenName).familyName(profileFamilyName).systemGivenName(this.account.isPrimaryDevice() ? local.systemGivenName : remote.systemGivenName).systemFamilyName(this.account.isPrimaryDevice() ? local.systemFamilyName : remote.systemFamilyName).systemNickname(remote.systemNickname).profileKey(Utils.firstNonEmpty(remoteProfileKey, local.profileKey)).username(Utils.firstNonEmpty(remote.username, local.username)).identityState(identityState).identityKey(identityKey).blocked(remote.blocked).whitelisted(remote.whitelisted).archived(remote.archived).markedUnread(remote.markedUnread).mutedUntilTimestamp(remote.mutedUntilTimestamp).hideStory(remote.hideStory).unregisteredAtTimestamp(remote.unregisteredAtTimestamp).hidden(remote.hidden).pniSignatureVerified(remote.pniSignatureVerified || local.pniSignatureVerified).nickname(remote.nickname).note(remote.note).avatarColor(remote.avatarColor);
        ContactRecord merged = mergedBuilder.build();
        boolean matchesRemote = ContactRecordProcessor.doProtosMatch(merged, remote);
        if (matchesRemote) {
            return remoteRecord;
        }
        boolean matchesLocal = ContactRecordProcessor.doProtosMatch(merged, local);
        if (matchesLocal) {
            return localRecord;
        }
        return new SignalContactRecord(StorageId.forContact((byte[])KeyUtils.createRawStorageId()), mergedBuilder.build());
    }

    @Override
    protected void insertLocal(SignalContactRecord record) throws SQLException {
        StorageRecordUpdate<SignalContactRecord> update = new StorageRecordUpdate<SignalContactRecord>(null, record);
        this.updateLocal(update);
    }

    @Override
    protected void updateLocal(StorageRecordUpdate<SignalContactRecord> update) throws SQLException {
        String profileFamilyName;
        Profile profile;
        String contactNote;
        SignalContactRecord contactRecord = update.newRecord();
        ContactRecord contactProto = contactRecord.getProto();
        RecipientAddress address = ContactRecordProcessor.getRecipientAddress(contactProto);
        RecipientId recipientId = this.account.getRecipientStore().resolveRecipientTrusted(this.connection, address);
        Recipient recipient = this.account.getRecipientStore().getRecipient(this.connection, recipientId);
        Contact contact = recipient.getContact();
        boolean blocked = contact != null && contact.isBlocked();
        boolean profileShared = contact != null && contact.isProfileSharingEnabled();
        boolean archived = contact != null && contact.isArchived();
        boolean hidden = contact != null && contact.isHidden();
        boolean hideStory = contact != null && contact.hideStory();
        long muteUntil = contact == null ? 0L : contact.muteUntil();
        long unregisteredTimestamp = contact == null || contact.unregisteredTimestamp() == null ? 0L : contact.unregisteredTimestamp();
        String contactGivenName = contact == null ? null : contact.givenName();
        String contactFamilyName = contact == null ? null : contact.familyName();
        String contactNickName = contact == null ? null : contact.nickName();
        String contactNickGivenName = contact == null ? null : contact.nickNameGivenName();
        String contactNickFamilyName = contact == null ? null : contact.nickNameFamilyName();
        String string = contactNote = contact == null ? null : contact.note();
        if (!(blocked == contactProto.blocked && profileShared == contactProto.whitelisted && archived == contactProto.archived && hidden == contactProto.hidden && hideStory == contactProto.hideStory && muteUntil == contactProto.mutedUntilTimestamp && unregisteredTimestamp == contactProto.unregisteredAtTimestamp && Objects.equals(Utils.nullIfEmpty(contactProto.systemGivenName), contactGivenName) && Objects.equals(Utils.nullIfEmpty(contactProto.systemFamilyName), contactFamilyName) && Objects.equals(Utils.nullIfEmpty(contactProto.systemNickname), contactNickName) && Objects.equals(Utils.nullIfEmpty(contactProto.nickname == null ? "" : contactProto.nickname.given), contactNickGivenName) && Objects.equals(Utils.nullIfEmpty(contactProto.nickname == null ? "" : contactProto.nickname.family), contactNickFamilyName) && Objects.equals(Utils.nullIfEmpty(contactProto.note), contactNote))) {
            logger.debug("Storing new or updated contact {}", (Object)recipientId);
            Contact.Builder contactBuilder = contact == null ? Contact.newBuilder() : Contact.newBuilder(contact);
            Contact.Builder newContact = contactBuilder.withIsBlocked(contactProto.blocked).withIsProfileSharingEnabled(contactProto.whitelisted).withIsArchived(contactProto.archived).withIsHidden(contactProto.hidden).withMuteUntil(contactProto.mutedUntilTimestamp).withHideStory(contactProto.hideStory).withGivenName(Utils.nullIfEmpty(contactProto.systemGivenName)).withFamilyName(Utils.nullIfEmpty(contactProto.systemFamilyName)).withNickName(Utils.nullIfEmpty(contactProto.systemNickname)).withNickNameGivenName(Utils.nullIfEmpty(contactProto.nickname == null ? null : contactProto.nickname.given)).withNickNameFamilyName(Utils.nullIfEmpty(contactProto.nickname == null ? null : contactProto.nickname.family)).withNote(Utils.nullIfEmpty(contactProto.note)).withUnregisteredTimestamp(contactProto.unregisteredAtTimestamp == 0L ? null : Long.valueOf(contactProto.unregisteredAtTimestamp));
            this.account.getRecipientStore().storeContact(this.connection, recipientId, newContact.build());
        }
        String profileGivenName = (profile = recipient.getProfile()) == null ? null : profile.getGivenName();
        String string2 = profileFamilyName = profile == null ? null : profile.getFamilyName();
        if (!Objects.equals(Utils.nullIfEmpty(contactProto.givenName), profileGivenName) || !Objects.equals(Utils.nullIfEmpty(contactProto.familyName), profileFamilyName)) {
            Profile.Builder profileBuilder = profile == null ? Profile.newBuilder() : Profile.newBuilder(profile);
            Profile newProfile = profileBuilder.withGivenName(Utils.nullIfEmpty(contactProto.givenName)).withFamilyName(Utils.nullIfEmpty(contactProto.familyName)).build();
            this.account.getRecipientStore().storeProfile(this.connection, recipientId, newProfile);
        }
        if (contactProto.profileKey.size() > 0) {
            try {
                logger.trace("Storing profile key {}", (Object)recipientId);
                ProfileKey profileKey = new ProfileKey(contactProto.profileKey.toByteArray());
                this.account.getRecipientStore().storeProfileKey(this.connection, recipientId, profileKey);
            }
            catch (InvalidInputException e) {
                logger.warn("Received invalid contact profile key from storage");
            }
        }
        if (contactProto.identityKey.size() > 0 && address.aci().isPresent()) {
            try {
                logger.trace("Storing identity key {}", (Object)recipientId);
                IdentityKey identityKey = new IdentityKey(contactProto.identityKey.toByteArray());
                this.account.getIdentityKeyStore().saveIdentity(this.connection, (ServiceId)address.aci().get(), identityKey);
                TrustLevel trustLevel = StorageSyncModels.remoteToLocal(contactProto.identityState);
                if (trustLevel != null) {
                    this.account.getIdentityKeyStore().setIdentityTrustLevel(this.connection, (ServiceId)address.aci().get(), identityKey, trustLevel);
                }
            }
            catch (InvalidKeyException e) {
                logger.warn("Received invalid contact identity key from storage");
            }
        }
        this.account.getRecipientStore().storeStorageRecord(this.connection, recipientId, contactRecord.getId(), contactProto.encode());
    }

    private static RecipientAddress getRecipientAddress(ContactRecord contactRecord) {
        return new RecipientAddress(ServiceId.ACI.parseOrNull((String)contactRecord.aci, (ByteString)contactRecord.aciBinary), ServiceId.PNI.parseOrNull((String)contactRecord.pni, (ByteString)contactRecord.pniBinary), Utils.nullIfEmpty(contactRecord.e164), Utils.nullIfEmpty(contactRecord.username));
    }

    @Override
    public int compare(SignalContactRecord lhsRecord, SignalContactRecord rhsRecord) {
        ContactRecord lhs = lhsRecord.getProto();
        ContactRecord rhs = rhsRecord.getProto();
        if (!lhs.aci.isEmpty() && Objects.equals(lhs.aci, rhs.aci) || lhs.aciBinary.size() != 0 && Objects.equals(lhs.aciBinary, rhs.aciBinary) || !lhs.e164.isEmpty() && Objects.equals(lhs.e164, rhs.e164) || !lhs.pni.isEmpty() && Objects.equals(lhs.pni, rhs.pni) && lhs.pniBinary == rhs.pniBinary || lhs.pniBinary.size() != 0 && Objects.equals(lhs.pniBinary, rhs.pniBinary)) {
            return 0;
        }
        return 1;
    }

    private static boolean isValidE164(String value) {
        return E164_PATTERN.matcher(value).matches();
    }

    private static boolean doProtosMatch(ContactRecord merged, ContactRecord other) {
        return Arrays.equals(merged.encode(), other.encode());
    }
}

