/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.senderKeys;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.storage.Database;
import org.asamk.signal.manager.storage.senderKeys.SenderKeyRecordStore;
import org.asamk.signal.manager.storage.senderKeys.SenderKeySharedStore;
import org.signal.core.models.ServiceId;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.groups.state.SenderKeyRecord;
import org.whispersystems.signalservice.api.SignalServiceSenderKeyStore;
import org.whispersystems.signalservice.api.push.DistributionId;

public class SenderKeyStore
implements SignalServiceSenderKeyStore {
    private final SenderKeyRecordStore senderKeyRecordStore;
    private final SenderKeySharedStore senderKeySharedStore;

    public SenderKeyStore(Database database) {
        this.senderKeyRecordStore = new SenderKeyRecordStore(database);
        this.senderKeySharedStore = new SenderKeySharedStore(database);
    }

    public void storeSenderKey(SignalProtocolAddress sender, UUID distributionId, SenderKeyRecord record) {
        this.senderKeyRecordStore.storeSenderKey(sender, distributionId, record);
    }

    public SenderKeyRecord loadSenderKey(SignalProtocolAddress sender, UUID distributionId) {
        return this.senderKeyRecordStore.loadSenderKey(sender, distributionId);
    }

    public Set<SignalProtocolAddress> getSenderKeySharedWith(DistributionId distributionId) {
        return this.senderKeySharedStore.getSenderKeySharedWith(distributionId);
    }

    public void markSenderKeySharedWith(DistributionId distributionId, Collection<SignalProtocolAddress> addresses) {
        this.senderKeySharedStore.markSenderKeySharedWith(distributionId, addresses);
    }

    public void clearSenderKeySharedWith(Collection<SignalProtocolAddress> addresses) {
        this.senderKeySharedStore.clearSenderKeySharedWith(addresses);
    }

    public void deleteAll() {
        this.senderKeySharedStore.deleteAll();
        this.senderKeyRecordStore.deleteAll();
    }

    public void deleteAll(ServiceId serviceId) {
        this.senderKeySharedStore.deleteAllFor(serviceId);
        this.senderKeyRecordStore.deleteAllFor(serviceId);
    }

    public void deleteSharedWith(ServiceId serviceId) {
        this.senderKeySharedStore.deleteAllFor(serviceId);
    }

    public void deleteSharedWith(ServiceId serviceId, int deviceId, DistributionId distributionId) {
        this.senderKeySharedStore.deleteSharedWith(serviceId, deviceId, distributionId);
    }

    public void deleteOurKey(ServiceId selfServiceId, DistributionId distributionId) {
        this.senderKeySharedStore.deleteAllFor(distributionId);
        this.senderKeyRecordStore.deleteSenderKey(selfServiceId, distributionId.asUuid());
    }

    public long getCreateTimeForOurKey(ServiceId selfServiceId, int deviceId, DistributionId distributionId) {
        return this.senderKeyRecordStore.getCreateTimeForKey(selfServiceId, deviceId, distributionId.asUuid());
    }

    void addLegacySenderKeys(Collection<Pair<SenderKeyRecordStore.Key, SenderKeyRecord>> senderKeys) {
        this.senderKeyRecordStore.addLegacySenderKeys(senderKeys);
    }

    void addLegacySenderKeysShared(Map<DistributionId, Set<SenderKeySharedStore.SenderKeySharedEntry>> sharedSenderKeys) {
        this.senderKeySharedStore.addLegacySenderKeysShared(sharedSenderKeys);
    }
}

