/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.sendLog;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.groups.GroupUtils;
import org.asamk.signal.manager.storage.Database;
import org.asamk.signal.manager.storage.Utils;
import org.asamk.signal.manager.storage.sendLog.MessageSendLogEntry;
import org.signal.core.models.ServiceId;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.crypto.ContentHint;
import org.whispersystems.signalservice.api.messages.SendMessageResult;
import org.whispersystems.signalservice.internal.push.Content;

public class MessageSendLogStore
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MessageSendLogStore.class);
    private static final String TABLE_MESSAGE_SEND_LOG = "message_send_log";
    private static final String TABLE_MESSAGE_SEND_LOG_CONTENT = "message_send_log_content";
    private static final Duration LOG_DURATION = Duration.ofDays(1L);
    private final Database database;
    private final Thread cleanupThread;
    private final boolean sendLogDisabled;

    public MessageSendLogStore(Database database, boolean disableMessageSendLog) {
        this.database = database;
        this.sendLogDisabled = disableMessageSendLog;
        this.cleanupThread = Thread.ofPlatform().name("msl-cleanup").daemon().start(() -> {
            try {
                long interval = Duration.ofHours(1L).toMillis();
                while (!Thread.interrupted()) {
                    try (Connection connection = database.getConnection();){
                        this.deleteOutdatedEntries(connection);
                    }
                    catch (SQLException e) {
                        logger.debug("MSL", (Throwable)e);
                        logger.warn("Deleting outdated entries failed");
                        break;
                    }
                    Thread.sleep(interval);
                }
            }
            catch (InterruptedException e) {
                logger.debug("Stopping msl cleanup thread");
            }
        });
    }

    public static void createSql(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE message_send_log (\n  _id INTEGER PRIMARY KEY,\n  content_id INTEGER NOT NULL REFERENCES message_send_log_content (_id) ON DELETE CASCADE,\n  address TEXT NOT NULL,\n  device_id INTEGER NOT NULL\n) STRICT;\nCREATE TABLE message_send_log_content (\n  _id INTEGER PRIMARY KEY,\n  group_id BLOB,\n  timestamp INTEGER NOT NULL,\n  content BLOB NOT NULL,\n  content_hint INTEGER NOT NULL,\n  urgent INTEGER NOT NULL\n) STRICT;\nCREATE INDEX mslc_timestamp_index ON message_send_log_content (timestamp);\nCREATE INDEX msl_recipient_index ON message_send_log (address, device_id, content_id);\nCREATE INDEX msl_content_index ON message_send_log (content_id);\n");
        }
    }

    /*
     * Exception decompiling
     */
    public List<MessageSendLogEntry> findMessages(ServiceId serviceId, int deviceId, long timestamp, boolean isSenderKey) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long insertIfPossible(long sentTimestamp, SendMessageResult sendMessageResult, ContentHint contentHint, boolean urgent) {
        if (this.sendLogDisabled) {
            return -1L;
        }
        RecipientDevices recipientDevice = this.getRecipientDevices(sendMessageResult);
        if (recipientDevice == null) {
            return -1L;
        }
        return this.insert(List.of(recipientDevice), sentTimestamp, (Content)sendMessageResult.getSuccess().getContent().get(), contentHint, urgent);
    }

    public long insertIfPossible(long sentTimestamp, List<SendMessageResult> sendMessageResults, ContentHint contentHint, boolean urgent) {
        if (this.sendLogDisabled) {
            return -1L;
        }
        List<RecipientDevices> recipientDevices = sendMessageResults.stream().map(this::getRecipientDevices).filter(Objects::nonNull).toList();
        if (recipientDevices.isEmpty()) {
            return -1L;
        }
        Content content = sendMessageResults.stream().filter(r -> r.isSuccess() && r.getSuccess().getContent().isPresent()).map(r -> (Content)r.getSuccess().getContent().get()).findFirst().get();
        return this.insert(recipientDevices, sentTimestamp, content, contentHint, urgent);
    }

    public void addRecipientToExistingEntryIfPossible(long contentId, SendMessageResult sendMessageResult) {
        if (this.sendLogDisabled) {
            return;
        }
        RecipientDevices recipientDevice = this.getRecipientDevices(sendMessageResult);
        if (recipientDevice == null) {
            return;
        }
        this.insertRecipientsForExistingContent(contentId, List.of(recipientDevice));
    }

    public void addRecipientToExistingEntryIfPossible(long contentId, List<SendMessageResult> sendMessageResults) {
        if (this.sendLogDisabled) {
            return;
        }
        List<RecipientDevices> recipientDevices = sendMessageResults.stream().map(this::getRecipientDevices).filter(Objects::nonNull).toList();
        if (recipientDevices.isEmpty()) {
            return;
        }
        this.insertRecipientsForExistingContent(contentId, recipientDevices);
    }

    public void deleteEntryForGroup(long sentTimestamp, GroupId groupId) {
        String sql = "DELETE FROM %s AS lc\nWHERE lc.timestamp = ? AND lc.group_id = ?\n".formatted(TABLE_MESSAGE_SEND_LOG_CONTENT);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, sentTimestamp);
            statement.setBytes(2, groupId.serialize());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            logger.warn("Failed delete from message send log", (Throwable)e);
        }
    }

    public void deleteEntryForRecipientNonGroup(long sentTimestamp, ServiceId serviceId) {
        String sql = "DELETE FROM %s AS lc\nWHERE lc.timestamp = ? AND lc.group_id IS NULL AND lc._id IN (SELECT content_id FROM %s l WHERE l.address = ?)\n".formatted(TABLE_MESSAGE_SEND_LOG_CONTENT, TABLE_MESSAGE_SEND_LOG);
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, sentTimestamp);
                statement.setString(2, serviceId.toString());
                statement.executeUpdate();
            }
            this.deleteOrphanedLogContents(connection);
            connection.commit();
        }
        catch (SQLException e) {
            logger.warn("Failed delete from message send log", (Throwable)e);
        }
    }

    public void deleteEntryForRecipient(long sentTimestamp, ServiceId serviceId, int deviceId) {
        this.deleteEntriesForRecipient(List.of(Long.valueOf(sentTimestamp)), serviceId, deviceId);
    }

    public void deleteEntriesForRecipient(List<Long> sentTimestamps, ServiceId serviceId, int deviceId) {
        String sql = "DELETE FROM %s AS l\nWHERE l.content_id IN (SELECT _id FROM %s lc WHERE lc.timestamp = ?) AND l.address = ? AND l.device_id = ?\n".formatted(TABLE_MESSAGE_SEND_LOG, TABLE_MESSAGE_SEND_LOG_CONTENT);
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                for (Long sentTimestamp : sentTimestamps) {
                    statement.setLong(1, sentTimestamp);
                    statement.setString(2, serviceId.toString());
                    statement.setInt(3, deviceId);
                    statement.executeUpdate();
                }
            }
            this.deleteOrphanedLogContents(connection);
            connection.commit();
        }
        catch (SQLException e) {
            logger.warn("Failed delete from message send log", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.cleanupThread.interrupt();
        try {
            this.cleanupThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private RecipientDevices getRecipientDevices(SendMessageResult sendMessageResult) {
        if (sendMessageResult.isSuccess() && sendMessageResult.getSuccess().getContent().isPresent()) {
            ServiceId serviceId = sendMessageResult.getAddress().getServiceId();
            return new RecipientDevices(serviceId, sendMessageResult.getSuccess().getDevices());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long insert(List<RecipientDevices> recipientDevices, long sentTimestamp, Content content, ContentHint contentHint, boolean urgent) {
        byte[] groupId = this.getGroupId(content);
        String sql = "INSERT INTO %s (timestamp, group_id, content, content_hint, urgent)\nVALUES (?,?,?,?,?)\nRETURNING _id\n".formatted(TABLE_MESSAGE_SEND_LOG_CONTENT);
        try (Connection connection = this.database.getConnection();){
            long contentId;
            connection.setAutoCommit(false);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setLong(1, sentTimestamp);
                statement.setBytes(2, groupId);
                statement.setBytes(3, content.encode());
                statement.setInt(4, contentHint.getType());
                statement.setBoolean(5, urgent);
                Optional<Long> generatedKey = Utils.executeQueryForOptional(statement, Utils::getIdMapper);
                contentId = generatedKey.isPresent() ? generatedKey.get() : -1L;
            }
            if (contentId == -1L) {
                logger.warn("Failed to insert message send log content");
                long l2 = -1L;
                return l2;
            }
            this.insertRecipientsForExistingContent(contentId, recipientDevices, connection);
            connection.commit();
            long l = contentId;
            return l;
        }
        catch (SQLException e) {
            logger.warn("Failed to insert into message send log", (Throwable)e);
            return -1L;
        }
    }

    private byte[] getGroupId(Content content) {
        try {
            return content.dataMessage == null ? null : (content.dataMessage.group != null && content.dataMessage.group.id != null ? content.dataMessage.group.id.toByteArray() : (content.dataMessage.groupV2 != null && content.dataMessage.groupV2.masterKey != null ? GroupUtils.getGroupIdV2(new GroupMasterKey(content.dataMessage.groupV2.masterKey.toByteArray())).serialize() : null));
        }
        catch (InvalidInputException e) {
            logger.warn("Failed to parse groupId id from content");
            return null;
        }
    }

    private void insertRecipientsForExistingContent(long contentId, List<RecipientDevices> recipientDevices) {
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            this.insertRecipientsForExistingContent(contentId, recipientDevices, connection);
            connection.commit();
        }
        catch (SQLException e) {
            logger.warn("Failed to append recipients to message send log", (Throwable)e);
        }
    }

    private void insertRecipientsForExistingContent(long contentId, List<RecipientDevices> recipientDevices, Connection connection) throws SQLException {
        String sql = "INSERT INTO %s (address, device_id, content_id)\nVALUES (?,?,?)\n".formatted(TABLE_MESSAGE_SEND_LOG);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            for (RecipientDevices recipientDevice : recipientDevices) {
                for (Integer deviceId : recipientDevice.deviceIds()) {
                    statement.setString(1, recipientDevice.serviceId().toString());
                    statement.setInt(2, deviceId);
                    statement.setLong(3, contentId);
                    statement.executeUpdate();
                }
            }
        }
    }

    private void deleteOutdatedEntries(Connection connection) throws SQLException {
        String sql = "DELETE FROM %s\nWHERE timestamp < ?\n".formatted(TABLE_MESSAGE_SEND_LOG_CONTENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, System.currentTimeMillis() - LOG_DURATION.toMillis());
            int rowCount = statement.executeUpdate();
            if (rowCount > 0) {
                logger.debug("Removed {} outdated entries from the message send log", (Object)rowCount);
            } else {
                logger.trace("No outdated entries to be removed from message send log.");
            }
        }
    }

    private void deleteOrphanedLogContents(Connection connection) throws SQLException {
        String sql = "DELETE FROM %s\nWHERE _id NOT IN (SELECT content_id FROM %s)\n".formatted(TABLE_MESSAGE_SEND_LOG_CONTENT, TABLE_MESSAGE_SEND_LOG);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.executeUpdate();
        }
    }

    private MessageSendLogEntry getMessageSendLogEntryFromResultSet(ResultSet resultSet) throws SQLException {
        Content content;
        Optional<GroupId> groupId = Optional.ofNullable(resultSet.getBytes("group_id")).map(GroupId::unknownVersion);
        try {
            content = (Content)Content.ADAPTER.decode(resultSet.getBinaryStream("content"));
        }
        catch (IOException e) {
            logger.warn("Failed to parse content from message send log", (Throwable)e);
            return null;
        }
        ContentHint contentHint = ContentHint.fromType((int)resultSet.getInt("content_hint"));
        boolean urgent = resultSet.getBoolean("urgent");
        return new MessageSendLogEntry(groupId, content, contentHint, urgent);
    }

    private static /* synthetic */ boolean lambda$findMessages$0(boolean isSenderKey, MessageSendLogEntry e) {
        return !isSenderKey || e.groupId().isPresent();
    }

    private record RecipientDevices(ServiceId serviceId, List<Integer> deviceIds) {
    }
}

