/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.recipients;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.asamk.signal.manager.api.Contact;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.PhoneNumberSharingMode;
import org.asamk.signal.manager.api.Profile;
import org.asamk.signal.manager.api.UnregisteredRecipientException;
import org.asamk.signal.manager.storage.Database;
import org.asamk.signal.manager.storage.Utils;
import org.asamk.signal.manager.storage.contacts.ContactsStore;
import org.asamk.signal.manager.storage.profiles.ProfileStore;
import org.asamk.signal.manager.storage.recipients.InvalidAddress;
import org.asamk.signal.manager.storage.recipients.MergeRecipientHelper;
import org.asamk.signal.manager.storage.recipients.Recipient;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.recipients.RecipientIdCreator;
import org.asamk.signal.manager.storage.recipients.RecipientResolver;
import org.asamk.signal.manager.storage.recipients.RecipientTrustedResolver;
import org.asamk.signal.manager.storage.recipients.RecipientWithAddress;
import org.asamk.signal.manager.storage.recipients.SelfAddressProvider;
import org.asamk.signal.manager.storage.recipients.SelfProfileKeyProvider;
import org.asamk.signal.manager.util.KeyUtils;
import org.signal.core.models.ServiceId;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ExpiringProfileKeyCredential;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.storage.StorageId;

public class RecipientStore
implements RecipientIdCreator,
RecipientResolver,
RecipientTrustedResolver,
ContactsStore,
ProfileStore {
    private static final Logger logger = LoggerFactory.getLogger(RecipientStore.class);
    private static final String TABLE_RECIPIENT = "recipient";
    private static final String SQL_IS_CONTACT = "r.given_name IS NOT NULL OR r.family_name IS NOT NULL OR r.nick_name IS NOT NULL OR r.nick_name_given_name IS NOT NULL OR r.nick_name_family_name IS NOT NULL OR r.note IS NOT NULL OR r.expiration_time > 0 OR r.profile_sharing = TRUE OR r.color IS NOT NULL OR r.blocked = TRUE OR r.archived = TRUE";
    private final RecipientMergeHandler recipientMergeHandler;
    private final SelfAddressProvider selfAddressProvider;
    private final SelfProfileKeyProvider selfProfileKeyProvider;
    private final Database database;
    private final Map<Long, Long> recipientsMerged = new HashMap<Long, Long>();
    private final Map<ServiceId, RecipientWithAddress> recipientAddressCache = new HashMap<ServiceId, RecipientWithAddress>();

    public static void createSql(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE recipient (\n  _id INTEGER PRIMARY KEY AUTOINCREMENT,\n  storage_id BLOB UNIQUE,\n  storage_record BLOB,\n  number TEXT UNIQUE,\n  username TEXT UNIQUE,\n  aci TEXT UNIQUE,\n  pni TEXT UNIQUE,\n  unregistered_timestamp INTEGER,\n  discoverable INTEGER,\n  profile_key BLOB,\n  profile_key_credential BLOB,\n  needs_pni_signature INTEGER NOT NULL DEFAULT FALSE,\n\n  given_name TEXT,\n  family_name TEXT,\n  nick_name TEXT,\n  nick_name_given_name TEXT,\n  nick_name_family_name TEXT,\n  note TEXT,\n  color TEXT,\n\n  expiration_time INTEGER NOT NULL DEFAULT 0,\n  expiration_time_version INTEGER DEFAULT 1 NOT NULL,\n  mute_until INTEGER NOT NULL DEFAULT 0,\n  blocked INTEGER NOT NULL DEFAULT FALSE,\n  archived INTEGER NOT NULL DEFAULT FALSE,\n  profile_sharing INTEGER NOT NULL DEFAULT FALSE,\n  hide_story INTEGER NOT NULL DEFAULT FALSE,\n  hidden INTEGER NOT NULL DEFAULT FALSE,\n\n  profile_last_update_timestamp INTEGER NOT NULL DEFAULT 0,\n  profile_given_name TEXT,\n  profile_family_name TEXT,\n  profile_about TEXT,\n  profile_about_emoji TEXT,\n  profile_avatar_url_path TEXT,\n  profile_mobile_coin_address BLOB,\n  profile_unidentified_access_mode TEXT,\n  profile_capabilities TEXT,\n  profile_phone_number_sharing TEXT\n) STRICT;\n");
        }
    }

    public RecipientStore(RecipientMergeHandler recipientMergeHandler, SelfAddressProvider selfAddressProvider, SelfProfileKeyProvider selfProfileKeyProvider, Database database) {
        this.recipientMergeHandler = recipientMergeHandler;
        this.selfAddressProvider = selfAddressProvider;
        this.selfProfileKeyProvider = selfProfileKeyProvider;
        this.database = database;
    }

    public RecipientAddress resolveRecipientAddress(RecipientId recipientId) {
        RecipientAddress recipientAddress;
        block8: {
            Connection connection = this.database.getConnection();
            try {
                recipientAddress = this.resolveRecipientAddress(connection, recipientId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed read from recipient store", e);
                }
            }
            connection.close();
        }
        return recipientAddress;
    }

    /*
     * Exception decompiling
     */
    public Collection<RecipientId> getRecipientIdsWithEnabledProfileSharing() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public RecipientId resolveRecipient(long rawRecipientId) {
        String sql = "SELECT r._id\nFROM %s r\nWHERE r._id = ?\n".formatted(TABLE_RECIPIENT);
        try (Connection connection = this.database.getConnection();){
            RecipientId recipientId;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setLong(1, rawRecipientId);
                    recipientId = Utils.executeQueryForOptional(statement, this::getRecipientIdFromResultSet).orElse(null);
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return recipientId;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from recipient store", e);
        }
    }

    @Override
    public RecipientId resolveRecipient(String identifier) {
        ServiceId serviceId = ServiceId.parseOrNull((String)identifier);
        if (serviceId != null) {
            return this.resolveRecipient(serviceId);
        }
        return this.resolveRecipientByNumber(identifier);
    }

    private RecipientId resolveRecipientByNumber(String number) {
        RecipientId recipientId;
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            recipientId = this.resolveRecipientLocked(connection, number);
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read recipient store", e);
        }
        return recipientId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RecipientId resolveRecipient(ServiceId serviceId) {
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            RecipientWithAddress recipientWithAddress = this.recipientAddressCache.get(serviceId);
            if (recipientWithAddress != null) {
                RecipientId recipientId2 = recipientWithAddress.id();
                return recipientId2;
            }
            RecipientId recipientId3 = this.resolveRecipientLocked(connection, serviceId);
            connection.commit();
            RecipientId recipientId = recipientId3;
            return recipientId;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read recipient store", e);
        }
    }

    @Override
    public RecipientId create(long recipientId) {
        return new RecipientId(recipientId, this);
    }

    public RecipientId resolveRecipientByNumber(String number, Supplier<ServiceId> serviceIdSupplier) throws UnregisteredRecipientException {
        Optional<RecipientWithAddress> byNumber;
        try (Connection connection = this.database.getConnection();){
            byNumber = this.findByNumber(connection, number);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from recipient store", e);
        }
        if (byNumber.isEmpty() || byNumber.get().address().serviceId().isEmpty()) {
            ServiceId serviceId = serviceIdSupplier.get();
            if (serviceId == null) {
                throw new UnregisteredRecipientException(new org.asamk.signal.manager.api.RecipientAddress(number));
            }
            return this.resolveRecipient(serviceId);
        }
        return byNumber.get().id();
    }

    public Optional<RecipientId> resolveRecipientByNumberOptional(String number) {
        Optional<RecipientWithAddress> byNumber;
        try (Connection connection = this.database.getConnection();){
            byNumber = this.findByNumber(connection, number);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from recipient store", e);
        }
        return byNumber.map(RecipientWithAddress::id);
    }

    public RecipientId resolveRecipientByUsername(String username, Supplier<ServiceId.ACI> aciSupplier) throws UnregisteredRecipientException {
        Optional<RecipientWithAddress> byUsername;
        try (Connection connection = this.database.getConnection();){
            byUsername = this.findByUsername(connection, username);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from recipient store", e);
        }
        if (byUsername.isEmpty() || byUsername.get().address().serviceId().isEmpty()) {
            ServiceId.ACI aci = aciSupplier.get();
            if (aci == null) {
                throw new UnregisteredRecipientException(new org.asamk.signal.manager.api.RecipientAddress(null, null, null, username));
            }
            return this.resolveRecipientTrusted(aci, username);
        }
        return byUsername.get().id();
    }

    @Override
    public RecipientId resolveRecipient(RecipientAddress address) {
        RecipientId recipientId;
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            recipientId = this.resolveRecipientLocked(connection, address);
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read recipient store", e);
        }
        return recipientId;
    }

    public RecipientId resolveRecipient(Connection connection, RecipientAddress address) throws SQLException {
        return this.resolveRecipientLocked(connection, address);
    }

    @Override
    public RecipientId resolveSelfRecipientTrusted(RecipientAddress address) {
        return this.resolveRecipientTrusted(address, true);
    }

    @Override
    public RecipientId resolveRecipientTrusted(RecipientAddress address) {
        return this.resolveRecipientTrusted(address, false);
    }

    public RecipientId resolveRecipientTrusted(Connection connection, RecipientAddress address) throws SQLException {
        Pair<RecipientId, List<RecipientId>> pair = this.resolveRecipientTrustedLocked(connection, address, false);
        if (!pair.second().isEmpty()) {
            this.mergeRecipients(connection, pair.first(), pair.second());
        }
        return pair.first();
    }

    @Override
    public RecipientId resolveRecipientTrusted(SignalServiceAddress address) {
        return this.resolveRecipientTrusted(new RecipientAddress(address));
    }

    @Override
    public RecipientId resolveRecipientTrusted(Optional<ServiceId.ACI> aci, Optional<ServiceId.PNI> pni, Optional<String> number) {
        return this.resolveRecipientTrusted(new RecipientAddress(aci, pni, number, Optional.empty()));
    }

    @Override
    public RecipientId resolveRecipientTrusted(ServiceId.ACI aci, String username) {
        return this.resolveRecipientTrusted(new RecipientAddress(aci, null, null, username));
    }

    @Override
    public void storeContact(RecipientId recipientId, Contact contact) {
        try (Connection connection = this.database.getConnection();){
            this.storeContact(connection, recipientId, contact);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update recipient store", e);
        }
    }

    @Override
    public Contact getContact(RecipientId recipientId) {
        Contact contact;
        block8: {
            Connection connection = this.database.getConnection();
            try {
                contact = this.getContact(connection, recipientId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed read from recipient store", e);
                }
            }
            connection.close();
        }
        return contact;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Pair<RecipientId, Contact>> getContacts() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Recipient getRecipient(Connection connection, RecipientId recipientId) throws SQLException {
        String sql = "SELECT r._id,\n       r.number, r.aci, r.pni, r.username,\n       r.profile_key, r.profile_key_credential,\n       r.given_name, r.family_name, r.nick_name, r.nick_name_given_name, r.nick_name_family_name, r.note, r.expiration_time, r.expiration_time_version, r.mute_until, r.hide_story, r.profile_sharing, r.color, r.blocked, r.archived, r.hidden, r.unregistered_timestamp,\n       r.profile_last_update_timestamp, r.profile_given_name, r.profile_family_name, r.profile_about, r.profile_about_emoji, r.profile_avatar_url_path, r.profile_mobile_coin_address, r.profile_unidentified_access_mode, r.profile_capabilities, r.profile_phone_number_sharing,\n       r.discoverable,\n       r.storage_record\nFROM %s r\nWHERE r._id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, recipientId.id());
            Recipient recipient = Utils.executeQuerySingleRow(statement, this::getRecipientFromResultSet);
            return recipient;
        }
    }

    public Recipient getRecipient(Connection connection, StorageId storageId) throws SQLException {
        Recipient recipient;
        block14: {
            String sql = "SELECT r._id,\n       r.number, r.aci, r.pni, r.username,\n       r.profile_key, r.profile_key_credential,\n       r.given_name, r.family_name, r.nick_name, r.nick_name_given_name, r.nick_name_family_name, r.note, r.expiration_time, r.expiration_time_version, r.mute_until, r.hide_story, r.profile_sharing, r.color, r.blocked, r.archived, r.hidden, r.unregistered_timestamp,\n       r.profile_last_update_timestamp, r.profile_given_name, r.profile_family_name, r.profile_about, r.profile_about_emoji, r.profile_avatar_url_path, r.profile_mobile_coin_address, r.profile_unidentified_access_mode, r.profile_capabilities, r.profile_phone_number_sharing,\n       r.discoverable,\n       r.storage_record\nFROM %s r\nWHERE r.storage_id = ?\n".formatted(TABLE_RECIPIENT);
            PreparedStatement statement = connection.prepareStatement(sql);
            try {
                statement.setBytes(1, storageId.getRaw());
                recipient = Utils.executeQuerySingleRow(statement, this::getRecipientFromResultSet);
                if (statement == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidAddress e) {
                    try (PreparedStatement statement2 = connection.prepareStatement("UPDATE %s SET aci=NULL, pni=NULL, username=NULL, number=NULL, storage_id=NULL WHERE storage_id = ?\n".formatted(TABLE_RECIPIENT));){
                        statement2.setBytes(1, storageId.getRaw());
                        statement2.executeUpdate();
                    }
                    connection.commit();
                    throw e;
                }
            }
            statement.close();
        }
        return recipient;
    }

    /*
     * Exception decompiling
     */
    public List<Recipient> getRecipients(boolean onlyContacts, Optional<Boolean> blocked, Set<RecipientId> recipientIds, Optional<String> name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Set<String> getAllNumbers() {
        String sql = "SELECT r.number\nFROM %s r\nWHERE r.number IS NOT NULL\n".formatted(TABLE_RECIPIENT);
        String selfNumber = this.selfAddressProvider.getSelfAddress().number().orElse(null);
        try (Connection connection = this.database.getConnection();){
            Set<String> set;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    set = Utils.executeQueryForStream(statement, resultSet -> resultSet.getString("number")).filter(Objects::nonNull).filter(n -> !n.equals(selfNumber)).filter(n -> {
                        try {
                            Long.parseLong(n);
                            return true;
                        }
                        catch (NumberFormatException e) {
                            return false;
                        }
                    }).collect(Collectors.toSet());
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return set;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from recipient store", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<ServiceId, ProfileKey> getServiceIdToProfileKeyMap() {
        String sql = "SELECT r.aci, r.profile_key\nFROM %s r\nWHERE r.aci IS NOT NULL AND r.profile_key IS NOT NULL\n".formatted(TABLE_RECIPIENT);
        ServiceId.ACI selfAci = this.selfAddressProvider.getSelfAddress().aci().orElse(null);
        try (Connection connection = this.database.getConnection();){
            Map<ServiceId, ProfileKey> map;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    map = Utils.executeQueryForStream(statement, resultSet -> {
                        ServiceId.ACI aci = ServiceId.ACI.parseOrThrow((String)resultSet.getString("aci"));
                        if (aci.equals((Object)selfAci)) {
                            return new Pair<ServiceId.ACI, ProfileKey>(aci, this.selfProfileKeyProvider.getSelfProfileKey());
                        }
                        ProfileKey profileKey = this.getProfileKeyFromResultSet(resultSet);
                        return new Pair<ServiceId.ACI, ProfileKey>(aci, profileKey);
                    }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::first, Pair::second));
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return map;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from recipient store", e);
        }
    }

    public List<RecipientId> getRecipientIds(Connection connection) throws SQLException {
        String sql = "SELECT r._id\nFROM %s r\nWHERE (r.aci IS NOT NULL OR r.pni IS NOT NULL)\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            List<RecipientId> list = Utils.executeQueryForStream(statement, this::getRecipientIdFromResultSet).toList();
            return list;
        }
    }

    public void setMissingStorageIds() {
        String selectSql = "SELECT r._id\nFROM %s r\nWHERE r.storage_id IS NULL AND r.unregistered_timestamp IS NULL AND (r.aci IS NOT NULL OR r.pni IS NOT NULL)\n".formatted(TABLE_RECIPIENT);
        String updateSql = "UPDATE %s\nSET storage_id = ?\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT);
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement selectStmt = connection.prepareStatement(selectSql);){
                List<RecipientId> recipientIds = Utils.executeQueryForStream(selectStmt, this::getRecipientIdFromResultSet).toList();
                try (PreparedStatement updateStmt = connection.prepareStatement(updateSql);){
                    for (RecipientId recipientId : recipientIds) {
                        updateStmt.setBytes(1, KeyUtils.createRawStorageId());
                        updateStmt.setLong(2, recipientId.id());
                        updateStmt.executeUpdate();
                    }
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update recipient store", e);
        }
    }

    @Override
    public void deleteContact(RecipientId recipientId) {
        this.storeContact(recipientId, null);
    }

    public void deleteRecipientData(RecipientId recipientId) {
        logger.debug("Deleting recipient data for {}", (Object)recipientId);
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            this.recipientAddressCache.entrySet().removeIf(e -> ((RecipientWithAddress)e.getValue()).id().equals(recipientId));
            this.storeContact(connection, recipientId, null);
            this.storeProfile(connection, recipientId, null);
            this.storeProfileKey(connection, recipientId, null, false);
            this.storeExpiringProfileKeyCredential(connection, recipientId, null);
            this.deleteRecipient(connection, recipientId);
            connection.commit();
        }
        catch (SQLException e2) {
            throw new RuntimeException("Failed update recipient store", e2);
        }
    }

    @Override
    public Profile getProfile(RecipientId recipientId) {
        Profile profile;
        block8: {
            Connection connection = this.database.getConnection();
            try {
                profile = this.getProfile(connection, recipientId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed read from recipient store", e);
                }
            }
            connection.close();
        }
        return profile;
    }

    @Override
    public ProfileKey getProfileKey(RecipientId recipientId) {
        ProfileKey profileKey;
        block8: {
            Connection connection = this.database.getConnection();
            try {
                profileKey = this.getProfileKey(connection, recipientId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed read from recipient store", e);
                }
            }
            connection.close();
        }
        return profileKey;
    }

    @Override
    public ExpiringProfileKeyCredential getExpiringProfileKeyCredential(RecipientId recipientId) {
        ExpiringProfileKeyCredential expiringProfileKeyCredential;
        block8: {
            Connection connection = this.database.getConnection();
            try {
                expiringProfileKeyCredential = this.getExpiringProfileKeyCredential(connection, recipientId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed read from recipient store", e);
                }
            }
            connection.close();
        }
        return expiringProfileKeyCredential;
    }

    @Override
    public void storeProfile(RecipientId recipientId, Profile profile) {
        try (Connection connection = this.database.getConnection();){
            this.storeProfile(connection, recipientId, profile);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update recipient store", e);
        }
    }

    @Override
    public void storeProfileKey(RecipientId recipientId, ProfileKey profileKey) {
        try (Connection connection = this.database.getConnection();){
            this.storeProfileKey(connection, recipientId, profileKey);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update recipient store", e);
        }
    }

    public void storeProfileKey(Connection connection, RecipientId recipientId, ProfileKey profileKey) throws SQLException {
        this.storeProfileKey(connection, recipientId, profileKey, true);
    }

    @Override
    public void storeExpiringProfileKeyCredential(RecipientId recipientId, ExpiringProfileKeyCredential profileKeyCredential) {
        try (Connection connection = this.database.getConnection();){
            this.storeExpiringProfileKeyCredential(connection, recipientId, profileKeyCredential);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update recipient store", e);
        }
    }

    public void rotateSelfStorageId() {
        try (Connection connection = this.database.getConnection();){
            this.rotateSelfStorageId(connection);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update recipient store", e);
        }
    }

    public void rotateSelfStorageId(Connection connection) throws SQLException {
        RecipientId selfRecipientId = this.resolveRecipient(connection, this.selfAddressProvider.getSelfAddress());
        this.rotateStorageId(connection, selfRecipientId);
    }

    public StorageId rotateStorageId(Connection connection, ServiceId serviceId) throws SQLException {
        RecipientId selfRecipientId = this.resolveRecipient(connection, new RecipientAddress(serviceId));
        return this.rotateStorageId(connection, selfRecipientId);
    }

    public List<StorageId> getStorageIds(Connection connection) throws SQLException {
        String sql = "SELECT r.storage_id\nFROM %s r WHERE r.storage_id IS NOT NULL AND r._id != ? AND (r.aci IS NOT NULL OR r.pni IS NOT NULL)\n".formatted(TABLE_RECIPIENT);
        RecipientId selfRecipientId = this.resolveRecipient(connection, this.selfAddressProvider.getSelfAddress());
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, selfRecipientId.id());
            List<StorageId> list = Utils.executeQueryForStream(statement, this::getContactStorageIdFromResultSet).toList();
            return list;
        }
    }

    public void updateStorageId(Connection connection, RecipientId recipientId, StorageId storageId) throws SQLException {
        String sql = "UPDATE %s\nSET storage_id = ?\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, storageId.getRaw());
            statement.setLong(2, recipientId.id());
            statement.executeUpdate();
        }
    }

    public void updateStorageIds(Connection connection, Map<RecipientId, StorageId> storageIdMap) throws SQLException {
        String sql = "UPDATE %s\nSET storage_id = ?\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            for (Map.Entry<RecipientId, StorageId> entry : storageIdMap.entrySet()) {
                statement.setBytes(1, entry.getValue().getRaw());
                statement.setLong(2, entry.getKey().id());
                statement.executeUpdate();
            }
        }
    }

    public StorageId getSelfStorageId(Connection connection) throws SQLException {
        RecipientId selfRecipientId = this.resolveRecipient(connection, this.selfAddressProvider.getSelfAddress());
        return StorageId.forAccount((byte[])this.getStorageId(connection, selfRecipientId).getRaw());
    }

    public StorageId getStorageId(Connection connection, RecipientId recipientId) throws SQLException {
        String sql = "SELECT r.storage_id\nFROM %s r WHERE r._id = ? AND r.storage_id IS NOT NULL\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, recipientId.id());
            Optional<StorageId> storageId = Utils.executeQueryForOptional(statement, this::getContactStorageIdFromResultSet);
            if (storageId.isPresent()) {
                StorageId storageId2 = storageId.get();
                return storageId2;
            }
        }
        return this.rotateStorageId(connection, recipientId);
    }

    private StorageId rotateStorageId(Connection connection, RecipientId recipientId) throws SQLException {
        StorageId newStorageId = StorageId.forAccount((byte[])KeyUtils.createRawStorageId());
        this.updateStorageId(connection, recipientId, newStorageId);
        return newStorageId;
    }

    public void storeStorageRecord(Connection connection, RecipientId recipientId, StorageId storageId, byte[] storageRecord) throws SQLException {
        String deleteSql = "UPDATE %s\nSET storage_id = NULL\nWHERE storage_id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(deleteSql);){
            statement.setBytes(1, storageId.getRaw());
            statement.executeUpdate();
        }
        String insertSql = "UPDATE %s\nSET storage_id = ?, storage_record = ?\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(insertSql);){
            statement.setBytes(1, storageId.getRaw());
            if (storageRecord == null) {
                statement.setNull(2, 2004);
            } else {
                statement.setBytes(2, storageRecord);
            }
            statement.setLong(3, recipientId.id());
            statement.executeUpdate();
        }
    }

    void addLegacyRecipients(Map<RecipientId, Recipient> recipients) {
        logger.debug("Migrating legacy recipients to database");
        long start = System.nanoTime();
        String sql = "INSERT INTO %s (_id, number, aci)\nVALUES (?, ?, ?)\n".formatted(TABLE_RECIPIENT);
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement statement = connection.prepareStatement("DELETE FROM %s".formatted(TABLE_RECIPIENT));){
                statement.executeUpdate();
            }
            statement = connection.prepareStatement(sql);
            try {
                for (Recipient recipient : recipients.values()) {
                    statement.setLong(1, recipient.getRecipientId().id());
                    statement.setString(2, recipient.getAddress().number().orElse(null));
                    statement.setString(3, recipient.getAddress().aci().map(ServiceId.ACI::toString).orElse(null));
                    statement.executeUpdate();
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            logger.debug("Initial inserts took {}ms", (Object)((System.nanoTime() - start) / 1000000L));
            for (Recipient recipient : recipients.values()) {
                if (recipient.getContact() != null) {
                    this.storeContact(connection, recipient.getRecipientId(), recipient.getContact());
                }
                if (recipient.getProfile() != null) {
                    this.storeProfile(connection, recipient.getRecipientId(), recipient.getProfile());
                }
                if (recipient.getProfileKey() != null) {
                    this.storeProfileKey(connection, recipient.getRecipientId(), recipient.getProfileKey(), false);
                }
                if (recipient.getExpiringProfileKeyCredential() == null) continue;
                this.storeExpiringProfileKeyCredential(connection, recipient.getRecipientId(), recipient.getExpiringProfileKeyCredential());
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update recipient store", e);
        }
        logger.debug("Complete recipients migration took {}ms", (Object)((System.nanoTime() - start) / 1000000L));
    }

    long getActualRecipientId(long recipientId) {
        while (this.recipientsMerged.containsKey(recipientId)) {
            Long newRecipientId = this.recipientsMerged.get(recipientId);
            logger.debug("Using {} instead of {}, because recipients have been merged", (Object)newRecipientId, (Object)recipientId);
            recipientId = newRecipientId;
        }
        return recipientId;
    }

    public void storeContact(Connection connection, RecipientId recipientId, Contact contact) throws SQLException {
        String sql = "UPDATE %s\nSET given_name = ?, family_name = ?, nick_name = ?, expiration_time = ?, expiration_time_version = ?, mute_until = ?, hide_story = ?, profile_sharing = ?, color = ?, blocked = ?, archived = ?, unregistered_timestamp = ?, nick_name_given_name = ?, nick_name_family_name = ?, note = ?, hidden = ?\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, contact == null ? null : contact.givenName());
            statement.setString(2, contact == null ? null : contact.familyName());
            statement.setString(3, contact == null ? null : contact.nickName());
            statement.setInt(4, contact == null ? 0 : contact.messageExpirationTime());
            statement.setInt(5, contact == null ? 0 : Math.max(1, contact.messageExpirationTimeVersion()));
            statement.setLong(6, contact == null ? 0L : contact.muteUntil());
            statement.setBoolean(7, contact != null && contact.hideStory());
            statement.setBoolean(8, contact != null && contact.isProfileSharingEnabled());
            statement.setString(9, contact == null ? null : contact.color());
            statement.setBoolean(10, contact != null && contact.isBlocked());
            statement.setBoolean(11, contact != null && contact.isArchived());
            if (contact == null || contact.unregisteredTimestamp() == null) {
                statement.setNull(12, 4);
            } else {
                statement.setLong(12, contact.unregisteredTimestamp());
            }
            statement.setString(13, contact == null ? null : contact.nickNameGivenName());
            statement.setString(14, contact == null ? null : contact.nickNameFamilyName());
            statement.setString(15, contact == null ? null : contact.note());
            statement.setBoolean(16, contact != null && contact.isHidden());
            statement.setLong(17, recipientId.id());
            statement.executeUpdate();
        }
        if (contact != null && contact.unregisteredTimestamp() != null) {
            this.markUnregisteredAndSplitIfNecessary(connection, recipientId);
        }
        this.rotateStorageId(connection, recipientId);
    }

    public int removeStorageIdsFromLocalOnlyUnregisteredRecipients(Connection connection, List<StorageId> storageIds) throws SQLException {
        String sql = "UPDATE %s\nSET storage_id = NULL\nWHERE storage_id = ? AND unregistered_timestamp IS NOT NULL\n".formatted(TABLE_RECIPIENT);
        int count = 0;
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            for (StorageId storageId : storageIds) {
                statement.setBytes(1, storageId.getRaw());
                count += statement.executeUpdate();
            }
        }
        return count;
    }

    public void markNeedsPniSignature(RecipientId recipientId, boolean value) {
        logger.debug("Marking {} numbers as need pni signature = {}", (Object)recipientId, (Object)value);
        try (Connection connection = this.database.getConnection();){
            String sql = "UPDATE %s\nSET needs_pni_signature = ?\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setBoolean(1, value);
                statement.setLong(2, recipientId.id());
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update recipient store", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean needsPniSignature(RecipientId recipientId) {
        try (Connection connection = this.database.getConnection();){
            boolean bl;
            block14: {
                String sql = "SELECT needs_pni_signature\nFROM %s\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT);
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setLong(1, recipientId.id());
                    bl = Utils.executeQuerySingleRow(statement, resultSet -> resultSet.getBoolean("needs_pni_signature"));
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read recipient store", e);
        }
    }

    public void markUndiscoverablePossiblyUnregistered(Set<String> numbers) {
        logger.debug("Marking {} numbers as undiscoverable", (Object)numbers.size());
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            for (String number : numbers) {
                Optional<RecipientWithAddress> recipientAddress = this.findByNumber(connection, number);
                if (!recipientAddress.isPresent()) continue;
                RecipientId recipientId = recipientAddress.get().id();
                this.markDiscoverable(connection, recipientId, false);
                Contact contact = this.getContact(connection, recipientId);
                if (!recipientAddress.get().address().aci().isEmpty() && (contact == null || contact.unregisteredTimestamp() == null)) continue;
                this.markUnregisteredAndSplitIfNecessary(connection, recipientId);
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update recipient store", e);
        }
    }

    public void markDiscoverable(Set<String> numbers) {
        logger.debug("Marking {} numbers as discoverable", (Object)numbers.size());
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            for (String number : numbers) {
                Optional<RecipientWithAddress> recipientAddress = this.findByNumber(connection, number);
                if (!recipientAddress.isPresent()) continue;
                RecipientId recipientId = recipientAddress.get().id();
                this.markDiscoverable(connection, recipientId, true);
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update recipient store", e);
        }
    }

    public void markRegistered(RecipientId recipientId, boolean registered) {
        logger.debug("Marking {} as registered={}", (Object)recipientId, (Object)registered);
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            if (registered) {
                this.markRegistered(connection, recipientId);
            } else {
                this.markUnregistered(connection, recipientId);
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update recipient store", e);
        }
    }

    private void markUnregisteredAndSplitIfNecessary(Connection connection, RecipientId recipientId) throws SQLException {
        this.markUnregistered(connection, recipientId);
        RecipientAddress address = this.resolveRecipientAddress(connection, recipientId);
        boolean needSplit = address.aci().isPresent() && address.pni().isPresent();
        logger.trace("Marking unregistered recipient {} as unregistered (and split={}): {}", new Object[]{recipientId, needSplit, address});
        if (needSplit) {
            RecipientAddress numberAddress = new RecipientAddress(address.pni().get(), (String)address.number().orElse(null));
            this.updateRecipientAddress(connection, recipientId, address.removeIdentifiersFrom(numberAddress));
            this.addNewRecipient(connection, numberAddress);
        }
    }

    private void markDiscoverable(Connection connection, RecipientId recipientId, boolean discoverable) throws SQLException {
        String sql = "UPDATE %s\nSET discoverable = ?\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBoolean(1, discoverable);
            statement.setLong(2, recipientId.id());
            statement.executeUpdate();
        }
    }

    private void markRegistered(Connection connection, RecipientId recipientId) throws SQLException {
        String sql = "UPDATE %s\nSET unregistered_timestamp = NULL\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, recipientId.id());
            statement.executeUpdate();
        }
    }

    private void markUnregistered(Connection connection, RecipientId recipientId) throws SQLException {
        String sql = "UPDATE %s\nSET unregistered_timestamp = ?, discoverable = FALSE\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, System.currentTimeMillis());
            statement.setLong(2, recipientId.id());
            statement.executeUpdate();
        }
    }

    private void storeExpiringProfileKeyCredential(Connection connection, RecipientId recipientId, ExpiringProfileKeyCredential profileKeyCredential) throws SQLException {
        String sql = "UPDATE %s\nSET profile_key_credential = ?\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, profileKeyCredential == null ? null : profileKeyCredential.serialize());
            statement.setLong(2, recipientId.id());
            statement.executeUpdate();
        }
    }

    public void storeProfile(Connection connection, RecipientId recipientId, Profile profile) throws SQLException {
        String sql = "UPDATE %s\nSET profile_last_update_timestamp = ?, profile_given_name = ?, profile_family_name = ?, profile_about = ?, profile_about_emoji = ?, profile_avatar_url_path = ?, profile_mobile_coin_address = ?, profile_unidentified_access_mode = ?, profile_capabilities = ?, profile_phone_number_sharing = ?\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, profile == null ? 0L : profile.getLastUpdateTimestamp());
            statement.setString(2, profile == null ? null : profile.getGivenName());
            statement.setString(3, profile == null ? null : profile.getFamilyName());
            statement.setString(4, profile == null ? null : profile.getAbout());
            statement.setString(5, profile == null ? null : profile.getAboutEmoji());
            statement.setString(6, profile == null ? null : profile.getAvatarUrlPath());
            statement.setBytes(7, profile == null ? null : profile.getMobileCoinAddress());
            statement.setString(8, profile == null ? null : profile.getUnidentifiedAccessMode().name());
            statement.setString(9, profile == null ? null : profile.getCapabilities().stream().map(Enum::name).collect(Collectors.joining(",")));
            statement.setString(10, profile == null || profile.getPhoneNumberSharingMode() == null ? null : profile.getPhoneNumberSharingMode().name());
            statement.setLong(11, recipientId.id());
            statement.executeUpdate();
        }
        this.rotateStorageId(connection, recipientId);
    }

    private void storeProfileKey(Connection connection, RecipientId recipientId, ProfileKey profileKey, boolean resetProfile) throws SQLException {
        Profile recipientProfile;
        ProfileKey recipientProfileKey;
        if (profileKey != null && profileKey.equals((Object)(recipientProfileKey = this.getProfileKey(connection, recipientId))) && ((recipientProfile = this.getProfile(connection, recipientId)) == null || recipientProfile.getUnidentifiedAccessMode() != Profile.UnidentifiedAccessMode.UNKNOWN && recipientProfile.getUnidentifiedAccessMode() != Profile.UnidentifiedAccessMode.DISABLED)) {
            return;
        }
        String sql = "UPDATE %s\nSET profile_key = ?, profile_key_credential = NULL%s\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT, resetProfile ? ", profile_last_update_timestamp = 0" : "");
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, profileKey == null ? null : profileKey.serialize());
            statement.setLong(2, recipientId.id());
            statement.executeUpdate();
        }
        this.rotateStorageId(connection, recipientId);
    }

    private RecipientAddress resolveRecipientAddress(Connection connection, RecipientId recipientId) throws SQLException {
        String sql = "SELECT r.number, r.aci, r.pni, r.username\nFROM %s r\nWHERE r._id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, recipientId.id());
            RecipientAddress recipientAddress = Utils.executeQuerySingleRow(statement, this::getRecipientAddressFromResultSet);
            return recipientAddress;
        }
    }

    private RecipientId resolveRecipientTrusted(RecipientAddress address, boolean isSelf) {
        Pair<RecipientId, List<RecipientId>> pair;
        Connection connection;
        try {
            connection = this.database.getConnection();
            try {
                connection.setAutoCommit(false);
                pair = this.resolveRecipientTrustedLocked(connection, address, isSelf);
                connection.commit();
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update recipient store", e);
        }
        if (!pair.second().isEmpty()) {
            logger.debug("Resolved address {}, merging {} other recipients", (Object)address, (Object)pair.second().size());
            try {
                connection = this.database.getConnection();
                try {
                    connection.setAutoCommit(false);
                    this.mergeRecipients(connection, pair.first(), pair.second());
                    connection.commit();
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed update recipient store", e);
            }
        }
        return pair.first();
    }

    private Pair<RecipientId, List<RecipientId>> resolveRecipientTrustedLocked(Connection connection, RecipientAddress address, boolean isSelf) throws SQLException {
        if (address.hasSingleIdentifier() || !isSelf && this.selfAddressProvider.getSelfAddress().matches(address)) {
            return new Pair<RecipientId, List<RecipientId>>(this.resolveRecipientLocked(connection, address), List.of());
        }
        Pair<RecipientId, List<RecipientId>> pair = MergeRecipientHelper.resolveRecipientTrustedLocked(new HelperStore(connection), address);
        this.markRegistered(connection, pair.first());
        for (RecipientId toBeMergedRecipientId : pair.second()) {
            this.mergeRecipientsLocked(connection, pair.first(), toBeMergedRecipientId);
        }
        return pair;
    }

    private void mergeRecipients(Connection connection, RecipientId recipientId, List<RecipientId> toBeMergedRecipientIds) throws SQLException {
        for (RecipientId toBeMergedRecipientId : toBeMergedRecipientIds) {
            this.recipientMergeHandler.mergeRecipients(connection, recipientId, toBeMergedRecipientId);
            this.deleteRecipient(connection, toBeMergedRecipientId);
            this.recipientAddressCache.entrySet().removeIf(e -> ((RecipientWithAddress)e.getValue()).id().equals(toBeMergedRecipientId));
        }
    }

    private RecipientId resolveRecipientLocked(Connection connection, RecipientAddress address) throws SQLException {
        Optional byNumber;
        Optional byPni;
        Optional byAci;
        Optional<Object> optional = byAci = address.aci().isEmpty() ? Optional.empty() : this.findByServiceId(connection, (ServiceId)address.aci().get());
        if (byAci.isPresent()) {
            return ((RecipientWithAddress)byAci.get()).id();
        }
        Optional<Object> optional2 = byPni = address.pni().isEmpty() ? Optional.empty() : this.findByServiceId(connection, (ServiceId)address.pni().get());
        if (byPni.isPresent()) {
            return ((RecipientWithAddress)byPni.get()).id();
        }
        Optional<Object> optional3 = byNumber = address.number().isEmpty() ? Optional.empty() : this.findByNumber(connection, address.number().get());
        if (byNumber.isPresent()) {
            return ((RecipientWithAddress)byNumber.get()).id();
        }
        logger.debug("Got new recipient, both serviceId and number are unknown");
        if (address.serviceId().isEmpty()) {
            return this.addNewRecipient(connection, address);
        }
        return this.addNewRecipient(connection, new RecipientAddress(address.serviceId().get()));
    }

    private RecipientId resolveRecipientLocked(Connection connection, ServiceId serviceId) throws SQLException {
        Optional<RecipientWithAddress> recipient = this.findByServiceId(connection, serviceId);
        if (recipient.isEmpty()) {
            logger.debug("Got new recipient, serviceId is unknown");
            return this.addNewRecipient(connection, new RecipientAddress(serviceId));
        }
        return recipient.get().id();
    }

    private RecipientId resolveRecipientLocked(Connection connection, String number) throws SQLException {
        Optional<RecipientWithAddress> recipient = this.findByNumber(connection, number);
        if (recipient.isEmpty()) {
            logger.debug("Got new recipient, number is unknown");
            return this.addNewRecipient(connection, new RecipientAddress(number));
        }
        return recipient.get().id();
    }

    private RecipientId addNewRecipient(Connection connection, RecipientAddress address) throws SQLException {
        String sql = "INSERT INTO %s (number, aci, pni, username)\nVALUES (?, ?, ?, ?)\nRETURNING _id\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, address.number().orElse(null));
            statement.setString(2, address.aci().map(ServiceId.ACI::toString).orElse(null));
            statement.setString(3, address.pni().map(ServiceId.PNI::toString).orElse(null));
            statement.setString(4, address.username().orElse(null));
            Optional<Long> generatedKey = Utils.executeQueryForOptional(statement, Utils::getIdMapper);
            if (generatedKey.isPresent()) {
                RecipientId recipientId = new RecipientId(generatedKey.get(), this);
                logger.debug("Added new recipient {} with address {}", (Object)recipientId, (Object)address);
                RecipientId recipientId2 = recipientId;
                return recipientId2;
            }
            throw new RuntimeException("Failed to add new recipient to database");
        }
    }

    private void removeRecipientAddress(Connection connection, RecipientId recipientId) throws SQLException {
        this.recipientAddressCache.entrySet().removeIf(e -> ((RecipientWithAddress)e.getValue()).id().equals(recipientId));
        String sql = "UPDATE %s\nSET number = NULL, aci = NULL, pni = NULL, username = NULL, storage_id = NULL\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, recipientId.id());
            statement.executeUpdate();
        }
    }

    private void updateRecipientAddress(Connection connection, RecipientId recipientId, RecipientAddress address) throws SQLException {
        this.recipientAddressCache.entrySet().removeIf(e -> ((RecipientWithAddress)e.getValue()).id().equals(recipientId));
        String sql = "UPDATE %s\nSET number = ?, aci = ?, pni = ?, username = ?\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, address.number().orElse(null));
            statement.setString(2, address.aci().map(ServiceId.ACI::toString).orElse(null));
            statement.setString(3, address.pni().map(ServiceId.PNI::toString).orElse(null));
            statement.setString(4, address.username().orElse(null));
            statement.setLong(5, recipientId.id());
            statement.executeUpdate();
        }
        this.rotateStorageId(connection, recipientId);
    }

    private void deleteRecipient(Connection connection, RecipientId recipientId) throws SQLException {
        String sql = "DELETE FROM %s\nWHERE _id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, recipientId.id());
            statement.executeUpdate();
        }
    }

    private void mergeRecipientsLocked(Connection connection, RecipientId recipientId, RecipientId toBeMergedRecipientId) throws SQLException {
        Profile profile;
        ExpiringProfileKeyCredential profileKeyCredential;
        ProfileKey profileKey;
        Contact contact = this.getContact(connection, recipientId);
        if (contact == null) {
            Contact toBeMergedContact = this.getContact(connection, toBeMergedRecipientId);
            this.storeContact(connection, recipientId, toBeMergedContact);
        }
        if ((profileKey = this.getProfileKey(connection, recipientId)) == null) {
            ProfileKey toBeMergedProfileKey = this.getProfileKey(connection, toBeMergedRecipientId);
            this.storeProfileKey(connection, recipientId, toBeMergedProfileKey, false);
        }
        if ((profileKeyCredential = this.getExpiringProfileKeyCredential(connection, recipientId)) == null) {
            ExpiringProfileKeyCredential toBeMergedProfileKeyCredential = this.getExpiringProfileKeyCredential(connection, toBeMergedRecipientId);
            this.storeExpiringProfileKeyCredential(connection, recipientId, toBeMergedProfileKeyCredential);
        }
        if ((profile = this.getProfile(connection, recipientId)) == null) {
            Profile toBeMergedProfile = this.getProfile(connection, toBeMergedRecipientId);
            this.storeProfile(connection, recipientId, toBeMergedProfile);
        }
        this.recipientsMerged.put(toBeMergedRecipientId.id(), recipientId.id());
    }

    private Optional<RecipientWithAddress> findByNumber(Connection connection, String number) throws SQLException {
        String sql = "SELECT r._id, r.number, r.aci, r.pni, r.username\nFROM %s r\nWHERE r.number = ?\nLIMIT 1\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, number);
            Optional<RecipientWithAddress> optional = Utils.executeQueryForOptional(statement, this::getRecipientWithAddressFromResultSet);
            return optional;
        }
    }

    private Optional<RecipientWithAddress> findByUsername(Connection connection, String username) throws SQLException {
        String sql = "SELECT r._id, r.number, r.aci, r.pni, r.username\nFROM %s r\nWHERE r.username = ?\nLIMIT 1\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, username);
            Optional<RecipientWithAddress> optional = Utils.executeQueryForOptional(statement, this::getRecipientWithAddressFromResultSet);
            return optional;
        }
    }

    private Optional<RecipientWithAddress> findByServiceId(Connection connection, ServiceId serviceId) throws SQLException {
        Optional<RecipientWithAddress> recipientWithAddress = Optional.ofNullable(this.recipientAddressCache.get(serviceId));
        if (recipientWithAddress.isPresent()) {
            return recipientWithAddress;
        }
        String sql = "SELECT r._id, r.number, r.aci, r.pni, r.username\nFROM %s r\nWHERE %s = ?1\nLIMIT 1\n".formatted(TABLE_RECIPIENT, serviceId instanceof ServiceId.ACI ? "r.aci" : "r.pni");
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, serviceId.toString());
            recipientWithAddress = Utils.executeQueryForOptional(statement, this::getRecipientWithAddressFromResultSet);
            recipientWithAddress.ifPresent(r -> this.recipientAddressCache.put(serviceId, (RecipientWithAddress)r));
            Optional<RecipientWithAddress> optional = recipientWithAddress;
            return optional;
        }
    }

    private Set<RecipientWithAddress> findAllByAddress(Connection connection, RecipientAddress address) throws SQLException {
        String sql = "SELECT r._id, r.number, r.aci, r.pni, r.username\nFROM %s r\nWHERE r.aci = ?1 OR\n      r.pni = ?2 OR\n      r.number = ?3 OR\n      r.username = ?4\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, address.aci().map(ServiceId::toString).orElse(null));
            statement.setString(2, address.pni().map(ServiceId::toString).orElse(null));
            statement.setString(3, address.number().orElse(null));
            statement.setString(4, address.username().orElse(null));
            Set<RecipientWithAddress> set = Utils.executeQueryForStream(statement, this::getRecipientWithAddressFromResultSet).collect(Collectors.toSet());
            return set;
        }
    }

    private Contact getContact(Connection connection, RecipientId recipientId) throws SQLException {
        String sql = "SELECT r.given_name, r.family_name, r.nick_name, r.nick_name_given_name, r.nick_name_family_name, r.note, r.expiration_time, r.expiration_time_version, r.mute_until, r.hide_story, r.profile_sharing, r.color, r.blocked, r.archived, r.hidden, r.unregistered_timestamp\nFROM %s r\nWHERE r._id = ? AND (%s)\n".formatted(TABLE_RECIPIENT, SQL_IS_CONTACT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, recipientId.id());
            Contact contact = Utils.executeQueryForOptional(statement, this::getContactFromResultSet).orElse(null);
            return contact;
        }
    }

    private ProfileKey getProfileKey(Connection connection, RecipientId recipientId) throws SQLException {
        RecipientId selfRecipientId = this.resolveRecipientLocked(connection, this.selfAddressProvider.getSelfAddress());
        if (recipientId.equals(selfRecipientId)) {
            return this.selfProfileKeyProvider.getSelfProfileKey();
        }
        String sql = "SELECT r.profile_key\nFROM %s r\nWHERE r._id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, recipientId.id());
            ProfileKey profileKey = Utils.executeQueryForOptional(statement, this::getProfileKeyFromResultSet).orElse(null);
            return profileKey;
        }
    }

    private ExpiringProfileKeyCredential getExpiringProfileKeyCredential(Connection connection, RecipientId recipientId) throws SQLException {
        String sql = "SELECT r.profile_key_credential\nFROM %s r\nWHERE r._id = ?\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, recipientId.id());
            ExpiringProfileKeyCredential expiringProfileKeyCredential = Utils.executeQueryForOptional(statement, this::getExpiringProfileKeyCredentialFromResultSet).orElse(null);
            return expiringProfileKeyCredential;
        }
    }

    public Profile getProfile(Connection connection, RecipientId recipientId) throws SQLException {
        String sql = "SELECT r.profile_last_update_timestamp, r.profile_given_name, r.profile_family_name, r.profile_about, r.profile_about_emoji, r.profile_avatar_url_path, r.profile_mobile_coin_address, r.profile_unidentified_access_mode, r.profile_capabilities, r.profile_phone_number_sharing\nFROM %s r\nWHERE r._id = ? AND r.profile_capabilities IS NOT NULL\n".formatted(TABLE_RECIPIENT);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, recipientId.id());
            Profile profile = Utils.executeQueryForOptional(statement, this::getProfileFromResultSet).orElse(null);
            return profile;
        }
    }

    private RecipientAddress getRecipientAddressFromResultSet(ResultSet resultSet) throws SQLException {
        Optional<ServiceId.ACI> aci = Optional.ofNullable(resultSet.getString("aci")).map(ServiceId.ACI::parseOrNull);
        Optional<ServiceId.PNI> pni = Optional.ofNullable(resultSet.getString("pni")).map(ServiceId.PNI::parseOrNull);
        Optional<String> number = Optional.ofNullable(resultSet.getString("number"));
        Optional<String> username = Optional.ofNullable(resultSet.getString("username"));
        return new RecipientAddress(aci, pni, number, username);
    }

    private RecipientId getRecipientIdFromResultSet(ResultSet resultSet) throws SQLException {
        return new RecipientId(resultSet.getLong("_id"), this);
    }

    private RecipientWithAddress getRecipientWithAddressFromResultSet(ResultSet resultSet) throws SQLException {
        return new RecipientWithAddress(this.getRecipientIdFromResultSet(resultSet), this.getRecipientAddressFromResultSet(resultSet));
    }

    private Recipient getRecipientFromResultSet(ResultSet resultSet) throws SQLException {
        return new Recipient(this.getRecipientIdFromResultSet(resultSet), this.getRecipientAddressFromResultSet(resultSet), this.getContactFromResultSet(resultSet), this.getProfileKeyFromResultSet(resultSet), this.getExpiringProfileKeyCredentialFromResultSet(resultSet), this.getProfileFromResultSet(resultSet), RecipientStore.getDiscoverableFromResultSet(resultSet), this.getStorageRecordFromResultSet(resultSet));
    }

    private Contact getContactFromResultSet(ResultSet resultSet) throws SQLException {
        long unregisteredTimestamp = resultSet.getLong("unregistered_timestamp");
        return new Contact(resultSet.getString("given_name"), resultSet.getString("family_name"), resultSet.getString("nick_name"), resultSet.getString("nick_name_given_name"), resultSet.getString("nick_name_family_name"), resultSet.getString("note"), resultSet.getString("color"), resultSet.getInt("expiration_time"), resultSet.getInt("expiration_time_version"), resultSet.getLong("mute_until"), resultSet.getBoolean("hide_story"), resultSet.getBoolean("blocked"), resultSet.getBoolean("archived"), resultSet.getBoolean("profile_sharing"), resultSet.getBoolean("hidden"), unregisteredTimestamp == 0L ? null : Long.valueOf(unregisteredTimestamp));
    }

    private static Boolean getDiscoverableFromResultSet(ResultSet resultSet) throws SQLException {
        boolean discoverable = resultSet.getBoolean("discoverable");
        if (resultSet.wasNull()) {
            return null;
        }
        return discoverable;
    }

    private Profile getProfileFromResultSet(ResultSet resultSet) throws SQLException {
        String profileCapabilities = resultSet.getString("profile_capabilities");
        String profileUnidentifiedAccessMode = resultSet.getString("profile_unidentified_access_mode");
        return new Profile(resultSet.getLong("profile_last_update_timestamp"), resultSet.getString("profile_given_name"), resultSet.getString("profile_family_name"), resultSet.getString("profile_about"), resultSet.getString("profile_about_emoji"), resultSet.getString("profile_avatar_url_path"), resultSet.getBytes("profile_mobile_coin_address"), profileUnidentifiedAccessMode == null ? Profile.UnidentifiedAccessMode.UNKNOWN : Profile.UnidentifiedAccessMode.valueOfOrUnknown(profileUnidentifiedAccessMode), profileCapabilities == null ? Set.of() : Arrays.stream(profileCapabilities.split(",")).map(Profile.Capability::valueOfOrNull).filter(Objects::nonNull).collect(Collectors.toSet()), PhoneNumberSharingMode.valueOfOrNull(resultSet.getString("profile_phone_number_sharing")));
    }

    private ProfileKey getProfileKeyFromResultSet(ResultSet resultSet) throws SQLException {
        byte[] profileKey = resultSet.getBytes("profile_key");
        if (profileKey == null) {
            return null;
        }
        try {
            return new ProfileKey(profileKey);
        }
        catch (InvalidInputException ignored) {
            return null;
        }
    }

    private ExpiringProfileKeyCredential getExpiringProfileKeyCredentialFromResultSet(ResultSet resultSet) throws SQLException {
        byte[] profileKeyCredential = resultSet.getBytes("profile_key_credential");
        if (profileKeyCredential == null) {
            return null;
        }
        try {
            return new ExpiringProfileKeyCredential(profileKeyCredential);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private StorageId getContactStorageIdFromResultSet(ResultSet resultSet) throws SQLException {
        byte[] storageId = resultSet.getBytes("storage_id");
        return StorageId.forContact((byte[])storageId);
    }

    private byte[] getStorageRecordFromResultSet(ResultSet resultSet) throws SQLException {
        return resultSet.getBytes("storage_record");
    }

    private /* synthetic */ Recipient lambda$getRecipients$2(RecipientAddress selfAddress, Recipient r) {
        if (r.getAddress().matches(selfAddress)) {
            return Recipient.newBuilder(r).withProfileKey(this.selfProfileKeyProvider.getSelfProfileKey()).build();
        }
        return r;
    }

    private static /* synthetic */ boolean lambda$getRecipients$1(Optional name, Recipient r) {
        return name.isEmpty() || r.getContact() != null && ((String)name.get()).equals(r.getContact().getName()) || r.getProfile() != null && ((String)name.get()).equals(r.getProfile().getDisplayName());
    }

    private static /* synthetic */ String lambda$getRecipients$0(RecipientId recipientId) {
        return String.valueOf(recipientId.id());
    }

    private /* synthetic */ Pair lambda$getContacts$0(ResultSet resultSet) throws SQLException {
        return new Pair<RecipientId, Contact>(this.getRecipientIdFromResultSet(resultSet), this.getContactFromResultSet(resultSet));
    }

    public static interface RecipientMergeHandler {
        public void mergeRecipients(Connection var1, RecipientId var2, RecipientId var3) throws SQLException;
    }

    private class HelperStore
    implements MergeRecipientHelper.Store {
        private final Connection connection;

        public HelperStore(Connection connection) {
            this.connection = connection;
        }

        @Override
        public Set<RecipientWithAddress> findAllByAddress(RecipientAddress address) throws SQLException {
            return RecipientStore.this.findAllByAddress(this.connection, address);
        }

        @Override
        public RecipientId addNewRecipient(RecipientAddress address) throws SQLException {
            return RecipientStore.this.addNewRecipient(this.connection, address);
        }

        @Override
        public void updateRecipientAddress(RecipientId recipientId, RecipientAddress address) throws SQLException {
            RecipientStore.this.updateRecipientAddress(this.connection, recipientId, address);
        }

        @Override
        public void removeRecipientAddress(RecipientId recipientId) throws SQLException {
            RecipientStore.this.removeRecipientAddress(this.connection, recipientId);
        }
    }
}

