/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.recipients;

import java.util.function.Supplier;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.signal.core.models.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;

public interface RecipientResolver {
    public RecipientId resolveRecipient(RecipientAddress var1);

    public RecipientId resolveRecipient(long var1);

    public RecipientId resolveRecipient(String var1);

    default public RecipientId resolveRecipient(SignalServiceAddress address) {
        return this.resolveRecipient(new RecipientAddress(address));
    }

    public RecipientId resolveRecipient(ServiceId var1);

    public static class RecipientResolverWrapper
    implements RecipientResolver {
        private final Supplier<RecipientResolver> recipientResolverSupplier;

        public RecipientResolverWrapper(Supplier<RecipientResolver> recipientResolverSupplier) {
            this.recipientResolverSupplier = recipientResolverSupplier;
        }

        @Override
        public RecipientId resolveRecipient(RecipientAddress address) {
            return this.recipientResolverSupplier.get().resolveRecipient(address);
        }

        @Override
        public RecipientId resolveRecipient(long recipientId) {
            return this.recipientResolverSupplier.get().resolveRecipient(recipientId);
        }

        @Override
        public RecipientId resolveRecipient(String identifier) {
            return this.recipientResolverSupplier.get().resolveRecipient(identifier);
        }

        @Override
        public RecipientId resolveRecipient(ServiceId serviceId) {
            return this.recipientResolverSupplier.get().resolveRecipient(serviceId);
        }
    }
}

