/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.recipients;

import java.util.Optional;
import org.asamk.signal.manager.storage.recipients.InvalidAddress;
import org.signal.core.models.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;

public record RecipientAddress(Optional<ServiceId.ACI> aci, Optional<ServiceId.PNI> pni, Optional<String> number, Optional<String> username) {
    public RecipientAddress {
        if (aci.isPresent() && aci.get().isUnknown()) {
            aci = Optional.empty();
        }
        if (pni.isPresent() && pni.get().isUnknown()) {
            pni = Optional.empty();
        }
        if (aci.isEmpty() && pni.isEmpty() && number.isEmpty() && username.isEmpty()) {
            throw new InvalidAddress("Must have either a ServiceId, username or E164 number!");
        }
    }

    public RecipientAddress(Optional<ServiceId> serviceId, Optional<String> number) {
        this(serviceId.filter(s -> s instanceof ServiceId.ACI).map(s -> (ServiceId.ACI)s), serviceId.filter(s -> s instanceof ServiceId.PNI).map(s -> (ServiceId.PNI)s), number, Optional.empty());
    }

    public RecipientAddress(ServiceId.ACI aci, String e164) {
        this(Optional.ofNullable(aci), Optional.empty(), Optional.ofNullable(e164), Optional.empty());
    }

    public RecipientAddress(ServiceId.PNI pni, String e164) {
        this(Optional.empty(), Optional.ofNullable(pni), Optional.ofNullable(e164), Optional.empty());
    }

    public RecipientAddress(String e164) {
        this(Optional.empty(), Optional.empty(), Optional.ofNullable(e164), Optional.empty());
    }

    public RecipientAddress(ServiceId.ACI aci, ServiceId.PNI pni, String e164) {
        this(Optional.ofNullable(aci), Optional.ofNullable(pni), Optional.ofNullable(e164), Optional.empty());
    }

    public RecipientAddress(ServiceId.ACI aci, ServiceId.PNI pni, String e164, String username) {
        this(Optional.ofNullable(aci), Optional.ofNullable(pni), Optional.ofNullable(e164), Optional.ofNullable(username));
    }

    public RecipientAddress(SignalServiceAddress address) {
        this(address.getServiceId() instanceof ServiceId.ACI ? Optional.of((ServiceId.ACI)address.getServiceId()) : Optional.empty(), address.getServiceId() instanceof ServiceId.PNI ? Optional.of((ServiceId.PNI)address.getServiceId()) : Optional.empty(), address.getNumber(), Optional.empty());
    }

    public RecipientAddress(org.asamk.signal.manager.api.RecipientAddress address) {
        this(address.aci().map(ServiceId.ACI::parseOrThrow), address.pni().map(ServiceId.PNI::parseOrThrow), address.number(), address.username());
    }

    public RecipientAddress(ServiceId serviceId) {
        this(Optional.of(serviceId), Optional.empty());
    }

    public RecipientAddress withOtherIdentifiersFrom(RecipientAddress address) {
        return new RecipientAddress(this.aci.or(address::aci), this.pni.or(address::pni), this.number.or(address::number), this.username.or(address::username));
    }

    public RecipientAddress removeIdentifiersFrom(RecipientAddress address) {
        return new RecipientAddress(address.aci.equals(this.aci) ? Optional.empty() : this.aci, address.pni.equals(this.pni) ? Optional.empty() : this.pni, address.number.equals(this.number) ? Optional.empty() : this.number, address.username.equals(this.username) ? Optional.empty() : this.username);
    }

    public Optional<ServiceId> serviceId() {
        return this.aci.map(aci -> aci).or(this::pni);
    }

    public String getIdentifier() {
        if (this.aci.isPresent()) {
            return this.aci.get().toString();
        }
        if (this.pni.isPresent()) {
            return this.pni.get().toString();
        }
        if (this.number.isPresent()) {
            return this.number.get();
        }
        throw new AssertionError((Object)"Given the checks in the constructor, this should not be possible.");
    }

    public String getLegacyIdentifier() {
        if (this.number.isPresent()) {
            return this.number.get();
        }
        if (this.aci.isPresent()) {
            return this.aci.get().toString();
        }
        if (this.pni.isPresent()) {
            return this.pni.get().toString();
        }
        throw new AssertionError((Object)"Given the checks in the constructor, this should not be possible.");
    }

    public boolean matches(RecipientAddress other) {
        return this.aci.isPresent() && other.aci.isPresent() && this.aci.get().equals((Object)other.aci.get()) || this.pni.isPresent() && other.pni.isPresent() && this.pni.get().equals((Object)other.pni.get()) || this.number.isPresent() && other.number.isPresent() && this.number.get().equals(other.number.get());
    }

    public boolean hasSingleIdentifier() {
        int identifiersCount = this.aci().map(s -> 1).orElse(0) + this.pni().map(s -> 1).orElse(0) + this.number().map(s -> 1).orElse(0) + this.username().map(s -> 1).orElse(0);
        return identifiersCount == 1;
    }

    public boolean hasIdentifiersOf(RecipientAddress address) {
        return !(!address.aci.isEmpty() && !address.aci.equals(this.aci) || !address.pni.isEmpty() && !address.pni.equals(this.pni) || !address.number.isEmpty() && !address.number.equals(this.number) || !address.username.isEmpty() && !address.username.equals(this.username));
    }

    public boolean hasAdditionalIdentifiersThan(RecipientAddress address) {
        return this.aci.isPresent() && (address.aci.isEmpty() || !address.aci.equals(this.aci)) || this.pni.isPresent() && (address.pni.isEmpty() || !address.pni.equals(this.pni)) || this.number.isPresent() && (address.number.isEmpty() || !address.number.equals(this.number)) || this.username.isPresent() && (address.username.isEmpty() || !address.username.equals(this.username));
    }

    public boolean hasOnlyPniAndNumber() {
        return this.pni.isPresent() && this.aci.isEmpty() && this.number.isPresent();
    }

    public SignalServiceAddress toSignalServiceAddress() {
        return new SignalServiceAddress(this.serviceId().orElse((ServiceId)ServiceId.ACI.UNKNOWN), this.number);
    }

    public org.asamk.signal.manager.api.RecipientAddress toApiRecipientAddress() {
        return new org.asamk.signal.manager.api.RecipientAddress(this.aci().map(ServiceId::toString), this.pni().map(ServiceId::toString), this.number(), this.username());
    }
}

