/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.recipients;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.signal.core.models.ServiceId;

public class LegacyRecipientStore {
    @JsonProperty(value="recipientStore")
    @JsonDeserialize(using=RecipientStoreDeserializer.class)
    private final List<RecipientAddress> addresses = new ArrayList<RecipientAddress>();

    public List<RecipientAddress> getAddresses() {
        return this.addresses;
    }

    public static class RecipientStoreDeserializer
    extends JsonDeserializer<List<RecipientAddress>> {
        public List<RecipientAddress> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            ArrayList<RecipientAddress> addresses = new ArrayList<RecipientAddress>();
            if (node.isArray()) {
                for (JsonNode recipient : node) {
                    String recipientName = recipient.get("name").asText();
                    ServiceId.ACI serviceId = ServiceId.ACI.parseOrThrow((String)recipient.get("uuid").asText());
                    addresses.add(new RecipientAddress(serviceId, recipientName));
                }
            }
            return addresses;
        }
    }
}

