/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.recipients;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.asamk.signal.manager.storage.Database;
import org.asamk.signal.manager.storage.Utils;

public class CdsiStore {
    private static final String TABLE_CDSI = "cdsi";
    private final Database database;

    public static void createSql(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE cdsi (\n  _id INTEGER PRIMARY KEY,\n  number TEXT NOT NULL UNIQUE,\n  last_seen_at INTEGER NOT NULL\n) STRICT;\n");
        }
    }

    public CdsiStore(Database database) {
        this.database = database;
    }

    public Set<String> getAllNumbers() {
        Set<String> set;
        block8: {
            Connection connection = this.database.getConnection();
            try {
                set = CdsiStore.getAllNumbers(connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed read from cdsi store", e);
                }
            }
            connection.close();
        }
        return set;
    }

    public void updateAfterFullCdsQuery(final Set<String> fullNumbers, Set<String> seenNumbers) {
        long lastSeen = System.currentTimeMillis();
        try (Connection connection = this.database.getConnection();){
            final Set<String> existingNumbers = CdsiStore.getAllNumbers(connection);
            HashSet<String> removedNumbers = new HashSet<String>(this, existingNumbers){
                final /* synthetic */ CdsiStore this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.removeAll(fullNumbers);
                }
            };
            CdsiStore.removeNumbers(connection, (Set<String>)removedNumbers);
            HashSet<String> addedNumbers = new HashSet<String>(this, fullNumbers){
                final /* synthetic */ CdsiStore this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.removeAll(existingNumbers);
                }
            };
            CdsiStore.addNumbers(connection, (Set<String>)addedNumbers, lastSeen);
            CdsiStore.updateLastSeen(connection, seenNumbers, lastSeen);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update cdsi store", e);
        }
    }

    public void updateAfterPartialCdsQuery(Set<String> seenNumbers) {
        long lastSeen = System.currentTimeMillis();
        try (Connection connection = this.database.getConnection();){
            CdsiStore.updateLastSeen(connection, seenNumbers, lastSeen);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update cdsi store", e);
        }
    }

    private static Set<String> getAllNumbers(Connection connection) throws SQLException {
        String sql = "SELECT c.number\nFROM %s c\n".formatted(TABLE_CDSI);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            Set<String> set;
            block12: {
                Stream<String> result = Utils.executeQueryForStream(statement, r -> r.getString("number"));
                try {
                    set = result.collect(Collectors.toSet());
                    if (result == null) break block12;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return set;
        }
    }

    private static void removeNumbers(Connection connection, Set<String> numbers) throws SQLException {
        String sql = "DELETE FROM %s\nWHERE number = ?\n".formatted(TABLE_CDSI);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            for (String number : numbers) {
                statement.setString(1, number);
                statement.executeUpdate();
            }
        }
    }

    private static void addNumbers(Connection connection, Set<String> numbers, long lastSeen) throws SQLException {
        String sql = "INSERT INTO %s (number, last_seen_at)\nVALUES (?, ?)\nON CONFLICT (number) DO UPDATE SET last_seen_at = excluded.last_seen_at\n".formatted(TABLE_CDSI);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            for (String number : numbers) {
                statement.setString(1, number);
                statement.setLong(2, lastSeen);
                statement.executeUpdate();
            }
        }
    }

    private static void updateLastSeen(Connection connection, Set<String> numbers, long lastSeen) throws SQLException {
        String sql = "UPDATE %s\nSET last_seen_at = ?\nWHERE number = ?\n".formatted(TABLE_CDSI);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            for (String number : numbers) {
                statement.setLong(1, lastSeen);
                statement.setString(2, number);
                statement.executeUpdate();
            }
        }
    }

    public void clearAll() {
        String sql = "DELETE FROM %s\n".formatted(TABLE_CDSI);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update cdsi store", e);
        }
    }
}

