/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.protocol;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyIdException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.ReusedBaseKeyException;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.groups.state.SenderKeyRecord;
import org.signal.libsignal.protocol.state.IdentityKeyStore;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.signal.libsignal.protocol.state.PreKeyRecord;
import org.signal.libsignal.protocol.state.SessionRecord;
import org.signal.libsignal.protocol.state.SignedPreKeyRecord;
import org.signal.libsignal.protocol.state.SignedPreKeyStore;
import org.whispersystems.signalservice.api.SignalServiceAccountDataStore;
import org.whispersystems.signalservice.api.SignalServiceKyberPreKeyStore;
import org.whispersystems.signalservice.api.SignalServicePreKeyStore;
import org.whispersystems.signalservice.api.SignalServiceSenderKeyStore;
import org.whispersystems.signalservice.api.SignalServiceSessionStore;
import org.whispersystems.signalservice.api.push.DistributionId;

public class SignalProtocolStore
implements SignalServiceAccountDataStore {
    private final SignalServicePreKeyStore preKeyStore;
    private final SignedPreKeyStore signedPreKeyStore;
    private final SignalServiceKyberPreKeyStore kyberPreKeyStore;
    private final SignalServiceSessionStore sessionStore;
    private final IdentityKeyStore identityKeyStore;
    private final SignalServiceSenderKeyStore senderKeyStore;
    private final Supplier<Boolean> isMultiDevice;

    public SignalProtocolStore(SignalServicePreKeyStore preKeyStore, SignedPreKeyStore signedPreKeyStore, SignalServiceKyberPreKeyStore kyberPreKeyStore, SignalServiceSessionStore sessionStore, IdentityKeyStore identityKeyStore, SignalServiceSenderKeyStore senderKeyStore, Supplier<Boolean> isMultiDevice) {
        this.preKeyStore = preKeyStore;
        this.signedPreKeyStore = signedPreKeyStore;
        this.kyberPreKeyStore = kyberPreKeyStore;
        this.sessionStore = sessionStore;
        this.identityKeyStore = identityKeyStore;
        this.senderKeyStore = senderKeyStore;
        this.isMultiDevice = isMultiDevice;
    }

    public IdentityKeyPair getIdentityKeyPair() {
        return this.identityKeyStore.getIdentityKeyPair();
    }

    public int getLocalRegistrationId() {
        return this.identityKeyStore.getLocalRegistrationId();
    }

    public IdentityKeyStore.IdentityChange saveIdentity(SignalProtocolAddress address, IdentityKey identityKey) {
        return this.identityKeyStore.saveIdentity(address, identityKey);
    }

    public boolean isTrustedIdentity(SignalProtocolAddress address, IdentityKey identityKey, IdentityKeyStore.Direction direction) {
        return this.identityKeyStore.isTrustedIdentity(address, identityKey, direction);
    }

    public IdentityKey getIdentity(SignalProtocolAddress address) {
        return this.identityKeyStore.getIdentity(address);
    }

    public PreKeyRecord loadPreKey(int preKeyId) throws InvalidKeyIdException {
        return this.preKeyStore.loadPreKey(preKeyId);
    }

    public void storePreKey(int preKeyId, PreKeyRecord record) {
        this.preKeyStore.storePreKey(preKeyId, record);
    }

    public boolean containsPreKey(int preKeyId) {
        return this.preKeyStore.containsPreKey(preKeyId);
    }

    public void removePreKey(int preKeyId) {
        this.preKeyStore.removePreKey(preKeyId);
    }

    public SessionRecord loadSession(SignalProtocolAddress address) {
        return this.sessionStore.loadSession(address);
    }

    public List<SessionRecord> loadExistingSessions(List<SignalProtocolAddress> addresses) throws NoSessionException {
        return this.sessionStore.loadExistingSessions(addresses);
    }

    public List<Integer> getSubDeviceSessions(String name) {
        return this.sessionStore.getSubDeviceSessions(name);
    }

    public void storeSession(SignalProtocolAddress address, SessionRecord record) {
        this.sessionStore.storeSession(address, record);
    }

    public boolean containsSession(SignalProtocolAddress address) {
        return this.sessionStore.containsSession(address);
    }

    public void deleteSession(SignalProtocolAddress address) {
        this.sessionStore.deleteSession(address);
    }

    public void deleteAllSessions(String name) {
        this.sessionStore.deleteAllSessions(name);
    }

    public void archiveSession(SignalProtocolAddress address) {
        this.sessionStore.archiveSession(address);
        this.senderKeyStore.clearSenderKeySharedWith(List.of(address));
    }

    public Map<SignalProtocolAddress, SessionRecord> getAllAddressesWithActiveSessions(List<String> addressNames) {
        return this.sessionStore.getAllAddressesWithActiveSessions(addressNames);
    }

    public SignedPreKeyRecord loadSignedPreKey(int signedPreKeyId) throws InvalidKeyIdException {
        return this.signedPreKeyStore.loadSignedPreKey(signedPreKeyId);
    }

    public List<SignedPreKeyRecord> loadSignedPreKeys() {
        return this.signedPreKeyStore.loadSignedPreKeys();
    }

    public void storeSignedPreKey(int signedPreKeyId, SignedPreKeyRecord record) {
        this.signedPreKeyStore.storeSignedPreKey(signedPreKeyId, record);
    }

    public boolean containsSignedPreKey(int signedPreKeyId) {
        return this.signedPreKeyStore.containsSignedPreKey(signedPreKeyId);
    }

    public void removeSignedPreKey(int signedPreKeyId) {
        this.signedPreKeyStore.removeSignedPreKey(signedPreKeyId);
    }

    public void storeSenderKey(SignalProtocolAddress sender, UUID distributionId, SenderKeyRecord record) {
        this.senderKeyStore.storeSenderKey(sender, distributionId, record);
    }

    public SenderKeyRecord loadSenderKey(SignalProtocolAddress sender, UUID distributionId) {
        return this.senderKeyStore.loadSenderKey(sender, distributionId);
    }

    public Set<SignalProtocolAddress> getSenderKeySharedWith(DistributionId distributionId) {
        return this.senderKeyStore.getSenderKeySharedWith(distributionId);
    }

    public void markSenderKeySharedWith(DistributionId distributionId, Collection<SignalProtocolAddress> addresses) {
        this.senderKeyStore.markSenderKeySharedWith(distributionId, addresses);
    }

    public void clearSenderKeySharedWith(Collection<SignalProtocolAddress> addresses) {
        this.senderKeyStore.clearSenderKeySharedWith(addresses);
    }

    public boolean isMultiDevice() {
        return this.isMultiDevice.get();
    }

    public KyberPreKeyRecord loadKyberPreKey(int kyberPreKeyId) throws InvalidKeyIdException {
        return this.kyberPreKeyStore.loadKyberPreKey(kyberPreKeyId);
    }

    public List<KyberPreKeyRecord> loadKyberPreKeys() {
        return this.kyberPreKeyStore.loadKyberPreKeys();
    }

    public void storeKyberPreKey(int kyberPreKeyId, KyberPreKeyRecord record) {
        this.kyberPreKeyStore.storeKyberPreKey(kyberPreKeyId, record);
    }

    public boolean containsKyberPreKey(int kyberPreKeyId) {
        return this.kyberPreKeyStore.containsKyberPreKey(kyberPreKeyId);
    }

    public void markKyberPreKeyUsed(int kyberPreKeyId, int signedPreKeyId, ECPublicKey baseKey) throws ReusedBaseKeyException {
        this.kyberPreKeyStore.markKyberPreKeyUsed(kyberPreKeyId, signedPreKeyId, baseKey);
    }

    public List<KyberPreKeyRecord> loadLastResortKyberPreKeys() {
        return this.kyberPreKeyStore.loadLastResortKyberPreKeys();
    }

    public void removeKyberPreKey(int i) {
        this.kyberPreKeyStore.removeKyberPreKey(i);
    }

    public void storeLastResortKyberPreKey(int i, KyberPreKeyRecord kyberPreKeyRecord) {
        this.kyberPreKeyStore.storeLastResortKyberPreKey(i, kyberPreKeyRecord);
    }

    public void deleteAllStaleOneTimeKyberPreKeys(long threshold, int minCount) {
        this.kyberPreKeyStore.deleteAllStaleOneTimeKyberPreKeys(threshold, minCount);
    }

    public void markAllOneTimeKyberPreKeysStaleIfNecessary(long staleTime) {
        this.kyberPreKeyStore.markAllOneTimeKyberPreKeysStaleIfNecessary(staleTime);
    }

    public void deleteAllStaleOneTimeEcPreKeys(long threshold, int minCount) {
        this.preKeyStore.deleteAllStaleOneTimeEcPreKeys(threshold, minCount);
    }

    public void markAllOneTimeEcPreKeysStaleIfNecessary(long staleTime) {
        this.preKeyStore.markAllOneTimeEcPreKeysStaleIfNecessary(staleTime);
    }
}

