/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.prekeys;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.asamk.signal.manager.config.ServiceConfig;
import org.asamk.signal.manager.storage.Database;
import org.asamk.signal.manager.storage.Utils;
import org.signal.libsignal.protocol.InvalidKeyIdException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.ReusedBaseKeyException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.SignalServiceKyberPreKeyStore;
import org.whispersystems.signalservice.api.push.ServiceIdType;

public class KyberPreKeyStore
implements SignalServiceKyberPreKeyStore {
    private static final String TABLE_KYBER_PRE_KEY = "kyber_pre_key";
    private static final Logger logger = LoggerFactory.getLogger(KyberPreKeyStore.class);
    private final Database database;
    private final int accountIdType;

    public static void createSql(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE kyber_pre_key (\n  _id INTEGER PRIMARY KEY,\n  account_id_type INTEGER NOT NULL,\n  key_id INTEGER NOT NULL,\n  serialized BLOB NOT NULL,\n  is_last_resort INTEGER NOT NULL,\n  stale_timestamp INTEGER,\n  timestamp INTEGER DEFAULT 0,\n  UNIQUE(account_id_type, key_id)\n) STRICT;\n");
        }
    }

    public KyberPreKeyStore(Database database, ServiceIdType serviceIdType) {
        this.database = database;
        this.accountIdType = Utils.getAccountIdType(serviceIdType);
    }

    public KyberPreKeyRecord loadKyberPreKey(int keyId) throws InvalidKeyIdException {
        KyberPreKeyRecord kyberPreKey = this.getPreKey(keyId);
        if (kyberPreKey == null) {
            throw new InvalidKeyIdException("No such kyber pre key record: " + keyId);
        }
        return kyberPreKey;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<KyberPreKeyRecord> loadKyberPreKeys() {
        String sql = "SELECT p.serialized\nFROM %s p\nWHERE p.account_id_type = ?\n".formatted(TABLE_KYBER_PRE_KEY);
        try (Connection connection = this.database.getConnection();){
            List<KyberPreKeyRecord> list;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setInt(1, this.accountIdType);
                    list = Utils.executeQueryForStream(statement, this::getKyberPreKeyRecordFromResultSet).toList();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from kyber_pre_key store", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<KyberPreKeyRecord> loadLastResortKyberPreKeys() {
        String sql = "SELECT p.serialized\nFROM %s p\nWHERE p.account_id_type = ? AND p.is_last_resort = TRUE\n".formatted(TABLE_KYBER_PRE_KEY);
        try (Connection connection = this.database.getConnection();){
            List<KyberPreKeyRecord> list;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setInt(1, this.accountIdType);
                    list = Utils.executeQueryForStream(statement, this::getKyberPreKeyRecordFromResultSet).toList();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from kyber_pre_key store", e);
        }
    }

    public void storeLastResortKyberPreKey(int keyId, KyberPreKeyRecord record) {
        this.storeKyberPreKey(keyId, record, true);
    }

    public void storeKyberPreKey(int keyId, KyberPreKeyRecord record) {
        this.storeKyberPreKey(keyId, record, false);
    }

    public void storeKyberPreKey(int keyId, KyberPreKeyRecord record, boolean isLastResort) {
        String sql = "INSERT INTO %s (account_id_type, key_id, serialized, is_last_resort, timestamp)\nVALUES (?, ?, ?, ?, ?)\n".formatted(TABLE_KYBER_PRE_KEY);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, this.accountIdType);
            statement.setInt(2, keyId);
            statement.setBytes(3, record.serialize());
            statement.setBoolean(4, isLastResort);
            statement.setLong(5, record.getTimestamp());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update kyber_pre_key store", e);
        }
    }

    public boolean containsKyberPreKey(int keyId) {
        return this.getPreKey(keyId) != null;
    }

    public void markKyberPreKeyUsed(int kyberPreKeyId, int signedPreKeyId, ECPublicKey baseKey) throws ReusedBaseKeyException {
        String sql = "DELETE FROM %s AS p\nWHERE p.account_id_type = ? AND p.key_id = ? AND p.is_last_resort = FALSE\n".formatted(TABLE_KYBER_PRE_KEY);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, this.accountIdType);
            statement.setInt(2, kyberPreKeyId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update kyber_pre_key store", e);
        }
    }

    public void removeKyberPreKey(int keyId) {
        String sql = "DELETE FROM %s AS p\nWHERE p.account_id_type = ? AND p.key_id = ?\n".formatted(TABLE_KYBER_PRE_KEY);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, this.accountIdType);
            statement.setInt(2, keyId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update kyber_pre_key store", e);
        }
    }

    public void removeAllKyberPreKeys() {
        String sql = "DELETE FROM %s AS p\nWHERE p.account_id_type = ?\n".formatted(TABLE_KYBER_PRE_KEY);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, this.accountIdType);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update kyber_pre_key store", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private KyberPreKeyRecord getPreKey(int keyId) {
        String sql = "SELECT p.serialized\nFROM %s p\nWHERE p.account_id_type = ? AND p.key_id = ?\n".formatted(TABLE_KYBER_PRE_KEY);
        try (Connection connection = this.database.getConnection();){
            KyberPreKeyRecord kyberPreKeyRecord;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setInt(1, this.accountIdType);
                    statement.setInt(2, keyId);
                    kyberPreKeyRecord = Utils.executeQueryForOptional(statement, this::getKyberPreKeyRecordFromResultSet).orElse(null);
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return kyberPreKeyRecord;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from kyber_pre_key store", e);
        }
    }

    private KyberPreKeyRecord getKyberPreKeyRecordFromResultSet(ResultSet resultSet) throws SQLException {
        try {
            byte[] serialized = resultSet.getBytes("serialized");
            return new KyberPreKeyRecord(serialized);
        }
        catch (InvalidMessageException e) {
            return null;
        }
    }

    public void removeOldLastResortKyberPreKeys(int activeLastResortKyberPreKeyId) {
        String sql = "DELETE FROM %s AS p\nWHERE p._id IN (\n    SELECT p._id\n    FROM %s AS p\n    WHERE p.account_id_type = ?\n        AND p.is_last_resort = TRUE\n        AND p.key_id != ?\n        AND p.timestamp < ?\n    ORDER BY p.timestamp DESC\n    LIMIT -1 OFFSET 1\n)\n".formatted(TABLE_KYBER_PRE_KEY, TABLE_KYBER_PRE_KEY);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, this.accountIdType);
            statement.setInt(2, activeLastResortKyberPreKeyId);
            statement.setLong(3, System.currentTimeMillis() - ServiceConfig.PREKEY_ARCHIVE_AGE);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update kyber_pre_key store", e);
        }
    }

    public void deleteAllStaleOneTimeKyberPreKeys(long threshold, int minCount) {
        String sql = "DELETE FROM %s AS p\nWHERE p.account_id_type = ?1\n    AND p.stale_timestamp < ?2\n    AND p.is_last_resort = FALSE\n    AND p._id NOT IN (\n        SELECT _id\n        FROM %s p2\n        WHERE p2.account_id_type = ?1\n        ORDER BY\n          CASE WHEN p2.stale_timestamp IS NULL THEN 1 ELSE 0 END DESC,\n          p2.stale_timestamp DESC,\n          p2._id DESC\n        LIMIT ?3\n    )\n".formatted(TABLE_KYBER_PRE_KEY, TABLE_KYBER_PRE_KEY);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setInt(1, this.accountIdType);
            statement.setLong(2, threshold);
            statement.setInt(3, minCount);
            int rowCount = statement.executeUpdate();
            if (rowCount > 0) {
                logger.debug("Deleted {} stale one time kyber pre keys", (Object)rowCount);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update kyber_pre_key store", e);
        }
    }

    public void markAllOneTimeKyberPreKeysStaleIfNecessary(long staleTime) {
        String sql = "UPDATE %s\nSET stale_timestamp = ?\nWHERE account_id_type = ? AND stale_timestamp IS NULL AND is_last_resort = FALSE\n".formatted(TABLE_KYBER_PRE_KEY);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, staleTime);
            statement.setInt(2, this.accountIdType);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update kyber_pre_key store", e);
        }
    }
}

