/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.keyValue;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Objects;
import org.asamk.signal.manager.storage.Database;
import org.asamk.signal.manager.storage.Utils;
import org.asamk.signal.manager.storage.keyValue.KeyValueEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueStore {
    private static final String TABLE_KEY_VALUE = "key_value";
    private static final Logger logger = LoggerFactory.getLogger(KeyValueStore.class);
    private final Database database;
    private final HashMap<KeyValueEntry<?>, Object> cache = new HashMap();

    public static void createSql(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE key_value (\n  _id INTEGER PRIMARY KEY,\n  key TEXT UNIQUE NOT NULL,\n  value ANY\n) STRICT;\n");
        }
    }

    public KeyValueStore(Database database) {
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getEntry(KeyValueEntry<T> key) {
        HashMap<KeyValueEntry<?>, Object> hashMap = this.cache;
        synchronized (hashMap) {
            if (this.cache.containsKey(key)) {
                return (T)this.cache.get(key);
            }
        }
        try (Connection connection = this.database.getConnection();){
            T t = this.getEntry(connection, key);
            return t;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from key_value store", e);
        }
    }

    public <T> boolean storeEntry(KeyValueEntry<T> key, T value) {
        boolean bl;
        block8: {
            Connection connection = this.database.getConnection();
            try {
                bl = this.storeEntry(connection, key, value);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed update key_value store", e);
                }
            }
            connection.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getEntry(Connection connection, KeyValueEntry<T> key) throws SQLException {
        String sql = "SELECT key, value\nFROM %s p\nWHERE p.key = ?\n".formatted(TABLE_KEY_VALUE);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, key.key());
            Object result = Utils.executeQueryForOptional(statement, resultSet -> KeyValueStore.readValueFromResultSet(key, resultSet)).orElse(null);
            if (result == null) {
                logger.trace("Got entry for key {} from default value", (Object)key.key());
                result = key.defaultValue();
            } else {
                logger.trace("Got entry for key {} from db", (Object)key.key());
            }
            HashMap<KeyValueEntry<?>, Object> hashMap = this.cache;
            synchronized (hashMap) {
                this.cache.put(key, result);
            }
            hashMap = result;
            return (T)hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean storeEntry(Connection connection, KeyValueEntry<T> key, T value) throws SQLException {
        T entry = this.getEntry(connection, key);
        if (Objects.equals(entry, value)) {
            return false;
        }
        String sql = "INSERT INTO %s (key, value)\nVALUES (?1, ?2)\nON CONFLICT (key) DO UPDATE SET value=excluded.value\n".formatted(TABLE_KEY_VALUE);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, key.key());
            KeyValueStore.setParameterValue(statement, 2, key.clazz(), value);
            statement.executeUpdate();
        }
        HashMap<KeyValueEntry<?>, Object> hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(key, value);
        }
        return true;
    }

    private static <T> T readValueFromResultSet(KeyValueEntry<T> key, ResultSet resultSet) throws SQLException {
        Object value;
        Class<T> clazz = key.clazz();
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            value = resultSet.getInt("value");
        } else if (clazz == Long.TYPE || clazz == Long.class) {
            value = resultSet.getLong("value");
        } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            value = resultSet.getBoolean("value");
        } else if (clazz == byte[].class || clazz == Byte[].class) {
            value = resultSet.getBytes("value");
        } else if (clazz == String.class) {
            value = resultSet.getString("value");
        } else if (Enum.class.isAssignableFrom(clazz)) {
            String name = resultSet.getString("value");
            if (name == null) {
                value = null;
            } else {
                try {
                    value = Enum.valueOf(key.clazz(), name);
                }
                catch (IllegalArgumentException e) {
                    logger.debug("Read invalid enum value from store, ignoring: {} for {}", (Object)name, key.clazz());
                    value = null;
                }
            }
        } else {
            throw new AssertionError((Object)("Invalid key type " + clazz.getSimpleName()));
        }
        if (resultSet.wasNull()) {
            return null;
        }
        return (T)value;
    }

    private static <T> void setParameterValue(PreparedStatement statement, int parameterIndex, Class<T> clazz, T value) throws SQLException {
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (value == null) {
                statement.setNull(parameterIndex, 4);
            } else {
                statement.setInt(parameterIndex, (Integer)value);
            }
        } else if (clazz == Long.TYPE || clazz == Long.class) {
            if (value == null) {
                statement.setNull(parameterIndex, 4);
            } else {
                statement.setLong(parameterIndex, (Long)value);
            }
        } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if (value == null) {
                statement.setNull(parameterIndex, 16);
            } else {
                statement.setBoolean(parameterIndex, (Boolean)value);
            }
        } else if (clazz == byte[].class || clazz == Byte[].class) {
            if (value == null) {
                statement.setNull(parameterIndex, 2004);
            } else {
                statement.setBytes(parameterIndex, (byte[])value);
            }
        } else if (clazz == String.class) {
            if (value == null) {
                statement.setNull(parameterIndex, 12);
            } else {
                statement.setString(parameterIndex, (String)value);
            }
        } else if (Enum.class.isAssignableFrom(clazz)) {
            if (value == null) {
                statement.setNull(parameterIndex, 12);
            } else {
                statement.setString(parameterIndex, ((Enum)value).name());
            }
        } else {
            throw new AssertionError((Object)("Invalid key type " + clazz.getSimpleName()));
        }
    }
}

