/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.identities;

import org.asamk.signal.manager.api.TrustLevel;
import org.signal.core.models.ServiceId;
import org.signal.libsignal.protocol.IdentityKey;

public class IdentityInfo {
    private final String address;
    private final IdentityKey identityKey;
    private final TrustLevel trustLevel;
    private final long addedTimestamp;

    IdentityInfo(String address, IdentityKey identityKey, TrustLevel trustLevel, long addedTimestamp) {
        this.address = address;
        this.identityKey = identityKey;
        this.trustLevel = trustLevel;
        this.addedTimestamp = addedTimestamp;
    }

    public ServiceId getServiceId() {
        return ServiceId.parseOrThrow((String)this.address);
    }

    public String getAddress() {
        return this.address;
    }

    public IdentityKey getIdentityKey() {
        return this.identityKey;
    }

    public TrustLevel getTrustLevel() {
        return this.trustLevel;
    }

    boolean isTrusted() {
        return this.trustLevel == TrustLevel.TRUSTED_UNVERIFIED || this.trustLevel == TrustLevel.TRUSTED_VERIFIED;
    }

    public long getDateAddedTimestamp() {
        return this.addedTimestamp;
    }
}

