/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.groups;

import java.util.Set;
import java.util.stream.Collectors;
import okio.ByteString;
import org.asamk.signal.manager.api.GroupIdV2;
import org.asamk.signal.manager.api.GroupInviteLinkUrl;
import org.asamk.signal.manager.api.GroupPermission;
import org.asamk.signal.manager.storage.groups.GroupInfo;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.recipients.RecipientResolver;
import org.signal.core.models.ServiceId;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.storageservice.storage.protos.groups.AccessControl;
import org.signal.storageservice.storage.protos.groups.Member;
import org.signal.storageservice.storage.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.storage.protos.groups.local.EnabledState;
import org.whispersystems.signalservice.api.push.DistributionId;

public final class GroupInfoV2
extends GroupInfo {
    private final GroupIdV2 groupId;
    private final GroupMasterKey masterKey;
    private final DistributionId distributionId;
    private boolean blocked;
    private boolean profileSharingEnabled;
    private DecryptedGroup group;
    private byte[] storageRecord;
    private boolean permissionDenied;
    private final RecipientResolver recipientResolver;

    public GroupInfoV2(GroupIdV2 groupId, GroupMasterKey masterKey, RecipientResolver recipientResolver) {
        this.groupId = groupId;
        this.masterKey = masterKey;
        this.distributionId = DistributionId.create();
        this.recipientResolver = recipientResolver;
    }

    public GroupInfoV2(GroupIdV2 groupId, GroupMasterKey masterKey, DecryptedGroup group, DistributionId distributionId, boolean blocked, boolean profileSharingEnabled, boolean permissionDenied, byte[] storageRecord, RecipientResolver recipientResolver) {
        this.groupId = groupId;
        this.masterKey = masterKey;
        this.group = group;
        this.distributionId = distributionId;
        this.blocked = blocked;
        this.profileSharingEnabled = profileSharingEnabled;
        this.permissionDenied = permissionDenied;
        this.storageRecord = storageRecord;
        this.recipientResolver = recipientResolver;
    }

    @Override
    public GroupIdV2 getGroupId() {
        return this.groupId;
    }

    public GroupMasterKey getMasterKey() {
        return this.masterKey;
    }

    public byte[] getStorageRecord() {
        return this.storageRecord;
    }

    @Override
    public DistributionId getDistributionId() {
        return this.distributionId;
    }

    public void setGroup(DecryptedGroup group) {
        if (group != null) {
            this.permissionDenied = false;
        }
        this.group = group;
    }

    public DecryptedGroup getGroup() {
        return this.group;
    }

    @Override
    public String getTitle() {
        if (this.group == null) {
            return null;
        }
        return this.group.title;
    }

    @Override
    public String getDescription() {
        if (this.group == null) {
            return null;
        }
        return this.group.description;
    }

    @Override
    public GroupInviteLinkUrl getGroupInviteLink() {
        if (this.group == null || this.group.inviteLinkPassword.toByteArray().length == 0 || this.group.accessControl != null && this.group.accessControl.addFromInviteLink != AccessControl.AccessRequired.ANY && this.group.accessControl.addFromInviteLink != AccessControl.AccessRequired.ADMINISTRATOR) {
            return null;
        }
        return GroupInviteLinkUrl.forGroup(this.masterKey, this.group);
    }

    @Override
    public Set<RecipientId> getMembers() {
        if (this.group == null) {
            return Set.of();
        }
        return this.group.members.stream().map(m -> ServiceId.parseOrThrow((ByteString)m.aciBytes)).map(this.recipientResolver::resolveRecipient).collect(Collectors.toSet());
    }

    @Override
    public Set<RecipientId> getBannedMembers() {
        if (this.group == null) {
            return Set.of();
        }
        return this.group.bannedMembers.stream().map(m -> ServiceId.parseOrThrow((ByteString)m.serviceIdBytes)).map(this.recipientResolver::resolveRecipient).collect(Collectors.toSet());
    }

    @Override
    public Set<RecipientId> getPendingMembers() {
        if (this.group == null) {
            return Set.of();
        }
        return this.group.pendingMembers.stream().map(m -> ServiceId.parseOrThrow((ByteString)m.serviceIdBytes)).map(this.recipientResolver::resolveRecipient).collect(Collectors.toSet());
    }

    @Override
    public Set<RecipientId> getRequestingMembers() {
        if (this.group == null) {
            return Set.of();
        }
        return this.group.requestingMembers.stream().map(m -> ServiceId.parseOrThrow((ByteString)m.aciBytes)).map(this.recipientResolver::resolveRecipient).collect(Collectors.toSet());
    }

    @Override
    public Set<RecipientId> getAdminMembers() {
        if (this.group == null) {
            return Set.of();
        }
        return this.group.members.stream().filter(m -> m.role == Member.Role.ADMINISTRATOR).map(m -> new RecipientAddress(ServiceId.ACI.parseOrNull((ByteString)m.aciBytes), ServiceId.PNI.parseOrNull((ByteString)m.pniBytes), null)).map(this.recipientResolver::resolveRecipient).collect(Collectors.toSet());
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    @Override
    public boolean isProfileSharingEnabled() {
        return this.profileSharingEnabled;
    }

    @Override
    public void setProfileSharingEnabled(boolean profileSharingEnabled) {
        this.profileSharingEnabled = profileSharingEnabled;
    }

    @Override
    public int getMessageExpirationTimer() {
        return this.group != null && this.group.disappearingMessagesTimer != null ? this.group.disappearingMessagesTimer.duration : 0;
    }

    @Override
    public boolean isAnnouncementGroup() {
        return this.group != null && this.group.isAnnouncementGroup == EnabledState.ENABLED;
    }

    @Override
    public GroupPermission getPermissionAddMember() {
        AccessControl accessControl = this.getAccessControl();
        return accessControl == null ? GroupPermission.EVERY_MEMBER : GroupInfoV2.toGroupPermission(accessControl.members);
    }

    @Override
    public GroupPermission getPermissionEditDetails() {
        AccessControl accessControl = this.getAccessControl();
        return accessControl == null ? GroupPermission.EVERY_MEMBER : GroupInfoV2.toGroupPermission(accessControl.attributes);
    }

    @Override
    public GroupPermission getPermissionSendMessage() {
        return this.isAnnouncementGroup() ? GroupPermission.ONLY_ADMINS : GroupPermission.EVERY_MEMBER;
    }

    public void setPermissionDenied(boolean permissionDenied) {
        this.permissionDenied = permissionDenied;
    }

    public boolean isPermissionDenied() {
        return this.permissionDenied;
    }

    private AccessControl getAccessControl() {
        if (this.group == null || this.group.accessControl == null) {
            return null;
        }
        return this.group.accessControl;
    }

    private static GroupPermission toGroupPermission(AccessControl.AccessRequired permission) {
        return switch (permission) {
            case AccessControl.AccessRequired.ADMINISTRATOR -> GroupPermission.ONLY_ADMINS;
            default -> GroupPermission.EVERY_MEMBER;
        };
    }
}

