/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.asamk.signal.manager.Settings;
import org.asamk.signal.manager.api.Contact;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.Profile;
import org.asamk.signal.manager.api.ServiceEnvironment;
import org.asamk.signal.manager.api.TrustLevel;
import org.asamk.signal.manager.config.ServiceConfig;
import org.asamk.signal.manager.helper.RecipientAddressResolver;
import org.asamk.signal.manager.storage.AccountDatabase;
import org.asamk.signal.manager.storage.UnknownStorageIdStore;
import org.asamk.signal.manager.storage.Utils;
import org.asamk.signal.manager.storage.configuration.ConfigurationStore;
import org.asamk.signal.manager.storage.configuration.LegacyConfigurationStore;
import org.asamk.signal.manager.storage.contacts.ContactsStore;
import org.asamk.signal.manager.storage.contacts.LegacyContactInfo;
import org.asamk.signal.manager.storage.contacts.LegacyJsonContactsStore;
import org.asamk.signal.manager.storage.groups.GroupInfo;
import org.asamk.signal.manager.storage.groups.GroupInfoV1;
import org.asamk.signal.manager.storage.groups.GroupStore;
import org.asamk.signal.manager.storage.groups.LegacyGroupStore;
import org.asamk.signal.manager.storage.identities.IdentityKeyStore;
import org.asamk.signal.manager.storage.identities.LegacyIdentityKeyStore;
import org.asamk.signal.manager.storage.identities.SignalIdentityKeyStore;
import org.asamk.signal.manager.storage.keyValue.KeyValueEntry;
import org.asamk.signal.manager.storage.keyValue.KeyValueStore;
import org.asamk.signal.manager.storage.messageCache.MessageCache;
import org.asamk.signal.manager.storage.prekeys.KyberPreKeyStore;
import org.asamk.signal.manager.storage.prekeys.LegacyPreKeyStore;
import org.asamk.signal.manager.storage.prekeys.LegacySignedPreKeyStore;
import org.asamk.signal.manager.storage.prekeys.PreKeyStore;
import org.asamk.signal.manager.storage.prekeys.SignedPreKeyStore;
import org.asamk.signal.manager.storage.profiles.LegacyProfileStore;
import org.asamk.signal.manager.storage.profiles.LegacySignalProfile;
import org.asamk.signal.manager.storage.profiles.LegacySignalProfileEntry;
import org.asamk.signal.manager.storage.profiles.ProfileStore;
import org.asamk.signal.manager.storage.protocol.LegacyIdentityInfo;
import org.asamk.signal.manager.storage.protocol.LegacyJsonSignalProtocolStore;
import org.asamk.signal.manager.storage.protocol.LegacySessionInfo;
import org.asamk.signal.manager.storage.protocol.SignalProtocolStore;
import org.asamk.signal.manager.storage.recipients.CdsiStore;
import org.asamk.signal.manager.storage.recipients.LegacyRecipientStore;
import org.asamk.signal.manager.storage.recipients.LegacyRecipientStore2;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.recipients.RecipientIdCreator;
import org.asamk.signal.manager.storage.recipients.RecipientResolver;
import org.asamk.signal.manager.storage.recipients.RecipientStore;
import org.asamk.signal.manager.storage.recipients.RecipientTrustedResolver;
import org.asamk.signal.manager.storage.sendLog.MessageSendLogStore;
import org.asamk.signal.manager.storage.senderKeys.LegacySenderKeyRecordStore;
import org.asamk.signal.manager.storage.senderKeys.LegacySenderKeySharedStore;
import org.asamk.signal.manager.storage.senderKeys.SenderKeyStore;
import org.asamk.signal.manager.storage.sessions.LegacySessionStore;
import org.asamk.signal.manager.storage.sessions.SessionStore;
import org.asamk.signal.manager.storage.stickers.LegacyStickerStore;
import org.asamk.signal.manager.storage.stickers.StickerStore;
import org.asamk.signal.manager.storage.threads.LegacyJsonThreadStore;
import org.asamk.signal.manager.storage.threads.LegacyThreadInfo;
import org.asamk.signal.manager.util.IOUtils;
import org.asamk.signal.manager.util.KeyUtils;
import org.signal.core.models.AccountEntropyPool;
import org.signal.core.models.MasterKey;
import org.signal.core.models.ServiceId;
import org.signal.core.models.backup.MediaRootBackupKey;
import org.signal.core.models.storageservice.StorageKey;
import org.signal.core.util.UuidUtil;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.signal.libsignal.protocol.state.PreKeyRecord;
import org.signal.libsignal.protocol.state.SessionRecord;
import org.signal.libsignal.protocol.state.SignedPreKeyRecord;
import org.signal.libsignal.protocol.util.KeyHelper;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.SignalServiceAccountDataStore;
import org.whispersystems.signalservice.api.SignalServiceDataStore;
import org.whispersystems.signalservice.api.account.AccountAttributes;
import org.whispersystems.signalservice.api.account.PreKeyCollection;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccess;
import org.whispersystems.signalservice.api.push.ServiceIdType;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.push.UsernameLinkComponents;
import org.whispersystems.signalservice.api.storage.SignalStorageManifest;
import org.whispersystems.signalservice.api.util.CredentialsProvider;

public class SignalAccount
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(SignalAccount.class);
    private static final int MINIMUM_STORAGE_VERSION = 1;
    private static final int CURRENT_STORAGE_VERSION = 10;
    private final Object LOCK = new Object();
    private final ObjectMapper jsonProcessor = Utils.createStorageObjectMapper();
    private final FileChannel fileChannel;
    private final FileLock lock;
    private int previousStorageVersion;
    private File dataPath;
    private String accountPath;
    private ServiceEnvironment serviceEnvironment;
    private String number;
    private String username;
    private UsernameLinkComponents usernameLink;
    private String encryptedDeviceName;
    private int deviceId = 0;
    private String password;
    private String registrationLockPin;
    private MasterKey pinMasterKey;
    private StorageKey storageKey;
    private AccountEntropyPool accountEntropyPool;
    private MediaRootBackupKey mediaRootBackupKey;
    private ProfileKey profileKey;
    private Settings settings;
    private final KeyValueEntry<String> verificationSessionId = new KeyValueEntry<String>("verification-session-id", String.class);
    private final KeyValueEntry<String> verificationSessionNumber = new KeyValueEntry<String>("verification-session-number", String.class);
    private final KeyValueEntry<Long> lastReceiveTimestamp = new KeyValueEntry<Long>("last-receive-timestamp", Long.TYPE, 0L);
    private final KeyValueEntry<Boolean> needsToRetryFailedMessages = new KeyValueEntry<Boolean>("retry-failed-messages", Boolean.class, true);
    private final KeyValueEntry<byte[]> cdsiToken = new KeyValueEntry<byte[]>("cdsi-token", byte[].class);
    private final KeyValueEntry<Long> lastRecipientsRefresh = new KeyValueEntry<Long>("last-recipients-refresh", Long.TYPE);
    private final KeyValueEntry<Long> storageManifestVersion = new KeyValueEntry<Long>("storage-manifest-version", Long.TYPE, -1L);
    private final KeyValueEntry<Boolean> unrestrictedUnidentifiedAccess = new KeyValueEntry<Boolean>("unrestricted-unidentified-access", Boolean.class, false);
    private boolean isMultiDevice = false;
    private boolean registered = false;
    private final AccountData<ServiceId.ACI> aciAccountData = new AccountData(ServiceIdType.ACI);
    private final AccountData<ServiceId.PNI> pniAccountData = new AccountData(ServiceIdType.PNI);
    private IdentityKeyStore identityKeyStore;
    private SenderKeyStore senderKeyStore;
    private GroupStore groupStore;
    private RecipientStore recipientStore;
    private StickerStore stickerStore;
    private UnknownStorageIdStore unknownStorageIdStore;
    private ConfigurationStore configurationStore;
    private KeyValueStore keyValueStore;
    private CdsiStore cdsiStore;
    private MessageCache messageCache;
    private MessageSendLogStore messageSendLogStore;
    private AccountDatabase accountDatabase;
    private RecipientId selfRecipientId;

    private SignalAccount(FileChannel fileChannel, FileLock lock) {
        this.fileChannel = fileChannel;
        this.lock = lock;
    }

    public static SignalAccount load(File dataPath, String accountPath, boolean waitForLock, Settings settings) throws IOException {
        logger.trace("Opening account file");
        File fileName = SignalAccount.getFileName(dataPath, accountPath);
        Pair<FileChannel, FileLock> pair = SignalAccount.openFileChannel(fileName, waitForLock);
        try {
            SignalAccount signalAccount = new SignalAccount(pair.first(), pair.second());
            signalAccount.load(dataPath, accountPath, settings);
            signalAccount.migrateLegacyConfigs();
            signalAccount.init();
            return signalAccount;
        }
        catch (Throwable e) {
            pair.second().close();
            pair.first().close();
            throw e;
        }
    }

    public static SignalAccount create(File dataPath, String accountPath, String number, ServiceEnvironment serviceEnvironment, IdentityKeyPair aciIdentityKey, IdentityKeyPair pniIdentityKey, ProfileKey profileKey, Settings settings) throws IOException {
        IOUtils.createPrivateDirectories(dataPath);
        File fileName = SignalAccount.getFileName(dataPath, accountPath);
        if (!fileName.exists()) {
            IOUtils.createPrivateFile(fileName);
        }
        Pair<FileChannel, FileLock> pair = SignalAccount.openFileChannel(fileName, true);
        SignalAccount signalAccount = new SignalAccount(pair.first(), pair.second());
        signalAccount.accountPath = accountPath;
        signalAccount.number = number;
        signalAccount.serviceEnvironment = serviceEnvironment;
        signalAccount.profileKey = profileKey;
        signalAccount.password = KeyUtils.createPassword();
        signalAccount.deviceId = 1;
        signalAccount.dataPath = dataPath;
        signalAccount.aciAccountData.setIdentityKeyPair(aciIdentityKey);
        signalAccount.pniAccountData.setIdentityKeyPair(pniIdentityKey);
        signalAccount.aciAccountData.setLocalRegistrationId(KeyHelper.generateRegistrationId((boolean)false));
        signalAccount.pniAccountData.setLocalRegistrationId(KeyHelper.generateRegistrationId((boolean)false));
        signalAccount.initAllPreKeyIds();
        signalAccount.settings = settings;
        signalAccount.registered = false;
        signalAccount.previousStorageVersion = 10;
        signalAccount.init();
        signalAccount.save();
        return signalAccount;
    }

    public static SignalAccount createLinkedAccount(File dataPath, String accountPath, ServiceEnvironment serviceEnvironment, Settings settings) throws IOException {
        IOUtils.createPrivateDirectories(dataPath);
        File fileName = SignalAccount.getFileName(dataPath, accountPath);
        IOUtils.createPrivateFile(fileName);
        Pair<FileChannel, FileLock> pair = SignalAccount.openFileChannel(fileName, true);
        SignalAccount signalAccount = new SignalAccount(pair.first(), pair.second());
        signalAccount.dataPath = dataPath;
        signalAccount.accountPath = accountPath;
        signalAccount.serviceEnvironment = serviceEnvironment;
        signalAccount.aciAccountData.setLocalRegistrationId(KeyHelper.generateRegistrationId((boolean)false));
        signalAccount.pniAccountData.setLocalRegistrationId(KeyHelper.generateRegistrationId((boolean)false));
        signalAccount.settings = settings;
        signalAccount.previousStorageVersion = 10;
        return signalAccount;
    }

    public void setProvisioningData(String number, ServiceId.ACI aci, ServiceId.PNI pni, String password, String encryptedDeviceName, IdentityKeyPair aciIdentity, IdentityKeyPair pniIdentity, ProfileKey profileKey, MasterKey masterKey, AccountEntropyPool accountEntropyPool, MediaRootBackupKey mediaRootBackupKey) {
        this.deviceId = 0;
        this.number = number;
        this.aciAccountData.setServiceId(aci);
        this.pniAccountData.setServiceId(pni);
        this.init();
        this.getRecipientTrustedResolver().resolveSelfRecipientTrusted(this.getSelfRecipientAddress());
        this.password = password;
        this.profileKey = profileKey;
        this.encryptedDeviceName = encryptedDeviceName;
        this.aciAccountData.setIdentityKeyPair(aciIdentity);
        this.pniAccountData.setIdentityKeyPair(pniIdentity);
        this.registered = false;
        this.isMultiDevice = true;
        this.setLastReceiveTimestamp(0L);
        if (accountEntropyPool != null) {
            this.pinMasterKey = null;
            this.accountEntropyPool = accountEntropyPool;
        } else {
            this.pinMasterKey = masterKey;
            this.accountEntropyPool = null;
        }
        this.mediaRootBackupKey = mediaRootBackupKey;
        this.getKeyValueStore().storeEntry(this.storageManifestVersion, -1L);
        this.setStorageManifest(null);
        this.storageKey = null;
        this.getSenderKeyStore().deleteAll();
        this.trustSelfIdentity(ServiceIdType.ACI);
        this.trustSelfIdentity(ServiceIdType.PNI);
        this.aciAccountData.getSessionStore().archiveAllSessions();
        this.pniAccountData.getSessionStore().archiveAllSessions();
        this.clearAllPreKeys();
        this.getKeyValueStore().storeEntry(this.lastRecipientsRefresh, null);
        this.save();
    }

    public void finishLinking(int deviceId, PreKeyCollection aciPreKeys, PreKeyCollection pniPreKeys) {
        this.registered = true;
        this.deviceId = deviceId;
        this.setPreKeys(ServiceIdType.ACI, aciPreKeys);
        this.setPreKeys(ServiceIdType.PNI, pniPreKeys);
        this.save();
    }

    public void finishRegistration(ServiceId.ACI aci, ServiceId.PNI pni, MasterKey masterKey, String pin, PreKeyCollection aciPreKeys, PreKeyCollection pniPreKeys) {
        this.pinMasterKey = masterKey;
        this.accountEntropyPool = null;
        this.getKeyValueStore().storeEntry(this.storageManifestVersion, -1L);
        this.setStorageManifest(null);
        this.storageKey = null;
        this.encryptedDeviceName = null;
        this.deviceId = 1;
        this.isMultiDevice = false;
        this.registered = true;
        this.aciAccountData.setServiceId(aci);
        this.pniAccountData.setServiceId(pni);
        this.init();
        this.registrationLockPin = pin;
        this.setLastReceiveTimestamp(0L);
        this.save();
        this.setPreKeys(ServiceIdType.ACI, aciPreKeys);
        this.setPreKeys(ServiceIdType.PNI, pniPreKeys);
        this.aciAccountData.getSessionStore().archiveAllSessions();
        this.pniAccountData.getSessionStore().archiveAllSessions();
        this.getSenderKeyStore().deleteAll();
        this.getRecipientTrustedResolver().resolveSelfRecipientTrusted(this.getSelfRecipientAddress());
        this.trustSelfIdentity(ServiceIdType.ACI);
        this.trustSelfIdentity(ServiceIdType.PNI);
        this.getKeyValueStore().storeEntry(this.lastRecipientsRefresh, null);
        this.clearSessionId();
    }

    public void initDatabase() {
        this.getAccountDatabase();
    }

    private void init() {
        this.selfRecipientId = this.getRecipientTrustedResolver().resolveSelfRecipientTrusted(this.getSelfRecipientAddress());
    }

    private void migrateLegacyConfigs() {
        if (this.isPrimaryDevice() && this.getPniIdentityKeyPair() == null) {
            logger.trace("Migrating legacy parts of account file");
            this.setPniIdentityKeyPair(KeyUtils.generateIdentityKeyPair());
        }
    }

    private void mergeRecipients(Connection connection, RecipientId recipientId, RecipientId toBeMergedRecipientId) throws SQLException {
        this.getMessageCache().mergeRecipients(recipientId, toBeMergedRecipientId);
        this.getGroupStore().mergeRecipients(connection, recipientId, toBeMergedRecipientId);
    }

    public void removeRecipient(RecipientId recipientId) {
        ServiceId.ACI serviceId;
        RecipientAddress recipientAddress = this.getRecipientStore().resolveRecipientAddress(recipientId);
        if (recipientAddress.matches(this.getSelfRecipientAddress())) {
            throw new RuntimeException("Can't delete self recipient");
        }
        this.getRecipientStore().deleteRecipientData(recipientId);
        this.getMessageCache().deleteMessages(recipientId);
        if (recipientAddress.aci().isPresent()) {
            serviceId = recipientAddress.aci().get();
            this.aciAccountData.getSessionStore().deleteAllSessions((ServiceId)serviceId);
            this.pniAccountData.getSessionStore().deleteAllSessions((ServiceId)serviceId);
            this.getIdentityKeyStore().deleteIdentity((ServiceId)serviceId);
            this.getSenderKeyStore().deleteAll((ServiceId)serviceId);
        }
        if (recipientAddress.pni().isPresent()) {
            serviceId = recipientAddress.pni().get();
            this.aciAccountData.getSessionStore().deleteAllSessions((ServiceId)serviceId);
            this.pniAccountData.getSessionStore().deleteAllSessions((ServiceId)serviceId);
            this.getIdentityKeyStore().deleteIdentity((ServiceId)serviceId);
            this.getSenderKeyStore().deleteAll((ServiceId)serviceId);
        }
    }

    public static File getFileName(File dataPath, String account) {
        return new File(dataPath, account);
    }

    private static File getUserPath(File dataPath, String account) {
        File path = new File(dataPath, account + ".d");
        try {
            IOUtils.createPrivateDirectories(path);
        }
        catch (IOException e) {
            throw new AssertionError("Failed to create user path", e);
        }
        return path;
    }

    private static File getMessageCachePath(File dataPath, String account) {
        return new File(SignalAccount.getUserPath(dataPath, account), "msg-cache");
    }

    private static File getStorageManifestFile(File dataPath, String account) {
        return new File(SignalAccount.getUserPath(dataPath, account), "storage-manifest");
    }

    private static File getDatabaseFile(File dataPath, String account) {
        return new File(SignalAccount.getUserPath(dataPath, account), "account.db");
    }

    public static boolean accountFileExists(File dataPath, String account) {
        if (account == null) {
            return false;
        }
        File f = SignalAccount.getFileName(dataPath, account);
        return f.exists() && !f.isDirectory() && f.length() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File dataPath, String accountPath, Settings settings) throws IOException {
        JsonNode rootNode;
        logger.trace("Loading account file {}", (Object)accountPath);
        this.dataPath = dataPath;
        this.accountPath = accountPath;
        this.settings = settings;
        FileChannel fileChannel = this.fileChannel;
        synchronized (fileChannel) {
            this.fileChannel.position(0L);
            rootNode = this.jsonProcessor.readTree(Channels.newInputStream(this.fileChannel));
        }
        boolean migratedLegacyConfig = false;
        if (rootNode.hasNonNull("version")) {
            int accountVersion = rootNode.get("version").asInt(1);
            if (accountVersion > 10) {
                throw new IOException("Config file was created by a more recent version: " + accountVersion);
            }
            if (accountVersion < 1) {
                throw new IOException("Config file was created by a no longer supported older version: " + accountVersion);
            }
            this.previousStorageVersion = accountVersion;
            if (accountVersion < 10) {
                migratedLegacyConfig = true;
            }
        }
        if (this.previousStorageVersion < 8) {
            File userPath = SignalAccount.getUserPath(dataPath, accountPath);
            this.loadLegacyFile(userPath, rootNode);
            migratedLegacyConfig = true;
        } else {
            Storage storage = (Storage)this.jsonProcessor.convertValue((Object)rootNode, Storage.class);
            this.serviceEnvironment = ServiceEnvironment.valueOf(storage.serviceEnvironment);
            this.registered = storage.registered;
            this.number = storage.number;
            this.username = storage.username;
            if ("".equals(this.username)) {
                this.username = null;
            }
            this.encryptedDeviceName = storage.encryptedDeviceName;
            this.deviceId = storage.deviceId;
            this.isMultiDevice = storage.isMultiDevice;
            this.password = storage.password;
            this.setAccountData(this.aciAccountData, storage.aciAccountData, ServiceId.ACI::parseOrThrow);
            this.setAccountData(this.pniAccountData, storage.pniAccountData, ServiceId.PNI::parseOrThrow);
            this.registrationLockPin = storage.registrationLockPin;
            Base64.Decoder base64 = Base64.getDecoder();
            if (storage.pinMasterKey != null) {
                this.pinMasterKey = new MasterKey(base64.decode(storage.pinMasterKey));
            }
            if (storage.storageKey != null) {
                this.storageKey = new StorageKey(base64.decode(storage.storageKey));
            }
            if (storage.accountEntropyPool != null) {
                this.accountEntropyPool = new AccountEntropyPool(storage.accountEntropyPool);
            }
            if (storage.mediaRootBackupKey != null) {
                this.mediaRootBackupKey = new MediaRootBackupKey(base64.decode(storage.mediaRootBackupKey));
            }
            if (storage.profileKey != null) {
                try {
                    this.profileKey = new ProfileKey(base64.decode(storage.profileKey));
                }
                catch (InvalidInputException e) {
                    throw new IOException("Config file contains an invalid profileKey, needs to be base64 encoded array of 32 bytes", e);
                }
            }
            if (storage.usernameLinkEntropy != null && storage.usernameLinkServerId != null) {
                this.usernameLink = new UsernameLinkComponents(base64.decode(storage.usernameLinkEntropy), UUID.fromString(storage.usernameLinkServerId));
            }
        }
        if (migratedLegacyConfig) {
            this.save();
        }
    }

    private <SERVICE_ID extends ServiceId> void setAccountData(AccountData<SERVICE_ID> accountData, Storage.AccountData storage, Function<String, SERVICE_ID> serviceIdParser) throws IOException {
        if (storage.serviceId != null) {
            try {
                accountData.setServiceId((ServiceId)serviceIdParser.apply(storage.serviceId));
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Config file contains an invalid serviceId, needs to be a valid UUID", e);
            }
        }
        accountData.setLocalRegistrationId(storage.registrationId);
        if (storage.identityPrivateKey != null && storage.identityPublicKey != null) {
            Base64.Decoder base64 = Base64.getDecoder();
            byte[] publicKeyBytes = base64.decode(storage.identityPublicKey);
            byte[] privateKeyBytes = base64.decode(storage.identityPrivateKey);
            IdentityKeyPair keyPair = KeyUtils.getIdentityKeyPair(publicKeyBytes, privateKeyBytes);
            accountData.setIdentityKeyPair(keyPair);
        }
        accountData.preKeyMetadata.nextPreKeyId = storage.nextPreKeyId;
        accountData.preKeyMetadata.nextSignedPreKeyId = storage.nextSignedPreKeyId;
        accountData.preKeyMetadata.activeSignedPreKeyId = storage.activeSignedPreKeyId;
        accountData.preKeyMetadata.nextKyberPreKeyId = storage.nextKyberPreKeyId;
        accountData.preKeyMetadata.activeLastResortKyberPreKeyId = storage.activeLastResortKyberPreKeyId;
    }

    private void loadLegacyFile(File userPath, JsonNode rootNode) throws IOException {
        File legacySenderKeysSharedPath;
        LegacyJsonSignalProtocolStore legacySignalProtocolStore;
        File legacyIdentitiesPath;
        File legacySessionsPath;
        File legacyPniSignedPreKeysPath;
        File legacyAciSignedPreKeysPath;
        File legacyPniPreKeysPath;
        File legacyAciPreKeysPath;
        File legacyRecipientsStoreFile;
        byte[] privateKeyBytes;
        byte[] publicKeyBytes;
        this.number = Utils.getNotNullNode(rootNode, "username").asText();
        if (rootNode.hasNonNull("password")) {
            this.password = rootNode.get("password").asText();
        }
        if (this.password == null) {
            this.password = KeyUtils.createPassword();
        }
        if (rootNode.hasNonNull("serviceEnvironment")) {
            this.serviceEnvironment = ServiceEnvironment.valueOf(rootNode.get("serviceEnvironment").asText());
        }
        if (this.serviceEnvironment == null) {
            this.serviceEnvironment = ServiceEnvironment.LIVE;
        }
        this.registered = Utils.getNotNullNode(rootNode, "registered").asBoolean();
        if (rootNode.hasNonNull("usernameIdentifier")) {
            this.username = rootNode.get("usernameIdentifier").asText();
            if ("".equals(this.username)) {
                this.username = null;
            }
        }
        if (rootNode.hasNonNull("uuid")) {
            try {
                this.aciAccountData.setServiceId(ServiceId.ACI.parseOrThrow((String)rootNode.get("uuid").asText()));
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Config file contains an invalid aci/uuid, needs to be a valid UUID", e);
            }
        }
        if (rootNode.hasNonNull("pni")) {
            try {
                this.pniAccountData.setServiceId(ServiceId.PNI.parseOrThrow((String)rootNode.get("pni").asText()));
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Config file contains an invalid pni, needs to be a valid UUID", e);
            }
        }
        if (rootNode.hasNonNull("sessionId")) {
            this.getKeyValueStore().storeEntry(this.verificationSessionId, rootNode.get("sessionId").asText());
        }
        if (rootNode.hasNonNull("sessionNumber")) {
            this.getKeyValueStore().storeEntry(this.verificationSessionNumber, rootNode.get("sessionNumber").asText());
        }
        if (rootNode.hasNonNull("deviceName")) {
            this.encryptedDeviceName = rootNode.get("deviceName").asText();
        }
        if (rootNode.hasNonNull("deviceId")) {
            this.deviceId = rootNode.get("deviceId").asInt();
        }
        if (rootNode.hasNonNull("isMultiDevice")) {
            this.isMultiDevice = rootNode.get("isMultiDevice").asBoolean();
        }
        if (rootNode.hasNonNull("lastReceiveTimestamp")) {
            this.setLastReceiveTimestamp(rootNode.get("lastReceiveTimestamp").asLong());
        }
        int registrationId = 0;
        if (rootNode.hasNonNull("registrationId")) {
            registrationId = rootNode.get("registrationId").asInt();
        }
        if (rootNode.hasNonNull("pniRegistrationId")) {
            this.pniAccountData.setLocalRegistrationId(rootNode.get("pniRegistrationId").asInt());
        } else {
            this.pniAccountData.setLocalRegistrationId(KeyHelper.generateRegistrationId((boolean)false));
        }
        IdentityKeyPair aciIdentityKeyPair = null;
        if (rootNode.hasNonNull("identityPrivateKey") && rootNode.hasNonNull("identityKey")) {
            publicKeyBytes = Base64.getDecoder().decode(rootNode.get("identityKey").asText());
            privateKeyBytes = Base64.getDecoder().decode(rootNode.get("identityPrivateKey").asText());
            aciIdentityKeyPair = KeyUtils.getIdentityKeyPair(publicKeyBytes, privateKeyBytes);
        }
        if (rootNode.hasNonNull("pniIdentityPrivateKey") && rootNode.hasNonNull("pniIdentityKey")) {
            publicKeyBytes = Base64.getDecoder().decode(rootNode.get("pniIdentityKey").asText());
            privateKeyBytes = Base64.getDecoder().decode(rootNode.get("pniIdentityPrivateKey").asText());
            this.pniAccountData.setIdentityKeyPair(KeyUtils.getIdentityKeyPair(publicKeyBytes, privateKeyBytes));
        }
        if (rootNode.hasNonNull("registrationLockPin")) {
            this.registrationLockPin = rootNode.get("registrationLockPin").asText();
        }
        if (rootNode.hasNonNull("pinMasterKey")) {
            this.pinMasterKey = new MasterKey(Base64.getDecoder().decode(rootNode.get("pinMasterKey").asText()));
        }
        if (rootNode.hasNonNull("storageKey")) {
            this.storageKey = new StorageKey(Base64.getDecoder().decode(rootNode.get("storageKey").asText()));
        }
        if (rootNode.hasNonNull("storageManifestVersion")) {
            this.getKeyValueStore().storeEntry(this.storageManifestVersion, rootNode.get("storageManifestVersion").asLong());
        }
        this.aciAccountData.preKeyMetadata.nextPreKeyId = rootNode.hasNonNull("preKeyIdOffset") ? rootNode.get("preKeyIdOffset").asInt(1) : SignalAccount.getRandomPreKeyIdOffset();
        this.aciAccountData.preKeyMetadata.nextSignedPreKeyId = rootNode.hasNonNull("nextSignedPreKeyId") ? rootNode.get("nextSignedPreKeyId").asInt(1) : SignalAccount.getRandomPreKeyIdOffset();
        this.aciAccountData.preKeyMetadata.activeSignedPreKeyId = rootNode.hasNonNull("activeSignedPreKeyId") ? rootNode.get("activeSignedPreKeyId").asInt(-1) : -1;
        this.pniAccountData.preKeyMetadata.nextPreKeyId = rootNode.hasNonNull("pniPreKeyIdOffset") ? rootNode.get("pniPreKeyIdOffset").asInt(1) : SignalAccount.getRandomPreKeyIdOffset();
        this.pniAccountData.preKeyMetadata.nextSignedPreKeyId = rootNode.hasNonNull("pniNextSignedPreKeyId") ? rootNode.get("pniNextSignedPreKeyId").asInt(1) : SignalAccount.getRandomPreKeyIdOffset();
        this.pniAccountData.preKeyMetadata.activeSignedPreKeyId = rootNode.hasNonNull("pniActiveSignedPreKeyId") ? rootNode.get("pniActiveSignedPreKeyId").asInt(-1) : -1;
        this.aciAccountData.preKeyMetadata.nextKyberPreKeyId = rootNode.hasNonNull("kyberPreKeyIdOffset") ? rootNode.get("kyberPreKeyIdOffset").asInt(1) : SignalAccount.getRandomPreKeyIdOffset();
        this.aciAccountData.preKeyMetadata.activeLastResortKyberPreKeyId = rootNode.hasNonNull("activeLastResortKyberPreKeyId") ? rootNode.get("activeLastResortKyberPreKeyId").asInt(-1) : -1;
        this.pniAccountData.preKeyMetadata.nextKyberPreKeyId = rootNode.hasNonNull("pniKyberPreKeyIdOffset") ? rootNode.get("pniKyberPreKeyIdOffset").asInt(1) : SignalAccount.getRandomPreKeyIdOffset();
        this.pniAccountData.preKeyMetadata.activeLastResortKyberPreKeyId = rootNode.hasNonNull("pniActiveLastResortKyberPreKeyId") ? rootNode.get("pniActiveLastResortKyberPreKeyId").asInt(-1) : -1;
        if (rootNode.hasNonNull("profileKey")) {
            try {
                this.profileKey = new ProfileKey(Base64.getDecoder().decode(rootNode.get("profileKey").asText()));
            }
            catch (InvalidInputException e) {
                throw new IOException("Config file contains an invalid profileKey, needs to be base64 encoded array of 32 bytes", e);
            }
        }
        if (this.profileKey == null) {
            this.setProfileKey(KeyUtils.createProfileKey());
        }
        if (this.previousStorageVersion < 5 && (legacyRecipientsStoreFile = new File(userPath, "recipients-store")).exists()) {
            LegacyRecipientStore2.migrate(legacyRecipientsStoreFile, this.getRecipientStore());
        }
        if (this.previousStorageVersion < 6) {
            this.getRecipientTrustedResolver().resolveSelfRecipientTrusted(this.getSelfRecipientAddress());
        }
        if ((legacyAciPreKeysPath = new File(userPath, "pre-keys")).exists()) {
            LegacyPreKeyStore.migrate(legacyAciPreKeysPath, this.aciAccountData.getPreKeyStore());
        }
        if ((legacyPniPreKeysPath = new File(userPath, "pre-keys-pni")).exists()) {
            LegacyPreKeyStore.migrate(legacyPniPreKeysPath, this.pniAccountData.getPreKeyStore());
        }
        if ((legacyAciSignedPreKeysPath = new File(userPath, "signed-pre-keys")).exists()) {
            LegacySignedPreKeyStore.migrate(legacyAciSignedPreKeysPath, this.aciAccountData.getSignedPreKeyStore());
        }
        if ((legacyPniSignedPreKeysPath = new File(userPath, "signed-pre-keys-pni")).exists()) {
            LegacySignedPreKeyStore.migrate(legacyPniSignedPreKeysPath, this.pniAccountData.getSignedPreKeyStore());
        }
        if ((legacySessionsPath = new File(userPath, "sessions")).exists()) {
            LegacySessionStore.migrate(legacySessionsPath, this.getRecipientResolver(), this.getRecipientAddressResolver(), this.aciAccountData.getSessionStore());
        }
        if ((legacyIdentitiesPath = new File(userPath, "identities")).exists()) {
            LegacyIdentityKeyStore.migrate(legacyIdentitiesPath, this.getRecipientResolver(), this.getRecipientAddressResolver(), this.getIdentityKeyStore());
        }
        LegacyJsonSignalProtocolStore legacyJsonSignalProtocolStore = legacySignalProtocolStore = rootNode.hasNonNull("axolotlStore") ? (LegacyJsonSignalProtocolStore)this.jsonProcessor.convertValue((Object)Utils.getNotNullNode(rootNode, "axolotlStore"), LegacyJsonSignalProtocolStore.class) : null;
        if (legacySignalProtocolStore != null && legacySignalProtocolStore.getLegacyIdentityKeyStore() != null) {
            aciIdentityKeyPair = legacySignalProtocolStore.getLegacyIdentityKeyStore().getIdentityKeyPair();
            registrationId = legacySignalProtocolStore.getLegacyIdentityKeyStore().getLocalRegistrationId();
        }
        this.aciAccountData.setIdentityKeyPair(aciIdentityKeyPair);
        this.aciAccountData.setLocalRegistrationId(registrationId);
        this.loadLegacyStores(rootNode, legacySignalProtocolStore);
        File legacySenderKeysPath = new File(userPath, "sender-keys");
        if (legacySenderKeysPath.exists()) {
            LegacySenderKeyRecordStore.migrate(legacySenderKeysPath, this.getRecipientResolver(), this.getRecipientAddressResolver(), this.getSenderKeyStore());
        }
        if ((legacySenderKeysSharedPath = new File(userPath, "shared-sender-keys-store")).exists()) {
            LegacySenderKeySharedStore.migrate(legacySenderKeysSharedPath, this.getRecipientResolver(), this.getRecipientAddressResolver(), this.getSenderKeyStore());
        }
        if (rootNode.hasNonNull("groupStore")) {
            LegacyGroupStore.Storage groupStoreStorage = (LegacyGroupStore.Storage)this.jsonProcessor.convertValue((Object)rootNode.get("groupStore"), LegacyGroupStore.Storage.class);
            LegacyGroupStore.migrate(groupStoreStorage, new File(userPath, "group-cache"), this.getRecipientResolver(), this.getGroupStore());
        }
        if (rootNode.hasNonNull("stickerStore")) {
            LegacyStickerStore.Storage storage = (LegacyStickerStore.Storage)this.jsonProcessor.convertValue((Object)rootNode.get("stickerStore"), LegacyStickerStore.Storage.class);
            LegacyStickerStore.migrate(storage, this.getStickerStore());
        }
        if (rootNode.hasNonNull("configurationStore")) {
            LegacyConfigurationStore.Storage configurationStoreStorage = (LegacyConfigurationStore.Storage)this.jsonProcessor.convertValue((Object)rootNode.get("configurationStore"), LegacyConfigurationStore.Storage.class);
            LegacyConfigurationStore.migrate(configurationStoreStorage, this.getConfigurationStore());
        }
        this.loadLegacyThreadStore(rootNode);
    }

    private void loadLegacyStores(JsonNode rootNode, LegacyJsonSignalProtocolStore legacySignalProtocolStore) {
        RecipientId recipientId;
        JsonNode legacyRecipientStoreNode = rootNode.get("recipientStore");
        if (legacyRecipientStoreNode != null) {
            logger.debug("Migrating legacy recipient store.");
            Iterator<Object> legacyRecipientStore = (LegacyRecipientStore)this.jsonProcessor.convertValue((Object)legacyRecipientStoreNode, LegacyRecipientStore.class);
            if (legacyRecipientStore != null) {
                ((LegacyRecipientStore)((Object)legacyRecipientStore)).getAddresses().forEach(recipient -> this.getRecipientStore().resolveRecipientTrusted((RecipientAddress)recipient));
            }
            this.getRecipientTrustedResolver().resolveSelfRecipientTrusted(this.getSelfRecipientAddress());
        }
        if (legacySignalProtocolStore != null && legacySignalProtocolStore.getLegacyPreKeyStore() != null) {
            logger.debug("Migrating legacy pre key store.");
            this.aciAccountData.getPreKeyStore().removeAllPreKeys();
            for (Map.Entry entry : legacySignalProtocolStore.getLegacyPreKeyStore().getPreKeys().entrySet()) {
                try {
                    this.aciAccountData.getPreKeyStore().storePreKey((Integer)entry.getKey(), new PreKeyRecord((byte[])entry.getValue()));
                }
                catch (InvalidMessageException e) {
                    logger.warn("Failed to migrate pre key, ignoring", (Throwable)e);
                }
            }
        }
        if (legacySignalProtocolStore != null && legacySignalProtocolStore.getLegacySignedPreKeyStore() != null) {
            logger.debug("Migrating legacy signed pre key store.");
            this.aciAccountData.getSignedPreKeyStore().removeAllSignedPreKeys();
            for (Map.Entry entry : legacySignalProtocolStore.getLegacySignedPreKeyStore().getSignedPreKeys().entrySet()) {
                try {
                    this.aciAccountData.getSignedPreKeyStore().storeSignedPreKey((Integer)entry.getKey(), new SignedPreKeyRecord((byte[])entry.getValue()));
                }
                catch (InvalidMessageException e) {
                    logger.warn("Failed to migrate signed pre key, ignoring", (Throwable)e);
                }
            }
        }
        if (legacySignalProtocolStore != null && legacySignalProtocolStore.getLegacySessionStore() != null) {
            logger.debug("Migrating legacy session store.");
            for (LegacySessionInfo legacySessionInfo : legacySignalProtocolStore.getLegacySessionStore().getSessions()) {
                try {
                    this.aciAccountData.getSessionStore().storeSession(new SignalProtocolAddress(legacySessionInfo.address.getIdentifier(), legacySessionInfo.deviceId), new SessionRecord(legacySessionInfo.sessionRecord));
                }
                catch (Exception e) {
                    logger.warn("Failed to migrate session, ignoring", (Throwable)e);
                }
            }
        }
        if (legacySignalProtocolStore != null && legacySignalProtocolStore.getLegacyIdentityKeyStore() != null) {
            logger.debug("Migrating legacy identity session store.");
            for (LegacyIdentityInfo legacyIdentityInfo : legacySignalProtocolStore.getLegacyIdentityKeyStore().getIdentities()) {
                if (legacyIdentityInfo.getAddress().serviceId().isEmpty()) continue;
                ServiceId serviceId = legacyIdentityInfo.getAddress().serviceId().get();
                this.getIdentityKeyStore().saveIdentity(serviceId, legacyIdentityInfo.getIdentityKey());
                this.getIdentityKeyStore().setIdentityTrustLevel(serviceId, legacyIdentityInfo.getIdentityKey(), legacyIdentityInfo.getTrustLevel());
            }
        }
        if (rootNode.hasNonNull("contactStore")) {
            logger.debug("Migrating legacy contact store.");
            JsonNode contactStoreNode = rootNode.get("contactStore");
            LegacyJsonContactsStore legacyJsonContactsStore = (LegacyJsonContactsStore)this.jsonProcessor.convertValue((Object)contactStoreNode, LegacyJsonContactsStore.class);
            for (LegacyContactInfo contact : legacyJsonContactsStore.getContacts()) {
                recipientId = this.getRecipientStore().resolveRecipientTrusted(contact.getAddress());
                this.getContactStore().storeContact(recipientId, new Contact(contact.name, null, null, null, null, null, contact.color, contact.messageExpirationTime, 1, 0L, false, contact.blocked, contact.archived, false, false, null));
                String profileKeyString = contact.profileKey;
                if (profileKeyString == null) continue;
                try {
                    ProfileKey profileKey = new ProfileKey(Base64.getDecoder().decode(profileKeyString));
                    this.getProfileStore().storeProfileKey(recipientId, profileKey);
                }
                catch (InvalidInputException e) {
                    logger.warn("Failed to parse legacy contact profile key: {}", (Object)e.getMessage());
                }
            }
        }
        if (rootNode.hasNonNull("profileStore")) {
            logger.debug("Migrating legacy profile store.");
            JsonNode profileStoreNode = rootNode.get("profileStore");
            LegacyProfileStore legacyProfileStore = (LegacyProfileStore)this.jsonProcessor.convertValue((Object)profileStoreNode, LegacyProfileStore.class);
            for (LegacySignalProfileEntry profileEntry : legacyProfileStore.getProfileEntries()) {
                recipientId = this.getRecipientResolver().resolveRecipient(profileEntry.address());
                this.getProfileStore().storeProfileKey(recipientId, profileEntry.profileKey());
                LegacySignalProfile profile = profileEntry.profile();
                if (profile == null) continue;
                HashSet<Profile.Capability> capabilities = new HashSet<Profile.Capability>();
                if (profile.getCapabilities() != null && profile.getCapabilities().storage) {
                    capabilities.add(Profile.Capability.storage);
                }
                Profile newProfile = new Profile(profileEntry.lastUpdateTimestamp(), profile.getGivenName(), profile.getFamilyName(), profile.getAbout(), profile.getAboutEmoji(), null, null, profile.isUnrestrictedUnidentifiedAccess() ? Profile.UnidentifiedAccessMode.UNRESTRICTED : (profile.getUnidentifiedAccess() != null ? Profile.UnidentifiedAccessMode.ENABLED : Profile.UnidentifiedAccessMode.DISABLED), capabilities, null);
                this.getProfileStore().storeProfile(recipientId, newProfile);
            }
        }
    }

    private void loadLegacyThreadStore(JsonNode rootNode) {
        JsonNode threadStoreNode = rootNode.get("threadStore");
        if (threadStoreNode != null && !threadStoreNode.isNull()) {
            LegacyJsonThreadStore threadStore = (LegacyJsonThreadStore)this.jsonProcessor.convertValue((Object)threadStoreNode, LegacyJsonThreadStore.class);
            for (LegacyThreadInfo thread : threadStore.getThreads()) {
                if (thread.id == null || thread.id.isEmpty()) continue;
                try {
                    if (UuidUtil.INSTANCE.isUuid(thread.id) || thread.id.startsWith("+")) {
                        RecipientId recipientId = this.getRecipientResolver().resolveRecipient(thread.id);
                        Contact contact = this.getContactStore().getContact(recipientId);
                        if (contact == null) continue;
                        this.getContactStore().storeContact(recipientId, Contact.newBuilder(contact).withMessageExpirationTime(thread.messageExpirationTime).withMessageExpirationTimeVersion(1).build());
                        continue;
                    }
                    GroupInfo groupInfo = this.getGroupStore().getGroup(GroupId.fromBase64(thread.id));
                    if (!(groupInfo instanceof GroupInfoV1)) continue;
                    ((GroupInfoV1)groupInfo).messageExpirationTime = thread.messageExpirationTime;
                    this.getGroupStore().updateGroup(groupInfo);
                }
                catch (Exception e) {
                    logger.warn("Failed to read legacy thread info: {}", (Object)e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        FileChannel fileChannel = this.fileChannel;
        synchronized (fileChannel) {
            Base64.Encoder base64 = Base64.getEncoder();
            Storage storage = new Storage(10, System.currentTimeMillis(), this.serviceEnvironment.name(), this.registered, this.number, this.username, this.encryptedDeviceName, this.deviceId, this.isMultiDevice, this.password, Storage.AccountData.from(this.aciAccountData), Storage.AccountData.from(this.pniAccountData), this.registrationLockPin, this.pinMasterKey == null ? null : base64.encodeToString(this.pinMasterKey.serialize()), this.storageKey == null ? null : base64.encodeToString(this.storageKey.serialize()), this.accountEntropyPool == null ? null : this.accountEntropyPool.getValue(), this.mediaRootBackupKey == null ? null : base64.encodeToString(this.mediaRootBackupKey.getValue()), this.profileKey == null ? null : base64.encodeToString(this.profileKey.serialize()), this.usernameLink == null ? null : base64.encodeToString(this.usernameLink.getEntropy()), this.usernameLink == null ? null : this.usernameLink.getServerId().toString());
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                this.jsonProcessor.writeValue((OutputStream)output, (Object)storage);
                ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
                this.fileChannel.position(0L);
                input.transferTo(Channels.newOutputStream(this.fileChannel));
                this.fileChannel.truncate(this.fileChannel.position());
                this.fileChannel.force(false);
            }
            catch (Exception e) {
                logger.error("Error saving file: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<FileChannel, FileLock> openFileChannel(File fileName, boolean waitForLock) throws IOException {
        try (FileChannel fileChannel = new RandomAccessFile(fileName, "rw").getChannel();){
            FileLock lock = fileChannel.tryLock();
            if (lock == null) {
                if (!waitForLock) {
                    logger.debug("Config file is in use by another instance.");
                    throw new IOException("Config file is in use by another instance.");
                }
                logger.info("Config file is in use by another instance, waiting\u2026");
                lock = fileChannel.lock();
                logger.info("Config file lock acquired.");
            }
            Pair<FileChannel, FileLock> result = new Pair<FileChannel, FileLock>(fileChannel, lock);
            fileChannel = null;
            Pair<FileChannel, FileLock> pair = result;
            return pair;
        }
    }

    private void clearAllPreKeys() {
        this.clearAllPreKeys(ServiceIdType.ACI);
        this.clearAllPreKeys(ServiceIdType.PNI);
    }

    private void initAllPreKeyIds() {
        this.resetPreKeyOffsets(ServiceIdType.ACI);
        this.resetPreKeyOffsets(ServiceIdType.PNI);
        this.resetKyberPreKeyOffsets(ServiceIdType.ACI);
        this.resetKyberPreKeyOffsets(ServiceIdType.PNI);
    }

    private void clearAllPreKeys(ServiceIdType serviceIdType) {
        AccountData<? extends ServiceId> accountData = this.getAccountData(serviceIdType);
        this.resetPreKeyOffsets(serviceIdType);
        this.resetKyberPreKeyOffsets(serviceIdType);
        accountData.getPreKeyStore().removeAllPreKeys();
        accountData.getSignedPreKeyStore().removeAllSignedPreKeys();
        accountData.getKyberPreKeyStore().removeAllKyberPreKeys();
        this.save();
    }

    private void setPreKeys(ServiceIdType serviceIdType, PreKeyCollection preKeyCollection) {
        AccountData<? extends ServiceId> accountData = this.getAccountData(serviceIdType);
        PreKeyMetadata preKeyMetadata = accountData.getPreKeyMetadata();
        preKeyMetadata.nextSignedPreKeyId = preKeyCollection.getSignedPreKey().getId();
        preKeyMetadata.nextKyberPreKeyId = preKeyCollection.getLastResortKyberPreKey().getId();
        accountData.getPreKeyStore().removeAllPreKeys();
        accountData.getSignedPreKeyStore().removeAllSignedPreKeys();
        accountData.getKyberPreKeyStore().removeAllKyberPreKeys();
        this.addSignedPreKey(serviceIdType, preKeyCollection.getSignedPreKey());
        this.addLastResortKyberPreKey(serviceIdType, preKeyCollection.getLastResortKyberPreKey());
        this.save();
    }

    public void resetPreKeyOffsets(ServiceIdType serviceIdType) {
        PreKeyMetadata preKeyMetadata = this.getAccountData(serviceIdType).getPreKeyMetadata();
        preKeyMetadata.nextPreKeyId = SignalAccount.getRandomPreKeyIdOffset();
        preKeyMetadata.nextSignedPreKeyId = SignalAccount.getRandomPreKeyIdOffset();
        preKeyMetadata.activeSignedPreKeyId = -1;
        this.save();
    }

    private static int getRandomPreKeyIdOffset() {
        return KeyUtils.getRandomInt(ServiceConfig.PREKEY_MAXIMUM_ID);
    }

    public void addPreKeys(ServiceIdType serviceIdType, List<PreKeyRecord> records) {
        AccountData<? extends ServiceId> accountData = this.getAccountData(serviceIdType);
        PreKeyMetadata preKeyMetadata = accountData.getPreKeyMetadata();
        logger.debug("Adding {} {} pre keys with offset {}", new Object[]{records.size(), serviceIdType, preKeyMetadata.nextPreKeyId});
        accountData.getSignalServiceAccountDataStore().markAllOneTimeEcPreKeysStaleIfNecessary(System.currentTimeMillis());
        for (PreKeyRecord record : records) {
            if (preKeyMetadata.nextPreKeyId != record.getId()) {
                logger.error("Invalid pre key id {}, expected {}", (Object)record.getId(), (Object)preKeyMetadata.nextPreKeyId);
                throw new AssertionError((Object)"Invalid pre key id");
            }
            accountData.getPreKeyStore().storePreKey(record.getId(), record);
            preKeyMetadata.nextPreKeyId = (preKeyMetadata.nextPreKeyId + 1) % ServiceConfig.PREKEY_MAXIMUM_ID;
        }
        this.save();
    }

    public void addSignedPreKey(ServiceIdType serviceIdType, SignedPreKeyRecord record) {
        AccountData<? extends ServiceId> accountData = this.getAccountData(serviceIdType);
        PreKeyMetadata preKeyMetadata = accountData.getPreKeyMetadata();
        logger.debug("Adding {} signed pre key with offset {}", (Object)serviceIdType, (Object)preKeyMetadata.nextSignedPreKeyId);
        if (preKeyMetadata.nextSignedPreKeyId != record.getId()) {
            logger.error("Invalid signed pre key id {}, expected {}", (Object)record.getId(), (Object)preKeyMetadata.nextSignedPreKeyId);
            throw new AssertionError((Object)"Invalid signed pre key id");
        }
        accountData.getSignedPreKeyStore().storeSignedPreKey(record.getId(), record);
        preKeyMetadata.nextSignedPreKeyId = (preKeyMetadata.nextSignedPreKeyId + 1) % ServiceConfig.PREKEY_MAXIMUM_ID;
        preKeyMetadata.activeSignedPreKeyId = record.getId();
        this.save();
    }

    public void resetKyberPreKeyOffsets(ServiceIdType serviceIdType) {
        PreKeyMetadata preKeyMetadata = this.getAccountData(serviceIdType).getPreKeyMetadata();
        preKeyMetadata.nextKyberPreKeyId = SignalAccount.getRandomPreKeyIdOffset();
        preKeyMetadata.activeLastResortKyberPreKeyId = -1;
        this.save();
    }

    public void addKyberPreKeys(ServiceIdType serviceIdType, List<KyberPreKeyRecord> records) {
        AccountData<? extends ServiceId> accountData = this.getAccountData(serviceIdType);
        PreKeyMetadata preKeyMetadata = accountData.getPreKeyMetadata();
        logger.debug("Adding {} {} kyber pre keys with offset {}", new Object[]{records.size(), serviceIdType, preKeyMetadata.nextKyberPreKeyId});
        accountData.getSignalServiceAccountDataStore().markAllOneTimeKyberPreKeysStaleIfNecessary(System.currentTimeMillis());
        for (KyberPreKeyRecord record : records) {
            if (preKeyMetadata.nextKyberPreKeyId != record.getId()) {
                logger.error("Invalid kyber pre key id {}, expected {}", (Object)record.getId(), (Object)preKeyMetadata.nextKyberPreKeyId);
                throw new AssertionError((Object)"Invalid kyber pre key id");
            }
            accountData.getKyberPreKeyStore().storeKyberPreKey(record.getId(), record);
            preKeyMetadata.nextKyberPreKeyId = (preKeyMetadata.nextKyberPreKeyId + 1) % ServiceConfig.PREKEY_MAXIMUM_ID;
        }
        this.save();
    }

    public void addLastResortKyberPreKey(ServiceIdType serviceIdType, KyberPreKeyRecord record) {
        AccountData<? extends ServiceId> accountData = this.getAccountData(serviceIdType);
        PreKeyMetadata preKeyMetadata = accountData.getPreKeyMetadata();
        logger.debug("Adding {} last resort kyber pre key with offset {}", (Object)serviceIdType, (Object)preKeyMetadata.nextKyberPreKeyId);
        if (preKeyMetadata.nextKyberPreKeyId != record.getId()) {
            logger.error("Invalid last resort kyber pre key id {}, expected {}", (Object)record.getId(), (Object)preKeyMetadata.nextKyberPreKeyId);
            throw new AssertionError((Object)"Invalid last resort kyber pre key id");
        }
        accountData.getKyberPreKeyStore().storeLastResortKyberPreKey(record.getId(), record);
        preKeyMetadata.activeLastResortKyberPreKeyId = record.getId();
        preKeyMetadata.nextKyberPreKeyId = (preKeyMetadata.nextKyberPreKeyId + 1) % ServiceConfig.PREKEY_MAXIMUM_ID;
        this.save();
    }

    public int getPreviousStorageVersion() {
        return this.previousStorageVersion;
    }

    public AccountData<? extends ServiceId> getAccountData(ServiceIdType serviceIdType) {
        return switch (serviceIdType) {
            default -> throw new MatchException(null, null);
            case ServiceIdType.ACI -> this.aciAccountData;
            case ServiceIdType.PNI -> this.pniAccountData;
        };
    }

    public AccountData<? extends ServiceId> getAccountData(ServiceId accountIdentifier) {
        if (accountIdentifier.equals(this.aciAccountData.getServiceId())) {
            return this.aciAccountData;
        }
        if (accountIdentifier.equals(this.pniAccountData.getServiceId())) {
            return this.pniAccountData;
        }
        throw new IllegalArgumentException("No matching account data found for " + String.valueOf(accountIdentifier));
    }

    public SignalServiceDataStore getSignalServiceDataStore() {
        return new SignalServiceDataStore(){

            public SignalServiceAccountDataStore get(ServiceId accountIdentifier) {
                return SignalAccount.this.getAccountData(accountIdentifier).getSignalServiceAccountDataStore();
            }

            public SignalServiceAccountDataStore aci() {
                return SignalAccount.this.aciAccountData.getSignalServiceAccountDataStore();
            }

            public SignalServiceAccountDataStore pni() {
                return SignalAccount.this.pniAccountData.getSignalServiceAccountDataStore();
            }

            public boolean isMultiDevice() {
                return SignalAccount.this.isMultiDevice();
            }
        };
    }

    public IdentityKeyStore getIdentityKeyStore() {
        return this.getOrCreate(() -> this.identityKeyStore, () -> {
            this.identityKeyStore = new IdentityKeyStore(this.getAccountDatabase(), this.settings.trustNewIdentity(), this.getRecipientStore());
        });
    }

    public GroupStore getGroupStore() {
        return this.getOrCreate(() -> this.groupStore, () -> {
            this.groupStore = new GroupStore(this.getAccountDatabase(), this.getRecipientResolver(), this.getRecipientIdCreator());
        });
    }

    public ContactsStore getContactStore() {
        return this.getRecipientStore();
    }

    public CdsiStore getCdsiStore() {
        return this.getOrCreate(() -> this.cdsiStore, () -> {
            this.cdsiStore = new CdsiStore(this.getAccountDatabase());
        });
    }

    private RecipientIdCreator getRecipientIdCreator() {
        return recipientId -> this.getRecipientStore().create(recipientId);
    }

    public RecipientResolver getRecipientResolver() {
        return new RecipientResolver.RecipientResolverWrapper(this::getRecipientStore);
    }

    public RecipientTrustedResolver getRecipientTrustedResolver() {
        return new RecipientTrustedResolver.RecipientTrustedResolverWrapper(this::getRecipientStore);
    }

    public RecipientAddressResolver getRecipientAddressResolver() {
        return recipientId -> this.getRecipientStore().resolveRecipientAddress(recipientId);
    }

    public RecipientStore getRecipientStore() {
        return this.getOrCreate(() -> this.recipientStore, () -> {
            this.recipientStore = new RecipientStore(this::mergeRecipients, this::getSelfRecipientAddress, this::getProfileKey, this.getAccountDatabase());
        });
    }

    public ProfileStore getProfileStore() {
        return this.getRecipientStore();
    }

    public StickerStore getStickerStore() {
        return this.getOrCreate(() -> this.stickerStore, () -> {
            this.stickerStore = new StickerStore(this.getAccountDatabase());
        });
    }

    public SenderKeyStore getSenderKeyStore() {
        return this.getOrCreate(() -> this.senderKeyStore, () -> {
            this.senderKeyStore = new SenderKeyStore(this.getAccountDatabase());
        });
    }

    private KeyValueStore getKeyValueStore() {
        return this.getOrCreate(() -> this.keyValueStore, () -> {
            this.keyValueStore = new KeyValueStore(this.getAccountDatabase());
        });
    }

    public UnknownStorageIdStore getUnknownStorageIdStore() {
        return this.getOrCreate(() -> this.unknownStorageIdStore, () -> {
            this.unknownStorageIdStore = new UnknownStorageIdStore();
        });
    }

    public ConfigurationStore getConfigurationStore() {
        return this.getOrCreate(() -> this.configurationStore, () -> {
            this.configurationStore = new ConfigurationStore(this.getKeyValueStore(), this.getRecipientStore());
        });
    }

    public MessageCache getMessageCache() {
        return this.getOrCreate(() -> this.messageCache, () -> {
            this.messageCache = new MessageCache(SignalAccount.getMessageCachePath(this.dataPath, this.accountPath));
        });
    }

    public AccountDatabase getAccountDatabase() {
        return this.getOrCreate(() -> this.accountDatabase, () -> {
            try {
                this.accountDatabase = AccountDatabase.init(SignalAccount.getDatabaseFile(this.dataPath, this.accountPath));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public MessageSendLogStore getMessageSendLogStore() {
        return this.getOrCreate(() -> this.messageSendLogStore, () -> {
            this.messageSendLogStore = new MessageSendLogStore(this.getAccountDatabase(), this.settings.disableMessageSendLog());
        });
    }

    public CredentialsProvider getCredentialsProvider() {
        return new CredentialsProvider(){

            public ServiceId.ACI getAci() {
                return SignalAccount.this.aciAccountData.getServiceId();
            }

            public ServiceId.PNI getPni() {
                return SignalAccount.this.pniAccountData.getServiceId();
            }

            public String getE164() {
                return SignalAccount.this.number;
            }

            public String getPassword() {
                return SignalAccount.this.password;
            }

            public int getDeviceId() {
                return SignalAccount.this.deviceId;
            }
        };
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
        this.save();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.save();
    }

    public UsernameLinkComponents getUsernameLink() {
        return this.usernameLink;
    }

    public void setUsernameLink(UsernameLinkComponents usernameLink) {
        this.usernameLink = usernameLink;
        this.save();
    }

    public ServiceEnvironment getServiceEnvironment() {
        return this.serviceEnvironment;
    }

    public void setServiceEnvironment(ServiceEnvironment serviceEnvironment) {
        this.serviceEnvironment = serviceEnvironment;
        this.save();
    }

    public AccountAttributes getAccountAttributes(String registrationLock) {
        return new AccountAttributes(null, this.aciAccountData.getLocalRegistrationId(), false, false, true, registrationLock != null ? registrationLock : this.getRegistrationLock(), this.getSelfUnidentifiedAccessKey(), this.isUnrestrictedUnidentifiedAccess(), this.isDiscoverableByPhoneNumber(), this.getAccountCapabilities(), this.encryptedDeviceName, this.pniAccountData.getLocalRegistrationId(), this.getRecoveryPassword());
    }

    public AccountAttributes.Capabilities getAccountCapabilities() {
        return ServiceConfig.getCapabilities(this.isPrimaryDevice());
    }

    public ServiceId getAccountId(ServiceIdType serviceIdType) {
        return this.getAccountData(serviceIdType).getServiceId();
    }

    public ServiceId.ACI getAci() {
        return this.aciAccountData.getServiceId();
    }

    public void setAci(ServiceId.ACI aci) {
        this.aciAccountData.setServiceId(aci);
        this.save();
    }

    public ServiceId.PNI getPni() {
        return this.pniAccountData.getServiceId();
    }

    public void setPni(ServiceId.PNI updatedPni) {
        ServiceId.PNI oldPni = this.pniAccountData.getServiceId();
        if (oldPni != null && !oldPni.equals((Object)updatedPni)) {
            this.identityKeyStore.deleteIdentity((ServiceId)oldPni);
        }
        this.pniAccountData.setServiceId(updatedPni);
        this.getRecipientTrustedResolver().resolveSelfRecipientTrusted(this.getSelfRecipientAddress());
        this.trustSelfIdentity(ServiceIdType.PNI);
        this.save();
    }

    public void setNewPniIdentity(IdentityKeyPair pniIdentityKeyPair, SignedPreKeyRecord pniSignedPreKey, KyberPreKeyRecord lastResortKyberPreKey, int localPniRegistrationId) {
        this.setPniIdentityKeyPair(pniIdentityKeyPair);
        this.pniAccountData.setLocalRegistrationId(localPniRegistrationId);
        AccountData<? extends ServiceId> accountData = this.getAccountData(ServiceIdType.PNI);
        PreKeyMetadata preKeyMetadata = accountData.getPreKeyMetadata();
        preKeyMetadata.nextSignedPreKeyId = pniSignedPreKey.getId();
        accountData.getSignedPreKeyStore().removeSignedPreKey(pniSignedPreKey.getId());
        this.addSignedPreKey(ServiceIdType.PNI, pniSignedPreKey);
        if (lastResortKyberPreKey != null) {
            preKeyMetadata.nextKyberPreKeyId = lastResortKyberPreKey.getId();
            accountData.getKyberPreKeyStore().removeKyberPreKey(lastResortKyberPreKey.getId());
            this.addLastResortKyberPreKey(ServiceIdType.PNI, lastResortKyberPreKey);
        }
        this.save();
    }

    public SignalServiceAddress getSelfAddress() {
        return new SignalServiceAddress((ServiceId)this.getAci(), this.number);
    }

    public RecipientAddress getSelfRecipientAddress() {
        return new RecipientAddress(this.getAci(), this.getPni(), this.number, this.username);
    }

    public RecipientId getSelfRecipientId() {
        return this.selfRecipientId;
    }

    public Profile getSelfRecipientProfile() {
        return this.recipientStore.getProfile(this.selfRecipientId);
    }

    public String getSessionId(String forNumber) {
        KeyValueStore keyValueStore = this.getKeyValueStore();
        String sessionNumber = keyValueStore.getEntry(this.verificationSessionNumber);
        if (!forNumber.equals(sessionNumber)) {
            return null;
        }
        return keyValueStore.getEntry(this.verificationSessionId);
    }

    public void setSessionId(String sessionNumber, String sessionId) {
        KeyValueStore keyValueStore = this.getKeyValueStore();
        keyValueStore.storeEntry(this.verificationSessionNumber, sessionNumber);
        keyValueStore.storeEntry(this.verificationSessionId, sessionId);
    }

    public void clearSessionId() {
        KeyValueStore keyValueStore = this.getKeyValueStore();
        keyValueStore.storeEntry(this.verificationSessionNumber, null);
        keyValueStore.storeEntry(this.verificationSessionId, null);
    }

    public void setEncryptedDeviceName(String encryptedDeviceName) {
        this.encryptedDeviceName = encryptedDeviceName;
        this.save();
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public boolean isPrimaryDevice() {
        return this.deviceId == 1;
    }

    public IdentityKeyPair getIdentityKeyPair(ServiceIdType serviceIdType) {
        return this.getAccountData(serviceIdType).getIdentityKeyPair();
    }

    public IdentityKeyPair getAciIdentityKeyPair() {
        return this.aciAccountData.getIdentityKeyPair();
    }

    public IdentityKeyPair getPniIdentityKeyPair() {
        return this.pniAccountData.getIdentityKeyPair();
    }

    public void setPniIdentityKeyPair(IdentityKeyPair identityKeyPair) {
        this.pniAccountData.setIdentityKeyPair(identityKeyPair);
        this.trustSelfIdentity(ServiceIdType.PNI);
        this.save();
    }

    public String getPassword() {
        return this.password;
    }

    public void setRegistrationLockPin(String registrationLockPin) {
        this.registrationLockPin = registrationLockPin;
        this.save();
    }

    public String getRegistrationLockPin() {
        return this.registrationLockPin;
    }

    public String getRegistrationLock() {
        MasterKey masterKey = this.getPinBackedMasterKey();
        if (masterKey == null) {
            return null;
        }
        return masterKey.deriveRegistrationLock();
    }

    public MasterKey getPinBackedMasterKey() {
        if (this.registrationLockPin == null) {
            return null;
        }
        if (!this.isPrimaryDevice()) {
            return this.getMasterKey();
        }
        return this.getOrCreatePinMasterKey();
    }

    public MasterKey getOrCreatePinMasterKey() {
        MasterKey key = this.getMasterKey();
        if (key != null) {
            return key;
        }
        return this.getOrCreateAccountEntropyPool().deriveMasterKey();
    }

    private MasterKey getMasterKey() {
        if (this.pinMasterKey != null) {
            return this.pinMasterKey;
        }
        if (this.accountEntropyPool != null) {
            return this.accountEntropyPool.deriveMasterKey();
        }
        return null;
    }

    public void setMasterKey(MasterKey masterKey) {
        if (this.isPrimaryDevice()) {
            return;
        }
        this.pinMasterKey = masterKey;
        if (masterKey != null) {
            this.storageKey = null;
        }
        this.save();
    }

    public StorageKey getOrCreateStorageKey() {
        if (this.storageKey != null) {
            return this.storageKey;
        }
        if (this.pinMasterKey != null) {
            return this.pinMasterKey.deriveStorageServiceKey();
        }
        if (this.accountEntropyPool != null) {
            return this.accountEntropyPool.deriveMasterKey().deriveStorageServiceKey();
        }
        if (!this.isPrimaryDevice() || !this.isMultiDevice()) {
            return null;
        }
        return this.getOrCreatePinMasterKey().deriveStorageServiceKey();
    }

    public void setStorageKey(StorageKey storageKey) {
        if (this.isPrimaryDevice() || storageKey.equals((Object)this.storageKey)) {
            return;
        }
        this.storageKey = storageKey;
        this.save();
    }

    public AccountEntropyPool getOrCreateAccountEntropyPool() {
        if (this.accountEntropyPool == null) {
            this.accountEntropyPool = AccountEntropyPool.Companion.generate();
            this.save();
        }
        return this.accountEntropyPool;
    }

    public void setAccountEntropyPool(AccountEntropyPool accountEntropyPool) {
        this.accountEntropyPool = accountEntropyPool;
        if (accountEntropyPool != null) {
            this.storageKey = null;
            this.pinMasterKey = null;
        }
        this.save();
    }

    public boolean needsStorageKeyMigration() {
        return this.isPrimaryDevice() && (this.storageKey != null || this.pinMasterKey != null);
    }

    public MediaRootBackupKey getOrCreateMediaRootBackupKey() {
        if (this.mediaRootBackupKey == null) {
            this.mediaRootBackupKey = KeyUtils.createMediaRootBackupKey();
            this.save();
        }
        return this.mediaRootBackupKey;
    }

    public void setMediaRootBackupKey(MediaRootBackupKey mediaRootBackupKey) {
        this.mediaRootBackupKey = mediaRootBackupKey;
        this.save();
    }

    public String getRecoveryPassword() {
        MasterKey masterKey = this.getPinBackedMasterKey();
        if (masterKey == null) {
            return null;
        }
        return masterKey.deriveRegistrationRecoveryPassword();
    }

    public long getStorageManifestVersion() {
        return this.getKeyValueStore().getEntry(this.storageManifestVersion);
    }

    public void setStorageManifestVersion(long value) {
        this.getKeyValueStore().storeEntry(this.storageManifestVersion, value);
    }

    public Optional<SignalStorageManifest> getStorageManifest() {
        Optional<SignalStorageManifest> optional;
        File storageManifestFile = SignalAccount.getStorageManifestFile(this.dataPath, this.accountPath);
        if (!storageManifestFile.exists()) {
            return Optional.empty();
        }
        FileInputStream inputStream = new FileInputStream(storageManifestFile);
        try {
            optional = Optional.of(SignalStorageManifest.Companion.deserialize(inputStream.readAllBytes()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.warn("Failed to read local storage manifest.", (Throwable)e);
                return Optional.empty();
            }
        }
        inputStream.close();
        return optional;
    }

    public void setStorageManifest(SignalStorageManifest manifest) {
        File storageManifestFile = SignalAccount.getStorageManifestFile(this.dataPath, this.accountPath);
        if (manifest == null) {
            if (storageManifestFile.exists()) {
                try {
                    Files.delete(storageManifestFile.toPath());
                }
                catch (IOException e) {
                    logger.error("Failed to delete local storage manifest.", (Throwable)e);
                }
            }
            return;
        }
        byte[] manifestBytes = manifest.serialize();
        try (FileOutputStream outputStream = new FileOutputStream(storageManifestFile);){
            outputStream.write(manifestBytes);
        }
        catch (IOException e) {
            logger.error("Failed to store local storage manifest.", (Throwable)e);
        }
    }

    public byte[] getCdsiToken() {
        return this.getKeyValueStore().getEntry(this.cdsiToken);
    }

    public void setCdsiToken(byte[] value) {
        this.getKeyValueStore().storeEntry(this.cdsiToken, value);
    }

    public Long getLastRecipientsRefresh() {
        return this.getKeyValueStore().getEntry(this.lastRecipientsRefresh);
    }

    public void setLastRecipientsRefresh(Long value) {
        this.getKeyValueStore().storeEntry(this.lastRecipientsRefresh, value);
    }

    public ProfileKey getProfileKey() {
        return this.profileKey;
    }

    public void setProfileKey(ProfileKey profileKey) {
        if (profileKey.equals((Object)this.profileKey)) {
            return;
        }
        this.profileKey = profileKey;
        this.save();
    }

    public byte[] getSelfUnidentifiedAccessKey() {
        return UnidentifiedAccess.deriveAccessKeyFrom((ProfileKey)this.getProfileKey());
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
        this.save();
    }

    public boolean isMultiDevice() {
        return this.isMultiDevice;
    }

    public void setMultiDevice(boolean multiDevice) {
        if (this.isMultiDevice == multiDevice) {
            return;
        }
        this.isMultiDevice = multiDevice;
        this.save();
    }

    public long getLastReceiveTimestamp() {
        return this.getKeyValueStore().getEntry(this.lastReceiveTimestamp);
    }

    public void setLastReceiveTimestamp(long value) {
        this.getKeyValueStore().storeEntry(this.lastReceiveTimestamp, value);
    }

    public void setNeedsToRetryFailedMessages(boolean value) {
        this.getKeyValueStore().storeEntry(this.needsToRetryFailedMessages, value);
    }

    public boolean getNeedsToRetryFailedMessages() {
        return this.getKeyValueStore().getEntry(this.needsToRetryFailedMessages);
    }

    public boolean isUnrestrictedUnidentifiedAccess() {
        return Boolean.TRUE.equals(this.getKeyValueStore().getEntry(this.unrestrictedUnidentifiedAccess));
    }

    public void setUnrestrictedUnidentifiedAccess(boolean value) {
        this.getKeyValueStore().storeEntry(this.unrestrictedUnidentifiedAccess, value);
    }

    public boolean isDiscoverableByPhoneNumber() {
        Boolean phoneNumberUnlisted = this.getConfigurationStore().getPhoneNumberUnlisted();
        return phoneNumberUnlisted == null || phoneNumberUnlisted == false;
    }

    private void trustSelfIdentity(ServiceIdType serviceIdType) {
        AccountData<? extends ServiceId> accountData = this.getAccountData(serviceIdType);
        ServiceId serviceId = accountData.getServiceId();
        IdentityKeyPair identityKeyPair = accountData.getIdentityKeyPair();
        if (serviceId == null || identityKeyPair == null) {
            return;
        }
        IdentityKey publicKey = identityKeyPair.getPublicKey();
        this.getIdentityKeyStore().saveIdentity(serviceId, publicKey);
        this.getIdentityKeyStore().setIdentityTrustLevel(serviceId, publicKey, TrustLevel.TRUSTED_VERIFIED);
    }

    public void deleteAccountData() throws IOException {
        this.close();
        try (Stream<Path> files = Files.walk(SignalAccount.getUserPath(this.dataPath, this.accountPath).toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder());){
            Iterator file = files.iterator();
            while (file.hasNext()) {
                Files.delete((Path)file.next());
            }
        }
        Files.delete(SignalAccount.getFileName(this.dataPath, this.accountPath).toPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        FileChannel fileChannel = this.fileChannel;
        synchronized (fileChannel) {
            if (this.accountDatabase != null) {
                this.accountDatabase.close();
            }
            if (this.messageSendLogStore != null) {
                this.messageSendLogStore.close();
            }
            try {
                try {
                    this.lock.close();
                }
                catch (ClosedChannelException closedChannelException) {
                    // empty catch block
                }
                this.fileChannel.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close account: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getOrCreate(Supplier<T> supplier, Callable creator) {
        T value = supplier.get();
        if (value != null) {
            return value;
        }
        Object object = this.LOCK;
        synchronized (object) {
            value = supplier.get();
            if (value != null) {
                return value;
            }
            creator.call();
            return supplier.get();
        }
    }

    public class AccountData<SERVICE_ID extends ServiceId> {
        private final ServiceIdType serviceIdType;
        private SERVICE_ID serviceId;
        private IdentityKeyPair identityKeyPair;
        private int localRegistrationId;
        private final PreKeyMetadata preKeyMetadata = new PreKeyMetadata();
        private SignalProtocolStore signalProtocolStore;
        private PreKeyStore preKeyStore;
        private SignedPreKeyStore signedPreKeyStore;
        private KyberPreKeyStore kyberPreKeyStore;
        private SessionStore sessionStore;
        private SignalIdentityKeyStore identityKeyStore;

        private AccountData(ServiceIdType serviceIdType) {
            this.serviceIdType = serviceIdType;
        }

        public SERVICE_ID getServiceId() {
            return this.serviceId;
        }

        private void setServiceId(SERVICE_ID serviceId) {
            this.serviceId = serviceId;
        }

        public IdentityKeyPair getIdentityKeyPair() {
            return this.identityKeyPair;
        }

        private void setIdentityKeyPair(IdentityKeyPair identityKeyPair) {
            this.identityKeyPair = identityKeyPair;
        }

        public int getLocalRegistrationId() {
            return this.localRegistrationId;
        }

        private void setLocalRegistrationId(int localRegistrationId) {
            this.localRegistrationId = localRegistrationId;
            this.identityKeyStore = null;
        }

        public PreKeyMetadata getPreKeyMetadata() {
            return this.preKeyMetadata;
        }

        private SignalServiceAccountDataStore getSignalServiceAccountDataStore() {
            return SignalAccount.this.getOrCreate(() -> this.signalProtocolStore, () -> {
                this.signalProtocolStore = new SignalProtocolStore(this.getPreKeyStore(), this.getSignedPreKeyStore(), this.getKyberPreKeyStore(), this.getSessionStore(), this.getIdentityKeyStore(), SignalAccount.this.getSenderKeyStore(), SignalAccount.this::isMultiDevice);
            });
        }

        public PreKeyStore getPreKeyStore() {
            return SignalAccount.this.getOrCreate(() -> this.preKeyStore, () -> {
                this.preKeyStore = new PreKeyStore(SignalAccount.this.getAccountDatabase(), this.serviceIdType);
            });
        }

        public SignedPreKeyStore getSignedPreKeyStore() {
            return SignalAccount.this.getOrCreate(() -> this.signedPreKeyStore, () -> {
                this.signedPreKeyStore = new SignedPreKeyStore(SignalAccount.this.getAccountDatabase(), this.serviceIdType);
            });
        }

        public KyberPreKeyStore getKyberPreKeyStore() {
            return SignalAccount.this.getOrCreate(() -> this.kyberPreKeyStore, () -> {
                this.kyberPreKeyStore = new KyberPreKeyStore(SignalAccount.this.getAccountDatabase(), this.serviceIdType);
            });
        }

        public SessionStore getSessionStore() {
            return SignalAccount.this.getOrCreate(() -> this.sessionStore, () -> {
                this.sessionStore = new SessionStore(SignalAccount.this.getAccountDatabase(), this.serviceIdType);
            });
        }

        public SignalIdentityKeyStore getIdentityKeyStore() {
            return SignalAccount.this.getOrCreate(() -> this.identityKeyStore, () -> {
                this.identityKeyStore = new SignalIdentityKeyStore(() -> this.identityKeyPair, this.localRegistrationId, SignalAccount.this.getIdentityKeyStore());
            });
        }
    }

    public record Storage(int version, long timestamp, String serviceEnvironment, boolean registered, String number, String username, String encryptedDeviceName, int deviceId, boolean isMultiDevice, String password, AccountData aciAccountData, AccountData pniAccountData, String registrationLockPin, String pinMasterKey, String storageKey, String accountEntropyPool, String mediaRootBackupKey, String profileKey, String usernameLinkEntropy, String usernameLinkServerId) {

        public record AccountData(String serviceId, int registrationId, String identityPrivateKey, String identityPublicKey, int nextPreKeyId, int nextSignedPreKeyId, int activeSignedPreKeyId, int nextKyberPreKeyId, int activeLastResortKyberPreKeyId) {
            private static AccountData from(org.asamk.signal.manager.storage.SignalAccount$AccountData<?> accountData) {
                Base64.Encoder base64 = Base64.getEncoder();
                PreKeyMetadata preKeyMetadata = accountData.getPreKeyMetadata();
                return new AccountData(accountData.getServiceId() == null ? null : accountData.getServiceId().toString(), accountData.getLocalRegistrationId(), accountData.getIdentityKeyPair() == null ? null : base64.encodeToString(accountData.getIdentityKeyPair().getPrivateKey().serialize()), accountData.getIdentityKeyPair() == null ? null : base64.encodeToString(accountData.getIdentityKeyPair().getPublicKey().serialize()), preKeyMetadata.getNextPreKeyId(), preKeyMetadata.getNextSignedPreKeyId(), preKeyMetadata.getActiveSignedPreKeyId(), preKeyMetadata.getNextKyberPreKeyId(), preKeyMetadata.getActiveLastResortKyberPreKeyId());
            }
        }
    }

    public static class PreKeyMetadata {
        private int nextPreKeyId = 1;
        private int nextSignedPreKeyId = 1;
        private int activeSignedPreKeyId = -1;
        private int nextKyberPreKeyId = 1;
        private int activeLastResortKyberPreKeyId = -1;

        public int getNextPreKeyId() {
            return this.nextPreKeyId;
        }

        public int getNextSignedPreKeyId() {
            return this.nextSignedPreKeyId;
        }

        public int getActiveSignedPreKeyId() {
            return this.activeSignedPreKeyId;
        }

        public int getNextKyberPreKeyId() {
            return this.nextKyberPreKeyId;
        }

        public int getActiveLastResortKyberPreKeyId() {
            return this.activeLastResortKyberPreKeyId;
        }
    }

    private static interface Callable {
        public void call();
    }
}

