/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage;

import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.storage.Database;
import org.asamk.signal.manager.storage.UnknownStorageIdStore;
import org.asamk.signal.manager.storage.Utils;
import org.asamk.signal.manager.storage.groups.GroupStore;
import org.asamk.signal.manager.storage.identities.IdentityKeyStore;
import org.asamk.signal.manager.storage.keyValue.KeyValueStore;
import org.asamk.signal.manager.storage.prekeys.KyberPreKeyStore;
import org.asamk.signal.manager.storage.prekeys.PreKeyStore;
import org.asamk.signal.manager.storage.prekeys.SignedPreKeyStore;
import org.asamk.signal.manager.storage.recipients.CdsiStore;
import org.asamk.signal.manager.storage.recipients.RecipientStore;
import org.asamk.signal.manager.storage.sendLog.MessageSendLogStore;
import org.asamk.signal.manager.storage.senderKeys.SenderKeyRecordStore;
import org.asamk.signal.manager.storage.senderKeys.SenderKeySharedStore;
import org.asamk.signal.manager.storage.sessions.SessionStore;
import org.asamk.signal.manager.storage.stickers.StickerStore;
import org.signal.core.models.ServiceId;
import org.signal.core.util.UuidUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountDatabase
extends Database {
    private static final Logger logger = LoggerFactory.getLogger(AccountDatabase.class);
    private static final long DATABASE_VERSION = 28L;

    private AccountDatabase(HikariDataSource dataSource) {
        super(logger, 28L, dataSource);
    }

    public static AccountDatabase init(File databaseFile) throws SQLException {
        return AccountDatabase.initDatabase(databaseFile, AccountDatabase::new);
    }

    @Override
    protected void createDatabase(Connection connection) throws SQLException {
        RecipientStore.createSql(connection);
        MessageSendLogStore.createSql(connection);
        StickerStore.createSql(connection);
        PreKeyStore.createSql(connection);
        SignedPreKeyStore.createSql(connection);
        KyberPreKeyStore.createSql(connection);
        GroupStore.createSql(connection);
        SessionStore.createSql(connection);
        IdentityKeyStore.createSql(connection);
        SenderKeyRecordStore.createSql(connection);
        SenderKeySharedStore.createSql(connection);
        KeyValueStore.createSql(connection);
        CdsiStore.createSql(connection);
        UnknownStorageIdStore.createSql(connection);
    }

    @Override
    protected void upgradeDatabase(Connection connection, long oldVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 2L) {
            logger.debug("Updating database: Creating recipient table");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("CREATE TABLE recipient (\n  _id INTEGER PRIMARY KEY AUTOINCREMENT,\n  number TEXT UNIQUE,\n  uuid BLOB UNIQUE,\n  profile_key BLOB,\n  profile_key_credential BLOB,\n\n  given_name TEXT,\n  family_name TEXT,\n  color TEXT,\n\n  expiration_time INTEGER NOT NULL DEFAULT 0,\n  blocked INTEGER NOT NULL DEFAULT FALSE,\n  archived INTEGER NOT NULL DEFAULT FALSE,\n  profile_sharing INTEGER NOT NULL DEFAULT FALSE,\n\n  profile_last_update_timestamp INTEGER NOT NULL DEFAULT 0,\n  profile_given_name TEXT,\n  profile_family_name TEXT,\n  profile_about TEXT,\n  profile_about_emoji TEXT,\n  profile_avatar_url_path TEXT,\n  profile_mobile_coin_address BLOB,\n  profile_unidentified_access_mode TEXT,\n  profile_capabilities TEXT\n) STRICT;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 3L) {
            logger.debug("Updating database: Creating sticker table");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("CREATE TABLE sticker (\n  _id INTEGER PRIMARY KEY,\n  pack_id BLOB UNIQUE NOT NULL,\n  pack_key BLOB NOT NULL,\n  installed INTEGER NOT NULL DEFAULT FALSE\n) STRICT;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 4L) {
            logger.debug("Updating database: Creating pre key tables");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("CREATE TABLE signed_pre_key (\n  _id INTEGER PRIMARY KEY,\n  account_id_type INTEGER NOT NULL,\n  key_id INTEGER NOT NULL,\n  public_key BLOB NOT NULL,\n  private_key BLOB NOT NULL,\n  signature BLOB NOT NULL,\n  timestamp INTEGER DEFAULT 0,\n  UNIQUE(account_id_type, key_id)\n) STRICT;\nCREATE TABLE pre_key (\n  _id INTEGER PRIMARY KEY,\n  account_id_type INTEGER NOT NULL,\n  key_id INTEGER NOT NULL,\n  public_key BLOB NOT NULL,\n  private_key BLOB NOT NULL,\n  UNIQUE(account_id_type, key_id)\n) STRICT;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 5L) {
            logger.debug("Updating database: Creating group tables");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("CREATE TABLE group_v2 (\n  _id INTEGER PRIMARY KEY,\n  group_id BLOB UNIQUE NOT NULL,\n  master_key BLOB NOT NULL,\n  group_data BLOB,\n  distribution_id BLOB UNIQUE NOT NULL,\n  blocked INTEGER NOT NULL DEFAULT FALSE,\n  permission_denied INTEGER NOT NULL DEFAULT FALSE\n) STRICT;\nCREATE TABLE group_v1 (\n  _id INTEGER PRIMARY KEY,\n  group_id BLOB UNIQUE NOT NULL,\n  group_id_v2 BLOB UNIQUE,\n  name TEXT,\n  color TEXT,\n  expiration_time INTEGER NOT NULL DEFAULT 0,\n  blocked INTEGER NOT NULL DEFAULT FALSE,\n  archived INTEGER NOT NULL DEFAULT FALSE\n) STRICT;\nCREATE TABLE group_v1_member (\n  _id INTEGER PRIMARY KEY,\n  group_id INTEGER NOT NULL REFERENCES group_v1 (_id) ON DELETE CASCADE,\n  recipient_id INTEGER NOT NULL REFERENCES recipient (_id) ON DELETE CASCADE,\n  UNIQUE(group_id, recipient_id)\n) STRICT;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 6L) {
            logger.debug("Updating database: Creating session tables");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("CREATE TABLE session (\n  _id INTEGER PRIMARY KEY,\n  account_id_type INTEGER NOT NULL,\n  recipient_id INTEGER NOT NULL REFERENCES recipient (_id) ON DELETE CASCADE,\n  device_id INTEGER NOT NULL,\n  record BLOB NOT NULL,\n  UNIQUE(account_id_type, recipient_id, device_id)\n) STRICT;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 7L) {
            logger.debug("Updating database: Creating identity table");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("CREATE TABLE identity (\n  _id INTEGER PRIMARY KEY,\n  recipient_id INTEGER UNIQUE NOT NULL REFERENCES recipient (_id) ON DELETE CASCADE,\n  identity_key BLOB NOT NULL,\n  added_timestamp INTEGER NOT NULL,\n  trust_level INTEGER NOT NULL\n) STRICT;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 8L) {
            logger.debug("Updating database: Creating sender key tables");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("CREATE TABLE sender_key (\n  _id INTEGER PRIMARY KEY,\n  recipient_id INTEGER NOT NULL REFERENCES recipient (_id) ON DELETE CASCADE,\n  device_id INTEGER NOT NULL,\n  distribution_id BLOB NOT NULL,\n  record BLOB NOT NULL,\n  created_timestamp INTEGER NOT NULL,\n  UNIQUE(recipient_id, device_id, distribution_id)\n) STRICT;\nCREATE TABLE sender_key_shared (\n  _id INTEGER PRIMARY KEY,\n  recipient_id INTEGER NOT NULL REFERENCES recipient (_id) ON DELETE CASCADE,\n  device_id INTEGER NOT NULL,\n  distribution_id BLOB NOT NULL,\n  timestamp INTEGER NOT NULL,\n  UNIQUE(recipient_id, device_id, distribution_id)\n) STRICT;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 9L) {
            logger.debug("Updating database: Adding urgent field");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("ALTER TABLE message_send_log_content ADD COLUMN urgent INTEGER NOT NULL DEFAULT TRUE;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 10L) {
            logger.debug("Updating database: Key tables on serviceId instead of recipientId");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("CREATE TABLE identity2 (\n  _id INTEGER PRIMARY KEY,\n  uuid BLOB UNIQUE NOT NULL,\n  identity_key BLOB NOT NULL,\n  added_timestamp INTEGER NOT NULL,\n  trust_level INTEGER NOT NULL\n) STRICT;\nINSERT INTO identity2 (_id, uuid, identity_key, added_timestamp, trust_level)\n  SELECT i._id, r.uuid, i.identity_key, i.added_timestamp, i.trust_level\n  FROM identity i LEFT JOIN recipient r ON i.recipient_id = r._id\n  WHERE uuid IS NOT NULL;\nDROP TABLE identity;\nALTER TABLE identity2 RENAME TO identity;\n\nDROP INDEX msl_recipient_index;\nALTER TABLE message_send_log ADD COLUMN uuid BLOB;\nUPDATE message_send_log\n  SET uuid = r.uuid\n  FROM message_send_log i, (SELECT _id, uuid FROM recipient) AS r\n  WHERE i.recipient_id = r._id;\nDELETE FROM message_send_log WHERE uuid IS NULL;\nALTER TABLE message_send_log DROP COLUMN recipient_id;\nCREATE INDEX msl_recipient_index ON message_send_log (uuid, device_id, content_id);\n\nCREATE TABLE sender_key2 (\n  _id INTEGER PRIMARY KEY,\n  uuid BLOB NOT NULL,\n  device_id INTEGER NOT NULL,\n  distribution_id BLOB NOT NULL,\n  record BLOB NOT NULL,\n  created_timestamp INTEGER NOT NULL,\n  UNIQUE(uuid, device_id, distribution_id)\n) STRICT;\nINSERT INTO sender_key2 (_id, uuid, device_id, distribution_id, record, created_timestamp)\n  SELECT s._id, r.uuid, s.device_id, s.distribution_id, s.record, s.created_timestamp\n  FROM sender_key s LEFT JOIN recipient r ON s.recipient_id = r._id\n  WHERE uuid IS NOT NULL;\nDROP TABLE sender_key;\nALTER TABLE sender_key2 RENAME TO sender_key;\n\nCREATE TABLE sender_key_shared2 (\n  _id INTEGER PRIMARY KEY,\n  uuid BLOB NOT NULL,\n  device_id INTEGER NOT NULL,\n  distribution_id BLOB NOT NULL,\n  timestamp INTEGER NOT NULL,\n  UNIQUE(uuid, device_id, distribution_id)\n) STRICT;\nINSERT INTO sender_key_shared2 (_id, uuid, device_id, distribution_id, timestamp)\n  SELECT s._id, r.uuid, s.device_id, s.distribution_id, s.timestamp\n  FROM sender_key_shared s LEFT JOIN recipient r ON s.recipient_id = r._id\n  WHERE uuid IS NOT NULL;\nDROP TABLE sender_key_shared;\nALTER TABLE sender_key_shared2 RENAME TO sender_key_shared;\n\nCREATE TABLE session2 (\n  _id INTEGER PRIMARY KEY,\n  account_id_type INTEGER NOT NULL,\n  uuid BLOB NOT NULL,\n  device_id INTEGER NOT NULL,\n  record BLOB NOT NULL,\n  UNIQUE(account_id_type, uuid, device_id)\n) STRICT;\nINSERT INTO session2 (_id, account_id_type, uuid, device_id, record)\n  SELECT s._id, s.account_id_type, r.uuid, s.device_id, s.record\n  FROM session s LEFT JOIN recipient r ON s.recipient_id = r._id\n  WHERE uuid IS NOT NULL;\nDROP TABLE session;\nALTER TABLE session2 RENAME TO session;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 11L) {
            logger.debug("Updating database: Adding pni field");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("ALTER TABLE recipient ADD COLUMN pni BLOB;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 12L) {
            logger.debug("Updating database: Adding username field");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("ALTER TABLE recipient ADD COLUMN username TEXT;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 13L) {
            logger.debug("Updating database: Cleanup unknown service ids");
            String sql = "DELETE FROM identity AS i\nWHERE i.uuid = ?\n";
            try (PreparedStatement statement2 = connection.prepareStatement("DELETE FROM identity AS i\nWHERE i.uuid = ?\n");){
                statement2.setBytes(1, ServiceId.ACI.UNKNOWN.toByteArray());
                statement2.executeUpdate();
            }
            sql = "DELETE FROM sender_key_shared AS i\nWHERE i.uuid = ?\n";
            statement2 = connection.prepareStatement("DELETE FROM sender_key_shared AS i\nWHERE i.uuid = ?\n");
            try {
                statement2.setBytes(1, ServiceId.ACI.UNKNOWN.toByteArray());
                statement2.executeUpdate();
            }
            finally {
                if (statement2 != null) {
                    statement2.close();
                }
            }
        }
        if (oldVersion < 14L) {
            logger.debug("Updating database: Creating kyber_pre_key table");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("CREATE TABLE kyber_pre_key (\n        _id INTEGER PRIMARY KEY,\n        account_id_type INTEGER NOT NULL,\n        key_id INTEGER NOT NULL,\n        serialized BLOB NOT NULL,\n        is_last_resort INTEGER NOT NULL,\n        UNIQUE(account_id_type, key_id)\n) STRICT;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 15L) {
            logger.debug("Updating database: Store serviceId as TEXT");
            statement = connection.createStatement();
            try {
                AccountDatabase.createUuidMappingTable(connection, statement);
                statement.executeUpdate("CREATE TABLE identity2 (\n  _id INTEGER PRIMARY KEY,\n  address TEXT UNIQUE NOT NULL,\n  identity_key BLOB NOT NULL,\n  added_timestamp INTEGER NOT NULL,\n  trust_level INTEGER NOT NULL\n) STRICT;\nINSERT INTO identity2 (_id, address, identity_key, added_timestamp, trust_level)\n  SELECT i._id, (SELECT t.address FROM tmp_mapping_table t WHERE t.uuid = i.uuid) address, i.identity_key, i.added_timestamp, i.trust_level\n  FROM identity i\n  WHERE address IS NOT NULL;\nDROP TABLE identity;\nALTER TABLE identity2 RENAME TO identity;\n\nCREATE TABLE message_send_log2 (\n  _id INTEGER PRIMARY KEY,\n  content_id INTEGER NOT NULL REFERENCES message_send_log_content (_id) ON DELETE CASCADE,\n  address TEXT NOT NULL,\n  device_id INTEGER NOT NULL\n) STRICT;\nINSERT INTO message_send_log2 (_id, content_id, address, device_id)\n  SELECT m._id, m.content_id, (SELECT t.address FROM tmp_mapping_table t WHERE t.uuid = m.uuid) address, m.device_id\n  FROM message_send_log m\n  WHERE address IS NOT NULL;\nDROP INDEX msl_recipient_index;\nDROP INDEX msl_content_index;\nDROP TABLE message_send_log;\nALTER TABLE message_send_log2 RENAME TO message_send_log;\nCREATE INDEX msl_recipient_index ON message_send_log (address, device_id, content_id);\nCREATE INDEX msl_content_index ON message_send_log (content_id);\n\nCREATE TABLE sender_key2 (\n  _id INTEGER PRIMARY KEY,\n  address TEXT NOT NULL,\n  device_id INTEGER NOT NULL,\n  distribution_id BLOB NOT NULL,\n  record BLOB NOT NULL,\n  created_timestamp INTEGER NOT NULL,\n  UNIQUE(address, device_id, distribution_id)\n) STRICT;\nINSERT INTO sender_key2 (_id, address, device_id, distribution_id, record, created_timestamp)\n  SELECT s._id, (SELECT t.address FROM tmp_mapping_table t WHERE t.uuid = s.uuid) address, s.device_id, s.distribution_id, s.record, s.created_timestamp\n  FROM sender_key s\n  WHERE address IS NOT NULL;\nDROP TABLE sender_key;\nALTER TABLE sender_key2 RENAME TO sender_key;\n\nCREATE TABLE sender_key_shared2 (\n  _id INTEGER PRIMARY KEY,\n  address TEXT NOT NULL,\n  device_id INTEGER NOT NULL,\n  distribution_id BLOB NOT NULL,\n  timestamp INTEGER NOT NULL,\n  UNIQUE(address, device_id, distribution_id)\n) STRICT;\nINSERT INTO sender_key_shared2 (_id, address, device_id, distribution_id, timestamp)\n  SELECT s._id, (SELECT t.address FROM tmp_mapping_table t WHERE t.uuid = s.uuid) address, s.device_id, s.distribution_id, s.timestamp\n  FROM sender_key_shared s\n  WHERE address IS NOT NULL;\nDROP TABLE sender_key_shared;\nALTER TABLE sender_key_shared2 RENAME TO sender_key_shared;\n\nCREATE TABLE session2 (\n  _id INTEGER PRIMARY KEY,\n  account_id_type INTEGER NOT NULL,\n  address TEXT NOT NULL,\n  device_id INTEGER NOT NULL,\n  record BLOB NOT NULL,\n  UNIQUE(account_id_type, address, device_id)\n) STRICT;\nINSERT INTO session2 (_id, account_id_type, address, device_id, record)\n  SELECT s._id, s.account_id_type, (SELECT t.address FROM tmp_mapping_table t WHERE t.uuid = s.uuid) address, s.device_id, s.record\n  FROM session s\n  WHERE address IS NOT NULL;\nDROP TABLE session;\nALTER TABLE session2 RENAME TO session;\n\nDROP TABLE tmp_mapping_table;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 16L) {
            logger.debug("Updating database: Adding stale_timestamp prekey field");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("ALTER TABLE pre_key ADD COLUMN stale_timestamp INTEGER;\nALTER TABLE kyber_pre_key ADD COLUMN stale_timestamp INTEGER;\nALTER TABLE kyber_pre_key ADD COLUMN timestamp INTEGER DEFAULT 0;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 17L) {
            logger.debug("Updating database: Adding key_value table");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("CREATE TABLE key_value (\n        _id INTEGER PRIMARY KEY,\n        key TEXT UNIQUE NOT NULL,\n        value ANY\n) STRICT;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 18L) {
            logger.debug("Updating database: Adding cdsi table");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("CREATE TABLE cdsi (\n  _id INTEGER PRIMARY KEY,\n  number TEXT NOT NULL UNIQUE,\n  last_seen_at INTEGER NOT NULL\n) STRICT;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 19L) {
            logger.debug("Updating database: Adding contact hidden column");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("ALTER TABLE recipient ADD COLUMN hidden INTEGER NOT NULL DEFAULT FALSE;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 20L) {
            logger.debug("Updating database: Creating storage id tables and columns");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("CREATE TABLE storage_id (\n  _id INTEGER PRIMARY KEY,\n  type INTEGER NOT NULL,\n  storage_id BLOB UNIQUE NOT NULL\n) STRICT;\nALTER TABLE group_v1 ADD COLUMN storage_id BLOB;\nALTER TABLE group_v1 ADD COLUMN storage_record BLOB;\nALTER TABLE group_v2 ADD COLUMN storage_id BLOB;\nALTER TABLE group_v2 ADD COLUMN storage_record BLOB;\nALTER TABLE recipient ADD COLUMN storage_id BLOB;\nALTER TABLE recipient ADD COLUMN storage_record BLOB;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 21L) {
            logger.debug("Updating database: Create unregistered column");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("ALTER TABLE recipient ADD unregistered_timestamp INTEGER;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 22L) {
            logger.debug("Updating database: Store recipient aci/pni as TEXT");
            statement = connection.createStatement();
            try {
                AccountDatabase.createUuidMappingTable(connection, statement);
                statement.executeUpdate("CREATE TABLE recipient2 (\n  _id INTEGER PRIMARY KEY AUTOINCREMENT,\n  storage_id BLOB UNIQUE,\n  storage_record BLOB,\n  number TEXT UNIQUE,\n  username TEXT UNIQUE,\n  aci TEXT UNIQUE,\n  pni TEXT UNIQUE,\n  unregistered_timestamp INTEGER,\n  profile_key BLOB,\n  profile_key_credential BLOB,\n\n  given_name TEXT,\n  family_name TEXT,\n  nick_name TEXT,\n  color TEXT,\n\n  expiration_time INTEGER NOT NULL DEFAULT 0,\n  mute_until INTEGER NOT NULL DEFAULT 0,\n  blocked INTEGER NOT NULL DEFAULT FALSE,\n  archived INTEGER NOT NULL DEFAULT FALSE,\n  profile_sharing INTEGER NOT NULL DEFAULT FALSE,\n  hide_story INTEGER NOT NULL DEFAULT FALSE,\n  hidden INTEGER NOT NULL DEFAULT FALSE,\n\n  profile_last_update_timestamp INTEGER NOT NULL DEFAULT 0,\n  profile_given_name TEXT,\n  profile_family_name TEXT,\n  profile_about TEXT,\n  profile_about_emoji TEXT,\n  profile_avatar_url_path TEXT,\n  profile_mobile_coin_address BLOB,\n  profile_unidentified_access_mode TEXT,\n  profile_capabilities TEXT\n) STRICT;\nINSERT INTO recipient2 (_id, aci, pni, storage_id, storage_record, number, username, unregistered_timestamp, profile_key, profile_key_credential, given_name, family_name, color, expiration_time, blocked, archived, profile_sharing, hidden, profile_last_update_timestamp, profile_given_name, profile_family_name, profile_about, profile_about_emoji, profile_avatar_url_path, profile_mobile_coin_address, profile_unidentified_access_mode, profile_capabilities)\n  SELECT r._id, (SELECT t.address FROM tmp_mapping_table t WHERE t.uuid = r.uuid AND t.address not like 'PNI:%') aci, (SELECT t.address FROM tmp_mapping_table t WHERE t.uuid = r.pni AND t.address like 'PNI:%' AND (SELECT COUNT(pni) FROM recipient WHERE pni = r.pni) = 1) pni, storage_id, storage_record, number, username, unregistered_timestamp, profile_key, profile_key_credential, given_name, family_name, color, expiration_time, blocked, archived, profile_sharing, hidden, profile_last_update_timestamp, profile_given_name, profile_family_name, profile_about, profile_about_emoji, profile_avatar_url_path, profile_mobile_coin_address, profile_unidentified_access_mode, profile_capabilities\n  FROM recipient r;\nDROP TABLE recipient;\nALTER TABLE recipient2 RENAME TO recipient;\n\nDROP TABLE tmp_mapping_table;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 23L) {
            logger.debug("Updating database: Create group profile sharing column");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("ALTER TABLE group_v2 ADD profile_sharing INTEGER NOT NULL DEFAULT TRUE;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 24L) {
            logger.debug("Updating database: Create needs_pni_signature column");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("ALTER TABLE recipient ADD needs_pni_signature INTEGER NOT NULL DEFAULT FALSE;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 25L) {
            logger.debug("Updating database: Create nick_name and note columns");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("ALTER TABLE recipient ADD nick_name_given_name TEXT;\nALTER TABLE recipient ADD nick_name_family_name TEXT;\nALTER TABLE recipient ADD note TEXT;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 26L) {
            logger.debug("Updating database: Create discoverable and profile_phone_number_sharing columns");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("ALTER TABLE recipient ADD discoverable INTEGER;\nALTER TABLE recipient ADD profile_phone_number_sharing TEXT;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 27L) {
            logger.debug("Updating database: Create expiration_time_version column");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("ALTER TABLE recipient ADD expiration_time_version INTEGER DEFAULT 1 NOT NULL;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 28L) {
            logger.debug("Updating database: Adding group endorsements");
            statement = connection.createStatement();
            try {
                statement.executeUpdate("ALTER TABLE group_v2 ADD endorsement_expiration_time INTEGER DEFAULT 0 NOT NULL;\nCREATE TABLE group_v2_member (\n  _id INTEGER PRIMARY KEY,\n  group_id INTEGER NOT NULL REFERENCES group_v2 (_id) ON DELETE CASCADE,\n  recipient_id INTEGER NOT NULL REFERENCES recipient (_id) ON DELETE CASCADE,\n  endorsement BLOB NOT NULL,\n  UNIQUE(group_id, recipient_id)\n) STRICT;\n");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    private static void createUuidMappingTable(Connection connection, Statement statement) throws SQLException {
        statement.executeUpdate("CREATE TABLE tmp_mapping_table (\n  uuid BLOB NOT NULL,\n  address TEXT NOT NULL\n) STRICT;\n");
        String sql = "SELECT r.uuid, r.pni\nFROM recipient r\n";
        HashMap uuidAddressMapping = new HashMap();
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT r.uuid, r.pni\nFROM recipient r\n");
             Stream<Pair> result = Utils.executeQueryForStream(preparedStatement, resultSet -> {
            Optional<ServiceId.PNI> pni = Optional.ofNullable(resultSet.getBytes("pni")).map(arg_0 -> ((UuidUtil)UuidUtil.INSTANCE).parseOrNull(arg_0)).map(ServiceId.PNI::from);
            Optional<UUID> serviceIdUuid = Optional.ofNullable(resultSet.getBytes("uuid")).map(arg_0 -> ((UuidUtil)UuidUtil.INSTANCE).parseOrNull(arg_0));
            Optional<ServiceId> serviceId = serviceIdUuid.isPresent() && pni.isPresent() && serviceIdUuid.get().equals(pni.get().getRawUuid()) ? pni.map(p -> p) : serviceIdUuid.map(ServiceId.ACI::from);
            return new Pair<Optional<ServiceId>, Optional<ServiceId.PNI>>(serviceId, pni);
        });){
            result.forEach(p -> {
                UUID rawUuid;
                Optional serviceId = (Optional)p.first();
                Optional pni = (Optional)p.second();
                if (serviceId.isPresent() && !uuidAddressMapping.containsKey(rawUuid = ((ServiceId)serviceId.get()).getRawUuid())) {
                    uuidAddressMapping.put(rawUuid, (ServiceId)serviceId.get());
                }
                if (pni.isPresent()) {
                    uuidAddressMapping.put(((ServiceId.PNI)pni.get()).getRawUuid(), (ServiceId)pni.get());
                }
            });
        }
        String insertSql = "INSERT INTO tmp_mapping_table (uuid, address)\nVALUES (?,?)\n";
        try (PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO tmp_mapping_table (uuid, address)\nVALUES (?,?)\n");){
            for (Map.Entry entry : uuidAddressMapping.entrySet()) {
                UUID uuid = (UUID)entry.getKey();
                ServiceId serviceId = (ServiceId)entry.getValue();
                insertStatement.setBytes(1, UuidUtil.toByteArray((UUID)uuid));
                insertStatement.setString(2, serviceId.toString());
                insertStatement.execute();
            }
        }
    }
}

