/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import org.asamk.signal.manager.api.InvalidStickerException;
import org.asamk.signal.manager.api.StickerPackId;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.stickerPacks.JsonStickerPack;
import org.asamk.signal.manager.storage.stickers.StickerPack;
import org.asamk.signal.manager.util.IOUtils;
import org.signal.core.util.Hex;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.SignalServiceMessageReceiver;
import org.whispersystems.signalservice.api.messages.SignalServiceStickerManifest;

public class StickerHelper {
    private static final Logger logger = LoggerFactory.getLogger(StickerHelper.class);
    private final Context context;
    private final SignalAccount account;
    private final SignalDependencies dependencies;

    public StickerHelper(Context context) {
        this.account = context.getAccount();
        this.dependencies = context.getDependencies();
        this.context = context;
    }

    public StickerPack addOrUpdateStickerPack(StickerPackId stickerPackId, byte[] stickerPackKey, boolean installed) {
        StickerPack sticker = this.account.getStickerStore().getStickerPack(stickerPackId);
        if (sticker != null) {
            if (sticker.isInstalled() != installed) {
                this.account.getStickerStore().updateStickerPackInstalled(sticker.packId(), installed);
            }
            return sticker;
        }
        if (stickerPackKey == null) {
            return null;
        }
        StickerPack newSticker = new StickerPack(-1L, stickerPackId, stickerPackKey, installed);
        this.account.getStickerStore().addStickerPack(newSticker);
        return newSticker;
    }

    public JsonStickerPack getOrRetrieveStickerPack(StickerPackId packId, byte[] packKey) throws InvalidStickerException {
        JsonStickerPack manifest;
        try {
            this.retrieveStickerPack(packId, packKey);
        }
        catch (IOException | InvalidMessageException e) {
            throw new InvalidStickerException("Failed to retrieve sticker pack");
        }
        try {
            manifest = this.context.getStickerPackStore().retrieveManifest(packId);
        }
        catch (IOException e) {
            throw new InvalidStickerException("Failed to load sticker pack manifest");
        }
        return manifest;
    }

    public void retrieveStickerPack(StickerPackId packId, byte[] packKey) throws InvalidMessageException, IOException {
        if (this.context.getStickerPackStore().existsStickerPack(packId)) {
            logger.debug("Sticker pack {} already downloaded.", (Object)Hex.toStringCondensed((byte[])packId.serialize()));
            return;
        }
        logger.debug("Retrieving sticker pack {}.", (Object)Hex.toStringCondensed((byte[])packId.serialize()));
        SignalServiceMessageReceiver messageReceiver = this.dependencies.getMessageReceiver();
        SignalServiceStickerManifest manifest = messageReceiver.retrieveStickerManifest(packId.serialize(), packKey);
        HashSet<Integer> stickerIds = new HashSet<Integer>();
        if (manifest.getCover().isPresent()) {
            stickerIds.add(((SignalServiceStickerManifest.StickerInfo)manifest.getCover().get()).getId());
        }
        for (SignalServiceStickerManifest.StickerInfo sticker : manifest.getStickers()) {
            stickerIds.add(sticker.getId());
        }
        for (Integer id : stickerIds) {
            InputStream inputStream = messageReceiver.retrieveSticker(packId.serialize(), packKey, id.intValue());
            try {
                this.context.getStickerPackStore().storeSticker(packId, id, o -> IOUtils.copyStream(inputStream, o));
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        JsonStickerPack jsonManifest = new JsonStickerPack(manifest.getTitle().orElse(null), manifest.getAuthor().orElse(null), manifest.getCover().map(c -> new JsonStickerPack.JsonSticker(c.getId(), c.getEmoji(), String.valueOf(c.getId()), c.getContentType())).orElse(null), manifest.getStickers().stream().map(c -> new JsonStickerPack.JsonSticker(c.getId(), c.getEmoji(), String.valueOf(c.getId()), c.getContentType())).toList());
        this.context.getStickerPackStore().storeManifest(packId, jsonManifest);
    }
}

