/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import okio.ByteString;
import org.asamk.signal.manager.api.Contact;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupNotFoundException;
import org.asamk.signal.manager.api.GroupSendingNotAllowedException;
import org.asamk.signal.manager.api.NotAGroupMemberException;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.Profile;
import org.asamk.signal.manager.api.UnregisteredRecipientException;
import org.asamk.signal.manager.groups.GroupUtils;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.groups.GroupInfo;
import org.asamk.signal.manager.storage.groups.GroupInfoV2;
import org.asamk.signal.manager.storage.identities.IdentityInfo;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.recipients.RecipientResolver;
import org.asamk.signal.manager.storage.sendLog.MessageSendLogEntry;
import org.asamk.signal.manager.storage.sendLog.MessageSendLogStore;
import org.signal.core.models.ServiceId;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidRegistrationIdException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.message.DecryptionErrorMessage;
import org.signal.libsignal.protocol.message.SenderKeyDistributionMessage;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.libsignal.zkgroup.groupsend.GroupSendEndorsement;
import org.signal.libsignal.zkgroup.groupsend.GroupSendFullToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.SignalServiceMessageSender;
import org.whispersystems.signalservice.api.crypto.ContentHint;
import org.whispersystems.signalservice.api.crypto.SealedSenderAccess;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccess;
import org.whispersystems.signalservice.api.crypto.UntrustedIdentityException;
import org.whispersystems.signalservice.api.groupsv2.GroupSendEndorsements;
import org.whispersystems.signalservice.api.messages.SendMessageResult;
import org.whispersystems.signalservice.api.messages.SignalServiceDataMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceEditMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceReceiptMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceTypingMessage;
import org.whispersystems.signalservice.api.messages.multidevice.SentTranscriptMessage;
import org.whispersystems.signalservice.api.messages.multidevice.SignalServiceSyncMessage;
import org.whispersystems.signalservice.api.push.DistributionId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.push.exceptions.NotFoundException;
import org.whispersystems.signalservice.api.push.exceptions.ProofRequiredException;
import org.whispersystems.signalservice.api.push.exceptions.RateLimitException;
import org.whispersystems.signalservice.api.push.exceptions.UnregisteredUserException;
import org.whispersystems.signalservice.internal.push.Content;
import org.whispersystems.signalservice.internal.push.exceptions.InvalidUnidentifiedAccessHeaderException;
import org.whispersystems.signalservice.internal.push.http.PartialSendCompleteListener;

public class SendHelper {
    private static final Logger logger = LoggerFactory.getLogger(SendHelper.class);
    private final SignalAccount account;
    private final SignalDependencies dependencies;
    private final Context context;

    public SendHelper(Context context) {
        this.account = context.getAccount();
        this.dependencies = context.getDependencies();
        this.context = context;
    }

    public SendMessageResult sendMessage(SignalServiceDataMessage.Builder messageBuilder, RecipientId recipientId, Optional<Long> editTargetTimestamp) {
        Contact contact = this.account.getContactStore().getContact(recipientId);
        if (contact == null || !contact.isProfileSharingEnabled() || contact.isHidden()) {
            Contact.Builder contactBuilder = contact == null ? Contact.newBuilder() : Contact.newBuilder(contact);
            contact = contactBuilder.withIsProfileSharingEnabled(true).withIsHidden(false).build();
            this.account.getContactStore().storeContact(recipientId, contact);
        }
        messageBuilder.withExpiration(contact.messageExpirationTime());
        messageBuilder.withExpireTimerVersion(contact.messageExpirationTimeVersion());
        if (!contact.isBlocked()) {
            byte[] profileKey = this.account.getProfileKey().serialize();
            messageBuilder.withProfileKey(profileKey);
        }
        SignalServiceDataMessage message = messageBuilder.build();
        return this.sendMessage(message, recipientId, editTargetTimestamp);
    }

    public List<SendMessageResult> sendAsGroupMessage(SignalServiceDataMessage.Builder messageBuilder, GroupId groupId, boolean includeSelf, Optional<Long> editTargetTimestamp) throws IOException, GroupNotFoundException, NotAGroupMemberException, GroupSendingNotAllowedException {
        GroupInfo g = this.getGroupForSending(groupId);
        return this.sendAsGroupMessage(messageBuilder, g, includeSelf, editTargetTimestamp);
    }

    public List<SendMessageResult> sendGroupMessage(SignalServiceDataMessage message, Set<RecipientId> recipientIds, GroupInfo groupInfo) throws IOException {
        return this.sendGroupMessage(message, recipientIds, groupInfo, ContentHint.IMPLICIT, Optional.empty());
    }

    public SendMessageResult sendReceiptMessage(SignalServiceReceiptMessage receiptMessage, RecipientId recipientId) {
        MessageSendLogStore messageSendLogStore = this.account.getMessageSendLogStore();
        SendMessageResult result = this.handleSendMessage(recipientId, (messageSender, address, unidentifiedAccess, includePniSignature) -> messageSender.sendReceipt(address, unidentifiedAccess, receiptMessage, includePniSignature));
        messageSendLogStore.insertIfPossible(receiptMessage.getWhen(), result, ContentHint.IMPLICIT, false);
        this.handleSendMessageResult(result);
        return result;
    }

    public SendMessageResult sendProfileKey(RecipientId recipientId) {
        logger.debug("Sending updated profile key to recipient: {}", (Object)recipientId);
        byte[] profileKey = this.account.getProfileKey().serialize();
        SignalServiceDataMessage message = SignalServiceDataMessage.newBuilder().asProfileKeyUpdate(true).withProfileKey(profileKey).build();
        return this.handleSendMessage(recipientId, (messageSender, address, unidentifiedAccess, includePniSignature) -> messageSender.sendDataMessage(address, unidentifiedAccess, ContentHint.IMPLICIT, message, SignalServiceMessageSender.IndividualSendEvents.EMPTY, false, includePniSignature));
    }

    public SendMessageResult sendRetryReceipt(DecryptionErrorMessage errorMessage, RecipientId recipientId, Optional<GroupId> groupId) {
        logger.debug("Sending retry receipt for {} to {}, device: {}", new Object[]{errorMessage.getTimestamp(), recipientId, errorMessage.getDeviceId()});
        SendMessageResult result = this.handleSendMessage(recipientId, (messageSender, address, unidentifiedAccess, includePniSignature) -> messageSender.sendRetryReceipt(address, unidentifiedAccess, groupId.map(GroupId::serialize), errorMessage));
        this.handleSendMessageResult(result);
        return result;
    }

    public SendMessageResult sendNullMessage(RecipientId recipientId) {
        SendMessageResult result = this.handleSendMessage(recipientId, (messageSender, address, unidentifiedAccess, includePniSignature) -> messageSender.sendNullMessage(address, unidentifiedAccess));
        this.handleSendMessageResult(result);
        return result;
    }

    public SendMessageResult sendSelfMessage(SignalServiceDataMessage.Builder messageBuilder, Optional<Long> editTargetTimestamp) {
        RecipientId recipientId = this.account.getSelfRecipientId();
        Contact contact = this.account.getContactStore().getContact(recipientId);
        messageBuilder.withExpiration(contact != null ? contact.messageExpirationTime() : 0);
        messageBuilder.withExpireTimerVersion(contact != null ? contact.messageExpirationTimeVersion() : 1);
        SignalServiceDataMessage message = messageBuilder.build();
        return this.sendSelfMessage(message, editTargetTimestamp);
    }

    public SendMessageResult sendSyncMessage(SignalServiceSyncMessage message) {
        SignalServiceMessageSender messageSender = this.dependencies.getMessageSender();
        if (!this.account.isMultiDevice()) {
            logger.trace("Not sending sync message because there are no linked devices.");
            return SendMessageResult.success((SignalServiceAddress)this.account.getSelfAddress(), List.of(), (boolean)false, (boolean)false, (long)0L, Optional.empty());
        }
        try {
            return messageSender.sendSyncMessage(message);
        }
        catch (Throwable e) {
            SignalServiceAddress address = this.context.getRecipientHelper().resolveSignalServiceAddress(this.account.getSelfRecipientId());
            try {
                return SignalServiceMessageSender.mapSendErrorToSendResult((Throwable)e, (long)System.currentTimeMillis(), (SignalServiceAddress)address);
            }
            catch (IOException ex) {
                logger.warn("Failed to send message due to IO exception: {}", (Object)e.getMessage());
                logger.debug("Exception", e);
                return SendMessageResult.networkFailure((SignalServiceAddress)address);
            }
        }
    }

    public SendMessageResult sendTypingMessage(SignalServiceTypingMessage message, RecipientId recipientId) {
        SendMessageResult result = this.handleSendMessage(recipientId, (messageSender, address, unidentifiedAccess, includePniSignature) -> (SendMessageResult)messageSender.sendTyping(List.of(address), List.of(unidentifiedAccess), message, null).getFirst());
        this.handleSendMessageResult(result);
        return result;
    }

    public List<SendMessageResult> sendGroupTypingMessage(SignalServiceTypingMessage message, GroupId groupId) throws IOException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException {
        GroupInfo g = this.getGroupForSending(groupId);
        if (g.isAnnouncementGroup() && !g.isAdmin(this.account.getSelfRecipientId())) {
            throw new GroupSendingNotAllowedException(groupId, g.getTitle());
        }
        Set<RecipientId> recipientIds = g.getMembersWithout(this.account.getSelfRecipientId());
        return this.sendGroupTypingMessage(message, recipientIds, g);
    }

    public SendMessageResult resendMessage(RecipientId recipientId, long timestamp, MessageSendLogEntry messageSendLogEntry) {
        logger.trace("Resending message {} to {}", (Object)timestamp, (Object)recipientId);
        if (messageSendLogEntry.groupId().isEmpty()) {
            return this.handleSendMessage(recipientId, (messageSender, address, unidentifiedAccess, includePniSignature) -> messageSender.resendContent(address, unidentifiedAccess, timestamp, messageSendLogEntry.content(), messageSendLogEntry.contentHint(), Optional.empty(), messageSendLogEntry.urgent()));
        }
        GroupId groupId = messageSendLogEntry.groupId().get();
        GroupInfo group = this.context.getGroupHelper().getGroup(groupId);
        if (group == null) {
            logger.debug("Could not find a matching group for the groupId {}! Skipping message send.", (Object)groupId.toBase64());
            return null;
        }
        if (!group.getMembers().contains(recipientId)) {
            logger.warn("The target user is no longer in the group {}! Skipping message send.", (Object)groupId.toBase64());
            return null;
        }
        SenderKeyDistributionMessage senderKeyDistributionMessage = this.dependencies.getMessageSender().getOrCreateNewGroupSession(group.getDistributionId());
        ByteString distributionBytes = ByteString.of((byte[])senderKeyDistributionMessage.serialize());
        Content contentToSend = messageSendLogEntry.content().newBuilder().senderKeyDistributionMessage(distributionBytes).build();
        SendMessageResult result = this.handleSendMessage(recipientId, (messageSender, address, unidentifiedAccess, includePniSignature) -> messageSender.resendContent(address, unidentifiedAccess, timestamp, contentToSend, messageSendLogEntry.contentHint(), Optional.of(group.getGroupId().serialize()), messageSendLogEntry.urgent()));
        if (result.isSuccess()) {
            SignalServiceAddress address2 = this.context.getRecipientHelper().resolveSignalServiceAddress(recipientId);
            List<SignalProtocolAddress> addresses = result.getSuccess().getDevices().stream().map(device -> new SignalProtocolAddress(address2.getIdentifier(), device.intValue())).toList();
            this.account.getSenderKeyStore().markSenderKeySharedWith(group.getDistributionId(), addresses);
        }
        return result;
    }

    private List<SendMessageResult> sendAsGroupMessage(SignalServiceDataMessage.Builder messageBuilder, GroupInfo g, boolean includeSelf, Optional<Long> editTargetTimestamp) throws IOException, GroupSendingNotAllowedException {
        Set<RecipientId> recipients;
        GroupUtils.setGroupContext(messageBuilder, g);
        messageBuilder.withExpiration(g.getMessageExpirationTimer());
        SignalServiceDataMessage message = messageBuilder.build();
        Set<RecipientId> set = recipients = includeSelf ? g.getMembers() : g.getMembersWithout(this.account.getSelfRecipientId());
        if (g.isAnnouncementGroup() && !g.isAdmin(this.account.getSelfRecipientId()) && (message.getBody().isPresent() || message.getAttachments().isPresent() || message.getQuote().isPresent() || message.getPreviews().isPresent() || message.getMentions().isPresent() || message.getSticker().isPresent())) {
            throw new GroupSendingNotAllowedException(g.getGroupId(), g.getTitle());
        }
        return this.sendGroupMessage(message, recipients, g, ContentHint.RESENDABLE, editTargetTimestamp);
    }

    private List<SendMessageResult> sendGroupMessage(SignalServiceDataMessage message, Set<RecipientId> recipientIds, GroupInfo groupInfo, ContentHint contentHint, Optional<Long> editTargetTimestamp) throws IOException {
        SignalServiceMessageSender messageSender = this.dependencies.getMessageSender();
        MessageSendLogStore messageSendLogStore = this.account.getMessageSendLogStore();
        AtomicLong entryId = new AtomicLong(-1L);
        boolean urgent = true;
        PartialSendCompleteListener partialSendCompleteListener = sendResult -> {
            logger.trace("Partial message send result: {}", (Object)sendResult.isSuccess());
            AtomicLong atomicLong = entryId;
            synchronized (atomicLong) {
                if (entryId.get() == -1L) {
                    long newId = messageSendLogStore.insertIfPossible(message.getTimestamp(), sendResult, contentHint, true);
                    entryId.set(newId);
                } else {
                    messageSendLogStore.addRecipientToExistingEntryIfPossible(entryId.get(), sendResult);
                }
            }
        };
        LegacySenderHandler legacySender = (recipients, unidentifiedAccess, isRecipientUpdate) -> editTargetTimestamp.isEmpty() ? messageSender.sendDataMessage(recipients, unidentifiedAccess, isRecipientUpdate, contentHint, message, SignalServiceMessageSender.LegacyGroupEvents.EMPTY, partialSendCompleteListener, () -> false, true) : messageSender.sendEditMessage(recipients, unidentifiedAccess, isRecipientUpdate, contentHint, message, SignalServiceMessageSender.LegacyGroupEvents.EMPTY, partialSendCompleteListener, () -> false, true, ((Long)editTargetTimestamp.get()).longValue());
        SenderKeySenderHandler senderKeySender = (distId, recipients, unidentifiedAccess, groupSendEndorsements, isRecipientUpdate) -> messageSender.sendGroupDataMessage(distId, recipients, unidentifiedAccess, groupSendEndorsements, isRecipientUpdate, contentHint, message, SignalServiceMessageSender.SenderKeyGroupEvents.EMPTY, true, false, (SignalServiceEditMessage)editTargetTimestamp.map(timestamp -> new SignalServiceEditMessage(timestamp.longValue(), message)).orElse(null), sendResult -> {
            long newId;
            logger.trace("Partial message send results: {}", (Object)sendResult.size());
            AtomicLong atomicLong = entryId;
            synchronized (atomicLong) {
                if (entryId.get() == -1L) {
                    newId = messageSendLogStore.insertIfPossible(message.getTimestamp(), sendResult, contentHint, true);
                    entryId.set(newId);
                } else {
                    messageSendLogStore.addRecipientToExistingEntryIfPossible(entryId.get(), sendResult);
                }
            }
            atomicLong = entryId;
            synchronized (atomicLong) {
                if (entryId.get() == -1L) {
                    newId = messageSendLogStore.insertIfPossible(message.getTimestamp(), sendResult, contentHint, true);
                    entryId.set(newId);
                } else {
                    messageSendLogStore.addRecipientToExistingEntryIfPossible(entryId.get(), sendResult);
                }
            }
        });
        List<SendMessageResult> results = this.sendGroupMessageInternal(legacySender, senderKeySender, recipientIds, groupInfo, false);
        for (SendMessageResult r : results) {
            this.handleSendMessageResult(r);
        }
        return results;
    }

    private List<SendMessageResult> sendGroupTypingMessage(SignalServiceTypingMessage message, Set<RecipientId> recipientIds, GroupInfo groupInfo) throws IOException {
        SignalServiceMessageSender messageSender = this.dependencies.getMessageSender();
        List<SendMessageResult> results = this.sendGroupMessageInternal((recipients, unidentifiedAccess, isRecipientUpdate) -> messageSender.sendTyping(recipients, unidentifiedAccess, message, () -> false), (distId, recipients, unidentifiedAccess, groupSendEndorsements, isRecipientUpdate) -> messageSender.sendGroupTyping(distId, recipients, unidentifiedAccess, groupSendEndorsements, message), recipientIds, groupInfo, false);
        for (SendMessageResult r : results) {
            this.handleSendMessageResult(r);
        }
        return results;
    }

    private GroupInfo getGroupForSending(GroupId groupId) throws GroupNotFoundException, NotAGroupMemberException {
        GroupInfo g = this.context.getGroupHelper().getGroup(groupId);
        if (g == null) {
            throw new GroupNotFoundException(groupId);
        }
        if (!g.isMember(this.account.getSelfRecipientId())) {
            throw new NotAGroupMemberException(groupId, g.getTitle());
        }
        if (!g.isProfileSharingEnabled()) {
            g.setProfileSharingEnabled(true);
            this.account.getGroupStore().updateGroup(g);
        }
        return g;
    }

    private List<SendMessageResult> sendGroupMessageInternal(LegacySenderHandler legacySender, SenderKeySenderHandler senderKeySender, Set<RecipientId> recipientIds, GroupInfo groupInfo, boolean isRecipientUpdate) throws IOException {
        boolean onlyTargetIsSelfWithLinkedDevice;
        Set senderKeyTargets;
        GroupSecretParams groupSecretParams;
        long startTime = System.currentTimeMillis();
        Map<RecipientId, SignalServiceAddress> addressesMap = recipientIds.stream().collect(Collectors.toMap(id -> id, this.context.getRecipientHelper()::resolveSignalServiceAddress));
        Map<RecipientId, UnidentifiedAccess> unidentifiedAccessesMap = this.context.getUnidentifiedAccessHelper().getAccessFor(recipientIds);
        Pair<Long, Map<RecipientId, GroupSendEndorsement>> groupSendEndorsementsResult = this.getGroupSendEndorsements(groupInfo);
        if (groupInfo instanceof GroupInfoV2) {
            GroupInfoV2 gv2 = (GroupInfoV2)groupInfo;
            groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)gv2.getMasterKey());
        } else {
            groupSecretParams = null;
        }
        GroupSecretParams groupSecretParams2 = groupSecretParams;
        Map<RecipientId, GroupSendEndorsement> groupSendEndorsements = groupSendEndorsementsResult == null ? null : groupSendEndorsementsResult.second();
        long groupSendEndorsementsExpirationMs = groupSendEndorsementsResult == null ? 0L : groupSendEndorsementsResult.first();
        Set<Object> set = senderKeyTargets = groupInfo.getDistributionId() == null || groupSendEndorsements == null ? Set.of() : recipientIds.stream().filter(s -> this.isSenderKeyCapable((RecipientId)s, (SignalServiceAddress)addressesMap.get(s), (UnidentifiedAccess)unidentifiedAccessesMap.get(s), groupSendEndorsements)).collect(Collectors.toSet());
        if (senderKeyTargets.size() < 2) {
            logger.debug("Too few sender-key-capable users ({}). Doing all legacy sends.", (Object)senderKeyTargets.size());
            senderKeyTargets = Set.of();
        } else {
            logger.debug("Can use sender key for {}/{} recipients.", (Object)senderKeyTargets.size(), (Object)recipientIds.size());
        }
        ArrayList<SendMessageResult> allResults = new ArrayList<SendMessageResult>(recipientIds.size());
        if (!senderKeyTargets.isEmpty()) {
            SenderCertificate senderCertificate = this.context.getUnidentifiedAccessHelper().getSenderCertificateFor(null);
            List<SignalServiceAddress> addresses = senderKeyTargets.stream().map(addressesMap::get).toList();
            GroupSendEndorsements requiredGroupSendEndorsements = new GroupSendEndorsements(groupSendEndorsementsExpirationMs, senderKeyTargets.stream().collect(Collectors.toMap(recipientId -> (ServiceId.ACI)((SignalServiceAddress)addressesMap.get(recipientId)).getServiceId(), groupSendEndorsements::get)), senderCertificate, groupSecretParams2);
            List<SendMessageResult> results = this.sendGroupMessageInternalWithSenderKey(senderKeySender, groupInfo.getDistributionId(), addresses, senderKeyTargets.stream().map(unidentifiedAccessesMap::get).toList(), requiredGroupSendEndorsements, isRecipientUpdate);
            if (results == null) {
                senderKeyTargets = Set.of();
            } else {
                results.stream().filter(SendMessageResult::isSuccess).forEach(allResults::add);
                RecipientResolver recipientResolver = this.account.getRecipientResolver();
                List<RecipientId> failedTargets = results.stream().filter(r -> !r.isSuccess()).map(r -> recipientResolver.resolveRecipient(r.getAddress())).toList();
                if (!failedTargets.isEmpty()) {
                    senderKeyTargets = new HashSet(senderKeyTargets);
                    failedTargets.forEach(senderKeyTargets::remove);
                }
            }
        }
        HashSet<RecipientId> legacyTargets = new HashSet<RecipientId>(recipientIds);
        legacyTargets.removeAll(senderKeyTargets);
        boolean bl = onlyTargetIsSelfWithLinkedDevice = recipientIds.isEmpty() && this.account.isMultiDevice();
        if (!legacyTargets.isEmpty() || onlyTargetIsSelfWithLinkedDevice) {
            if (!legacyTargets.isEmpty()) {
                logger.debug("Need to do {} legacy sends.", (Object)legacyTargets.size());
            } else {
                logger.debug("Need to do a legacy send to send a sync message for a group of only ourselves.");
            }
            List<SignalServiceAddress> addresses = legacyTargets.stream().map(addressesMap::get).toList();
            List<UnidentifiedAccess> unidentifiedAccess = legacyTargets.stream().map(unidentifiedAccessesMap::get).toList();
            SenderCertificate senderCertificate = unidentifiedAccess.stream().filter(Objects::nonNull).findFirst().map(UnidentifiedAccess::getUnidentifiedCertificate).orElse(null);
            Instant expirationMs = Instant.ofEpochMilli(groupSendEndorsementsExpirationMs);
            List<GroupSendFullToken> groupSendTokens = groupSendEndorsements != null && groupSecretParams2 != null ? legacyTargets.stream().map(groupSendEndorsements::get).map(endorsement -> Optional.ofNullable(endorsement).map(e -> e.toFullToken(groupSecretParams2, expirationMs)).orElse(null)).toList() : null;
            List sealedSenderAccesses = SealedSenderAccess.forFanOutGroupSend(groupSendTokens, (SenderCertificate)senderCertificate, unidentifiedAccess);
            List<SendMessageResult> results = this.sendGroupMessageInternalWithLegacy(legacySender, addresses, sealedSenderAccesses, isRecipientUpdate || !allResults.isEmpty());
            allResults.addAll(results);
        }
        Duration duration = Duration.ofMillis(System.currentTimeMillis() - startTime);
        logger.debug("Sending took {}", (Object)duration.toString());
        return allResults;
    }

    private Pair<Long, Map<RecipientId, GroupSendEndorsement>> getGroupSendEndorsements(GroupInfo groupInfo) {
        if (!(groupInfo instanceof GroupInfoV2)) {
            return null;
        }
        GroupInfoV2 groupInfoV2 = (GroupInfoV2)groupInfo;
        Map<RecipientId, GroupSendEndorsement> groupSendEndorsementMap = this.account.getGroupStore().getGroupEndorsements(groupInfoV2.getGroupId());
        long groupSendEndorsementExpirationMs = this.account.getGroupStore().getGroupEndorsementExpirationMs(groupInfoV2.getGroupId());
        if (groupSendEndorsementMap.isEmpty() || groupSendEndorsementExpirationMs - TimeUnit.HOURS.toMillis(2L) < System.currentTimeMillis()) {
            logger.debug("No group send endorsements available, trying to update");
            this.context.getGroupHelper().updateGroupSendEndorsements(groupInfoV2.getGroupId());
            groupSendEndorsementMap = this.account.getGroupStore().getGroupEndorsements(groupInfoV2.getGroupId());
            groupSendEndorsementExpirationMs = this.account.getGroupStore().getGroupEndorsementExpirationMs(groupInfoV2.getGroupId());
            if (groupSendEndorsementMap.isEmpty() || groupSendEndorsementExpirationMs - TimeUnit.HOURS.toMillis(2L) < System.currentTimeMillis()) {
                logger.debug("Updating group send endorsements was not successful");
                return null;
            }
        }
        return new Pair<Long, Map<RecipientId, GroupSendEndorsement>>(groupSendEndorsementExpirationMs, groupSendEndorsementMap);
    }

    private boolean isSenderKeyCapable(RecipientId recipientId, SignalServiceAddress address, UnidentifiedAccess access, Map<RecipientId, GroupSendEndorsement> groupSendEndorsements) {
        ServiceId serviceId;
        if (access == null || !address.hasValidServiceId() || !((serviceId = address.getServiceId()) instanceof ServiceId.ACI)) {
            return false;
        }
        ServiceId.ACI aci = (ServiceId.ACI)serviceId;
        if (!groupSendEndorsements.containsKey(recipientId)) {
            return false;
        }
        IdentityInfo identity = this.account.getIdentityKeyStore().getIdentityInfo((ServiceId)aci);
        return identity != null && identity.getTrustLevel().isTrusted();
    }

    private List<SendMessageResult> sendGroupMessageInternalWithLegacy(LegacySenderHandler sender, List<SignalServiceAddress> addresses, List<SealedSenderAccess> unidentifiedAccesses, boolean isRecipientUpdate) throws IOException {
        try {
            List<SendMessageResult> results = sender.send(addresses, unidentifiedAccesses, isRecipientUpdate);
            long successCount = results.stream().filter(SendMessageResult::isSuccess).count();
            logger.debug("Successfully sent using 1:1 to {}/{} legacy targets.", (Object)successCount, (Object)addresses.size());
            return results;
        }
        catch (UntrustedIdentityException e) {
            return List.of();
        }
    }

    private List<SendMessageResult> sendGroupMessageInternalWithSenderKey(SenderKeySenderHandler sender, DistributionId distributionId, List<SignalServiceAddress> addresses, List<UnidentifiedAccess> unidentifiedAccesses, GroupSendEndorsements groupSendEndorsements, boolean isRecipientUpdate) throws IOException {
        long keyCreateTime = this.account.getSenderKeyStore().getCreateTimeForOurKey((ServiceId)this.account.getAci(), this.account.getDeviceId(), distributionId);
        long keyAge = System.currentTimeMillis() - keyCreateTime;
        if (keyCreateTime != -1L && keyAge > TimeUnit.DAYS.toMillis(14L)) {
            logger.debug("DistributionId {} was created at {} and is {} ms old (~{} days). Rotating.", new Object[]{distributionId, keyCreateTime, keyAge, TimeUnit.MILLISECONDS.toDays(keyAge)});
            this.account.getSenderKeyStore().deleteOurKey((ServiceId)this.account.getAci(), distributionId);
        }
        try {
            List<SendMessageResult> results = sender.send(distributionId, addresses, unidentifiedAccesses, groupSendEndorsements, isRecipientUpdate);
            long successCount = results.stream().filter(SendMessageResult::isSuccess).count();
            logger.debug("Successfully sent using sender key to {}/{} sender key targets.", (Object)successCount, (Object)addresses.size());
            return results;
        }
        catch (UntrustedIdentityException e) {
            return null;
        }
        catch (InvalidUnidentifiedAccessHeaderException e) {
            logger.warn("Someone had a bad UD header. Falling back to legacy sends.", (Throwable)e);
            return null;
        }
        catch (NoSessionException e) {
            logger.warn("No session. Falling back to legacy sends.", (Throwable)e);
            this.account.getSenderKeyStore().deleteOurKey((ServiceId)this.account.getAci(), distributionId);
            return null;
        }
        catch (InvalidKeyException e) {
            logger.warn("Invalid key. Falling back to legacy sends.", (Throwable)e);
            this.account.getSenderKeyStore().deleteOurKey((ServiceId)this.account.getAci(), distributionId);
            return null;
        }
        catch (InvalidRegistrationIdException e) {
            logger.warn("Invalid registrationId. Falling back to legacy sends.", (Throwable)e);
            return null;
        }
        catch (NotFoundException e) {
            logger.warn("Someone was unregistered. Falling back to legacy sends.", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            if (e.getCause() instanceof InvalidKeyException) {
                logger.warn("Invalid key. Falling back to legacy sends.", (Throwable)e);
                return null;
            }
            throw e;
        }
    }

    private SendMessageResult sendMessage(SignalServiceDataMessage message, RecipientId recipientId, Optional<Long> editTargetTimestamp) {
        MessageSendLogStore messageSendLogStore = this.account.getMessageSendLogStore();
        boolean urgent = true;
        SendMessageResult result = this.handleSendMessage(recipientId, editTargetTimestamp.isEmpty() ? (messageSender, address, unidentifiedAccess, includePniSignature) -> messageSender.sendDataMessage(address, unidentifiedAccess, ContentHint.RESENDABLE, message, SignalServiceMessageSender.IndividualSendEvents.EMPTY, true, includePniSignature) : (messageSender, address, unidentifiedAccess, includePniSignature) -> messageSender.sendEditMessage(address, unidentifiedAccess, ContentHint.RESENDABLE, message, SignalServiceMessageSender.IndividualSendEvents.EMPTY, true, ((Long)editTargetTimestamp.get()).longValue()));
        messageSendLogStore.insertIfPossible(message.getTimestamp(), result, ContentHint.RESENDABLE, true);
        this.handleSendMessageResult(result);
        return result;
    }

    private SendMessageResult handleSendMessage(RecipientId recipientId, SenderHandler s) {
        SignalServiceMessageSender messageSender = this.dependencies.getMessageSender();
        SignalServiceAddress address = this.context.getRecipientHelper().resolveSignalServiceAddress(recipientId);
        try {
            boolean includePniSignature = this.account.getRecipientStore().needsPniSignature(recipientId);
            try {
                return s.send(messageSender, address, this.context.getUnidentifiedAccessHelper().getSealedSenderAccessFor(recipientId), includePniSignature);
            }
            catch (UnregisteredUserException e) {
                RecipientId newRecipientId;
                try {
                    newRecipientId = this.context.getRecipientHelper().refreshRegisteredUser(recipientId);
                }
                catch (UnregisteredRecipientException ex) {
                    return SendMessageResult.unregisteredFailure((SignalServiceAddress)address);
                }
                address = this.context.getRecipientHelper().resolveSignalServiceAddress(newRecipientId);
                return s.send(messageSender, address, this.context.getUnidentifiedAccessHelper().getSealedSenderAccessFor(newRecipientId), includePniSignature);
            }
        }
        catch (Throwable e) {
            try {
                return SignalServiceMessageSender.mapSendErrorToSendResult((Throwable)e, (long)System.currentTimeMillis(), (SignalServiceAddress)address);
            }
            catch (IOException ex) {
                logger.warn("Failed to send message due to IO exception: {}", (Object)e.getMessage());
                logger.debug("Exception", e);
                return SendMessageResult.networkFailure((SignalServiceAddress)address);
            }
        }
    }

    private SendMessageResult sendSelfMessage(SignalServiceDataMessage message, Optional<Long> editTargetTimestamp) {
        SignalServiceAddress address = this.account.getSelfAddress();
        SentTranscriptMessage transcript = new SentTranscriptMessage(Optional.of(address), message.getTimestamp(), editTargetTimestamp.isEmpty() ? Optional.of(message) : Optional.empty(), (long)message.getExpiresInSeconds(), Map.of(address.getServiceId(), true), false, Optional.empty(), Set.of(), editTargetTimestamp.map(timestamp -> new SignalServiceEditMessage(timestamp.longValue(), message)));
        SignalServiceSyncMessage syncMessage = SignalServiceSyncMessage.forSentTranscript((SentTranscriptMessage)transcript);
        return this.sendSyncMessage(syncMessage);
    }

    private void handleSendMessageResult(SendMessageResult r) {
        Profile profile;
        RecipientId recipientId;
        if (r.isSuccess() && !r.getSuccess().isUnidentified()) {
            recipientId = this.account.getRecipientResolver().resolveRecipient(r.getAddress());
            profile = this.account.getProfileStore().getProfile(recipientId);
            if (profile != null && (profile.getUnidentifiedAccessMode() == Profile.UnidentifiedAccessMode.ENABLED || profile.getUnidentifiedAccessMode() == Profile.UnidentifiedAccessMode.UNRESTRICTED)) {
                this.account.getProfileStore().storeProfile(recipientId, Profile.newBuilder(profile).withUnidentifiedAccessMode(Profile.UnidentifiedAccessMode.UNKNOWN).build());
            }
        }
        if (r.isUnregisteredFailure()) {
            recipientId = this.account.getRecipientResolver().resolveRecipient(r.getAddress());
            profile = this.account.getProfileStore().getProfile(recipientId);
            if (profile != null && (profile.getUnidentifiedAccessMode() == Profile.UnidentifiedAccessMode.ENABLED || profile.getUnidentifiedAccessMode() == Profile.UnidentifiedAccessMode.UNRESTRICTED)) {
                this.account.getProfileStore().storeProfile(recipientId, Profile.newBuilder(profile).withUnidentifiedAccessMode(Profile.UnidentifiedAccessMode.UNKNOWN).build());
            }
        }
        if (r.getIdentityFailure() != null) {
            recipientId = this.account.getRecipientResolver().resolveRecipient(r.getAddress());
            this.context.getIdentityHelper().handleIdentityFailure(recipientId, r.getAddress().getServiceId(), r.getIdentityFailure());
        }
    }

    static interface SenderHandler {
        public SendMessageResult send(SignalServiceMessageSender var1, SignalServiceAddress var2, SealedSenderAccess var3, boolean var4) throws IOException, UnregisteredUserException, ProofRequiredException, RateLimitException, UntrustedIdentityException;
    }

    static interface LegacySenderHandler {
        public List<SendMessageResult> send(List<SignalServiceAddress> var1, List<SealedSenderAccess> var2, boolean var3) throws IOException, UntrustedIdentityException;
    }

    static interface SenderKeySenderHandler {
        public List<SendMessageResult> send(DistributionId var1, List<SignalServiceAddress> var2, List<UnidentifiedAccess> var3, GroupSendEndorsements var4, boolean var5) throws IOException, UntrustedIdentityException, NoSessionException, InvalidKeyException, InvalidRegistrationIdException;
    }
}

