/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.asamk.signal.manager.api.RecipientAddress;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.UnregisteredRecipientException;
import org.asamk.signal.manager.api.UsernameLinkUrl;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.util.Utils;
import org.signal.core.models.ServiceId;
import org.signal.libsignal.usernames.BaseUsernameException;
import org.signal.libsignal.usernames.Username;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.cds.CdsiV2Service;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.push.UsernameLinkComponents;
import org.whispersystems.signalservice.api.push.exceptions.CdsiInvalidArgumentException;
import org.whispersystems.signalservice.api.push.exceptions.CdsiInvalidTokenException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;

public class RecipientHelper {
    private static final Logger logger = LoggerFactory.getLogger(RecipientHelper.class);
    private final SignalAccount account;
    private final SignalDependencies dependencies;

    public RecipientHelper(Context context) {
        this.account = context.getAccount();
        this.dependencies = context.getDependencies();
    }

    public SignalServiceAddress resolveSignalServiceAddress(RecipientId recipientId) {
        ServiceId serviceId;
        org.asamk.signal.manager.storage.recipients.RecipientAddress address = this.account.getRecipientAddressResolver().resolveRecipientAddress(recipientId);
        if (address.number().isEmpty() || address.serviceId().isPresent()) {
            return address.toSignalServiceAddress();
        }
        String number = address.number().get();
        try {
            serviceId = this.getRegisteredUserByNumber(number);
        }
        catch (UnregisteredRecipientException e) {
            logger.warn("Failed to get uuid for e164 number: {}", (Object)number);
            return address.toSignalServiceAddress();
        }
        catch (IOException e) {
            logger.warn("Failed to get uuid for e164 number: {}", (Object)number, (Object)e);
            return address.toSignalServiceAddress();
        }
        return this.account.getRecipientAddressResolver().resolveRecipientAddress(this.account.getRecipientResolver().resolveRecipient(serviceId)).toSignalServiceAddress();
    }

    public Set<RecipientId> resolveRecipients(Collection<RecipientIdentifier.Single> recipients) throws UnregisteredRecipientException, IOException {
        HashSet<RecipientId> recipientIds = new HashSet<RecipientId>(recipients.size());
        for (RecipientIdentifier.Single number : recipients) {
            RecipientId recipientId = this.resolveRecipient(number);
            recipientIds.add(recipientId);
        }
        return recipientIds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RecipientId resolveRecipient(RecipientIdentifier.Single recipient) throws UnregisteredRecipientException {
        String username2;
        if (recipient instanceof RecipientIdentifier.Uuid) {
            UUID uUID;
            RecipientIdentifier.Uuid uuid = (RecipientIdentifier.Uuid)recipient;
            UUID uuid2 = uUID = uuid.uuid();
            return this.account.getRecipientResolver().resolveRecipient((ServiceId)ServiceId.ACI.from((UUID)uuid2));
        }
        if (recipient instanceof RecipientIdentifier.Pni) {
            UUID uUID;
            RecipientIdentifier.Pni pni = (RecipientIdentifier.Pni)recipient;
            UUID pni2 = uUID = pni.pni();
            return this.account.getRecipientResolver().resolveRecipient((ServiceId)ServiceId.PNI.from((UUID)pni2));
        }
        if (recipient instanceof RecipientIdentifier.Number) {
            String string;
            RecipientIdentifier.Number number = (RecipientIdentifier.Number)recipient;
            String number2 = string = number.number();
            return this.account.getRecipientStore().resolveRecipientByNumber(number2, () -> {
                try {
                    return this.getRegisteredUserByNumber(number2);
                }
                catch (Exception e) {
                    return null;
                }
            });
        }
        if (!(recipient instanceof RecipientIdentifier.Username)) throw new AssertionError((Object)("Unexpected RecipientIdentifier: " + String.valueOf(recipient)));
        RecipientIdentifier.Username username = (RecipientIdentifier.Username)recipient;
        try {
            String string;
            username2 = string = username.username();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        try {
            return this.resolveRecipientByUsernameOrLink(username2, false);
        }
        catch (Exception e) {
            throw new UnregisteredRecipientException(new RecipientAddress(null, null, null, username2));
        }
    }

    public RecipientId resolveRecipientByUsernameOrLink(String username, boolean forceRefresh) throws UnregisteredRecipientException, IOException {
        Username finalUsername;
        try {
            finalUsername = this.getUsernameFromUsernameOrLink(username);
        }
        catch (IOException | BaseUsernameException e) {
            throw new RuntimeException(e);
        }
        if (forceRefresh) {
            try {
                ServiceId.ACI aci = (ServiceId.ACI)Utils.handleResponseException(this.dependencies.getUsernameApi().getAciByUsername(finalUsername));
                return this.account.getRecipientStore().resolveRecipientTrusted(aci, finalUsername.getUsername());
            }
            catch (NonSuccessfulResponseCodeException e) {
                if (e.code == 404) {
                    throw new UnregisteredRecipientException(new RecipientAddress(null, null, null, username));
                }
                logger.debug("Failed to get uuid for username: {}", (Object)username, (Object)e);
                throw e;
            }
        }
        return this.account.getRecipientStore().resolveRecipientByUsername(finalUsername.getUsername(), () -> {
            try {
                ServiceId.ACI result = (ServiceId.ACI)Utils.handleResponseException(this.dependencies.getUsernameApi().getAciByUsername(finalUsername));
                return result;
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    private Username getUsernameFromUsernameOrLink(String username) throws BaseUsernameException, IOException {
        try {
            UsernameLinkUrl usernameLinkUrl = UsernameLinkUrl.fromUri(username);
            UsernameLinkComponents components = usernameLinkUrl.getComponents();
            byte[] encryptedUsername = (byte[])Utils.handleResponseException(this.dependencies.getUsernameApi().getEncryptedUsernameFromLinkServerId(components.getServerId()));
            Username.UsernameLink link = new Username.UsernameLink(components.getEntropy(), encryptedUsername);
            return Username.fromLink((Username.UsernameLink)link);
        }
        catch (UsernameLinkUrl.InvalidUsernameLinkException e) {
            return new Username(username);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<RecipientId> resolveRecipientOptional(RecipientIdentifier.Single recipient) {
        try {
            return Optional.of(this.resolveRecipient(recipient));
        }
        catch (UnregisteredRecipientException e) {
            if (!(recipient instanceof RecipientIdentifier.Number)) return Optional.empty();
            RecipientIdentifier.Number number = (RecipientIdentifier.Number)recipient;
            try {
                String string;
                String number2 = string = number.number();
                return this.account.getRecipientStore().resolveRecipientByNumberOptional(number2);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    public void refreshUsers() throws IOException {
        this.getRegisteredUsers(this.account.getRecipientStore().getAllNumbers(), false);
    }

    public RecipientId refreshRegisteredUser(RecipientId recipientId) throws IOException, UnregisteredRecipientException {
        SignalServiceAddress address = this.resolveSignalServiceAddress(recipientId);
        if (address.getNumber().isEmpty()) {
            return recipientId;
        }
        String number = (String)address.getNumber().get();
        ServiceId serviceId = this.getRegisteredUserByNumber(number);
        return this.account.getRecipientTrustedResolver().resolveRecipientTrusted(new SignalServiceAddress(serviceId, number));
    }

    public Map<String, RegisteredUser> getRegisteredUsers(final Set<String> numbers) throws IOException {
        if (numbers.size() > 3) {
            HashSet<String> allNumbers = new HashSet<String>(this, this.account.getRecipientStore().getAllNumbers()){
                final /* synthetic */ RecipientHelper this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.addAll(numbers);
                }
            };
            return this.getRegisteredUsers((Set<String>)allNumbers, false);
        }
        return this.getRegisteredUsers(numbers, true);
    }

    private Map<String, RegisteredUser> getRegisteredUsers(Set<String> numbers, boolean isPartialRefresh) throws IOException {
        Map<String, RegisteredUser> registeredUsers = this.getRegisteredUsersV2(numbers, isPartialRefresh);
        registeredUsers.forEach((number, u) -> this.account.getRecipientTrustedResolver().resolveRecipientTrusted(u.aci, u.pni, Optional.of(number)));
        HashSet<String> unregisteredUsers = new HashSet<String>(numbers);
        unregisteredUsers.removeAll(registeredUsers.keySet());
        this.account.getRecipientStore().markUndiscoverablePossiblyUnregistered(unregisteredUsers);
        this.account.getRecipientStore().markDiscoverable(registeredUsers.keySet());
        return registeredUsers;
    }

    private ServiceId getRegisteredUserByNumber(String number) throws IOException, UnregisteredRecipientException {
        Map<String, RegisteredUser> aciMap;
        try {
            aciMap = this.getRegisteredUsers(Set.of(number), true);
        }
        catch (NumberFormatException e) {
            throw new UnregisteredRecipientException(new RecipientAddress(number));
        }
        RegisteredUser user = aciMap.get(number);
        if (user == null) {
            throw new UnregisteredRecipientException(new RecipientAddress(number));
        }
        return user.getServiceId();
    }

    private Map<String, RegisteredUser> getRegisteredUsersV2(Set<String> numbers, boolean isPartialRefresh) throws IOException {
        CdsiV2Service.Response response;
        final Set<Object> previousNumbers = isPartialRefresh ? Set.of() : this.account.getCdsiStore().getAllNumbers();
        HashSet<String> newNumbers = new HashSet<String>(this, numbers){
            final /* synthetic */ RecipientHelper this$0;
            {
                this.this$0 = this$0;
                super(arg0);
                this.removeAll(previousNumbers);
            }
        };
        if (newNumbers.isEmpty() && previousNumbers.isEmpty()) {
            logger.debug("No new numbers to query.");
            return Map.of();
        }
        logger.trace("Querying CDSI for {} new numbers ({} previous), isPartialRefresh={}", new Object[]{newNumbers.size(), previousNumbers.size(), isPartialRefresh});
        Optional token = previousNumbers.isEmpty() ? Optional.empty() : Optional.ofNullable(this.account.getCdsiToken());
        try {
            response = (CdsiV2Service.Response)Utils.handleResponseException(this.dependencies.getCdsApi().getRegisteredUsers(token.isEmpty() ? Set.of() : previousNumbers, (Set)newNumbers, this.account.getRecipientStore().getServiceIdToProfileKeyMap(), token, null, this.dependencies.getLibSignalNetwork(), arg_0 -> this.lambda$getRegisteredUsersV2$0(isPartialRefresh, newNumbers, previousNumbers, numbers, arg_0)));
        }
        catch (CdsiInvalidArgumentException | CdsiInvalidTokenException e) {
            this.account.setCdsiToken(null);
            this.account.getCdsiStore().clearAll();
            throw e;
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
        logger.debug("CDSI request successful, quota used by this request: {}", (Object)response.getQuotaUsedDebugOnly());
        HashMap<String, RegisteredUser> registeredUsers = new HashMap<String, RegisteredUser>();
        response.getResults().forEach((key, value) -> registeredUsers.put((String)key, new RegisteredUser(value.getAci(), Optional.of(value.getPni()))));
        return registeredUsers;
    }

    private /* synthetic */ void lambda$getRegisteredUsersV2$0(boolean isPartialRefresh, final 2 newNumbers, Set previousNumbers, Set numbers, byte[] newToken) {
        if (isPartialRefresh) {
            this.account.getCdsiStore().updateAfterPartialCdsQuery(newNumbers);
        } else {
            HashSet<String> fullNumbers = new HashSet<String>(this, (Collection)previousNumbers){
                final /* synthetic */ RecipientHelper this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.addAll(newNumbers);
                }
            };
            HashSet<String> seenNumbers = new HashSet<String>(this, (Collection)numbers){
                final /* synthetic */ RecipientHelper this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                    this.addAll(newNumbers);
                }
            };
            this.account.getCdsiStore().updateAfterFullCdsQuery((Set<String>)fullNumbers, (Set<String>)seenNumbers);
            this.account.setCdsiToken(newToken);
            this.account.setLastRecipientsRefresh(System.currentTimeMillis());
        }
    }

    public record RegisteredUser(Optional<ServiceId.ACI> aci, Optional<ServiceId.PNI> pni) {
        public RegisteredUser {
            aci = aci.isPresent() && aci.get().isUnknown() ? Optional.empty() : aci;
            Optional<Object> optional = pni = pni.isPresent() && pni.get().isUnknown() ? Optional.empty() : pni;
            if (aci.isEmpty() && pni.isEmpty()) {
                throw new AssertionError((Object)"Must have either a ACI or PNI!");
            }
        }

        public ServiceId getServiceId() {
            return this.aci.map(a -> a).or(this::pni).orElse(null);
        }
    }
}

