/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import org.asamk.signal.manager.api.IncorrectPinException;
import org.signal.core.models.MasterKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.svr.SecureValueRecovery;
import org.whispersystems.signalservice.internal.push.AuthCredentials;
import org.whispersystems.signalservice.internal.push.LockedException;

public class PinHelper {
    private static final Logger logger = LoggerFactory.getLogger(PinHelper.class);
    private final List<SecureValueRecovery> secureValueRecoveries;

    public PinHelper(List<SecureValueRecovery> secureValueRecoveries) {
        this.secureValueRecoveries = secureValueRecoveries;
    }

    public void setRegistrationLockPin(String pin, MasterKey masterKey) throws IOException {
        IOException exception = null;
        boolean setPinSuccessfully = false;
        for (SecureValueRecovery secureValueRecovery : this.secureValueRecoveries) {
            try {
                SecureValueRecovery.BackupResponse backupResponse;
                SecureValueRecovery.BackupResponse backupResponse2 = backupResponse = secureValueRecovery.setPin(pin, masterKey).execute();
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SecureValueRecovery.BackupResponse.Success.class, SecureValueRecovery.BackupResponse.ServerRejected.class, SecureValueRecovery.BackupResponse.EnclaveNotFound.class, SecureValueRecovery.BackupResponse.ExposeFailure.class, SecureValueRecovery.BackupResponse.ApplicationError.class, SecureValueRecovery.BackupResponse.NetworkError.class}, (Object)backupResponse2, n)) {
                    case 0: {
                        SecureValueRecovery.BackupResponse.Success success = (SecureValueRecovery.BackupResponse.Success)backupResponse2;
                        setPinSuccessfully = true;
                        logger.trace("PIN set successfully");
                        break;
                    }
                    case 1: {
                        SecureValueRecovery.BackupResponse.ServerRejected serverRejected = (SecureValueRecovery.BackupResponse.ServerRejected)backupResponse2;
                        logger.warn("Backup svr failed: ServerRejected");
                        break;
                    }
                    case 2: {
                        SecureValueRecovery.BackupResponse.EnclaveNotFound enclaveNotFound = (SecureValueRecovery.BackupResponse.EnclaveNotFound)backupResponse2;
                        logger.warn("Backup svr failed: EnclaveNotFound");
                        break;
                    }
                    case 3: {
                        SecureValueRecovery.BackupResponse.ExposeFailure exposeFailure = (SecureValueRecovery.BackupResponse.ExposeFailure)backupResponse2;
                        logger.warn("Backup svr failed: ExposeFailure");
                        break;
                    }
                    case 4: {
                        SecureValueRecovery.BackupResponse.ApplicationError error = (SecureValueRecovery.BackupResponse.ApplicationError)backupResponse2;
                        throw new IOException(error.getException());
                    }
                    case 5: {
                        SecureValueRecovery.BackupResponse.NetworkError error = (SecureValueRecovery.BackupResponse.NetworkError)backupResponse2;
                        throw error.getException();
                    }
                    default: {
                        throw new AssertionError((Object)"Unexpected response");
                    }
                }
            }
            catch (IOException e) {
                exception = e;
            }
        }
        if (!setPinSuccessfully && exception != null) {
            throw exception;
        }
    }

    public void migrateRegistrationLockPin(String pin, MasterKey masterKey) throws IOException {
        this.setRegistrationLockPin(pin, masterKey);
    }

    public void removeRegistrationLockPin() throws IOException {
        IOException exception = null;
        boolean removedPinSuccessfully = false;
        for (SecureValueRecovery secureValueRecovery : this.secureValueRecoveries) {
            try {
                SecureValueRecovery.DeleteResponse deleteResponse;
                SecureValueRecovery.DeleteResponse deleteResponse2 = deleteResponse = secureValueRecovery.deleteData();
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SecureValueRecovery.DeleteResponse.Success.class, SecureValueRecovery.DeleteResponse.ServerRejected.class, SecureValueRecovery.DeleteResponse.EnclaveNotFound.class, SecureValueRecovery.DeleteResponse.ApplicationError.class, SecureValueRecovery.DeleteResponse.NetworkError.class}, (Object)deleteResponse2, n)) {
                    case 0: {
                        SecureValueRecovery.DeleteResponse.Success success = (SecureValueRecovery.DeleteResponse.Success)deleteResponse2;
                        removedPinSuccessfully = true;
                        break;
                    }
                    case 1: {
                        SecureValueRecovery.DeleteResponse.ServerRejected serverRejected = (SecureValueRecovery.DeleteResponse.ServerRejected)deleteResponse2;
                        logger.warn("Delete svr2 failed: ServerRejected");
                        break;
                    }
                    case 2: {
                        SecureValueRecovery.DeleteResponse.EnclaveNotFound enclaveNotFound = (SecureValueRecovery.DeleteResponse.EnclaveNotFound)deleteResponse2;
                        logger.warn("Delete svr2 failed: EnclaveNotFound");
                        break;
                    }
                    case 3: {
                        SecureValueRecovery.DeleteResponse.ApplicationError error = (SecureValueRecovery.DeleteResponse.ApplicationError)deleteResponse2;
                        throw new IOException(error.getException());
                    }
                    case 4: {
                        SecureValueRecovery.DeleteResponse.NetworkError error = (SecureValueRecovery.DeleteResponse.NetworkError)deleteResponse2;
                        throw error.getException();
                    }
                    default: {
                        throw new AssertionError((Object)"Unexpected response");
                    }
                }
            }
            catch (IOException e) {
                exception = e;
            }
        }
        if (!removedPinSuccessfully && exception != null) {
            throw exception;
        }
    }

    public SecureValueRecovery.RestoreResponse.Success getRegistrationLockData(String pin, LockedException lockedException) throws IOException, IncorrectPinException {
        AuthCredentials svr2Credentials = lockedException.getSvr2Credentials();
        if (svr2Credentials != null) {
            IOException exception = null;
            for (SecureValueRecovery secureValueRecovery : this.secureValueRecoveries) {
                try {
                    SecureValueRecovery.RestoreResponse.Success lockData = this.getRegistrationLockData(secureValueRecovery, svr2Credentials, pin);
                    if (lockData == null) continue;
                    return lockData;
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        return null;
    }

    public SecureValueRecovery.RestoreResponse.Success getRegistrationLockData(SecureValueRecovery secureValueRecovery, AuthCredentials authCredentials, String pin) throws IOException, IncorrectPinException {
        SecureValueRecovery.RestoreResponse restoreResponse;
        SecureValueRecovery.RestoreResponse restoreResponse2 = restoreResponse = secureValueRecovery.restoreDataPreRegistration(authCredentials, null, pin);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SecureValueRecovery.RestoreResponse.Success.class, SecureValueRecovery.RestoreResponse.PinMismatch.class, SecureValueRecovery.RestoreResponse.ApplicationError.class, SecureValueRecovery.RestoreResponse.NetworkError.class, SecureValueRecovery.RestoreResponse.Missing.class}, (Object)restoreResponse2, n)) {
            case 0: {
                SecureValueRecovery.RestoreResponse.Success s = (SecureValueRecovery.RestoreResponse.Success)restoreResponse2;
                return s;
            }
            case 1: {
                SecureValueRecovery.RestoreResponse.PinMismatch pinMismatch = (SecureValueRecovery.RestoreResponse.PinMismatch)restoreResponse2;
                throw new IncorrectPinException(pinMismatch.getTriesRemaining());
            }
            case 2: {
                SecureValueRecovery.RestoreResponse.ApplicationError error = (SecureValueRecovery.RestoreResponse.ApplicationError)restoreResponse2;
                throw new IOException(error.getException());
            }
            case 3: {
                SecureValueRecovery.RestoreResponse.NetworkError error = (SecureValueRecovery.RestoreResponse.NetworkError)restoreResponse2;
                throw error.getException();
            }
            case 4: {
                SecureValueRecovery.RestoreResponse.Missing missing = (SecureValueRecovery.RestoreResponse.Missing)restoreResponse2;
                logger.debug("No SVR data stored for the given credentials.");
                return null;
            }
        }
        throw new AssertionError((Object)("Unexpected response: " + restoreResponse.getClass().getSimpleName()));
    }
}

