/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import java.util.UUID;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.InvalidNumberException;
import org.asamk.signal.manager.api.RecipientAddress;
import org.asamk.signal.manager.util.PhoneNumberFormatter;
import org.signal.core.util.UuidUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public sealed interface RecipientIdentifier {
    public String getIdentifier();

    public record Group(GroupId groupId) implements RecipientIdentifier
    {
        @Override
        public String getIdentifier() {
            return this.groupId.toBase64();
        }
    }

    public record Username(String username) implements Single
    {
        @Override
        public String getIdentifier() {
            return "u:" + this.username;
        }

        @Override
        public RecipientAddress toPartialRecipientAddress() {
            return new RecipientAddress(null, null, null, this.username);
        }
    }

    public record Number(String number) implements Single
    {
        @Override
        public String getIdentifier() {
            return this.number;
        }

        @Override
        public RecipientAddress toPartialRecipientAddress() {
            return new RecipientAddress(this.number);
        }
    }

    public record Pni(UUID pni) implements Single
    {
        @Override
        public String getIdentifier() {
            return "PNI:" + this.pni.toString();
        }

        @Override
        public RecipientAddress toPartialRecipientAddress() {
            return new RecipientAddress(null, this.getIdentifier(), null, null);
        }
    }

    public record Uuid(UUID uuid) implements Single
    {
        @Override
        public String getIdentifier() {
            return this.uuid.toString();
        }

        @Override
        public RecipientAddress toPartialRecipientAddress() {
            return new RecipientAddress(this.uuid);
        }
    }

    public static sealed interface Single
    extends RecipientIdentifier
    permits Uuid, Pni, Number, Username {
        public static Single fromString(String identifier, String localNumber) throws InvalidNumberException {
            if (UuidUtil.INSTANCE.isUuid(identifier)) {
                return new Uuid(UUID.fromString(identifier));
            }
            if (identifier.startsWith("PNI:")) {
                String pni = identifier.substring(4);
                if (!UuidUtil.INSTANCE.isUuid(pni)) {
                    throw new InvalidNumberException("Invalid PNI");
                }
                return new Pni(UUID.fromString(pni));
            }
            if (identifier.startsWith("u:")) {
                return new Username(identifier.substring(2));
            }
            String normalizedNumber = PhoneNumberFormatter.formatNumber(identifier, localNumber);
            if (!normalizedNumber.equals(identifier)) {
                Logger logger = LoggerFactory.getLogger(RecipientIdentifier.class);
                logger.debug("Normalized number {} to {}.", (Object)identifier, (Object)normalizedNumber);
            }
            return new Number(normalizedNumber);
        }

        public static Single fromAddress(RecipientAddress address) {
            if (address.number().isPresent()) {
                return new Number(address.number().get());
            }
            if (address.aci().isPresent()) {
                return new Uuid(UUID.fromString(address.aci().get()));
            }
            if (address.pni().isPresent()) {
                return new Pni(UUID.fromString(address.pni().get().substring(4)));
            }
            if (address.username().isPresent()) {
                return new Username(address.username().get());
            }
            throw new AssertionError((Object)"RecipientAddress without identifier");
        }

        public RecipientAddress toPartialRecipientAddress();
    }

    public record NoteToSelf() implements RecipientIdentifier
    {
        public static final NoteToSelf INSTANCE = new NoteToSelf();

        @Override
        public String getIdentifier() {
            return "Note-To-Self";
        }
    }
}

