/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import java.util.Optional;
import java.util.UUID;
import org.signal.core.util.UuidUtil;

public record RecipientAddress(Optional<String> aci, Optional<String> pni, Optional<String> number, Optional<String> username) {
    public static final UUID UNKNOWN_UUID = UuidUtil.UNKNOWN_UUID;

    public RecipientAddress {
        if (aci.isEmpty() && pni.isEmpty() && number.isEmpty() && username.isEmpty()) {
            throw new AssertionError((Object)"Must have either a ACI, PNI, username or E164 number!");
        }
    }

    public RecipientAddress(String e164) {
        this(null, null, e164, null);
    }

    public RecipientAddress(UUID uuid) {
        this(uuid.toString(), null, null, null);
    }

    public RecipientAddress(String aci, String pni, String e164, String username) {
        this(Optional.ofNullable(aci), Optional.ofNullable(pni), Optional.ofNullable(e164), Optional.ofNullable(username));
    }

    public Optional<UUID> uuid() {
        return this.aci.map(UUID::fromString);
    }

    public String getIdentifier() {
        if (this.aci.isPresent()) {
            return this.aci.get();
        }
        if (this.number.isPresent()) {
            return this.number.get();
        }
        if (this.pni.isPresent()) {
            return this.pni.get();
        }
        if (this.username.isPresent()) {
            return this.username.get();
        }
        throw new AssertionError((Object)"Given the checks in the constructor, this should not be possible.");
    }

    public String getLegacyIdentifier() {
        if (this.number.isPresent()) {
            return this.number.get();
        }
        return this.getIdentifier();
    }

    public boolean matches(RecipientAddress other) {
        return this.aci.isPresent() && other.aci.isPresent() && this.aci.get().equals(other.aci.get()) || this.pni.isPresent() && other.pni.isPresent() && this.pni.get().equals(other.pni.get()) || this.number.isPresent() && other.number.isPresent() && this.number.get().equals(other.number.get()) || this.username.isPresent() && other.username.isPresent() && this.username.get().equals(other.username.get());
    }
}

