/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.asamk.signal.manager.api.Color;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.RecipientAddress;
import org.asamk.signal.manager.api.StickerPackId;
import org.asamk.signal.manager.api.TextStyle;
import org.asamk.signal.manager.groups.GroupUtils;
import org.asamk.signal.manager.helper.RecipientAddressResolver;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.recipients.RecipientResolver;
import org.signal.core.models.ServiceId;
import org.signal.libsignal.metadata.ProtocolException;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentPointer;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentStream;
import org.whispersystems.signalservice.api.messages.SignalServiceContent;
import org.whispersystems.signalservice.api.messages.SignalServiceDataMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceEditMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceEnvelope;
import org.whispersystems.signalservice.api.messages.SignalServiceGroup;
import org.whispersystems.signalservice.api.messages.SignalServiceGroupContext;
import org.whispersystems.signalservice.api.messages.SignalServiceGroupV2;
import org.whispersystems.signalservice.api.messages.SignalServicePreview;
import org.whispersystems.signalservice.api.messages.SignalServiceReceiptMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceStoryMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceTextAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceTypingMessage;
import org.whispersystems.signalservice.api.messages.calls.AnswerMessage;
import org.whispersystems.signalservice.api.messages.calls.BusyMessage;
import org.whispersystems.signalservice.api.messages.calls.HangupMessage;
import org.whispersystems.signalservice.api.messages.calls.IceUpdateMessage;
import org.whispersystems.signalservice.api.messages.calls.OfferMessage;
import org.whispersystems.signalservice.api.messages.calls.OpaqueMessage;
import org.whispersystems.signalservice.api.messages.calls.SignalServiceCallMessage;
import org.whispersystems.signalservice.api.messages.multidevice.BlockedListMessage;
import org.whispersystems.signalservice.api.messages.multidevice.ContactsMessage;
import org.whispersystems.signalservice.api.messages.multidevice.MessageRequestResponseMessage;
import org.whispersystems.signalservice.api.messages.multidevice.ReadMessage;
import org.whispersystems.signalservice.api.messages.multidevice.SentTranscriptMessage;
import org.whispersystems.signalservice.api.messages.multidevice.SignalServiceSyncMessage;
import org.whispersystems.signalservice.api.messages.multidevice.ViewOnceOpenMessage;
import org.whispersystems.signalservice.api.messages.multidevice.ViewedMessage;
import org.whispersystems.signalservice.api.messages.shared.SharedContact;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;

public record MessageEnvelope(Optional<RecipientAddress> sourceAddress, int sourceDevice, long timestamp, long serverReceivedTimestamp, long serverDeliveredTimestamp, boolean isUnidentifiedSender, Optional<Receipt> receipt, Optional<Typing> typing, Optional<Data> data, Optional<Edit> edit, Optional<Sync> sync, Optional<Call> call, Optional<Story> story) {
    public static MessageEnvelope from(SignalServiceEnvelope envelope, SignalServiceContent content, RecipientResolver recipientResolver, RecipientAddressResolver addressResolver, AttachmentFileProvider fileProvider, Exception exception) {
        Optional<Story> story;
        Optional<Call> call;
        Optional<Sync> sync;
        Optional<Edit> edit;
        Optional<Data> data;
        Optional<Typing> typing;
        Optional<Receipt> receipt;
        int sourceDevice;
        RecipientId source;
        ServiceId serviceId = envelope.getSourceServiceId().map(ServiceId::parseOrNull).orElse(null);
        if (!envelope.isUnidentifiedSender() && serviceId != null) {
            v0 = recipientResolver.resolveRecipient(serviceId);
        } else if (envelope.isUnidentifiedSender() && content != null) {
            v0 = recipientResolver.resolveRecipient(content.getSender());
        } else if (exception instanceof ProtocolException) {
            ProtocolException e = (ProtocolException)exception;
            v0 = recipientResolver.resolveRecipient(e.getSender());
        } else {
            v0 = source = null;
        }
        if (envelope.hasSourceDevice()) {
            v1 = envelope.getSourceDevice();
        } else if (content != null) {
            v1 = content.getSenderDevice();
        } else if (exception instanceof ProtocolException) {
            ProtocolException e = (ProtocolException)exception;
            v1 = e.getSenderDevice();
        } else {
            v1 = sourceDevice = 0;
        }
        if (content != null) {
            receipt = content.getReceiptMessage().map(Receipt::from);
            typing = content.getTypingMessage().map(Typing::from);
            data = content.getDataMessage().map(dataMessage -> Data.from(dataMessage, recipientResolver, addressResolver, fileProvider));
            edit = content.getEditMessage().map(s -> Edit.from(s, recipientResolver, addressResolver, fileProvider));
            sync = content.getSyncMessage().map(s -> Sync.from(s, recipientResolver, addressResolver, fileProvider));
            call = content.getCallMessage().map(Call::from);
            story = content.getStoryMessage().map(s -> Story.from(s, fileProvider));
        } else {
            receipt = envelope.isReceipt() ? Optional.of(new Receipt(envelope.getServerReceivedTimestamp(), Receipt.Type.DELIVERY, List.of(Long.valueOf(envelope.getTimestamp())))) : Optional.empty();
            typing = Optional.empty();
            data = Optional.empty();
            edit = Optional.empty();
            sync = Optional.empty();
            call = Optional.empty();
            story = Optional.empty();
        }
        return new MessageEnvelope(source == null ? Optional.empty() : Optional.of(addressResolver.resolveRecipientAddress(source).toApiRecipientAddress()), sourceDevice, envelope.getTimestamp(), envelope.getServerReceivedTimestamp(), envelope.getServerDeliveredTimestamp(), envelope.isUnidentifiedSender(), receipt, typing, data, edit, sync, call, story);
    }

    public static interface AttachmentFileProvider {
        public File getFile(SignalServiceAttachmentPointer var1);
    }

    public record Receipt(long when, Type type, List<Long> timestamps) {
        static Receipt from(SignalServiceReceiptMessage receiptMessage) {
            return new Receipt(receiptMessage.getWhen(), Type.from(receiptMessage.getType()), receiptMessage.getTimestamps());
        }

        public static enum Type {
            DELIVERY,
            READ,
            VIEWED,
            UNKNOWN;


            static Type from(SignalServiceReceiptMessage.Type type) {
                return switch (type) {
                    default -> throw new MatchException(null, null);
                    case SignalServiceReceiptMessage.Type.DELIVERY -> DELIVERY;
                    case SignalServiceReceiptMessage.Type.READ -> READ;
                    case SignalServiceReceiptMessage.Type.VIEWED -> VIEWED;
                    case SignalServiceReceiptMessage.Type.UNKNOWN -> UNKNOWN;
                };
            }
        }
    }

    public record Story(boolean allowsReplies, Optional<GroupId> groupId, Optional<Data.Attachment> fileAttachment, Optional<TextAttachment> textAttachment) {
        public static Story from(SignalServiceStoryMessage storyMessage, AttachmentFileProvider fileProvider) {
            return new Story(storyMessage.getAllowsReplies().orElse(false), storyMessage.getGroupContext().map(c -> GroupUtils.getGroupIdV2(c.getMasterKey())), storyMessage.getFileAttachment().map(f -> Data.Attachment.from(f, fileProvider)), storyMessage.getTextAttachment().map(t -> TextAttachment.from(t, fileProvider)));
        }

        public record TextAttachment(Optional<String> text, Optional<Style> style, Optional<Color> textForegroundColor, Optional<Color> textBackgroundColor, Optional<Data.Preview> preview, Optional<Gradient> backgroundGradient, Optional<Color> backgroundColor) {
            static TextAttachment from(SignalServiceTextAttachment textAttachment, AttachmentFileProvider fileProvider) {
                return new TextAttachment(textAttachment.getText(), textAttachment.getStyle().map(Style::from), textAttachment.getTextForegroundColor().map(Color::new), textAttachment.getTextBackgroundColor().map(Color::new), textAttachment.getPreview().map(p -> Data.Preview.from(p, fileProvider)), textAttachment.getBackgroundGradient().map(Gradient::from), textAttachment.getBackgroundColor().map(Color::new));
            }

            public record Gradient(List<Color> colors, List<Float> positions, Optional<Integer> angle) {
                static Gradient from(SignalServiceTextAttachment.Gradient gradient) {
                    return new Gradient(gradient.getColors().stream().map(Color::new).toList(), gradient.getPositions(), gradient.getAngle());
                }
            }

            public static enum Style {
                DEFAULT,
                REGULAR,
                BOLD,
                SERIF,
                SCRIPT,
                CONDENSED;


                static Style from(SignalServiceTextAttachment.Style style) {
                    return switch (style) {
                        default -> throw new MatchException(null, null);
                        case SignalServiceTextAttachment.Style.DEFAULT -> DEFAULT;
                        case SignalServiceTextAttachment.Style.REGULAR -> REGULAR;
                        case SignalServiceTextAttachment.Style.BOLD -> BOLD;
                        case SignalServiceTextAttachment.Style.SERIF -> SERIF;
                        case SignalServiceTextAttachment.Style.SCRIPT -> SCRIPT;
                        case SignalServiceTextAttachment.Style.CONDENSED -> CONDENSED;
                    };
                }
            }
        }
    }

    public record Sync(Optional<Sent> sent, Optional<Blocked> blocked, List<Read> read, List<Viewed> viewed, Optional<ViewOnceOpen> viewOnceOpen, Optional<Contacts> contacts, Optional<Groups> groups, Optional<MessageRequestResponse> messageRequestResponse) {
        public static Sync from(SignalServiceSyncMessage syncMessage, RecipientResolver recipientResolver, RecipientAddressResolver addressResolver, AttachmentFileProvider fileProvider) {
            return new Sync(syncMessage.getSent().map(s -> Sent.from(s, recipientResolver, addressResolver, fileProvider)), syncMessage.getBlockedList().map(b -> Blocked.from(b, recipientResolver, addressResolver)), syncMessage.getRead().map(r -> r.stream().map(rm -> Read.from(rm, recipientResolver, addressResolver)).toList()).orElse(List.of()), syncMessage.getViewed().map(r -> r.stream().map(rm -> Viewed.from(rm, recipientResolver, addressResolver)).toList()).orElse(List.of()), syncMessage.getViewOnceOpen().map(rm -> ViewOnceOpen.from(rm, recipientResolver, addressResolver)), syncMessage.getContacts().map(Contacts::from), syncMessage.getGroups().map(Groups::from), syncMessage.getMessageRequestResponse().map(m -> MessageRequestResponse.from(m, recipientResolver, addressResolver)));
        }

        public record MessageRequestResponse(Type type, Optional<GroupId> groupId, Optional<RecipientAddress> person) {
            static MessageRequestResponse from(MessageRequestResponseMessage messageRequestResponse, RecipientResolver recipientResolver, RecipientAddressResolver addressResolver) {
                return new MessageRequestResponse(Type.from(messageRequestResponse.getType()), messageRequestResponse.getGroupId().map(GroupId::unknownVersion), messageRequestResponse.getPerson().map(p -> addressResolver.resolveRecipientAddress(recipientResolver.resolveRecipient((ServiceId)p)).toApiRecipientAddress()));
            }

            public static enum Type {
                UNKNOWN,
                ACCEPT,
                DELETE,
                BLOCK,
                BLOCK_AND_DELETE,
                UNBLOCK_AND_ACCEPT,
                SPAM,
                BLOCK_AND_SPAM;


                static Type from(MessageRequestResponseMessage.Type type) {
                    return switch (type) {
                        default -> throw new MatchException(null, null);
                        case MessageRequestResponseMessage.Type.UNKNOWN -> UNKNOWN;
                        case MessageRequestResponseMessage.Type.ACCEPT -> ACCEPT;
                        case MessageRequestResponseMessage.Type.DELETE -> DELETE;
                        case MessageRequestResponseMessage.Type.BLOCK -> BLOCK;
                        case MessageRequestResponseMessage.Type.BLOCK_AND_DELETE -> BLOCK_AND_DELETE;
                        case MessageRequestResponseMessage.Type.UNBLOCK_AND_ACCEPT -> UNBLOCK_AND_ACCEPT;
                        case MessageRequestResponseMessage.Type.SPAM -> SPAM;
                        case MessageRequestResponseMessage.Type.BLOCK_AND_SPAM -> BLOCK_AND_SPAM;
                    };
                }
            }
        }

        public record ViewOnceOpen(RecipientAddress sender, long timestamp) {
            static ViewOnceOpen from(ViewOnceOpenMessage readMessage, RecipientResolver recipientResolver, RecipientAddressResolver addressResolver) {
                return new ViewOnceOpen(addressResolver.resolveRecipientAddress(recipientResolver.resolveRecipient(readMessage.getSender())).toApiRecipientAddress(), readMessage.getTimestamp());
            }
        }

        public record Viewed(RecipientAddress sender, long timestamp) {
            static Viewed from(ViewedMessage readMessage, RecipientResolver recipientResolver, RecipientAddressResolver addressResolver) {
                return new Viewed(addressResolver.resolveRecipientAddress(recipientResolver.resolveRecipient(readMessage.getSender())).toApiRecipientAddress(), readMessage.getTimestamp());
            }
        }

        public record Read(RecipientAddress sender, long timestamp) {
            static Read from(ReadMessage readMessage, RecipientResolver recipientResolver, RecipientAddressResolver addressResolver) {
                return new Read(addressResolver.resolveRecipientAddress(recipientResolver.resolveRecipient((ServiceId)readMessage.getSenderAci())).toApiRecipientAddress(), readMessage.getTimestamp());
            }
        }

        public record Blocked(List<RecipientAddress> recipients, List<GroupId> groupIds) {
            static Blocked from(BlockedListMessage blockedListMessage, RecipientResolver recipientResolver, RecipientAddressResolver addressResolver) {
                return new Blocked(blockedListMessage.individuals.stream().map(d -> new RecipientAddress(d.getAci() == null ? null : d.getAci().toString(), null, d.getE164(), null)).toList(), blockedListMessage.groupIds.stream().map(GroupId::unknownVersion).toList());
            }
        }

        public record Sent(long timestamp, long expirationStartTimestamp, Optional<RecipientAddress> destination, Set<RecipientAddress> recipients, Optional<Data> message, Optional<Edit> editMessage, Optional<Story> story) {
            static Sent from(SentTranscriptMessage sentMessage, RecipientResolver recipientResolver, RecipientAddressResolver addressResolver, AttachmentFileProvider fileProvider) {
                return new Sent(sentMessage.getTimestamp(), sentMessage.getExpirationStartTimestamp(), sentMessage.getDestination().map(d -> addressResolver.resolveRecipientAddress(recipientResolver.resolveRecipient((SignalServiceAddress)d)).toApiRecipientAddress()), sentMessage.getRecipients().stream().map(d -> addressResolver.resolveRecipientAddress(recipientResolver.resolveRecipient((ServiceId)d)).toApiRecipientAddress()).collect(Collectors.toSet()), sentMessage.getDataMessage().map(message -> Data.from(message, recipientResolver, addressResolver, fileProvider)), sentMessage.getEditMessage().map(message -> Edit.from(message, recipientResolver, addressResolver, fileProvider)), sentMessage.getStoryMessage().map(s -> Story.from(s, fileProvider)));
            }
        }

        public record Groups() {
            static Groups from(SignalServiceAttachment groupsMessage) {
                return new Groups();
            }
        }

        public record Contacts(boolean isComplete) {
            static Contacts from(ContactsMessage contactsMessage) {
                return new Contacts(contactsMessage.isComplete());
            }
        }
    }

    public record Edit(long targetSentTimestamp, Data dataMessage) {
        public static Edit from(SignalServiceEditMessage editMessage, RecipientResolver recipientResolver, RecipientAddressResolver addressResolver, AttachmentFileProvider fileProvider) {
            return new Edit(editMessage.getTargetSentTimestamp(), Data.from(editMessage.getDataMessage(), recipientResolver, addressResolver, fileProvider));
        }
    }

    public record Data(long timestamp, Optional<GroupContext> groupContext, Optional<StoryContext> storyContext, Optional<GroupCallUpdate> groupCallUpdate, Optional<String> body, int expiresInSeconds, boolean isExpirationUpdate, boolean isViewOnce, boolean isEndSession, boolean isProfileKeyUpdate, boolean hasProfileKey, Optional<Reaction> reaction, Optional<Quote> quote, Optional<Payment> payment, List<Attachment> attachments, Optional<Long> remoteDeleteId, Optional<Sticker> sticker, List<SharedContact> sharedContacts, Optional<PollCreate> pollCreate, Optional<PollVote> pollVote, Optional<PollTerminate> pollTerminate, List<Mention> mentions, List<Preview> previews, List<TextStyle> textStyles) {
        static Data from(SignalServiceDataMessage dataMessage, RecipientResolver recipientResolver, RecipientAddressResolver addressResolver, AttachmentFileProvider fileProvider) {
            return new Data(dataMessage.getTimestamp(), dataMessage.getGroupContext().map(GroupContext::from), dataMessage.getStoryContext().map(storyContext -> StoryContext.from(storyContext, recipientResolver, addressResolver)), dataMessage.getGroupCallUpdate().map(GroupCallUpdate::from), dataMessage.getBody(), dataMessage.getExpiresInSeconds(), dataMessage.isExpirationUpdate(), dataMessage.isViewOnce(), dataMessage.isEndSession(), dataMessage.isProfileKeyUpdate(), dataMessage.getProfileKey().isPresent(), dataMessage.getReaction().map(r -> Reaction.from(r, recipientResolver, addressResolver)), dataMessage.getQuote().filter(q -> q.getAuthor() != null && q.getAuthor().isValid()).map(q -> Quote.from(q, recipientResolver, addressResolver, fileProvider)), dataMessage.getPayment().map(p -> p.getPaymentNotification().isPresent() ? Payment.from(p) : null), dataMessage.getAttachments().map(a -> a.stream().map(as -> Attachment.from(as, fileProvider)).toList()).orElse(List.of()), dataMessage.getRemoteDelete().map(SignalServiceDataMessage.RemoteDelete::getTargetSentTimestamp), dataMessage.getSticker().map(Sticker::from), dataMessage.getSharedContacts().map(a -> a.stream().map(sharedContact -> SharedContact.from(sharedContact, fileProvider)).toList()).orElse(List.of()), dataMessage.getPollCreate().map(PollCreate::from), dataMessage.getPollVote().map(p -> PollVote.from(p, recipientResolver, addressResolver)), dataMessage.getPollTerminate().map(PollTerminate::from), dataMessage.getMentions().map(a -> a.stream().map(m -> Mention.from(m, recipientResolver, addressResolver)).toList()).orElse(List.of()), dataMessage.getPreviews().map(a -> a.stream().map(preview -> Preview.from(preview, fileProvider)).toList()).orElse(List.of()), dataMessage.getBodyRanges().map(a -> a.stream().filter(r -> r.style != null).map(TextStyle::from).toList()).orElse(List.of()));
        }

        public record Preview(String title, String description, long date, String url, Optional<Attachment> image) {
            static Preview from(SignalServicePreview preview, AttachmentFileProvider fileProvider) {
                return new Preview(preview.getTitle(), preview.getDescription(), preview.getDate(), preview.getUrl(), preview.getImage().map(as -> Attachment.from(as, fileProvider)));
            }
        }

        public record Mention(RecipientAddress recipient, int start, int length) {
            static Mention from(SignalServiceDataMessage.Mention mention, RecipientResolver recipientResolver, RecipientAddressResolver addressResolver) {
                return new Mention(addressResolver.resolveRecipientAddress(recipientResolver.resolveRecipient(mention.getServiceId())).toApiRecipientAddress(), mention.getStart(), mention.getLength());
            }
        }

        public record PollVote(RecipientAddress targetAuthor, long targetSentTimestamp, List<Integer> optionIndexes, int voteCount) {
            static PollVote from(SignalServiceDataMessage.PollVote pollVote, RecipientResolver recipientResolver, RecipientAddressResolver addressResolver) {
                return new PollVote(addressResolver.resolveRecipientAddress(recipientResolver.resolveRecipient(pollVote.getTargetAuthor())).toApiRecipientAddress(), pollVote.getTargetSentTimestamp(), pollVote.getOptionIndexes(), pollVote.getVoteCount());
            }
        }

        public record SharedContact(Name name, Optional<Avatar> avatar, List<Phone> phone, List<Email> email, List<Address> address, Optional<String> organization) {
            static SharedContact from(org.whispersystems.signalservice.api.messages.shared.SharedContact sharedContact, AttachmentFileProvider fileProvider) {
                return new SharedContact(Name.from(sharedContact.getName()), sharedContact.getAvatar().map(avatar1 -> Avatar.from(avatar1, fileProvider)), sharedContact.getPhone().map(p -> p.stream().map(Phone::from).toList()).orElse(List.of()), sharedContact.getEmail().map(p -> p.stream().map(Email::from).toList()).orElse(List.of()), sharedContact.getAddress().map(p -> p.stream().map(Address::from).toList()).orElse(List.of()), sharedContact.getOrganization());
            }

            public record Name(Optional<String> nickname, Optional<String> given, Optional<String> family, Optional<String> prefix, Optional<String> suffix, Optional<String> middle) {
                static Name from(org.whispersystems.signalservice.api.messages.shared.SharedContact$Name name) {
                    return new Name(name.getNickname(), name.getGiven(), name.getFamily(), name.getPrefix(), name.getSuffix(), name.getMiddle());
                }
            }

            public record Avatar(Attachment attachment, boolean isProfile) {
                static Avatar from(org.whispersystems.signalservice.api.messages.shared.SharedContact$Avatar avatar, AttachmentFileProvider fileProvider) {
                    return new Avatar(Attachment.from(avatar.getAttachment(), fileProvider), avatar.isProfile());
                }
            }

            public record Address(Type type, Optional<String> label, Optional<String> street, Optional<String> pobox, Optional<String> neighborhood, Optional<String> city, Optional<String> region, Optional<String> postcode, Optional<String> country) {
                static Address from(SharedContact.PostalAddress address) {
                    return new Address(Type.from(address.getType()), address.getLabel(), address.getStreet(), address.getPobox(), address.getNeighborhood(), address.getCity(), address.getRegion(), address.getPostcode(), address.getCountry());
                }

                public static enum Type {
                    HOME,
                    WORK,
                    CUSTOM;


                    static Type from(SharedContact.PostalAddress.Type type) {
                        return switch (type) {
                            default -> throw new MatchException(null, null);
                            case SharedContact.PostalAddress.Type.HOME -> HOME;
                            case SharedContact.PostalAddress.Type.WORK -> WORK;
                            case SharedContact.PostalAddress.Type.CUSTOM -> CUSTOM;
                        };
                    }
                }
            }

            public record Email(String value, Type type, Optional<String> label) {
                static Email from(org.whispersystems.signalservice.api.messages.shared.SharedContact$Email email) {
                    return new Email(email.getValue(), Type.from(email.getType()), email.getLabel());
                }

                public static enum Type {
                    HOME,
                    WORK,
                    MOBILE,
                    CUSTOM;


                    static Type from(org.whispersystems.signalservice.api.messages.shared.SharedContact$Email$Type type) {
                        return switch (type) {
                            default -> throw new MatchException(null, null);
                            case org.whispersystems.signalservice.api.messages.shared.SharedContact$Email$Type.HOME -> HOME;
                            case org.whispersystems.signalservice.api.messages.shared.SharedContact$Email$Type.WORK -> WORK;
                            case org.whispersystems.signalservice.api.messages.shared.SharedContact$Email$Type.MOBILE -> MOBILE;
                            case org.whispersystems.signalservice.api.messages.shared.SharedContact$Email$Type.CUSTOM -> CUSTOM;
                        };
                    }
                }
            }

            public record Phone(String value, Type type, Optional<String> label) {
                static Phone from(org.whispersystems.signalservice.api.messages.shared.SharedContact$Phone phone) {
                    return new Phone(phone.getValue(), Type.from(phone.getType()), phone.getLabel());
                }

                public static enum Type {
                    HOME,
                    WORK,
                    MOBILE,
                    CUSTOM;


                    static Type from(org.whispersystems.signalservice.api.messages.shared.SharedContact$Phone$Type type) {
                        return switch (type) {
                            default -> throw new MatchException(null, null);
                            case org.whispersystems.signalservice.api.messages.shared.SharedContact$Phone$Type.HOME -> HOME;
                            case org.whispersystems.signalservice.api.messages.shared.SharedContact$Phone$Type.WORK -> WORK;
                            case org.whispersystems.signalservice.api.messages.shared.SharedContact$Phone$Type.MOBILE -> MOBILE;
                            case org.whispersystems.signalservice.api.messages.shared.SharedContact$Phone$Type.CUSTOM -> CUSTOM;
                        };
                    }
                }
            }
        }

        public record Attachment(Optional<String> id, Optional<File> file, Optional<String> fileName, String contentType, Optional<Long> uploadTimestamp, Optional<Long> size, Optional<byte[]> preview, Optional<Attachment> thumbnail, Optional<String> caption, Optional<Integer> width, Optional<Integer> height, boolean isVoiceNote, boolean isGif, boolean isBorderless) {
            static Attachment from(SignalServiceAttachment signalAttachment, AttachmentFileProvider fileProvider) {
                Attachment attachment;
                block9: {
                    if (signalAttachment.isPointer()) {
                        SignalServiceAttachmentPointer a = signalAttachment.asPointer();
                        File attachmentFile = fileProvider.getFile(a);
                        return new Attachment(Optional.of(attachmentFile.getName()), Optional.of(attachmentFile), a.getFileName(), a.getContentType(), a.getUploadTimestamp() == 0L ? Optional.empty() : Optional.of(a.getUploadTimestamp()), a.getSize().map(Integer::longValue), a.getPreview(), Optional.empty(), a.getCaption().map(c -> c.isEmpty() ? null : c), a.getWidth() == 0 ? Optional.empty() : Optional.of(a.getWidth()), a.getHeight() == 0 ? Optional.empty() : Optional.of(a.getHeight()), a.getVoiceNote(), a.isGif(), a.isBorderless());
                    }
                    Attachment attachment2 = null;
                    SignalServiceAttachmentStream a = signalAttachment.asStream();
                    try {
                        attachment = attachment2 = new Attachment(Optional.empty(), Optional.empty(), a.getFileName(), a.getContentType(), a.getUploadTimestamp() == 0L ? Optional.empty() : Optional.of(a.getUploadTimestamp()), Optional.of(a.getLength()), a.getPreview(), Optional.empty(), a.getCaption(), a.getWidth() == 0 ? Optional.empty() : Optional.of(a.getWidth()), a.getHeight() == 0 ? Optional.empty() : Optional.of(a.getHeight()), a.getVoiceNote(), a.isGif(), a.isBorderless());
                        if (a == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (a != null) {
                                try {
                                    a.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            return attachment2;
                        }
                    }
                    a.close();
                }
                return attachment;
            }

            static Attachment from(SignalServiceDataMessage.Quote.QuotedAttachment a, AttachmentFileProvider fileProvider) {
                return new Attachment(Optional.empty(), Optional.empty(), Optional.ofNullable(a.getFileName()), a.getContentType(), Optional.empty(), Optional.empty(), Optional.empty(), a.getThumbnail() == null ? Optional.empty() : Optional.of(Attachment.from(a.getThumbnail(), fileProvider)), Optional.empty(), Optional.empty(), Optional.empty(), false, false, false);
            }
        }

        public record Payment(String note, byte[] receipt) {
            static Payment from(SignalServiceDataMessage.Payment payment) {
                return new Payment(((SignalServiceDataMessage.PaymentNotification)payment.getPaymentNotification().get()).getNote(), ((SignalServiceDataMessage.PaymentNotification)payment.getPaymentNotification().get()).getReceipt());
            }
        }

        public record Quote(long id, RecipientAddress author, Optional<String> text, List<Mention> mentions, List<Attachment> attachments, List<TextStyle> textStyles) {
            static Quote from(SignalServiceDataMessage.Quote quote, RecipientResolver recipientResolver, RecipientAddressResolver addressResolver, AttachmentFileProvider fileProvider) {
                return new Quote(quote.getId(), addressResolver.resolveRecipientAddress(recipientResolver.resolveRecipient(quote.getAuthor())).toApiRecipientAddress(), Optional.of(quote.getText()), quote.getMentions() == null ? List.of() : quote.getMentions().stream().map(m -> Mention.from(m, recipientResolver, addressResolver)).toList(), quote.getAttachments() == null ? List.of() : quote.getAttachments().stream().map(a -> Attachment.from(a, fileProvider)).toList(), quote.getBodyRanges() == null ? List.of() : quote.getBodyRanges().stream().filter(r -> r.style != null).map(TextStyle::from).toList());
            }
        }

        public record Reaction(long targetSentTimestamp, RecipientAddress targetAuthor, String emoji, boolean isRemove) {
            static Reaction from(SignalServiceDataMessage.Reaction reaction, RecipientResolver recipientResolver, RecipientAddressResolver addressResolver) {
                return new Reaction(reaction.getTargetSentTimestamp(), addressResolver.resolveRecipientAddress(recipientResolver.resolveRecipient(reaction.getTargetAuthor())).toApiRecipientAddress(), reaction.getEmoji(), reaction.isRemove());
            }
        }

        public record StoryContext(RecipientAddress author, long sentTimestamp) {
            static StoryContext from(SignalServiceDataMessage.StoryContext storyContext, RecipientResolver recipientResolver, RecipientAddressResolver addressResolver) {
                return new StoryContext(addressResolver.resolveRecipientAddress(recipientResolver.resolveRecipient(storyContext.getAuthorServiceId())).toApiRecipientAddress(), storyContext.getSentTimestamp());
            }
        }

        public record PollTerminate(long targetSentTimestamp) {
            static PollTerminate from(SignalServiceDataMessage.PollTerminate pollTerminate) {
                return new PollTerminate(pollTerminate.getTargetSentTimestamp());
            }
        }

        public record PollCreate(String question, boolean allowMultiple, List<String> options) {
            static PollCreate from(SignalServiceDataMessage.PollCreate pollCreate) {
                return new PollCreate(pollCreate.getQuestion(), pollCreate.getAllowMultiple(), pollCreate.getOptions());
            }
        }

        public record Sticker(StickerPackId packId, byte[] packKey, int stickerId) {
            static Sticker from(SignalServiceDataMessage.Sticker sticker) {
                return new Sticker(StickerPackId.deserialize(sticker.getPackId()), sticker.getPackKey(), sticker.getStickerId());
            }
        }

        public record GroupCallUpdate(String eraId) {
            static GroupCallUpdate from(SignalServiceDataMessage.GroupCallUpdate groupCallUpdate) {
                return new GroupCallUpdate(groupCallUpdate.getEraId());
            }
        }

        public record GroupContext(GroupId groupId, boolean isGroupUpdate, int revision) {
            static GroupContext from(SignalServiceGroupContext groupContext) {
                if (groupContext.getGroupV1().isPresent()) {
                    return new GroupContext(GroupId.v1(((SignalServiceGroup)groupContext.getGroupV1().get()).getGroupId()), groupContext.getGroupV1Type() == SignalServiceGroup.Type.UPDATE, 0);
                }
                if (groupContext.getGroupV2().isPresent()) {
                    SignalServiceGroupV2 groupV2 = (SignalServiceGroupV2)groupContext.getGroupV2().get();
                    return new GroupContext(GroupUtils.getGroupIdV2(groupV2.getMasterKey()), groupV2.hasSignedGroupChange(), groupV2.getRevision());
                }
                throw new RuntimeException("Invalid group context state");
            }
        }
    }

    public record Call(Optional<Integer> destinationDeviceId, Optional<GroupId> groupId, Optional<Long> timestamp, Optional<Offer> offer, Optional<Answer> answer, Optional<Hangup> hangup, Optional<Busy> busy, List<IceUpdate> iceUpdate, Optional<Opaque> opaque, boolean isUrgent) {
        public static Call from(SignalServiceCallMessage callMessage) {
            return new Call(callMessage.getDestinationDeviceId(), callMessage.getGroupId().map(GroupId::unknownVersion), callMessage.getTimestamp(), callMessage.getOfferMessage().map(Offer::from), callMessage.getAnswerMessage().map(Answer::from), callMessage.getHangupMessage().map(Hangup::from), callMessage.getBusyMessage().map(Busy::from), callMessage.getIceUpdateMessages().map(m -> m.stream().map(IceUpdate::from).toList()).orElse(List.of()), callMessage.getOpaqueMessage().map(Opaque::from), callMessage.isUrgent());
        }

        public record Opaque(byte[] opaque, Urgency urgency) {
            static Opaque from(OpaqueMessage opaqueMessage) {
                return new Opaque(opaqueMessage.getOpaque(), Urgency.from(opaqueMessage.getUrgency()));
            }

            public static enum Urgency {
                DROPPABLE,
                HANDLE_IMMEDIATELY;


                static Urgency from(OpaqueMessage.Urgency urgency) {
                    return switch (urgency) {
                        default -> throw new MatchException(null, null);
                        case OpaqueMessage.Urgency.DROPPABLE -> DROPPABLE;
                        case OpaqueMessage.Urgency.HANDLE_IMMEDIATELY -> HANDLE_IMMEDIATELY;
                    };
                }
            }
        }

        public record IceUpdate(long id, byte[] opaque) {
            static IceUpdate from(IceUpdateMessage iceUpdateMessage) {
                return new IceUpdate(iceUpdateMessage.getId(), iceUpdateMessage.getOpaque());
            }
        }

        public record Hangup(long id, Type type, int deviceId) {
            static Hangup from(HangupMessage hangupMessage) {
                return new Hangup(hangupMessage.getId(), Type.from(hangupMessage.getType()), hangupMessage.getDeviceId());
            }

            public static enum Type {
                NORMAL,
                ACCEPTED,
                DECLINED,
                BUSY,
                NEED_PERMISSION;


                static Type from(HangupMessage.Type type) {
                    return switch (type) {
                        default -> throw new MatchException(null, null);
                        case HangupMessage.Type.NORMAL -> NORMAL;
                        case HangupMessage.Type.ACCEPTED -> ACCEPTED;
                        case HangupMessage.Type.DECLINED -> DECLINED;
                        case HangupMessage.Type.BUSY -> BUSY;
                        case HangupMessage.Type.NEED_PERMISSION -> NEED_PERMISSION;
                    };
                }
            }
        }

        public record Busy(long id) {
            static Busy from(BusyMessage busyMessage) {
                return new Busy(busyMessage.getId());
            }
        }

        public record Answer(long id, byte[] opaque) {
            static Answer from(AnswerMessage answerMessage) {
                return new Answer(answerMessage.getId(), answerMessage.getOpaque());
            }
        }

        public record Offer(long id, Type type, byte[] opaque) {
            static Offer from(OfferMessage offerMessage) {
                return new Offer(offerMessage.getId(), Type.from(offerMessage.getType()), offerMessage.getOpaque());
            }

            public static enum Type {
                AUDIO_CALL,
                VIDEO_CALL;


                static Type from(OfferMessage.Type type) {
                    return switch (type) {
                        default -> throw new MatchException(null, null);
                        case OfferMessage.Type.AUDIO_CALL -> AUDIO_CALL;
                        case OfferMessage.Type.VIDEO_CALL -> VIDEO_CALL;
                    };
                }
            }
        }
    }

    public record Typing(long timestamp, Type type, Optional<GroupId> groupId) {
        public static Typing from(SignalServiceTypingMessage typingMessage) {
            return new Typing(typingMessage.getTimestamp(), typingMessage.isTypingStarted() ? Type.STARTED : Type.STOPPED, typingMessage.getGroupId().map(GroupId::unknownVersion));
        }

        public static enum Type {
            STARTED,
            STOPPED;

        }
    }
}

