/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import okio.ByteString;
import org.asamk.signal.manager.groups.GroupLinkPassword;
import org.signal.core.util.Base64;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.storageservice.storage.protos.groups.GroupInviteLink;
import org.signal.storageservice.storage.protos.groups.local.DecryptedGroup;

public final class GroupInviteLinkUrl {
    private static final String GROUP_URL_HOST = "signal.group";
    private static final String GROUP_URL_PREFIX = "https://signal.group/#";
    private final GroupMasterKey groupMasterKey;
    private final GroupLinkPassword password;
    private final String url;

    public static GroupInviteLinkUrl forGroup(GroupMasterKey groupMasterKey, DecryptedGroup group) {
        return new GroupInviteLinkUrl(groupMasterKey, GroupLinkPassword.fromBytes(group.inviteLinkPassword.toByteArray()));
    }

    public static GroupInviteLinkUrl fromUri(String urlString) throws InvalidGroupLinkException, UnknownGroupLinkVersionException {
        URI uri = GroupInviteLinkUrl.getGroupUrl(urlString);
        if (uri == null) {
            return null;
        }
        try {
            if (!"/".equals(uri.getPath()) && !uri.getPath().isEmpty()) {
                throw new InvalidGroupLinkException("No path was expected in uri");
            }
            String encoding = uri.getFragment();
            if (encoding == null || encoding.isEmpty()) {
                throw new InvalidGroupLinkException("No reference was in the uri");
            }
            byte[] bytes = Base64.decode((String)encoding);
            GroupInviteLink groupInviteLink = (GroupInviteLink)GroupInviteLink.ADAPTER.decode(bytes);
            if (groupInviteLink.contentsV1 != null) {
                GroupInviteLink.GroupInviteLinkContentsV1 groupInviteLinkContentsV1 = groupInviteLink.contentsV1;
                GroupMasterKey groupMasterKey = new GroupMasterKey(groupInviteLinkContentsV1.groupMasterKey.toByteArray());
                GroupLinkPassword password = GroupLinkPassword.fromBytes(groupInviteLinkContentsV1.inviteLinkPassword.toByteArray());
                return new GroupInviteLinkUrl(groupMasterKey, password);
            }
            throw new UnknownGroupLinkVersionException("Url contains no known group link content");
        }
        catch (IOException | InvalidInputException e) {
            throw new InvalidGroupLinkException(e);
        }
    }

    private static URI getGroupUrl(String urlString) {
        try {
            URI url = new URI(urlString);
            if (!"https".equalsIgnoreCase(url.getScheme()) && !"sgnl".equalsIgnoreCase(url.getScheme())) {
                return null;
            }
            return GROUP_URL_HOST.equalsIgnoreCase(url.getHost()) ? url : null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private GroupInviteLinkUrl(GroupMasterKey groupMasterKey, GroupLinkPassword password) {
        this.groupMasterKey = groupMasterKey;
        this.password = password;
        this.url = GroupInviteLinkUrl.createUrl(groupMasterKey, password);
    }

    private static String createUrl(GroupMasterKey groupMasterKey, GroupLinkPassword password) {
        GroupInviteLink groupInviteLink = new GroupInviteLink.Builder().contentsV1(new GroupInviteLink.GroupInviteLinkContentsV1.Builder().groupMasterKey(ByteString.of((byte[])groupMasterKey.serialize())).inviteLinkPassword(ByteString.of((byte[])password.serialize())).build()).build();
        String encoding = Base64.encodeUrlSafeWithoutPadding((byte[])groupInviteLink.encode());
        return GROUP_URL_PREFIX + encoding;
    }

    public String getUrl() {
        return this.url;
    }

    public GroupMasterKey getGroupMasterKey() {
        return this.groupMasterKey;
    }

    public GroupLinkPassword getPassword() {
        return this.password;
    }

    public static final class InvalidGroupLinkException
    extends Exception {
        public InvalidGroupLinkException(String message) {
            super(message);
        }

        public InvalidGroupLinkException(Throwable cause) {
            super(cause);
        }
    }

    public static final class UnknownGroupLinkVersionException
    extends Exception {
        public UnknownGroupLinkVersionException(String message) {
            super(message);
        }
    }
}

