/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.actions;

import org.asamk.signal.manager.actions.HandleAction;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.signal.core.models.ServiceId;

public class RenewSessionAction
implements HandleAction {
    private final RecipientId recipientId;
    private final ServiceId serviceId;
    private final ServiceId accountId;

    public RenewSessionAction(RecipientId recipientId, ServiceId serviceId, ServiceId accountId) {
        this.recipientId = recipientId;
        this.serviceId = serviceId;
        this.accountId = accountId;
    }

    @Override
    public void execute(Context context) throws Throwable {
        context.getAccount().getAccountData(this.accountId).getSessionStore().archiveSessions(this.serviceId);
        context.getSendHelper().sendNullMessage(this.recipientId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenewSessionAction that = (RenewSessionAction)o;
        return this.recipientId.equals(that.recipientId);
    }

    public int hashCode() {
        return this.recipientId.hashCode();
    }
}

