from .util import unhex

init_hardcoded = unhex('''
06020000014a231406e5542fc6dc3b1aedebe68f55596ad3ca13f6e019994c6f71672fff756fbde0511d09d45978b12ba415b3694a0e763
48c8cfe9dbb9abf86813fc0c67c1005519a6f87360c2fb3e12bd0a9e012b06d9f5c9b44ccc6645b0fbd47afe45c8c874fcb88fbfd18fb7a
9b3241351f256acce689f9586a52b01f8fdcb66cdf3b340b1f9f386d58ca24fdfcdfbcebefb5f3a3c2a08357721040235a20ce1ee2f4f78
56e0d9c27b92cd9b975c86f2c8cab1179868f795da674004b93c15e6ac8aa825a1907f2003cb9e6df096423167b2cabae98c0cd3fd200d1
1c7e0ee1ba5a725f7f2022886f3caa5f68b688ba61bc5cb0190db569efa0a57aa9d76ecdc7440c8920ea02768734221260d083bebb39c17
6d129c01d1a0f1388497171402ba041afd925d71e76ce4905e44fa5fd528759a2c9f12895864b5aa394dc71a4a17161dd82197a10742fa5
f3135c5e78820e36653fa3db535f57c71897242939d7da50f81070ce9ab81c61af6ac29a6c6c4a5df73ffd08542fb540e417939ed117298
051d27736c2faf1c5577a2133b6f60ea7484c692faae2a49c51c8e6f69af77774bad51a9adeea3109d3611d6a437cdc0c356e46a8f9a6d3
054c5519c17c986e54f61f8329006ce184c275984799dbdf5512188fa8ff10aa2ddc25eb697ebdcb156509309ade5d7909a734bf35ec69e
062cb941c2ea4af0958110da93bd2b5f17fc9b1ebdbd8020a3c36f22a68f707226cec716126d6a830219521669bd59fa0e4bd35db6ef0aa
2999d1c0e7acf67e598696cd58cc4bdb1b7c037ee9a085f784c4
''')

init_hardcoded_clean_slate = unhex('''
06020000012c40c9d271378bc0912ef5dced69bd81b7fc16972c7b46e621af54a00e2cc6baca6eb83ea30222dfc6c925262006ae93412ea
cf482f2034ee7b13297474b7e1e91f279cac2ccb7195443e4dd3328cfd292ade073fcc2eaa8f07b77231130ba997f921b9be7b4fb6cc691
0d2976b3e050913b27dbe73afd6e964260b9435ebab5117e71f7cb68464d4b6f8afc7e1a421f671f5854a1d0c8ab93ed3b88b2bc1a42875
e40b15f0e78496ac40e4a4a7fd39a97534ce1866479e0384f0789bbfc2fea0ce982bf7a9df97d60b237edbe1b26c9791043a96b81e435d6
de5971c758d374905df95b0cddabfbf531749ba191f07a6f5e2722852f137a53513a9ec6ab30c3f09aa6ce21b391e55cf81dcda6422011b
f163317a9a4382546141d45f2274bd660103bd3af705f3ed12e493bc4f834d5d7f162e2c3405cf857b00129789a3353bf7fab7796e267e3
062d55660dbbb857911ac8e871c460dd31c56a86a5631475f0f2ee5e9ce2af0faec0931a640ba2394025f29ffeca3a7e99c15a78ce1f1f7
808cedd7601b9b6382d72ca873257d4f6af70e29e22afea15e36e0282b8f0bfc68ffa3417d212b8bbe11bb73b363a19872e6e947d45de30
fbc493ca083a0a4650615d8628606362081ca6df5d67527971d1776ad76a7a28c932f0317b59cb4a82a14b2bcb7b01fb662be1496d24d91
9140ec80068b21a818daa2fb8e05f63edbd4bd5797c74a28b3e7cf81c9045248584977711341fca3f08ba91ff853b62dc24ce4bba4ed57f
47bd458545d805b6bb14fe0cde01440b60bf7be937f6444a8e2a10ed8fa9ddb8604bb95fe411b97112e78dbf5a4a0f004669c93765a9f38
665cb55f5658895c1c06a7aedf694bfb3afa9b8b1dea5ab85c821ac20b0663b95023642fda36ad78e3e00140b966f404f7e55f0b416ea43
b4c74c39900830abc6906a1004bef1b5b7dbbbeb5ec1b22604ac86429b9f56511b746a7124c449b8c9498f49144abc2d64f6a114f1d7f91
aa41249faeef4d838e280cb5d6fc19cfe86c75f
''')

reset_blob = unhex('''
06020000018772bd56dd58d64023e1745f7c253a49b32dd6a02bc32347195b6763bfcc23c9e0beb0c5809e06a5628629f28c4048530a5cd
df6f48391ea0c2cb5a7ffe93ef04c8b4dad584117e65aac085c25062a0f12a8ee432c7ecbb6613c28b743e4a75e382afc6b8037e342d466
7b66a73691edc6b25698c15e78d9d67f7cc56274e99e6b7bb5fba32dd42d74dfa672f414c4a29302b30a202d00a2571d2a884169e82106c
3dce195eb81b62aa7d29481d5d4d5318d8dd2901594752092cdbcd3b5f9f73eac99efb57012305e8aa06e0fced2b0a92150b261c3cb86b4
32db0b6aa7ee398c2cb094de1393e063094dae769acb692cda9c6a6393db82db00b6d8b5b58787529a8e1667e1641498f63621b81f583a7
614edbb40cf5f2ecd2514799dc6a267109a1773dfaf6e75ddeccd6dcc600b9b8697683ab391a5ae00f498b2742cc124d56dd06fab1d3609
3733730e57436a742ab022bc1079cd5a182c665ce7fb84bd33531ff22387da107af7cb0a8eae6340b5b0a9902aa4bb5c67af09d45cf79bf
9fd210be476b3540c8c98de9e9c9c0aa57bf3286806e7cfeef2d2768a60ce06abe57105f054814af2c58d707216cb0a3d57265833103a0c
5476fbfac1e6232854049353f6212a2dd4a86a5afb4d9cceb4d497cc1e1a60b7a29114cd3173d0e53ddb7ff75d6307f3472d0979f275704
43114624902608334c95711d1b98f9f9e1f5100e9633c7edb1821930455c8af061e826d218320bd2fad3452e1fc99d04fbcb4ef0af13cd9
31f507db95608979d44345b34e5d18d1306e6eb4a8e5a6e1d8f5b729ee01ed9fb7b9f8a13fee9098c2302807c7069f7dab0607ad34e7df8
f329dff61d6b0b6579c05d8306b604e1a99d1d4cdb2acc39d46960fdee90a47e77b01f057d60979aac5d5497785acfce5a3f1e6a96f06ad
099f57a729a7e2e7820f657a823f1b7688bb104f9b5297a543ee2d326a13bc8243df4ffeee7156005d648b189169875b8e4197eef5fd832
a20755a03c12a936565896f457dc4a1c90e333e383b233d9a8f8cf0f70c12d779a6095ea92fc6ba9040a6a68edfe9aaa76436a5a3c55bab
afa391934fc4847b0ba17b94dac8f8bcf0587e1a74dd654a78f60fcd5bfc151ca10fdbfc1c7ca26c954380a9406fbd3aececb69b6ed5905
aba3436bd331da878aef62963fe9d3fa481f79719886b201581ebf2cb05742779f18f6375401fd9a24d018f5f7692e78c9066ff26a9dec1
395ae3f7b4359eccf34ff3d91ad7014560e40365815e4846599ea50d15bf3fde561907f1dfc58505f1eafbb86d6a1f1eb354b3857c50ab1
8dcacffea97e5421a5504c05a48dbbe5933aefdf525529bb0a74677778cc6c9eabe0847daa1151902280a6d0ebf266ffcf24294c03f72af
4409541f6ab76f59e9083b3c87064c0ee59279542bc04b210c3d7f484b8fe32403c8bcb7306777d1a79461068d96662d76babe39bc1059c
ae30152d8c65765b96dac42006b0443722b700009941942738e1092559400b9aad99dabb58dde270e7117bc0962fe0c4bdc4948dc2c54cc
e4d0160332120e7edc5f03862aa271bb249200a38ff5afd4cc10e146e8127eea60a21dec67276c29eb51b20ac316378c2d8318cc118d5f2
7853292c65ee1f344447e327651b336a434a62eea2c69929ec0b78411cc1a26934128875155cfd8478ef11fcc987d6323a5574905f14452
107c2ade173c166e981de0aa3f7ed0ce55fdf0bcafa48381b216244225b4f45200cd107e923545cbff5a608bc78f77c9cb56af94ea69294
40237583d5567c3ea45cf788d248c64726db1b0e6278c4aac4d5b4972196b149379834b4fb7d5635b93102ed8bf7a1715c8a5fb1b9b1e06
128c9224157cb99ee1caa6183dc85e4eb12df7a021db9b47607e3bdccdc04c7276fee38c90569d2e429ee3434e950dba0f95c48131eaddb
b578659fdff548c5e87a63cbc1bd7d3804f6ec9d23eea0c4bd6339c7d8e02f87a4cd0666ddeb45735d28c196b056eb43e6a21b4caede9e6
bd05ef701d843a1302ef666b6051f7c995cb145f93a98a14af719ca9c2a47ad0ad04bad312b7fa09fccfaec2806f0be71783cf2f2c8a609
daa40a00a03b8c826d178631084df666f599080e401461676003e9ccbdfcc461074bb7f18c2638715641606bb670d99a95862522317b4e7
bc29dae5af1686fb927a02589bd7376f6c03bbc5d865eaf7bf2eeb89cdd91e3f36ebd4200ead2f2676dcf13917fc6b0b4b7716efcb8936c
a66fc1e971316f20f8dff4f9de2fd5f0e582049e20db3eb041aac0278a5a2d011a7626079338aa2c29ba36cbe75c663c805407e80c334b1
c13ff0a23287738974a9ebe2ae57d3279009bd562949e8975bd24c441839758a18b57c8d3cad25d7d97445ee3d5353717a881e095565a85
a4c54bd38db42403602377b64ad1383fdc55b5782142b79eefde654a7d1a265a046a6eccdd423305cd8b9b31dcac2286228f5df16193317
6af14836938ce0f060b2d994c40ac956f4cb69f0e0f2b30b92bc4ec1e57361b07179561cbdc9d6170d08efc70acd36330d2df87a6c4f85e
2157fd0d9a5fa7b075d13833784d02089abae613ae301b9881dd32ee7fb55477591fa05b1abcae5bc12c445ea1b4bac596d28234879c13f
9dde60b3e6e07abc117dc517b1ef1bf89b33d2d37d37e0381f47f7062ef3d64ef1e0c24ba931f0d00059a144e09e90b15ea6dc90eaf63fe
d5881afcfc950c18ee33d55d863b56b1ac015a81372183e63e797a27c0c3368034120834987391db4706cf3df4b4294ccadb8f89beef332
a0a5c69887a141e0e84f286e96a942e0a97e3c99fa869879af94cc0efe1daceeecd3ef68a32c648f5605b0edb68c4ad926e556ef0620b09
6d0871214eabac748e1496f63c55c565ff5892b83211ec21f03062613760768f15d4f1b18cf871f7bfff34be4c037c055fd2b4cb1eebbf6
2bba0c3cc2756edbb705e809f1ec3376a69e92b87402029c146ca0728b0e9e964b7557831210d1a0eb7ac238ea5e450753b347b8eac961c
ffd7f53a37d1bf2787750a8dd744cd33e66116f5c3ab5ad715306d7fbbc967463a4c85092fe07460c26b434112f3535064d7406ebdbba49
19149eec2eb6628c59c1432b325b79cd8c8b227bdd1a9d364b6e2195a772d0231efd85029a893278a8ee140706e03508fe60ac2b84935c7
753a72dcfb19968c8a597e086f43666945132e0128ff50ecd80e17528975a3b5cd3f401d14645a3b96cf78266d77e686a78578eed858d5e
a71e0db79978815804065ab1b02afd025ff0a0050618b79952be1f72bd404ab46be600f5da3a9e7f21e8960b833686762913979c26c3ddb
47e5aa32a182681b94612f03dc5842937cc2c417d5b9a5d663255fac6e5a8fc4a7daeaf65f8f5a2cb58b8b72df04772add3ece18d65f193
baf8e7d63cf938df5b7bbff273c5fb77bea7a09bc93f908bf774b15ec6647089821a05e4b0784fef1c07fd8eafbc10467298521b7429e14
aefa16fb6cf9385d63d919da2cb4fbe91c369f1e64eeb64857e0412354c8bb62de804d842fa0264c2dee3dda5d6ee26742ea0a7cda41b55
ae19c95d633259fd3e758c7c8a45c370852d7cb8d0513abe1a1887e9dde40562817f46f55186bad6664679c71bf09ad55295dbe2fd72d0e
2f4f48f719077ac06f52ac37765e63ece56a298116c4dbb315dcc04dfdb0e92f183bea0ecc7256818d8cf4939e6bd64816d8062404825cc
0df90210f00f2a8fc19e9ef9f032eb20df619c6c8363d803869bd747b4ff41361392bed560e32872851b7df36cd4cb2658bfa1883947f83
6d347333f5b77b394b1290b13b76cea0cc337f9d5ab21ec91eeac1dea65216b90442bf88158ab40c8b488c5e8342fce21489ef36c5b3928
30f95b8fe6fb0ee3a095abfe8f31a159b0ab8c3b48cc163c996dd75002b3b742289e28afb0854212bd84dc5509a40a2766c10027192f6db
7053b2f460b609b857db7710e3457906496203e53c4bc3b39407e39bfe06015d6d460873a2f1e05c46d2f673086edf2e7b4f5c4982334e0
eae3eaf78f80d5967a5266a7c5d2ebb9c04baffd56ef426f7bd4dc91b6f1e1c273e00f2d261e86ca919ca1f48b86a7a84e9612096a2457a
6ab1206245729e76676d99d7facd57b9277dcd4b70f0e6826dcbb8747b63f5d5c04158433a70a441875328719123e27da511521056fd7a8
90a9947f177bb13edce7ed55376f2bf13fa8cf09b27a43ccbe071dcc97c385db7e44a4b15de14ca0012e6c3a8e41306a4b6fb58adec7089
9cc19138d7fdcf8db684459f6f5a24f7415872da5b8f01c80a75a8b1708ccafc2efc224250b462647849caae820c37ef69fadb4134c002a
a9365a4df9bab1ee34b2fae1ef4fa6ed1562ec0a7784cfbc3ff129c7ab02fd316f2268a5caac67ed371aa2d9f8f63185e87f9db5ee427b5
6078b27eed7a36f48351729f7008a13f29e9ebf5bcaf815563ce76add94a547d96e638621afc743465b49c0091750b2e518ca398b77bc6b
b44d6d0b95019fef04fb2b0c61f9b85a353a15e54452d9307513e40cad6d22295a32dac6a44fd3e5149fc791c50a6403aa5d7f649ae8577
057cef9eed7cd2889cbcfca443c740575bfe39ad245e61214c67dbf6f3af05ef65aba392955f613702d6eacd7421797a5f87af8812b55bd
7305ff01075ac14d9ffc9ceafd445a875685642470113307c93446dbfee27db08dcc7f822d32bdbe46949eba44b900ac6b72f7dc961d2af
fca0c6b73bdc099183a7124652227fa06629f35dda82f6e6c248f554c3abb4822f5c55c9aa492c527de24783e26a14416b4120dd27aface
9cb3c516a1fc2c0c48006c789129e6459e276a7f54df3a4812b788b275e541d946f48ccf04ae7190b0f10bc403ae6a3c58b1ec4da885d5a
4e6af7df1d0020814bd095b499bf34acae57a2882bc1ea932730d93c82545e0708ec67e46544034171420ebdd36c44db41b96dcfe5f13e2
52fdb347b6c1257c7af8b2416ba25ab09bfe6f606a1cb4e8a7c5179e9b11c10595e16e378bfaa8647cb29c76d9947c4f38db6f8d28d5e98
189219724430256233350cf66972f4ee96b79f9e76f7f892f552e87a747f8df4bbbfd76498e23dba7ac2bd122130d9fb0642327c0feed93
b3dad9f9f6c6175ab6bfd80936906c061899b8e7f6cdcfec0d6f6ad5d8e9dc0c325b471d5714bbb21600f38642076aeac17ff86e29349ff
7e653ee4abf8a2b314d7799ae6f7773f6e0566c7f9f600f9ac173641862c16815e8175c4f46182706b4a72ee3f68fba749f4ba84397dcfc
36221e6cf77e5e381897b2a5723d10d603d24bcc734ba7725d4425bd09066a7e18e41e53375abd8e0f6fa5335ffeb93cf805c1cda2daa9b
e119f64800f310ad1f2bebe1f6e5e3730417fb3804218a4535b7add147a3deded57036251b2b03d83c297fb0c3341d48e512616c61b5bd3
a63faa55a624acec36ef1e377bef570663e69b7d908df6450a1506e8033d9d8033fca549213c2935acacffdbf16af79a829d5d0b28ef473
96515eb7b0fcf574e63d89c021f24040713f78a38b38b4e8f3491b517a6fa0a4068c185dbbe7d1e9c52c0e8f0bb7ecbc912ea3cebcdb080
02460c402fcfcb4ccb0ed77f7ccbac010467b885f04a0e9646388b9b8a0961416b096af9644edb9aa120dad144cec504c139d6063e0ab40
95c3008a3d46bc4a89bed935920e6091380d1e24821629534d46a3a834481107d6565729531955dd13cb299a7f83d43cb79340a772a7428
09abe7b2ee4ded9ed9c6c316932f0c7af782416f6ff5034d52cb9d5b9e30ac80cf88ea4b2edbfbea4d717594633acefa19be4fd84ae9c64
1c0c404458144b88b76c2480bcd47da397a7acd60121ea30793f56a2dde1b76b50fb3b2bd7cd917b41fcdf75a3886c5c5f1f9fc5abb51a6
dfa95091b4c8b30a0e7a09e5f6f64330b3e2cac2e5cdfd89376a1e46c2dc6a14ff726f76d610a8c42b714ab1ee7e5323b0632f4389e3ddb
1ea48a203aff0aee98388c7313fdd84ec448d1480ef9538fbcdbf407ae7bbc4078ba490015bd804f8feef8e417be8d61e239a79f237a448
a2bb70c1e70e8682c9d031cea28d16b12a190a88624148a9356ac5f5b85db0c709606eb5e65e334f5c320a667bc2fc5b134096ca1a74c71
e5ecb1b3a94238d7fa4154af8f467f91c5fa79c97944c85b6cd5956e0f346d08d443cbc4497290c40275a4a90707615e75ae90fad773d6e
5a6b1fd2827614155a8538871936647a5ddddaec8c720f27d7355128ef46d2712f019af6e19b4859441bc8b11a729559b9a13afebd93435
777d18fb01fd98923d4e433c0966e13c72c90a0becf585b6a1ac00f6b8984baf86cf3395425d3c3dd302067945789160d94009e5e9a1367
b75e9cd719d3bfa0474f1179e0ca6f4b5df714520bc4528fab43aaca37862e83bcca4a91ce51958e6b75edb3221a879f382c06ac195e694
c867c2b91c6b680598ce9d284522dab5e24d530859993230aba0c7f7509f6bb5ba8033d04bb808cbdae641a974d6d6e4756ce822b8115a7
c0cbbd394412a143c4886237ebba6399d5445954d99c27f3b956b31b0e5da3366cefeed07200287e083feb46980868b93c951e182378c66
0987bb3fc4857dcbaf20129ad7cb50459647464af9403bda41033a0fffc48240542d966897231c2483247c928644ccc7f5b3b83f5812b90
9a61d07abbef1cfcafde5e778cceb5181b65a94d4e8a47a2e7f64002c02edbeb6b9b2c2c764121b755d5b28a33a465fbf99339632ef29b5
124147d9577d354b468926174edfabbc9ae2c994582f63ea179ca92ec49a88a02678846ee1e929993fe24c2c182dd8478726b9a0333074f
5f969cc0786f9d08658cdd1c86c165c4caa7d71abc35a7518d022a06a8593fc70728ad3ce86b3791c7b6f708ef67801f65acbdcddfe4097
c3bc556ac769eba132ed39b7ff1d1b8973dba0aa07d38d613eea23583251d8dd643040d1e23e85d80a7881777229a8b667c9b885ccb36b2
107e1bea2527852a5c6c8e9b0ec08e6418e204b135ee499430030d7dc292416e8a4db0051ffd4abc2afb3407da84853cd3b6c03e9e6e8fe
cafc8b6cf086852ac0325cd30bbcc0a1e6ed76ba11678ecfead8b328e8e7a4b6ab11ea9849c4a797c1505e0d6927f0d490e2a6f23ad8ca7
c39bc70c47bd69520fbc0f4cafe6ce2841ff145ca372582b3d4b5b65022d268b50b22331acc749322b6d95a341d0de2a19d45029114ed82
999d71db0af22730ef4088b3ee49105a72d826276fabcf54a6f22c2e2f8d7e64a1a6f472eb00926503b456f20e503904cb17bfb2a5333eb
b94068dcc9a43717ae994d19c9159a3c913565d0570ce6a4f06aba86cd7a73658da93ba16181a4c3723bd9f013e7f87b7b939ab144a7832
91669b2264b5cdfe9aa350f37539f63a43a88620c40d6855c6868c5574072d99f05bdcdb77c5ec08894da6fd2d97ebecebaaacd67ecd426
c262320ae2d6ab5bfe16f419fcd9fc4cace7cf2d6d929eacf96532b47cdc9c033085d820f051fe4bda9617afd2f7de60c6ead253815d50e
e3d990f84676ed77e35e1afeebd575bb265c4425bae8338b5d8b487a546e2931706f17872a452d41bbe27488cc8cc9bbf0ec9b925398128
732f1e0ebd23478990bdb318a4aa4cfcb48e2bc8b80ea9d1f2e66b50beb048b4df661e75348d348229798426b2ab9a74e5e748e1e6b1e15
ce3d9a94cb9672e00b3221d2009a096b4aef8e665b239486a5e6129a679b274ffc15de7def66417265356c69e258874698356c7f623a8cd
c3fb390b75cd06dcaf085198020d7c1fb10be60fadb58268a6be902069dea0a0508434f5b6a8b4ea39dabb51957095af0e12e9a354d4448
c1000408f74ec7fd2e62cb00e2f5869ddc5cc9bc8a7ab717eb28ea1784692fede6ca9387497632c27bea3317623d17447d8632503014460
4754e471643d39c649a33933286d970efdc4fab1706498e675ac2e9d8656fed087151d9b9169bc1a90b7c95d7c736dd6f497ed15bacbfe0
9ea3680060a9ce4c6ddf834c9dab4896c371624390b8d7f08be51052eecb66dc1dab15fc6755f6e05d3ffef0d5adb01679cd7d9b0e22b1a
af62191ac6e569520325f8dbef37739ebc8150e5246ad7e38774731ce1f0f2e64c00b7a2b7a331a4576e364f6db0596bc1b31e6c4a061c4
8e85f18b00e256cbbe136637eaf5d56b523212875cb3d74f74ea54a213a5e10098a1973adbdd34d66003b31d685d0d0218e648ae33b8c76
c8ee454adc9d9589d4ef6ebe551fc3fb266225d9ca33dd11fabc977a43f0f9900f5ba841fcd4370f64f11ef5c42c041c9a4cd7d6153172b
3b9b3939057d115a577bb686278df0f5dc95df07aafd7da89789606534df4a7a37271b901309ee5e4fe79d2f87627fc73ce9e1965a13d27
579e8c6bd91f7e8019cfcbe40a2e7797453734442010a9afbaef3a3545641b6fba07385faf45b84402d166f7dd36f2be06473ff2eaeb873
c4e96ca9dec80ef2398970c643ab70d1f4e89db432128bce7547ea3b3a6c4d26c2e11e460c1d44880f799630e3b9db9e7ffae65deec50c2
8f7e2d9d8b2b810e3c4d8673c4f21db9af66cd69833b697e907b6c885ee9bace76ffb265694f3ff011ee3b8f60e19727e33ff30177367df
880c6ae2b5c35d4fc60eaa93864e2003c018cfbda08189e42f7831774c00a192abeb81fe921d66be0ac3db3814fb44770d6b10e475758b7
730a50c8f1b34b359c3828e0ac4adc39d6a2a21912b3e96f0e43e16bae7cd553d8a2ffc95e9421aeb75a274250b5856304179dda05de11e
9825e1bc54942b312269a7f944e3384bbc09657241c0c785358c145b5da2c249c9f51fa5e7f0eeb148bd567ad514675b64f73199627af2f
1bf7ecf45129987442b71f818ea760530553102dafede00f4b5218c83b7d4ac0f535b98bd76b084f271aefd510f093bc5b1fa49dab3b747
3d2d1aaa5a87dc1de18b9f04f8efc8e825b02e0b02870b5e957889e91f65d8d17a40c85ed30f4e256b248cda865b687d3886a5ac7f3c7f4
05bad5366a6f7ae635614df3cb20d1941574aa7033a8313cdaa4029112d670e71377092e70acc38e368f1616596c0220ca96c402f0b0c0d
ccd5b01dbe26e9ea41aad811b0d28e3aa02b45d72e7fa43e690708ba9503a1af4e1b6bf29951571f384f922737d7b9dadcd3da40550ac5c
ad2424da37382b7cef2529dde9340ae9fa26d5c9ed2c4c43c0f44d20b481f40515a9f8afacb83041528564a105024b49708ed701f23c900
8e444362bd2707f16c60096ab912a440658446b19f391a1a700bc1d2fa04716ab2db2e80e9cd41b604cd686f56ddb820236cfc08db0755b
4f123693bf0912d0bd79c399b2d303d75ab5de2d776ab363442554658ff105245dfae18677379f28d6053aa166f3785a47f386299f57ff9
4017e5136d6fd711ff5db82d20def1835798b1a533a43c21451e15ce063b0baeb29e2e7279d818ff6e8c339cd7daa24537b5aba6b764c4a
0dc826681d370cba556b9c0436d5bd8f4d5815cb4c29ac91391e1c35dc138445eb75072704ccc0bd5653dd4f02077e7f8743385d8f3cb68
989813943946c1a8d3745931473edb9bf06c45985de74fc33120d7eb641b6ad7171e4e92a66f996a52eff9cf7a76ef7f799cc30123372d4
3dbf46fdd64b3f69e402a210e4be1369f5fcccf8a207e50a47713995864d47a710d050d3bd664c2a8966ebe311eb604727f79380127d883
69ef5610867f586f5061f481f3743d6a2c9cad173ad8c1013fc136f24b36604df60aa264d7bebe5c798c1c1628f597fa2c9dcb6b37d816e
c3f543aa910ffcf20460f927ede990e0964f9d81bb13ca8bc4bc092aa24bb0458a34dcdacb625fbf4d03ecea9fac1e3f61be208d540726b
1794ab2e689fe99530e18e61359d87e1ef25534585088b5b05d7d6a776c2b3d1a5853e22c8c118489a72dbea10f24b7cc70ee7476f80aec
62f2760b99c9d83186cd863007c0b4c52a93dea6aaf76bfea9f8994890dd1e45b26bc3826fd069d2747f7adbfdb7b666cd940c917c8e52a
bd5a793e625ad28340323fa8ab8a7437797e947a77d7dcf5ee5a7cfb939de9b3b867ebd162ba16aa2dabba95ae7ee4c2f9570e558fd7796
297ccff9896145fba3fc83e68b75fa56dcc5d793e1e3400487fba3617a591bce456e11b9e9435a2c321ff93ebbf889eccc02a415f78335e
462a4e91b7d8a2319a0e3dc3fa2e513ef7694844bb26bf576db382d98109fcc233a806aa080fc660f90523c3924b6cd5a35133d3925aaa0
97fd2c06a5cb1a3309e81bae2dd52cb14d6a2d14af77cceeba07cc31a839b0c5d821f8ed1fb8cb3b308b86cffc72632d126c66ba473831a
2cbc6cfca70c111e3f4651a74eb9902e153de26a3aa426963ab630e47350f1c307a56da061ffec19e2b77a4b4338b11d9d6381c69c70682
091bf075897d812ad71e30f1b6512ff48113ab54be22e3466c68740df7c6cfdd1b2115d416d55a379d9b665086203e84701fcb428ce41b9
5b15caa4ff3d847c0ac4ee2f279bf7182d4943eb19e9d395d9b5e4d169b862b4fba45a82e3336a3c7af85feecde8fbda1ed5c829112207a
d7d77b451629ad188167ad09a1d9c4241002a451ac2804bffa6b833a19e62a3cec35b9f03bb4f850697ee86e75f9b5692da99503415820a
3297272189d4665df347bd3795a86c27739c6b03ac2de394e246a5f34cfe736b36457d14dcfd86f7a11c8b6739b6fb4e0f50c1a560ce621
9b073e2adbe80e47e20e54e52b72e2c2be7121285ccdb3426e1c092ca855035904d8ab66de6b3360ecac584ad910ef660d8d653ada772e6
2eb44d21868b3fe389868ce479044148aa3f81fd8f9c1d71ecedffcb6bb346ffcafcbe716af8928890b6832d29fe264353d7e8f53cf89ac
8a2c4dd9413ac460cf7500484edd1f939fadc85a59429a76f937e783e80696927bda906d00aa2ffef68799aac2b7164dc2e3c96ad2fe20a
d404255e4effd5e59ed9011b231e6f744b5c4e63d878356fc087e306ab5cc6772a582fe24e1b927b00b6f416187cc1b126286a3bbc4f5a4
33fca109725b2a9aa7f9b285dcb3ebc64e8dda311547c67eb029de40cf5168beabd1d17593056622a1e2c918add4987bc889debb5d1aa5c
91b5710511171de5d2de00658cc19605ed201a31c753d80b99b79c9a9f63bcabd9cd5e55ef5dcea3b733d696b24e3fa0bf0384b9d4a383b
7e39cb90bb9454595a31ea3958f0a43300d962e46796714bfe87ad58ff5de5b892e04ec0a8f32a739a8dc78f0b36dc17fc5fc7ee965c269
427292ffaff8e866094ebc62af4c37655467a1fee3b69b440817fee17f43af0b240b1d9d9539a5f529a571b6ec7043f408c7c752ea77014
bbbd95ff72c837d03761ab85239a48e39a8b1a4cd28a46c147fbc99cd5bfe105e8e5da35c2059930fe805d24845fbf21e2ac1fe3d5ecaf3
5b77a77d88bdbd2ec5e782d17228dc396a4a123cb0f6db56ba62618f8df73781f65e356031f91f31a5b94095394635b03dd3dc56b07e643
5c4ca2ed4b586a24a340ebb362071198cccbf4b902292db7708655578d3d1c5354a8610215d88480db926537ae1687d6156280b47c332b7
8c0f6d68008d48cfa2dbf8914914b01d69e3b6ffd5a6b22a2cdcaab2ae214dc58a39f15c857d53510c1889e4fe6ddb7d0fd30a7518dc6d6
c3ba2dd28864f405ba135571ea57e822ca5a2557c225e787b7033d41035dd6da69342e250c607c2bd0d4c7766a2f20bc71a8ab11e0897d9
99a8333e61cc86920a449ecfd50102c07d61eddd82fcdb5c57195c3e27f7fbd33fd901ca86e26f94ffc8bc8375449c3f3ecfba05f2041b8
a8f15ce898c4a66411a2a1e3ff7b5030f2a1214799d28b8dc9847da701d025766cbae248a355b60992d6961ab01fa2154b72763b24303df
a21d5f12b985c9211b0ef563f24789e497cd63ae77529bd62516b8fbfd263594ab16c7b8f7facc9f53c96afdb9637e9bd0eba01ea810e7d
2ec5e71f2911e5b25a85ec897bb249b4228dafe2246b459bb3b1ba82d4cd05deed5bb63b2cde0dd8132857da4048e53b8556bb91c6ed154
15894d02ee47b20d0fdc678b8864f00e692061003e7ff75120d9356c8f7ead19c664c353df64ef3be5d93e06f2dc12708163e153daac384
f4f917b6250352bff8533ef043e1d73c0ffaf4883f92795233f23cdab41ecb3f33a8a9433e464b084e17764d91dd4bc83bce1ffff994122
86bcbd43e50082c913bd2911f455214ca86e18ea8694ba7936ee3d52713493f730c3af7581db3df5635fbab0edb0b349e4577e8ba39fea3
82314ebbb02ac17c9b1633f6660e2c421193a46ba8c5df9726634be7072896fe35e8d17c8dffd892b6173725fcd4f87e63b9efa571f5c67
f4b8c46bd8b310fa8a4341d67b6aadca391c9dfff5c8ca69e539149da6feb232cc75d7b74d6fec0c584e7308f6d1674f83b3b1460d3eb60
89adb3d7e2644ebbd8c04b8b6b8a8e511b707c6e0bc0ccdffff3039fede5309eef44b1be5d5729a1f39d250e6969e9e5f53811996b77cdd
e372ec31cb86046195a704bc50c8293d778d20d783dd18e4354c2d196f3ac5cd4286e09f67e47a4e8f6027d558784267692fd8912c51593
af17397cc41a203177611e4994d1c20a4fa5d4918ee47f88c700d52862c246dfef25bb728ca52d20256c16ae30cb48da14a584aa5a68f4f
fcad4e9b30f306698bb1e39c1a1cd04639a25d81f6e2f9cc42dae50e2dc56e2963a12e3e9de0fb15371e689767f83561b5310d732fee963
4234575a14be0a1cd246a7bb311b129050a9f7159518571e5d718f4559fab261f5bff901ae5f26cea861dbe237de9a4f4a2b77d0b9939d1
24a5fbe1b0ac293644fd52d546d93e7d48d493688c798d829d03bd27104a05733449a426b779e2a69c5d7d352bb71f53f7f01c149ee006f
54e9d5f83bba2469d32da710b4557a20622e9196958b8e4d05a86a23c9899544ae63a51b51853bfb1bba2ef68cdea75c26a5cb0fd960851
c5e98fee2004db3a16d72ce9162b980d73b716097d7bdf31a84cd95530fa32dae0575325c32d8debfccfe15a8b6b4e20699e8eea861b9e0
304da2a5adbe11e7dcdbc14d85254859a61008c0a5bd30e4947376c1f785256186362885b06341f88c449b9d01ed813e8d14e6eec21a6af
c7e184980cddd38e1de762cf926edb8c9a7303b138094ecfda7c69a32c2f545c13c71a153a75d1cd910d28c85ba3f55cb8ed5f18325f40a
fdacc38046a0f5fc2d6a2148c3c8e745931903799f8c8cd6d0bbecd0532de6a7ee02ed33cbd62f454d323def4fcda5fa26e40ffb475f648
a82d404e713a595f76305dde2f767dd523880c2eb262bb3bbaaf246c867f9be3254f1a551badc2614a798680de0194c80778412db8b23f1
ec5311c448964e3de8e73b4394484fcb947b6bea3e7bf450503693eb4ebf3ec9a98fb2e6b75eeeb31aac5aa3d76d673f118f0027fdb7f32
a5b443ddca9f9b51734975e76754f6920688e0fbc57053c35a422ba6dc1c4957381fd7a869cb1e4530f8ce2b3bfd03683f7c4203f62e87f
60b42640d292f0525bd7ba6855a05a601b9c035a0411e6ce4bc151a69649fb205445cec3ab72baafe8cc7e352171f3b09ad39d2e9d01fdf
165a820b9bc855d6ed662760be3cefd10e4f759159c6585620009392760b52fe338df1ee124b841be30807513a86e43eccf43e6093e2377
2d7ffba037de8137ecb787ccdb4ef5cd77982ba2068d106078625450e6699dc816b787a4a2d928001d45971fd541fcdae5d5b149003bc14
c765fc0af7610e4546a2fb2448cabfcdedffaade35f37555d2e81ddeedd1aeffaf6406b4210afb99262a7013a3e906ce1fa108ab9c1112c
29767c04c7f75b085d5557954012076911f26a9d534a81fbdb42d8f91aa4eff22d650b0c7ec622c7d747656a71abf7a2b344ecb455a6295
8f2d81065b624785bd53b35d4bf5968110149ecf44badcc730c803cec835c27879ab7d4d2e7857bb48f81411eeed56414d37e957c1fe7a9
697837d7f68338dd4e7eb89c4cfe2e68043707a9b8fc9684ba11022f4d25589cccc8e0a57405a05677ec19197a57fee305351f32b3430b9
a6c3456c4ee3e20d71e212a67d2a8c8c90b545e02659882bf76f3afd2b7a06bc6f704bb6c13ab51a1a15cc10c7803f659cd793e14fff373
6183f441c8d572cc507d3a4aa4a484d3adf6d0e6321f67b1210441beb5402a711976a84d99244d03014fcc78e738b7fb2a25168dc88c3be
8cd809778b5ea8cf583e30868d54de93a5c4f7d77ce1c74152bb026038b6731f51ae7336e96acf73667c948c6cee32894821936bd329f0d
82c2b529e816e3cfd3dae745a69afdeaf24b1c3ee79cfc119c896472b6caf6582ba68db0062ffe0b01820b88856174242c44101b23f906f
c03be1c3db3b3cde1bf6eaaad8b02fac4cb477e93012d73d4cb318a77681a066d9dabc4aaf1d68c9aa96f613f9b1b8963880c7af3724df0
8ffcdb717d7fbede993e73b90b0684b05f82c8d79b6bbece07439c75ca3bc5cb523e93522950285c53087e5045294c89358de4b2b9de18e
b21486ad4acc5a1d1e5908175a1308ffc9e020c03b589a95ed6a66b7b3910ceaf367e368cb25c293112f45d04f489f5687f3a9876cc8063
1bda2c902f94fea1c465043e699ab7a99b8d03dbf23bd5eb8f6132c74465ff34ff070cf10b99e72909d8a0367bdeabf9867562ddf4392ae
a4fe1971b6bca3e1631d27b8b1ee3f50dd9f6f7722f34e1f1abb9574746b138826f100523b68c151e4037754317e63d93cf061de2d314fb
abe5aa19b5dc1347a8e2415099f0e7e3e242abe53c020ab02fab99e3ba821dc13edf9f3aece0a024a46d9157c2884e51884b9eef2fdd612
22f35f5c8d7ce3ea06dec31b9353826c0c6fce497670f644439072dfb59de45889ac5f410a385c0ce193b376d61777ba85f56cc0df5e088
898a2811ea2f52046f4e971f472511c8510b5340d9fe76e5d14fc897b9cd9e67d7063e400688c26758deeba47fd9bdf844839527ede9c36
3ba1b47e98506475833e6bedb5f6b7a5eaef6b815452d605e7f1b7d0b9c06d0285d86ea00e95609d11f4aebe41ed5fd19cbd555bcf43a8c
24a9cd747d532c409ed611415885f743c0b70e737e25d44c1f0ecbde8b346c21e4c4872bf4bf73ab6da3523958c0c611f4a0eace22e5243
1ac0977ce345aedfa88cc2ae1a403f77b4256aaefc650eb4f749e37777d81897c7dd01bf405018d7b706b88764d2ef6f99964e9bfab029c
0cee623b94fe06eefdceaf927f22e532e004cf1c2b82d9b66d50fb123931d1e01b9412d8599f4b8b9d91f371accc4c2374afc9b8a2dbe81
3473be99905565bb52784e79dc13ed78edaeb8bd4d8e27a824327c4a07d93967d18be2066e045abcc581948807e78a6ed447e7b1aeb79eb
1cbaf15c82469bd10c876cc19e74b29dd1922fba4d74f2fef987c5cea3c016fbb6e5ef289a4d7bd146476af6f88d8c9220b2212f4481d53
f3df0f40596ab6550ecad9ec7be3481613ae385d078d074d432da1a440b62f3fe60c46aa3947b22344bf648db6a545110352bf255cdd7fe
d7ee0b70b01630792e6fa50fe146152a5bb4502f08c8f3bbbf16d5ecece1d66c04f553b84700839138304f42eed49e2cb3179bbc4542a43
9d3079a917d93103eb74479463e6741d8ac184da156821dd81ae5819950feda921b5a018898fa6574fa4f59e825062f68d6c0989ddc4119
6ebbdaea7908cdac7aa12881951f1c945e9f5dddfbf6c7223b494272836f4089250fdbe42cfe216c7d70188c3db8a7351ef579167123a3a
461f9bad886e6dc7694b64a754dd091cc8777a74442f282ad59c1690f24ae20880ab2cebe1bdca36fd24a02b04052b32c94f056cf819555
36b1e6b6422ddfeac48ac4464c1220186093be0dfc6d29faf6154b25e72fad0dad90a29a5148ad0b59ef546a0540312d17346cce86d18a1
f41f78ac9e0b9197d6819b02632a1718c23b34fdb06c2e5e0f287006093ad77471782eb7fd43f60008ba604023719626e4a8eb60b73b0fc
ca105fa6fcff6f3ace245e6730c089891c40f4c02cb691fedff32a8f18636ef1354781f4a44ff38ec2767436356f5d626c8365516dd25b8
9c51345b9b55a0e80fd167f23ec21d3b415729003a979c316d02e3b0f039574fa3505c24bca5e7884a267315ffae85a78a4e55f801ba495
c2291dffb2feaa0b70ceaec801bba18fb38f7bebdb5daca99a808c80824027e6b9647a1cd02a162f3129db3c38b6ff02c88ca94c55a0c49
856102182a3cb26eff54fef90fa0f53fbb350a723bd2d72297770b67c75d3e01ecfd1f4612027e5a8d42de782b9b04663a495949918831f
7b200905028cb4e5322722cf56b1531269e5bf518a1d5cde1cf1a91072f537aad0f58b3ae4734a2e0504d2ba14084addfe06fdc6ca33e7f
9be0564be136fbc616f134982000047f585e3bbdee15c34f02619a04f1eb0d320fcb93890475711a4761cb1e67198b852b7b605037340ae
ca68ad6c1b6d81ee24b622e922ff6c16faf88ff75728ae344d1a50bd51f26c9cad3b5608b33c858e57feaf3ff882f4a40c7fe51a14dabe8
9f0f40253ecb7bd1d4d5291ed3c1b88b1da932a487d22b14181ffb770911bbebcfbf19a9843bffe3209785b02b23fe3a6176bf208f2ee25
f20332657d2ca6728b9865a6bfdc9a9055a6ab86cb782307c2c0255525884bf8060f8aed7ec034f3ea0489f0f1d61cdcbea1ff69835df7c
41b6a448c2e8274c99e9caa0339c052fbcbf6648c2780f119607c6355b8c37e83a11858b3f296815f2c60da62c68358653db2fbc738d4a9
20f8bb8d94784228934870046f60ac937af4957c9414bcc33895fcc183062be4e4bff56f9c89838ead8e433dc604536938
''')

db_write_enable = unhex('''
0602000001f48001074892b6c57deb7889b5ebf86bc3040f6d91ff1f68765f046591184be08cf36c154b7ec5368139d0f9532382214379a
ff3ffbfe4659e2f274e864bd0ad660f99e21da2bab677dbfa907a66ce110c180d2ddc5dfe40b8ed975cbedffc11631f12f8bd646a0ee82d
44d2a6c1ec9cfbd40f485cb3d9124376b97b4a3349b0a730adda626d8ac28ec20e886aab1b8851deee3431c4d89c8bb3e787eaa9c0323df
e583d5424d36436e4435043e04fd4ea46b1fb2507ca6f0eb03baf27c84b819cbc96cec31a78045eb648339e2aa4789e7672d933936005f4
720c8ffdc1ea23a4f30a1cdc8f6e87775c241b9ab1566f7771857cc4703d571f1106c526f95232925a6a93ec8e919022fbe303a515f9aaa
8ca215072069311dd3f97d9a4f56259bab3a1b7a8582d6dc2f92d49f023d6f25a05837e1536a633e252ef645225f4293955041a0d54dcb1
d1dd7e097b7839de5fde2a6ce999966d712b4cb2fd9d7830031da55d9faa99f866fbb7e520566efba43c2509286bf28e1a20c6a836db8a1
fa4cb9b8d193780aab592d41653839670129066ac56f1268e6f761337f768555e13c5d68137c60f83dba8dc3863e00e73fd3af21e23a566
daa67f3f14dd934e323651167021ca6b82a6103cb30be849446e2f54dde64a05377052b57332e9bf08a18cf52da2a13ebbd55e60333f8bc
319e1457f38ec5d4839ec0ecd034825bdeaf64926858c6e8c2df418717b5f67135abc038835d3e4e1aa809546fd0d7f01066a71537f96bd
1ecec3687583e1b511bf48c2776f4670158e56164c62da20f671764c785c352fc3cce22cefa20760acff8f45efb54a934f9834d54f9701d
edacd4d383ac01f8cca92562eec774a58da6f55da252c491ee2ab58ff769f89a9649d3956682ca7d06bbf33f9a935b781dfc21b123b1669
4424e72d6a3e6781dcf195effd36470a4eab0fdc74e87102879ec81fea6549920cce454ac7813997b82d51e7b8c1ee24fad389904478f84
7654ec3a63bc595b9a7dde798db5c0b6f244901f239e7674c98eebb42b66e8956a733c3796586280a19a1df8a69224acd2556f7ec2e27ca
e37c69b332b2c0ec85991ae48722f988935f658b9cf32f46dfc6d96a5a36f18b6bf9f657b59b3da42414e4d56c0a24485aa298d2d0d1b17
7e7d0dafe602a4fb4f423def4bdb010fdc626c947587e19e7e4b0e6f9f2da41c29a8f1903d0d2803365fe0a113abba19220141d1ac7cec6
83962030d3f6591f98ea3dd09162715e5c12f40332b47c53164532827e5596fb2cc0aa8f31683cc63ec14c034c6f3d2c70b8c47611b4c5c
b5348a2559fb162a780a2b403b0120a6846e27d6057a3ab9e1b18915ae2039e81cc6c50d2a14d5913617bacae78fe9b91e9e49d2e82def4
7565c12ff938b182f8ce941d2781b773479538c76ed9f7d4469f6fe5ba7f6e3ad98871b2866f0ef4f36277daa76c1042c83f77df0ff2e26
39540bb355ea84273411c453081bd1e1035c402c53190d0bd905e8d01fc3787c65b69172cca5b234e92e358463bbb8d23e38c74a3a8e273
5542b996ba5ec22c5095a777b6775a728df59c3560c7f36b83d55f819f196573f8fd356379fe9a5e7cecb376395e01309e2005b29e3b160
cb74c6a5856093480dd06aea5fb3fbe23e004f8d7a38fd07866cdf24161391cc756f6ff71ff072e308b35e259435111bee09ddf2b8df99d
0f2c2e8edaa4ecaabc6975a58f23bb6bfc94ebcbbba0d581f16be9d043c4e410b321c6df424ecaeea94edbe5801eb786199124222b091e5
b33bad6761445a8a6606d0e781c07a6f91cd5fe188ddb9f9e17f5e07b0cba319c52e5fb03f53df570f82ddb603d305b72a2406bc7c1a37f
920405f8f14d3ddf5d836ba68d83c1a8d7f1a41d148cc34b1ef996ddfb43ef19d2fbf0adcad301a473497739eaa10bbce85e15c32f1d90c
8ab8605d0ae941eb914086592d087a521fde33a676cdfb94a4247f60f51edd37294511e92ec71a9a54bab68a0edaabdcb2c1a3adea778f4
16e39200af4c517dd7152bb72476c5d1413f04704615d795300f3a091214f4e4ac2ef41969c81f8fc08610864907b2e6edfa5fdb0926b6f
064b2a1c3b8c7b631cc75663cedad5e71868abc9bac678e430144613cb0e51982b9e019099026b069bb7a4dc376cdd6a3c5956631797621
3672754fac87df85953cdc0de276fb8742f48ba218d4202fe6f865834152979d6da9b473e5d476c0aaa68491f545091b879c01986078d64
fa5f49f60e615cb865f154f48b45173a1dc85f2eb1128652290bd383cdedcd8f280117e60be034ce224f92673934ed9e0077d5f7899f4e0
eee097933a35e40f205d84a10733f492da619802ff70d9b949ca0c2bcb9ba68c290f2ef9a20a3bf496834c66956a8ec4179266999d9f87b
dfc14aea865f0487e2be10a64becba69547d01658935e63703986a56d6ce38fe66dbf61d754ba9a1a278353913422e4f2e4100c5962999a
3eaa3e1672bc73edcfcc7525a2d3dbe95683b4bf38f7444ac0f470f0e98079916e4e1fba3fcd5b082fc2772e63b5e0663f87638a163858f
590845240a8c22dacf6f7999c431a2ab5204a7da7839c9a932608c7f83a87d1d73d7d8b2fec65abb95221fada44365fe21061dbcde52cb8
4cbfe9f061c4dab3be86002e7683eed16c23c687ce61c5d923ffbab40bee6ae93ed7f857f304e5eb16ec6d088563524e90d916e41a3a8c7
777e29731f0f45c125082c423a5c02704c07c6fc19b1c4838ee3eabe12562829e67581d312c720b792a41744dec1e157426ab75136d31ee
2f208147039091453c0b0e3970c5624d7a53df8076e9d1625d2c8e693e0e9a81e23862dca78921b66ca4c3c5ed35b0b5ed2e24622eb216b
a0ba6e0c0eaf97c754eeb3db4a506d5854a3edc92d0111af3d2135a998729123f03d0f9366bb0d2c681cfc62c59bcd75c6b410d8e6997cc
a55c989f010393d6c242f7ce1ea71c6f262e498855584347b04ce26cce2e822b8c6b7b4937148a45c947073b300f7c72b6e78c4231078d8
0531b7f9317c1bb4d6070f299e9a97731b1befeeec2dae0a1a0364568acbebab069a4b90147776ff7e7f79c1cc98b2fe6214792501554f4
195783b0f9188ccfe96ad8cd29f5463409c2054e4a2496ee65eaa1fcda3d7764cd3e8431e44a2b05e64aa2f9fb0d13456bfea9c91ec2d90
d0099e7e395dce818650dcaf8bdfe23b4c6443f5c690b18ead221a6c2bcd34572ffb83b3332eafde6e25b37ff3ac6da0c3cc697b996265c
aa5a53ce44570303d7d111f44c635119595c247e86a32083f2865501752f93e3024b2e2b6d82d0c03b745bfd809af7e8e1349d1a79bed51
bba415064701a2a7890e8f39937c6d2f563b0747bd94f1b698624b4fd17dfdf68ffdc0450c26d771f8ff4fb01a26ff8f64eb5b6d9153f5c
e29d9dfcf84ca230a4c212401b437d1137f83a44f7a98a9fd1bc3d883e6227ce369ed32a960550aa863f3d014de7494dead34fced1d7b4e
ab651d499033589446fb5a1564557d63e724941e77ae3f46b79703d06277d87356999b51f61893d31c7231b0c635f1d83ab38a0dce544f5
f6803861d6e3d7e70d617ecc593920b1ab9006bdc7bff34a8b36a7601eb170a040156b4567ab37f55fdf2d466fca9374277322f21811d02
c7bc599c9ed5c2b1fe7b6baa19b1b0a30f79f8641b97bf66491dca0b4c0341367aa5acec1398bb37c037d81ac2368db49c5d5720bbfb746
6ba616c70c7d834286303047357da0e9a34fc14b00c17a0a02f6a62a5b52976b00ed67bb2d0aa1b4a8a93100b799e1839695bdae9b98e75
c8df5d8340d158be60379a6f626af052ad55c5cea01f806048e937f87e01e725e67620364e511afd288b25953e9ade343b596068608190f
a5c4df114c93d3c8deca929c066d8bae5ac2d607e3f94d68a5d3554827a64735a43c462bc3682cc1664411f592c9456f53da1026f51459a
0cf20cc171b9b6bede47ce57d845dffe1025c6eb240615da151106a5601b75c24c673d6ea818d60c31f414aeaa55597b40cc4f2ed2b3850
d366084a52513420b013695e2bfcb0dbfad0014975c67471a3807528d15730802a4428842c6368c72650b3161265d6b86007264cf093a31
7fee4ee388e7721a02434c514324cbf85cb57f709b53fdf69624adc29b85518f1a051f2473ad9384d7ac57c2a780ab72506ba925fa39992
dd2d0b00ffd8c38645d55c2ca2ae94cf4ffa372284a28a13797e25eb0d950c08371656a889e6189f83b9c0c8e06952b34fe13ccb5c3b2c8
2f2d988f6d9a233f1a9e64de97218be12ee7a8e8463d82131624ce167e744a3ca3915c78e6e76362d06090e2a7ed60ea7437c84838d8aa7
5f096c9a928e403e2428550c98de8c43bd25e24520aef6ee534ee1d4702175e6b25d030b87941845cefc1dc289cee33c72139f29839af81
cb6a097d114311a01736f479bdae32a59398fc4a7494d034fc8dc5f2ba8af93fc4c576b703967ae593780413b44b98f4baba9d3fd7b5571
5ad5e5c41f9361a42a757d9a6d7220a9467e19f739877076164c142d40bbae9501312c394dc0233dc5868814162bfc1f10bd4663b285dd2
d005f3bc3dad2ff023f7e81b799b1b323b37e82fc99dc81291cf93cc04a0e05aa674bcfd3bc0d930a10d0957ec7712b8cc78375dd904eb5
a468296015dab1babb076786f305c8ad90ca3947b150da79cb94037e970e9180437ea34c72771d673000826741fe759fcdc2b03558331fd
f5b89d6e3f25a05241f32f139e898126aec8b1715cac0208831fb1205f9efb75538755b2d83931c7ad9e252c88c8af3c5df62fb99653aff
99e6c6c051a9a1241381cd5ce1307261f866575caea0a3e847286ecc67d7d9aa18f48ef2a5e5f183286127f8b9aa2caa0869ec5e474a70e
5427dc2f0488b134d201241dae68ed3996869453247bb50d8bc3d3c909951e5a47b1e899610347ea8d7193346bfe754c289ad1ca454b9c9
2a07527b95a1fe508d0b7c8da5b9047d277508ff615c9dc9ab11596aa88d0c9734a45d81f0393219bead587d3a6f9d07c470f2abf8d7c69
92228bf0ab6ef79e46599bb0a60
''')
