/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKeyBase;
import com.vladsch.flexmark.util.misc.BitFieldSet;
import com.vladsch.flexmark.util.sequence.BasedOptionsHolder;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasedOptionsSequence
implements CharSequence,
BasedOptionsHolder {
    @NotNull
    private final CharSequence chars;
    private final int optionFlags;
    @Nullable
    private final DataHolder options;

    private BasedOptionsSequence(@NotNull CharSequence chars, int optionFlags, @Nullable DataHolder options) {
        this.chars = chars;
        this.optionFlags = optionFlags & ~(options == null || SEGMENTED_STATS.get(options) == null ? F_COLLECT_SEGMENTED_STATS : 0);
        this.options = options;
    }

    @Override
    public int getOptionFlags() {
        return this.optionFlags;
    }

    @Override
    public boolean allOptions(int options) {
        return (this.optionFlags & options) == options;
    }

    @Override
    public boolean anyOptions(int options) {
        return (this.optionFlags & options) != 0;
    }

    @Override
    public <T> T getOption(DataKeyBase<T> dataKey) {
        return dataKey.get(this.options);
    }

    @Override
    @Nullable
    public DataHolder getOptions() {
        return this.options;
    }

    @Override
    public int length() {
        return this.chars.length();
    }

    @Override
    public char charAt(int index) {
        return this.chars.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.chars.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.chars.toString();
    }

    @Override
    public IntStream chars() {
        return this.chars.chars();
    }

    @Override
    public IntStream codePoints() {
        return this.chars.codePoints();
    }

    public boolean equals(Object o) {
        return this.chars.equals(o);
    }

    public int hashCode() {
        return this.chars.hashCode();
    }

    public static BasedOptionsSequence of(@NotNull CharSequence chars, BitFieldSet<BasedOptionsHolder.Options> optionFlags) {
        return new BasedOptionsSequence(chars, optionFlags.toInt(), null);
    }

    public static BasedOptionsSequence of(@NotNull CharSequence chars, int optionFlags) {
        return new BasedOptionsSequence(chars, optionFlags, null);
    }

    public static BasedOptionsSequence of(@NotNull CharSequence chars, BitFieldSet<BasedOptionsHolder.Options> optionFlags, @Nullable DataHolder options) {
        return new BasedOptionsSequence(chars, optionFlags.toInt(), options);
    }

    public static BasedOptionsSequence of(@NotNull CharSequence chars, int optionFlags, @Nullable DataHolder options) {
        return new BasedOptionsSequence(chars, optionFlags, options);
    }
}

