/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.WithSelectHdlGenerator;
import com.cburch.logisim.std.ttl.TtlLibrary;
import com.cburch.logisim.util.LineBuffer;

public class Ttl7447HdlGenerator
extends AbstractHdlGeneratorFactory {
    public Ttl7447HdlGenerator() {
        this.myWires.addWire("segments", 7).addWire("realSegments", 7).addWire("bcd", 4);
        this.myPorts.add("input", "BCD0", 1, 6).add("input", "BCD1", 1, 0).add("input", "BCD2", 1, 1).add("input", "BCD3", 1, 5).add("input", "LT", 1, 2, false).add("input", "BI", 1, 3, false).add("input", "RBI", 1, 4, false).add("output", "Sega", 1, 11).add("output", "Segb", 1, 10).add("output", "Segc", 1, 9).add("output", "Segd", 1, 8).add("output", "Sege", 1, 7).add("output", "Segf", 1, 13).add("output", "Segg", 1, 12);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        WithSelectHdlGenerator decoder = new WithSelectHdlGenerator("decoder1", "bcd", 4, "segments", 7).setDefault("0000000").add((Long)0L, "0111111").add((Long)1L, "0000110").add((Long)2L, "1011011").add((Long)3L, "1001111").add((Long)4L, "1100110").add((Long)5L, "1101101").add((Long)6L, "1111100").add((Long)7L, "0000111").add((Long)8L, "1111111").add((Long)9L, "1100111").add((Long)10L, "1011000").add((Long)11L, "1001100").add((Long)12L, "1100010").add((Long)13L, "1101001").add((Long)14L, "1111000");
        LineBuffer contents = LineBuffer.getHdlBuffer();
        contents.add(decoder.getHdlCode()).empty();
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("  Sega  <= realSegments(0);\n  Segb  <= realSegments(1);\n  Segc  <= realSegments(2);\n  Segd  <= realSegments(3);\n  Sege  <= realSegments(4);\n  Segf  <= realSegments(5);\n  Segg  <= realSegments(6);\n\n  bcd   <= BCD3&BCD2&BCD1&BCD0;\n\n  realSegments <= ({{others}} => '1') {{when}} BI = '0' {{else}}\n                  ({{others}} => '0') {{when}} LT = '0' {{else}}\n                  ({{others}} => '1') {{when}} (RBI='0') {{and}} (bcd=x\"0\") {{else}}\n                  {{not}}(segments);\n");
        } else {
            contents.add("assign Sega = realSegments[0];\nassign Segb = realSegments[1];\nassign Segc = realSegments[2];\nassign Segd = realSegments[3];\nassign Sege = realSegments[4];\nassign Segf = realSegments[5];\nassign Segg = realSegments[6];\nassign bcd  = {BCD3, BCD2, BCD1, BCD0};\n\nassign realSegments = BI == 0 ? 7'h7F : LT == 0 ? 0 : RBI == 0 && bcd == 0 ? 7'h7F : !segments;\n");
        }
        return contents.empty();
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        if (attrs == null) {
            return false;
        }
        return attrs.getValue(TtlLibrary.VCC_GND) == false;
    }
}

