/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;

public class TelnetServer
implements InstanceData {
    private final ServerSocket serverSocket;
    private ByteBuffer buffer;
    private final ServerThread serverThread;
    private boolean telnetEscape;
    private ClientThread client;
    private Value lastClock;
    private InstanceState instanceState;

    TelnetServer(int port, int bufferSize) throws IOException {
        this.buffer = new ByteBuffer(bufferSize);
        this.serverSocket = new ServerSocket(port);
        this.serverThread = new ServerThread();
        this.serverThread.start();
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public Value setLastClock(Value newClock) {
        Value ret = this.lastClock;
        this.lastClock = newClock;
        return ret;
    }

    void send(int value) {
        if (this.client != null) {
            this.client.send(value);
        }
    }

    int getData() {
        return this.buffer.peek();
    }

    void deleteOldest() {
        this.buffer.delete();
    }

    public void deleteAll() {
        this.buffer.deleteAll();
    }

    boolean hasData() {
        return this.buffer.hasData();
    }

    private void setClient(ClientThread client) {
        this.client = client;
    }

    void setTelnetEscape(boolean telnetEscape) {
        this.telnetEscape = telnetEscape;
    }

    public int getBufferSize() {
        return this.buffer.getBufferSize();
    }

    void setBufferSize(int bufferSize) {
        this.buffer = new ByteBuffer(bufferSize);
    }

    private void dataReceived(int data) {
        this.buffer.put((byte)data);
        if (this.instanceState != null) {
            this.instanceState.fireInvalidated();
        }
    }

    boolean isDead() {
        return !this.serverThread.isAlive();
    }

    @Override
    public Object clone() {
        return null;
    }

    public InstanceState getInstanceState() {
        return this.instanceState;
    }

    public void setInstanceState(InstanceState instanceState) {
        this.instanceState = instanceState;
    }

    static class ByteBuffer {
        private final byte[] data;
        private final int size;
        private int inBuffer;
        private int newest;
        private int oldest;

        public ByteBuffer(int size) {
            this.data = new byte[size];
            this.size = size;
        }

        public int getBufferSize() {
            return this.size;
        }

        public synchronized void put(byte value) {
            if (this.inBuffer < this.size) {
                this.data[this.newest] = value;
                this.newest = this.inc(this.newest);
                ++this.inBuffer;
            }
        }

        public synchronized byte peek() {
            if (this.inBuffer > 0) {
                return this.data[this.oldest];
            }
            return -1;
        }

        public synchronized void delete() {
            if (this.inBuffer > 0) {
                this.oldest = this.inc(this.oldest);
                --this.inBuffer;
            }
        }

        public synchronized void deleteAll() {
            this.oldest = 0;
            this.newest = 0;
            this.inBuffer = 0;
        }

        public synchronized boolean hasData() {
            return this.inBuffer > 0;
        }

        private int inc(int n) {
            if (++n >= this.size) {
                n = 0;
            }
            return n;
        }
    }

    private final class ServerThread
    extends Thread {
        private ServerThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Socket client = TelnetServer.this.serverSocket.accept();
                    ClientThread cl = new ClientThread(client, TelnetServer.this);
                    cl.start();
                    TelnetServer.this.setClient(cl);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private static final class ClientThread
    extends Thread {
        private static final int ECHO = 1;
        private static final int SGA = 3;
        private static final int WILL = 251;
        private static final int WONT = 252;
        private static final int DO = 253;
        private static final int DONT = 254;
        private static final int IAC = 255;
        private final InputStream in;
        private final OutputStream out;
        private final Socket client;
        private final TelnetServer server;

        private ClientThread(Socket client, TelnetServer server) throws IOException {
            this.setDaemon(true);
            this.in = client.getInputStream();
            this.out = client.getOutputStream();
            if (server.telnetEscape) {
                this.out.write(255);
                this.out.write(251);
                this.out.write(3);
                this.out.write(255);
                this.out.write(251);
                this.out.write(1);
                this.out.flush();
            }
            this.client = client;
            this.server = server;
        }

        @Override
        public void run() {
            try {
                int data;
                while ((data = this.in.read()) >= 0) {
                    if (data == 255 && this.server.telnetEscape) {
                        int command = this.in.read();
                        int n = this.in.read();
                        continue;
                    }
                    this.server.dataReceived(data);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void send(int value) {
            try {
                this.out.write(value);
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static final class ServerHolder {
        public static final ServerHolder INSTANCE = new ServerHolder();
        private final HashMap<Integer, TelnetServer> serverMap = new HashMap();

        private ServerHolder() {
        }

        public TelnetServer getServer(int port, int bufferSize) throws IOException {
            TelnetServer server = this.serverMap.get(port);
            if (server == null || server.isDead()) {
                server = new TelnetServer(port, bufferSize);
                this.serverMap.put(port, server);
            } else {
                server.deleteAll();
                server.setBufferSize(bufferSize);
            }
            return server;
        }
    }
}

