/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.hdl.HdlModel;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.hdl.BlifCircuitAttributes;
import com.cburch.logisim.std.hdl.BlifContentComponent;
import com.cburch.logisim.std.hdl.DenseLogicCircuit;
import com.cburch.logisim.std.hdl.HdlCircuitComponent;
import com.cburch.logisim.std.hdl.HdlContentAttribute;
import com.cburch.logisim.vhdl.Strings;

public class BlifCircuitComponent
extends HdlCircuitComponent<BlifContentComponent> {
    public static final String _ID = "BLIFCircuit";
    public static final Attribute<BlifContentComponent> CONTENT_ATTR = new HdlContentAttribute<BlifContentComponent>(BlifContentComponent::create);

    public BlifCircuitComponent() {
        super(_ID, Strings.S.getter("blifComponent"), null, false, CONTENT_ATTR);
        this.setIcon(new ArithmeticIcon("BLIF"));
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new BlifCircuitAttributes();
    }

    @Override
    public void propagate(InstanceState state) {
        BlifContentComponent content = (BlifContentComponent)state.getAttributeValue(this.contentAttr);
        if (content.compiled == null) {
            return;
        }
        BlifCircuitState id = (BlifCircuitState)state.getData();
        if (id == null || id.circuit != content.compiled) {
            id = new BlifCircuitState(content.compiled);
            state.setData(id);
        }
        if (state.getInstance().getPorts().size() != content.inputs.length + content.outputs.length) {
            return;
        }
        int inputsLen = content.inputs.length;
        this.loadInInputs(0, content.inputs, content.compiledInputPinsX, id, state);
        id.circuit.simulate(id.cells, id.auxData);
        this.readOutOutputs(inputsLen, content.outputs, content.compiledOutputPinsO, id, state);
    }

    private void loadInInputs(int base, HdlModel.PortDescription[] set, int[][] pinX, BlifCircuitState id, InstanceState state) {
        for (int i = 0; i < set.length; ++i) {
            Value v = state.getPortValue(base + i);
            int width = set[i].getWidthInt();
            for (int j = 0; j < width; ++j) {
                int cellId = pinX[i][j];
                if (cellId == -1) continue;
                byte b = 0;
                Value bit = v.get(j);
                if (bit == Value.FALSE) {
                    b = 1;
                } else if (bit == Value.TRUE) {
                    b = 2;
                } else if (bit == Value.ERROR) {
                    b = 3;
                }
                id.circuit.setCell(cellId, b, id.cells, id.auxData);
            }
        }
    }

    private void readOutOutputs(int base, HdlModel.PortDescription[] set, int[][] pinO, BlifCircuitState id, InstanceState state) {
        for (int i = 0; i < set.length; ++i) {
            Value[] translated = new Value[set[i].getWidthInt()];
            for (int j = 0; j < translated.length; ++j) {
                int cellId = pinO[i][j];
                translated[j] = cellId == -1 ? Value.UNKNOWN : DenseLogicCircuit.LEV_TO_LS[id.cells[cellId]];
            }
            state.setPort(base + i, Value.create(translated), 1);
        }
    }

    public class BlifCircuitState
    implements InstanceData {
        public final DenseLogicCircuit circuit;
        public final byte[] cells;
        public final int[] auxData;

        public BlifCircuitState(DenseLogicCircuit circuit) {
            this(circuit, circuit.newCells(), circuit.newAuxData());
        }

        public BlifCircuitState(DenseLogicCircuit circuit, byte[] cells, int[] auxData) {
            this.circuit = circuit;
            this.cells = cells;
            this.auxData = auxData;
        }

        @Override
        public BlifCircuitState clone() {
            return new BlifCircuitState(this.circuit, (byte[])this.cells.clone(), (int[])this.auxData.clone());
        }
    }
}

