/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.arith.Comparator;
import com.cburch.logisim.std.arith.ComparatorHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;

public class MultiplierHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String NR_OF_BITS_STRING = "nrOfBits";
    private static final int NR_OF_BITS_ID = -1;
    private static final String CALC_BITS_STRING = "calcBits";
    private static final int CALC_BITS_ID = -2;
    private static final String UNSIGNED_STRING = "unsignedMultiplier";
    private static final int UNSIGNED_ID = -3;

    public MultiplierHdlGeneratorFactory() {
        this.myParametersList.add(NR_OF_BITS_STRING, -1).add(CALC_BITS_STRING, -2, 3, 2).add(UNSIGNED_STRING, -3, 4, Comparator.MODE_ATTR, ComparatorHdlGeneratorFactory.SIGNED_MAP);
        this.myWires.addWire("s_multResult", -2).addWire("s_extendedcarryIn", -2).addWire("s_newResult", -2);
        this.myPorts.add("input", "inputA", -1, 0).add("input", "inputB", -1, 1).add("input", "carryIn", -1, 3).add("output", "multLow", -1, 2).add("output", "multHigh", -1, 4);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair(NR_OF_BITS_STRING, NR_OF_BITS_STRING).pair("unsigned", UNSIGNED_STRING).pair(CALC_BITS_STRING, CALC_BITS_STRING);
        if (Hdl.isVhdl()) {
            contents.empty().addVhdlKeywords().add("s_multResult <= std_logic_vector(unsigned(inputA)*unsigned(inputB))\n                    {{when}} {{unsigned}}= 1 {{else}}\n                 std_logic_vector(signed(inputA)*signed(inputB));\ns_extendedcarryIn({{calcBits}}-1 {{downto}} {{nrOfBits}}) <= ({{others}} => '0') {{when}} {{unsigned}} = 1 {{else}} ({{others}} => carryIn({{nrOfBits}}-1));\ns_extendedcarryIn({{nrOfBits}}-1 {{downto}} 0) <= carryIn;\ns_newResult  <= std_logic_vector(unsigned(s_multResult) + unsigned(s_extendedcarryIn))\n                    {{when}} {{unsigned}}= 1 {{else}}\n                 std_logic_vector(signed(s_multResult) + signed(s_extendedcarryIn));\nmultHigh     <= s_newResult({{calcBits}}-1 {{downto}} {{nrOfBits}});\nmultLow      <= s_newResult({{nrOfBits}}-1 {{downto}} 0);\n");
        } else {
            contents.add("reg[{{calcBits}}-1:0] s_carryIn;\nreg[{{calcBits}}-1:0] s_multUnsigned;\nreg[{{calcBits}}-1:0] s_intermediateResult;\nreg signed[{{calcBits}}-1:0] s_multSigned;\n\nalways @(*)\nbegin\n   s_carryIn[{{nrOfBits}}-1:0] = carryIn;\n   if ({{unsigned}}== 1)\n      begin\n         s_carryIn[{{calcBits}}-1:{{nrOfBits}}] = 0;\n         s_multUnsigned = $unsigned(inputA) * $unsigned(inputB);\n         s_intermediateResult = $unsigned(s_multUnsigned) + $unsigned(s_carryIn);\n       end\n    else\n      begin\n         if (carryIn[{{nrOfBits}}-1] == 1)\n            s_carryIn[{{calcBits}}-1:{{nrOfBits}}] = -1;\n         else\n            s_carryIn[{{calcBits}}-1:{{nrOfBits}}] = 0;\n         s_multSigned = $signed(inputA) * $signed(inputB);\n         s_intermediateResult = $signed(s_multSigned) + $signed(s_carryIn);\n       end\nend\n\nassign multHigh = s_intermediateResult[{{calcBits}}-1:{{nrOfBits}}];\nassign multLow  = s_intermediateResult[{{nrOfBits}}-1:0];\n");
        }
        return contents.empty();
    }
}

