/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.logisim.analyze.gui.AnalyzerManager;
import com.cburch.logisim.file.LibraryEvent;
import com.cburch.logisim.file.LibraryListener;
import com.cburch.logisim.gui.prefs.PreferencesFrame;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.proj.Projects;
import com.cburch.logisim.util.WindowMenuItemManager;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JFrame;

public class WindowManagers {
    private static final MyListener myListener = new MyListener();
    private static final HashMap<Project, ProjectManager> projectMap = new LinkedHashMap<Project, ProjectManager>();
    private static boolean initialized = false;

    private WindowManagers() {
    }

    private static void computeListeners() {
        List<Project> nowOpen = Projects.getOpenProjects();
        HashSet<Project> closed = new HashSet<Project>(projectMap.keySet());
        nowOpen.forEach(closed::remove);
        for (Project proj : closed) {
            ProjectManager manager = projectMap.get(proj);
            manager.frameClosed(manager.getJFrame(false, null));
            projectMap.remove(proj);
        }
        LinkedHashSet<Project> opened = new LinkedHashSet<Project>(nowOpen);
        opened.removeAll(projectMap.keySet());
        for (Project proj : opened) {
            ProjectManager manager = new ProjectManager(proj);
            projectMap.put(proj, manager);
        }
    }

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            AnalyzerManager.initialize();
            PreferencesFrame.initializeManager();
            Projects.addPropertyChangeListener("projectList", myListener);
            WindowManagers.computeListeners();
        }
    }

    private static class ProjectManager
    extends WindowMenuItemManager
    implements ProjectListener,
    LibraryListener {
        private final Project proj;

        ProjectManager(Project proj) {
            super(proj.getLogisimFile().getName(), false);
            this.proj = proj;
            proj.addProjectListener(this);
            proj.addLibraryListener(this);
            this.frameOpened(proj.getFrame());
        }

        @Override
        public JFrame getJFrame(boolean create, Component parent) {
            return this.proj.getFrame();
        }

        @Override
        public void libraryChanged(LibraryEvent event) {
            if (event.getAction() == 6) {
                this.setText((String)event.getData());
            }
        }

        @Override
        public void projectChanged(ProjectEvent event) {
            if (event.getAction() == 0) {
                this.setText(this.proj.getLogisimFile().getName());
            }
        }
    }

    private static class MyListener
    implements PropertyChangeListener {
        private MyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            WindowManagers.computeListeners();
        }
    }
}

