/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.download;

import com.cburch.contracts.BaseWindowListenerContract;
import com.cburch.logisim.Main;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.data.BoardInformation;
import com.cburch.logisim.fpga.data.ComponentMapParser;
import com.cburch.logisim.fpga.download.AlteraDownload;
import com.cburch.logisim.fpga.download.DownloadBase;
import com.cburch.logisim.fpga.download.OpenFpgaDownload;
import com.cburch.logisim.fpga.download.VendorDownload;
import com.cburch.logisim.fpga.download.VivadoDownload;
import com.cburch.logisim.fpga.download.XilinxDownload;
import com.cburch.logisim.fpga.gui.ComponentMapDialog;
import com.cburch.logisim.fpga.gui.Reporter;
import com.cburch.logisim.fpga.settings.VendorSoftware;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JProgressBar;

public class Download
extends DownloadBase
implements Runnable,
BaseWindowListenerContract {
    private boolean stopRequested = false;
    private boolean downloadOnly;
    private boolean generateHdlOnly;
    private char vendor;
    private boolean useGui;
    private JProgressBar progressBar;
    private VendorDownload downloader;
    private String topLevelSheet;
    private double tickFrequency;
    private static final int basicSteps = 5;
    private String mapFileName;
    final ArrayList<String> entities = new ArrayList();
    final ArrayList<String> architectures = new ArrayList();
    private Process executable;
    private final Object lock = new Object();
    private JFrame parent;
    private final ArrayList<ActionListener> listeners = new ArrayList();

    public Download(Project myProject, String topLevelSheet, double tickFrequency, BoardInformation myBoardInformation, String mapFileName, boolean writeToFlash, boolean downloadOnly, boolean generateHdlOnly, double preMultiplier, double preDivider, JProgressBar progressBar, JFrame myParent) {
        this.progressBar = progressBar;
        this.parent = myParent;
        this.setUpDownload(myProject, topLevelSheet, tickFrequency, myBoardInformation, mapFileName, writeToFlash, downloadOnly, generateHdlOnly, preMultiplier, preDivider);
    }

    public Download(Project myProject, String topLevelSheet, double tickFrequency, BoardInformation myBoardInformation, String mapFileName, boolean writeToFlash, boolean downloadOnly, boolean generateHdlOnly, double preMultiplier, double preDivider) {
        this.setUpDownload(myProject, topLevelSheet, tickFrequency, myBoardInformation, mapFileName, writeToFlash, downloadOnly, generateHdlOnly, preMultiplier, preDivider);
    }

    private void setUpDownload(Project myProject, String topLevelSheet, double tickFrequency, BoardInformation myBoardInformation, String mapFileName, boolean writeToFlash, boolean downloadOnly, boolean generateHdlOnly, double preMultiplier, double preDivider) {
        this.myProject = myProject;
        this.myBoardInformation = myBoardInformation;
        this.downloadOnly = downloadOnly;
        this.generateHdlOnly = generateHdlOnly;
        this.preDivider = preDivider;
        this.preMultiplier = preMultiplier;
        if (myBoardInformation == null) {
            this.generateHdlOnly = true;
            this.vendor = (char)32;
        } else {
            this.vendor = myBoardInformation.fpga.getVendor();
        }
        this.useGui = !Main.headless;
        this.topLevelSheet = topLevelSheet;
        this.tickFrequency = tickFrequency;
        this.mapFileName = mapFileName;
        Circuit rootSheet = myProject.getLogisimFile().getCircuit(topLevelSheet);
        if (rootSheet == null) {
            return;
        }
        int steps = 5;
        if (!this.generateHdlOnly && this.useGui) {
            rootSheet.setDownloadBoard(myBoardInformation.getBoardName());
        }
        switch (this.vendor) {
            case '\u0000': {
                this.downloader = new AlteraDownload(this.getProjDir(topLevelSheet), rootSheet.getNetList(), myBoardInformation, this.entities, this.architectures, AppPreferences.HdlType.get(), writeToFlash);
                break;
            }
            case '\u0001': {
                this.downloader = new XilinxDownload(this.getProjDir(topLevelSheet), rootSheet.getNetList(), myBoardInformation, this.entities, this.architectures, AppPreferences.HdlType.get(), writeToFlash);
                break;
            }
            case '\u0002': {
                this.downloader = new VivadoDownload(this.getProjDir(topLevelSheet), rootSheet.getNetList(), myBoardInformation, this.entities, this.architectures);
                break;
            }
            case '\u0003': {
                this.downloader = new OpenFpgaDownload(this.getProjDir(topLevelSheet), rootSheet.getNetList(), myBoardInformation, this.entities, this.architectures, AppPreferences.HdlType.get(), writeToFlash);
                break;
            }
            default: {
                Reporter.report.addFatalError("BUG: Tried to Download to an unknown target");
                return;
            }
        }
        if (this.progressBar == null) {
            this.useGui = false;
        }
        if (this.useGui) {
            if (this.downloader != null) {
                steps += this.downloader.getNumberOfStages();
            }
            this.progressBar.setMaximum(steps);
            this.progressBar.setString(Strings.S.get("FpgaDownloadInfo"));
        }
    }

    public void doDownload() {
        new Thread(this).start();
    }

    public void stop() {
        this.stopRequested = true;
        this.progressBar.setString(Strings.S.get("FpgaGuiCanceling"));
    }

    public boolean createDownloadScripts() {
        if (this.downloader != null) {
            return this.downloader.createDownloadScripts();
        }
        return false;
    }

    public void addListener(ActionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    private void fireEvent(ActionEvent e) {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(e);
        }
    }

    @Override
    public void run() {
        if (this.prepareDownload() && this.isVendorSoftwarePresent() && !this.generateHdlOnly) {
            try {
                String error = this.download();
                if (error != null) {
                    Reporter.report.addFatalError(error);
                }
            }
            catch (IOException e) {
                Reporter.report.addFatalError(Strings.S.get("FPGAIOError", VendorSoftware.getVendorString(this.vendor)));
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                Reporter.report.addError(Strings.S.get("FPGAInterruptedError", VendorSoftware.getVendorString(this.vendor)));
            }
        }
        this.fireEvent(new ActionEvent(this, 1, "DownloadDone"));
    }

    public boolean runTty() {
        Circuit root = this.myProject.getLogisimFile().getCircuit(this.topLevelSheet);
        if (root == null) {
            Reporter.report.addFatalError("Toplevel sheet \"" + this.topLevelSheet + "\" not found in project!");
            return false;
        }
        root.annotate(this.myProject, false, false);
        if (!this.prepareDownload()) {
            return false;
        }
        if (this.generateHdlOnly) {
            return true;
        }
        if (!this.isVendorSoftwarePresent()) {
            return false;
        }
        try {
            String error = this.download();
            if (error != null) {
                Reporter.report.addFatalError(error);
                return false;
            }
        }
        catch (IOException e) {
            Reporter.report.addFatalError(Strings.S.get("FPGAIOError", VendorSoftware.getVendorString(this.vendor)));
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            Reporter.report.addError(Strings.S.get("FPGAInterruptedError", VendorSoftware.getVendorString(this.vendor)));
            return false;
        }
        return true;
    }

    private String download() throws IOException, InterruptedException {
        Reporter.report.clearConsole();
        if (!this.downloadOnly || !this.downloader.readyForDownload()) {
            for (int stages = 0; stages < this.downloader.getNumberOfStages(); ++stages) {
                String result;
                if (this.stopRequested) {
                    return Strings.S.get("FPGAInterrupted");
                }
                ProcessBuilder currentStage = this.downloader.performStep(stages);
                if (currentStage != null && (result = this.execute(this.downloader.getStageMessage(stages), currentStage)) != null) {
                    return result;
                }
                if (!this.useGui) continue;
                this.progressBar.setValue(stages + 5);
            }
        }
        if (this.useGui) {
            this.progressBar.setValue(this.downloader.getNumberOfStages() + 5 - 1);
        }
        if (this.generateHdlOnly) {
            return null;
        }
        if (this.stopRequested) {
            return Strings.S.get("FPGAInterrupted");
        }
        Object[] options = new Object[]{Strings.S.get("FPGADownloadOk"), Strings.S.get("FPGADownloadCancel")};
        if (this.useGui && OptionPane.showOptionDialog(null, Strings.S.get("FPGAVerifyMsg1"), Strings.S.get("FPGAVerifyMsg2"), 0, 2, null, options, options[0]) != 0) {
            return Strings.S.get("FPGADownloadAborted");
        }
        if (!this.downloader.isBoardConnected()) {
            return Strings.S.get("FPGABoardNotConnected");
        }
        ProcessBuilder DownloadBitfile = this.downloader.downloadToBoard();
        if (DownloadBitfile != null) {
            return this.execute(Strings.S.get("FPGADownloadBitfile"), DownloadBitfile);
        }
        return null;
    }

    public static String execute(ProcessBuilder process, List<String> report) throws IOException, InterruptedException {
        Process executable = process.start();
        InputStream is = executable.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        String line = "";
        while ((line = br.readLine()) != null) {
            Reporter.report.print(line);
            if (report == null) continue;
            report.add(line);
        }
        executable.waitFor();
        isr.close();
        br.close();
        if (executable.exitValue() != 0) {
            return Strings.S.get("FPGAStaticExecutionFailure");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execute(String StageName, ProcessBuilder process) throws IOException, InterruptedException {
        if (this.useGui) {
            this.progressBar.setString(StageName);
        }
        Reporter.report.print(" ");
        Reporter.report.print("==>");
        Reporter.report.print("==> " + StageName);
        Reporter.report.print("==>");
        Object object = this.lock;
        synchronized (object) {
            this.executable = process.start();
        }
        InputStream is = this.executable.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        String line = "";
        while ((line = br.readLine()) != null) {
            Reporter.report.print(line);
        }
        this.executable.waitFor();
        isr.close();
        br.close();
        if (this.executable.exitValue() != 0) {
            return Strings.S.get("FPGAExecutionFailure", StageName);
        }
        return null;
    }

    private boolean prepareDownload() {
        if (this.downloadOnly && this.downloader.readyForDownload()) {
            return true;
        }
        if (this.useGui) {
            this.progressBar.setString(Strings.S.get("FPGAState0"));
        }
        if (!this.performDrc(this.topLevelSheet, AppPreferences.HdlType.get())) {
            return false;
        }
        String name = this.myProject.getLogisimFile().getName();
        if (name.contains(" ")) {
            Reporter.report.addFatalError(Strings.S.get("FPGANameContainsSpaces", name));
            return false;
        }
        if (this.useGui) {
            this.progressBar.setValue(1);
            this.progressBar.setString(Strings.S.get("FPGAState2"));
        }
        if (!this.mapDesign(this.topLevelSheet)) {
            return false;
        }
        if (this.useGui) {
            this.progressBar.setValue(2);
            this.progressBar.setString(Strings.S.get("FPGAState3"));
            ComponentMapDialog mapPanel = this.myProject.getLogisimFile().getLoader().getMainFile() != null ? new ComponentMapDialog(this.parent, this.myProject.getLogisimFile().getLoader().getMainFile().getAbsolutePath(), this.myBoardInformation, this.myMappableResources) : new ComponentMapDialog(this.parent, "", this.myBoardInformation, this.myMappableResources);
            if (!mapPanel.run()) {
                Reporter.report.addError(Strings.S.get("FPGADownloadAborted"));
                return false;
            }
        } else if (this.mapFileName != null) {
            File mapFile = new File(this.mapFileName);
            if (!mapFile.exists()) {
                return false;
            }
            ComponentMapParser cmp = new ComponentMapParser(mapFile, this.myMappableResources, this.myBoardInformation);
            cmp.parseFile();
        }
        if (!this.mapDesignCheckIOs()) {
            Reporter.report.addError(Strings.S.get("FPGAMapNotComplete", this.myBoardInformation.getBoardName()));
            return false;
        }
        if (this.useGui) {
            this.progressBar.setValue(3);
            this.progressBar.setString(Strings.S.get("FPGAState1"));
        }
        if (this.tickFrequency <= 0.0) {
            this.tickFrequency = 1.0;
        }
        if (this.tickFrequency > (double)(this.getSynthesizedFrequency() / 4L)) {
            this.tickFrequency = this.getSynthesizedFrequency() / 4L;
        }
        if (!this.writeHDL(this.topLevelSheet, this.tickFrequency)) {
            return false;
        }
        String projectPath = this.getProjDir(this.topLevelSheet);
        String sourcePath = projectPath + AppPreferences.HdlType.get().toLowerCase() + File.separator;
        this.getVhdlFiles(projectPath, sourcePath, this.entities, this.architectures, AppPreferences.HdlType.get());
        if (this.useGui) {
            this.progressBar.setValue(4);
            this.progressBar.setString(Strings.S.get("FPGAState4"));
        }
        this.downloader.setMapableResources(this.myMappableResources);
        return this.createDownloadScripts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosing(WindowEvent e) {
        this.progressBar.setString(Strings.S.get("FPGACancelWait"));
        this.stopRequested = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.executable != null) {
                this.executable.destroy();
            }
        }
    }

    public static String getClockFrequencyString(BoardInformation currentBoard) {
        long clkfreq = currentBoard.fpga.getClockFrequency();
        if (clkfreq % 1000000L == 0L) {
            return (clkfreq /= 1000000L) + " MHz ";
        }
        if (clkfreq % 1000L == 0L) {
            return (clkfreq /= 1000L) + " kHz ";
        }
        return Long.toString(clkfreq);
    }

    public static String chooseBoard(List<String> devices) {
        if (Main.hasGui()) {
            Object[] choices = new String[devices.size()];
            for (int i = 0; i < devices.size(); ++i) {
                choices[i] = devices.get(i);
            }
            return (String)OptionPane.showInputDialog(null, Strings.S.get("FPGAMultipleBoards", devices.size()), Strings.S.get("FPGABoardSelection"), 3, null, choices, choices[0]);
        }
        return null;
    }
}

