// This file is @generated by prost-build.
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ServiceIdentifier {
    /// *
    /// The type of identity represented by this service identifier.
    #[prost(enumeration = "IdentityType", tag = "1")]
    pub identity_type: i32,
    /// *
    /// The UUID of the identity represented by this service identifier.
    #[prost(bytes = "vec", tag = "2")]
    pub uuid: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AccountIdentifiers {
    /// *
    /// A list of service identifiers for the identified account.
    #[prost(message, repeated, tag = "1")]
    pub service_identifiers: ::prost::alloc::vec::Vec<ServiceIdentifier>,
    /// *
    /// The phone number associated with the identified account.
    #[prost(string, tag = "2")]
    pub e164: ::prost::alloc::string::String,
    /// *
    /// The username hash (if any) associated with the identified account. May be
    /// empty if no username is associated with the identified account.
    #[prost(bytes = "vec", tag = "3")]
    pub username_hash: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct EcPreKey {
    /// *
    /// A locally-unique identifier for this key.
    #[prost(uint64, tag = "1")]
    pub key_id: u64,
    /// *
    /// The serialized form of the public key.
    #[prost(bytes = "vec", tag = "2")]
    pub public_key: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct EcSignedPreKey {
    /// *
    /// A locally-unique identifier for this key.
    #[prost(uint64, tag = "1")]
    pub key_id: u64,
    /// *
    /// The serialized form of the public key.
    #[prost(bytes = "vec", tag = "2")]
    pub public_key: ::prost::alloc::vec::Vec<u8>,
    /// *
    /// A signature of the public key, verifiable with the identity key for the
    /// account/identity associated with this pre-key.
    #[prost(bytes = "vec", tag = "3")]
    pub signature: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct KemSignedPreKey {
    /// *
    /// A locally-unique identifier for this key.
    #[prost(uint64, tag = "1")]
    pub key_id: u64,
    /// *
    /// The serialized form of the public key.
    #[prost(bytes = "vec", tag = "2")]
    pub public_key: ::prost::alloc::vec::Vec<u8>,
    /// *
    /// A signature of the public key, verifiable with the identity key for the
    /// account/identity associated with this pre-key.
    #[prost(bytes = "vec", tag = "3")]
    pub signature: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ZkCredential {
    ///
    /// Day on which this credential can be redeemed, in UTC seconds since epoch
    #[prost(int64, tag = "1")]
    pub redemption_time: i64,
    ///
    /// The ZK credential, using libsignal's serialization
    #[prost(bytes = "vec", tag = "2")]
    pub credential: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum IdentityType {
    Unspecified = 0,
    Aci = 1,
    Pni = 2,
}
impl IdentityType {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unspecified => "IDENTITY_TYPE_UNSPECIFIED",
            Self::Aci => "IDENTITY_TYPE_ACI",
            Self::Pni => "IDENTITY_TYPE_PNI",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "IDENTITY_TYPE_UNSPECIFIED" => Some(Self::Unspecified),
            "IDENTITY_TYPE_ACI" => Some(Self::Aci),
            "IDENTITY_TYPE_PNI" => Some(Self::Pni),
            _ => None,
        }
    }
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum DeviceCapability {
    Unspecified = 0,
    Storage = 1,
    Transfer = 2,
    AttachmentBackfill = 6,
    SparsePostQuantumRatchet = 7,
}
impl DeviceCapability {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unspecified => "DEVICE_CAPABILITY_UNSPECIFIED",
            Self::Storage => "DEVICE_CAPABILITY_STORAGE",
            Self::Transfer => "DEVICE_CAPABILITY_TRANSFER",
            Self::AttachmentBackfill => "DEVICE_CAPABILITY_ATTACHMENT_BACKFILL",
            Self::SparsePostQuantumRatchet => {
                "DEVICE_CAPABILITY_SPARSE_POST_QUANTUM_RATCHET"
            }
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "DEVICE_CAPABILITY_UNSPECIFIED" => Some(Self::Unspecified),
            "DEVICE_CAPABILITY_STORAGE" => Some(Self::Storage),
            "DEVICE_CAPABILITY_TRANSFER" => Some(Self::Transfer),
            "DEVICE_CAPABILITY_ATTACHMENT_BACKFILL" => Some(Self::AttachmentBackfill),
            "DEVICE_CAPABILITY_SPARSE_POST_QUANTUM_RATCHET" => {
                Some(Self::SparsePostQuantumRatchet)
            }
            _ => None,
        }
    }
}
