// This file is @generated by prost-build.
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GetAccountIdentityRequest {}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetAccountIdentityResponse {
    /// *
    /// A set of account identifiers for the authenticated account.
    #[prost(message, optional, tag = "1")]
    pub account_identifiers: ::core::option::Option<super::common::AccountIdentifiers>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteAccountRequest {}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteAccountResponse {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct SetRegistrationLockRequest {
    /// *
    /// The new registration lock secret for the authenticated account.
    #[prost(bytes = "vec", tag = "1")]
    pub registration_lock: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct SetRegistrationLockResponse {}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ClearRegistrationLockRequest {}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ClearRegistrationLockResponse {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReserveUsernameHashRequest {
    /// *
    /// A prioritized list of username hashes to attempt to reserve.
    #[prost(bytes = "vec", repeated, tag = "1")]
    pub username_hashes: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct UsernameNotAvailable {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ReserveUsernameHashResponse {
    #[prost(oneof = "reserve_username_hash_response::Response", tags = "1, 2")]
    pub response: ::core::option::Option<reserve_username_hash_response::Response>,
}
/// Nested message and enum types in `ReserveUsernameHashResponse`.
pub mod reserve_username_hash_response {
    #[derive(Clone, PartialEq, Eq, Hash, ::prost::Oneof)]
    pub enum Response {
        /// *
        /// The first username hash that was available (and actually reserved).
        #[prost(bytes, tag = "1")]
        UsernameHash(::prost::alloc::vec::Vec<u8>),
        /// *
        /// Indicates that, of all of the candidate hashes provided, none were
        /// available. Callers may generate a new set of hashes and and retry.
        #[prost(message, tag = "2")]
        UsernameNotAvailable(super::UsernameNotAvailable),
    }
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ConfirmUsernameHashRequest {
    /// *
    /// The username hash to claim for the authenticated account.
    #[prost(bytes = "vec", tag = "1")]
    pub username_hash: ::prost::alloc::vec::Vec<u8>,
    /// *
    /// A zero-knowledge proof that the given username hash was generated by the
    /// Signal username algorithm.
    #[prost(bytes = "vec", tag = "2")]
    pub zk_proof: ::prost::alloc::vec::Vec<u8>,
    /// *
    /// The ciphertext of the chosen username for use in public-facing contexts
    /// (e.g. links and QR codes).
    #[prost(bytes = "vec", tag = "3")]
    pub username_ciphertext: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ConfirmUsernameHashResponse {
    #[prost(oneof = "confirm_username_hash_response::Response", tags = "1, 2, 3")]
    pub response: ::core::option::Option<confirm_username_hash_response::Response>,
}
/// Nested message and enum types in `ConfirmUsernameHashResponse`.
pub mod confirm_username_hash_response {
    #[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
    pub struct ConfirmedUsernameHash {
        /// *
        /// The newly-confirmed username hash.
        #[prost(bytes = "vec", tag = "1")]
        pub username_hash: ::prost::alloc::vec::Vec<u8>,
        /// *
        /// The server-generated username link handle for the newly-confirmed username.
        #[prost(bytes = "vec", tag = "2")]
        pub username_link_handle: ::prost::alloc::vec::Vec<u8>,
    }
    #[derive(Clone, PartialEq, Eq, Hash, ::prost::Oneof)]
    pub enum Response {
        /// *
        /// The details of the successfully confirmed username.
        #[prost(message, tag = "1")]
        ConfirmedUsernameHash(ConfirmedUsernameHash),
        /// *
        /// The provided hash was not reserved for the account.
        #[prost(message, tag = "2")]
        ReservationNotFound(super::super::errors::FailedPrecondition),
        /// *
        /// The reservation has lapsed and the requested username has been claimed by
        /// another caller.
        #[prost(message, tag = "3")]
        UsernameNotAvailable(super::UsernameNotAvailable),
    }
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteUsernameHashRequest {}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteUsernameHashResponse {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct SetUsernameLinkRequest {
    /// *
    /// The username ciphertext for which to generate a new link handle.
    #[prost(bytes = "vec", tag = "1")]
    pub username_ciphertext: ::prost::alloc::vec::Vec<u8>,
    /// *
    /// If true and the account already had an encrypted username stored, the
    /// existing link handle will be reused. Otherwise a new link handle will be
    /// created.
    #[prost(bool, tag = "2")]
    pub keep_link_handle: bool,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct SetUsernameLinkResponse {
    #[prost(oneof = "set_username_link_response::Response", tags = "1, 2")]
    pub response: ::core::option::Option<set_username_link_response::Response>,
}
/// Nested message and enum types in `SetUsernameLinkResponse`.
pub mod set_username_link_response {
    #[derive(Clone, PartialEq, Eq, Hash, ::prost::Oneof)]
    pub enum Response {
        /// *
        /// A new link handle for the given username ciphertext.
        #[prost(bytes, tag = "1")]
        UsernameLinkHandle(::prost::alloc::vec::Vec<u8>),
        /// *
        /// The authenticated account did not have a username set.
        #[prost(message, tag = "2")]
        NoUsernameSet(super::super::errors::FailedPrecondition),
    }
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteUsernameLinkRequest {}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct DeleteUsernameLinkResponse {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ConfigureUnidentifiedAccessRequest {
    /// *
    /// The key that other users must provide to interact with this account
    /// anonymously (i.e. to retrieve keys or profiles or to send messages) unless
    /// unrestricted unidentified access is permitted. Must be present if
    /// unrestricted unidentified access is not allowed.
    #[prost(bytes = "vec", tag = "1")]
    pub unidentified_access_key: ::prost::alloc::vec::Vec<u8>,
    /// *
    /// If `true`, any user may interact with this account anonymously without
    /// providing an unidentified access key. Otherwise, users must provide the
    /// given unidentified access key to interact with this account anonymously.
    #[prost(bool, tag = "2")]
    pub allow_unrestricted_unidentified_access: bool,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ConfigureUnidentifiedAccessResponse {}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct SetDiscoverableByPhoneNumberRequest {
    /// *
    /// If true, the authenticated account may be discovered by phone number via
    /// the Contact Discovery Service (CDS). Otherwise, other users must discover
    /// this account by other means (i.e. by username).
    #[prost(bool, tag = "1")]
    pub discoverable_by_phone_number: bool,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct SetDiscoverableByPhoneNumberResponse {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct SetRegistrationRecoveryPasswordRequest {
    /// *
    /// The new registration recovery password for the authenticated account.
    #[prost(bytes = "vec", tag = "1")]
    pub registration_recovery_password: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct SetRegistrationRecoveryPasswordResponse {}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct CheckAccountExistenceRequest {
    /// *
    /// The service identifier of an account that may or may not exist.
    #[prost(message, optional, tag = "1")]
    pub service_identifier: ::core::option::Option<super::common::ServiceIdentifier>,
}
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct CheckAccountExistenceResponse {
    /// *
    /// True if an account exists with the given service identifier or false if no
    /// account was found.
    #[prost(bool, tag = "1")]
    pub account_exists: bool,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LookupUsernameHashRequest {
    /// *
    /// A 32-byte username hash for which to find an account.
    #[prost(bytes = "vec", tag = "1")]
    pub username_hash: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LookupUsernameHashResponse {
    #[prost(oneof = "lookup_username_hash_response::Response", tags = "1, 2")]
    pub response: ::core::option::Option<lookup_username_hash_response::Response>,
}
/// Nested message and enum types in `LookupUsernameHashResponse`.
pub mod lookup_username_hash_response {
    #[derive(Clone, PartialEq, Eq, Hash, ::prost::Oneof)]
    pub enum Response {
        /// *
        /// The service identifier associated with the provided username hash.
        #[prost(message, tag = "1")]
        ServiceIdentifier(super::super::common::ServiceIdentifier),
        /// *
        /// No account was found for the provided username hash.
        #[prost(message, tag = "2")]
        NotFound(super::super::errors::NotFound),
    }
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LookupUsernameLinkRequest {
    /// *
    /// The link handle for which to find an encrypted username. Link handles are
    /// 16-byte representations of UUIDs.
    #[prost(bytes = "vec", tag = "1")]
    pub username_link_handle: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct LookupUsernameLinkResponse {
    #[prost(oneof = "lookup_username_link_response::Response", tags = "1, 2")]
    pub response: ::core::option::Option<lookup_username_link_response::Response>,
}
/// Nested message and enum types in `LookupUsernameLinkResponse`.
pub mod lookup_username_link_response {
    #[derive(Clone, PartialEq, Eq, Hash, ::prost::Oneof)]
    pub enum Response {
        /// *
        /// The ciphertext of the username identified by the provided link handle.
        #[prost(bytes, tag = "1")]
        UsernameCiphertext(::prost::alloc::vec::Vec<u8>),
        /// *
        /// No username was found for the provided link handle.
        #[prost(message, tag = "2")]
        NotFound(super::super::errors::NotFound),
    }
}
/// Generated client implementations.
pub mod accounts_client {
    #![allow(
        unused_variables,
        dead_code,
        missing_docs,
        clippy::wildcard_imports,
        clippy::let_unit_value,
    )]
    use tonic::codegen::*;
    use tonic::codegen::http::Uri;
    /// *
    /// Provides methods for working with Signal accounts.
    #[derive(Debug, Clone)]
    pub struct AccountsClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl<T> AccountsClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::Body>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + std::marker::Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + std::marker::Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> AccountsClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                http::Request<tonic::body::Body>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::Body>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::Body>,
            >>::Error: Into<StdError> + std::marker::Send + std::marker::Sync,
        {
            AccountsClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        /// *
        /// Returns basic identifiers for the authenticated account.
        pub async fn get_account_identity(
            &mut self,
            request: impl tonic::IntoRequest<super::GetAccountIdentityRequest>,
        ) -> std::result::Result<
            tonic::Response<super::GetAccountIdentityResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/org.signal.chat.account.Accounts/GetAccountIdentity",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "org.signal.chat.account.Accounts",
                        "GetAccountIdentity",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// *
        /// Deletes the authenticated account, purging all associated data in the
        /// process.
        pub async fn delete_account(
            &mut self,
            request: impl tonic::IntoRequest<super::DeleteAccountRequest>,
        ) -> std::result::Result<
            tonic::Response<super::DeleteAccountResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/org.signal.chat.account.Accounts/DeleteAccount",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("org.signal.chat.account.Accounts", "DeleteAccount"),
                );
            self.inner.unary(req, path, codec).await
        }
        /// *
        /// Sets the registration lock secret for the authenticated account. To remove
        /// a registration lock, please use `ClearRegistrationLock`.
        pub async fn set_registration_lock(
            &mut self,
            request: impl tonic::IntoRequest<super::SetRegistrationLockRequest>,
        ) -> std::result::Result<
            tonic::Response<super::SetRegistrationLockResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/org.signal.chat.account.Accounts/SetRegistrationLock",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "org.signal.chat.account.Accounts",
                        "SetRegistrationLock",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// *
        /// Removes any registration lock credentials from the authenticated account.
        pub async fn clear_registration_lock(
            &mut self,
            request: impl tonic::IntoRequest<super::ClearRegistrationLockRequest>,
        ) -> std::result::Result<
            tonic::Response<super::ClearRegistrationLockResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/org.signal.chat.account.Accounts/ClearRegistrationLock",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "org.signal.chat.account.Accounts",
                        "ClearRegistrationLock",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// *
        /// Attempts to reserve one of multiple given username hashes. Reserved
        /// usernames may be claimed later via `ConfirmUsernameHash`.
        pub async fn reserve_username_hash(
            &mut self,
            request: impl tonic::IntoRequest<super::ReserveUsernameHashRequest>,
        ) -> std::result::Result<
            tonic::Response<super::ReserveUsernameHashResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/org.signal.chat.account.Accounts/ReserveUsernameHash",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "org.signal.chat.account.Accounts",
                        "ReserveUsernameHash",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// *
        /// Sets the username hash/encrypted username to a previously-reserved value
        /// (see `ReserveUsernameHash`).
        pub async fn confirm_username_hash(
            &mut self,
            request: impl tonic::IntoRequest<super::ConfirmUsernameHashRequest>,
        ) -> std::result::Result<
            tonic::Response<super::ConfirmUsernameHashResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/org.signal.chat.account.Accounts/ConfirmUsernameHash",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "org.signal.chat.account.Accounts",
                        "ConfirmUsernameHash",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// *
        /// Clears the current username hash, ciphertext, and link for the
        /// authenticated user.
        pub async fn delete_username_hash(
            &mut self,
            request: impl tonic::IntoRequest<super::DeleteUsernameHashRequest>,
        ) -> std::result::Result<
            tonic::Response<super::DeleteUsernameHashResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/org.signal.chat.account.Accounts/DeleteUsernameHash",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "org.signal.chat.account.Accounts",
                        "DeleteUsernameHash",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// *
        /// Associates the given username ciphertext with the account, replacing any
        /// previously stored ciphertext. A new link handle will optionally be created,
        /// and the link handle to use will be returned in any event.
        pub async fn set_username_link(
            &mut self,
            request: impl tonic::IntoRequest<super::SetUsernameLinkRequest>,
        ) -> std::result::Result<
            tonic::Response<super::SetUsernameLinkResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/org.signal.chat.account.Accounts/SetUsernameLink",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "org.signal.chat.account.Accounts",
                        "SetUsernameLink",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// *
        /// Clears any username link associated with the authenticated account.
        pub async fn delete_username_link(
            &mut self,
            request: impl tonic::IntoRequest<super::DeleteUsernameLinkRequest>,
        ) -> std::result::Result<
            tonic::Response<super::DeleteUsernameLinkResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/org.signal.chat.account.Accounts/DeleteUsernameLink",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "org.signal.chat.account.Accounts",
                        "DeleteUsernameLink",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// *
        /// Configures "unidentified access" keys and preferences for the authenticated
        /// account. Other users permitted to interact with this account anonymously
        /// may take actions like fetching pre-keys and profiles for this account or
        /// sending sealed-sender messages without providing identifying credentials.
        pub async fn configure_unidentified_access(
            &mut self,
            request: impl tonic::IntoRequest<super::ConfigureUnidentifiedAccessRequest>,
        ) -> std::result::Result<
            tonic::Response<super::ConfigureUnidentifiedAccessResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/org.signal.chat.account.Accounts/ConfigureUnidentifiedAccess",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "org.signal.chat.account.Accounts",
                        "ConfigureUnidentifiedAccess",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// *
        /// Sets whether the authenticated account may be discovered by phone number
        /// via the Contact Discovery Service (CDS).
        pub async fn set_discoverable_by_phone_number(
            &mut self,
            request: impl tonic::IntoRequest<super::SetDiscoverableByPhoneNumberRequest>,
        ) -> std::result::Result<
            tonic::Response<super::SetDiscoverableByPhoneNumberResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/org.signal.chat.account.Accounts/SetDiscoverableByPhoneNumber",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "org.signal.chat.account.Accounts",
                        "SetDiscoverableByPhoneNumber",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// *
        /// Sets the registration recovery password for the authenticated account.
        pub async fn set_registration_recovery_password(
            &mut self,
            request: impl tonic::IntoRequest<
                super::SetRegistrationRecoveryPasswordRequest,
            >,
        ) -> std::result::Result<
            tonic::Response<super::SetRegistrationRecoveryPasswordResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/org.signal.chat.account.Accounts/SetRegistrationRecoveryPassword",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "org.signal.chat.account.Accounts",
                        "SetRegistrationRecoveryPassword",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
    }
}
/// Generated client implementations.
pub mod accounts_anonymous_client {
    #![allow(
        unused_variables,
        dead_code,
        missing_docs,
        clippy::wildcard_imports,
        clippy::let_unit_value,
    )]
    use tonic::codegen::*;
    use tonic::codegen::http::Uri;
    /// *
    /// Provides methods for looking up Signal accounts. Callers must not provide
    /// identifying credentials when calling methods in this service.
    #[derive(Debug, Clone)]
    pub struct AccountsAnonymousClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl<T> AccountsAnonymousClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::Body>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + std::marker::Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + std::marker::Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> AccountsAnonymousClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                http::Request<tonic::body::Body>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::Body>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::Body>,
            >>::Error: Into<StdError> + std::marker::Send + std::marker::Sync,
        {
            AccountsAnonymousClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        /// *
        /// Checks whether an account with the given service identifier exists.
        pub async fn check_account_existence(
            &mut self,
            request: impl tonic::IntoRequest<super::CheckAccountExistenceRequest>,
        ) -> std::result::Result<
            tonic::Response<super::CheckAccountExistenceResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/org.signal.chat.account.AccountsAnonymous/CheckAccountExistence",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "org.signal.chat.account.AccountsAnonymous",
                        "CheckAccountExistence",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// *
        /// Finds the service identifier of the account associated with the given
        /// username hash.
        pub async fn lookup_username_hash(
            &mut self,
            request: impl tonic::IntoRequest<super::LookupUsernameHashRequest>,
        ) -> std::result::Result<
            tonic::Response<super::LookupUsernameHashResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/org.signal.chat.account.AccountsAnonymous/LookupUsernameHash",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "org.signal.chat.account.AccountsAnonymous",
                        "LookupUsernameHash",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// *
        /// Finds the encrypted username identified by a given username link handle.
        /// This method will return a `NOT_FOUND` status if no username was found for
        /// the given link handle.
        pub async fn lookup_username_link(
            &mut self,
            request: impl tonic::IntoRequest<super::LookupUsernameLinkRequest>,
        ) -> std::result::Result<
            tonic::Response<super::LookupUsernameLinkResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic_prost::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/org.signal.chat.account.AccountsAnonymous/LookupUsernameLink",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "org.signal.chat.account.AccountsAnonymous",
                        "LookupUsernameLink",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
    }
}
