// This file is @generated by prost-build.
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ClientRequest {
    /// Each ACI/UAK pair is a 32-byte buffer, containing the 16-byte ACI followed
    /// by its 16-byte UAK.
    #[prost(bytes = "vec", tag = "1")]
    pub aci_uak_pairs: ::prost::alloc::vec::Vec<u8>,
    /// Each E164 is an 8-byte big-endian number, as 8 bytes.
    #[prost(bytes = "vec", tag = "2")]
    pub prev_e164s: ::prost::alloc::vec::Vec<u8>,
    #[prost(bytes = "vec", tag = "3")]
    pub new_e164s: ::prost::alloc::vec::Vec<u8>,
    #[prost(bytes = "vec", tag = "4")]
    pub discard_e164s: ::prost::alloc::vec::Vec<u8>,
    /// If set, a token which allows rate limiting to discount the e164s in
    /// the request's prev_e164s, only counting new_e164s.  If not set, then
    /// rate limiting considers both prev_e164s' and new_e164s' size.
    #[prost(bytes = "vec", tag = "6")]
    pub token: ::prost::alloc::vec::Vec<u8>,
    /// After receiving a new token from the server, send back a message just
    /// containing a token_ack.
    #[prost(bool, tag = "7")]
    pub token_ack: bool,
}
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ClientResponse {
    /// Each triple is an 8-byte e164, a 16-byte PNI, and a 16-byte ACI.
    /// If the e164 was not found, PNI and ACI are all zeros.  If the PNI
    /// was found but the ACI was not, the PNI will be non-zero and the ACI
    /// will be all zeros.  ACI will be returned if one of the returned
    /// PNIs has an ACI/UAK pair that matches.
    ///
    /// Should the request be successful (IE: a successful status returned),
    /// |e164_pni_aci_triple| will always equal |e164| of the request,
    /// so the entire marshalled size of the response will be (2+32)*|e164|,
    /// where the additional 2 bytes are the id/type/length additions of the
    /// protobuf marshaling added to each byte array.  This avoids any data
    /// leakage based on the size of the encrypted output.
    #[prost(bytes = "vec", tag = "1")]
    pub e164_pni_aci_triples: ::prost::alloc::vec::Vec<u8>,
    /// A token which allows subsequent calls' rate limiting to discount the
    /// e164s sent up in this request, only counting those in the next
    /// request's new_e164s.
    #[prost(bytes = "vec", tag = "3")]
    pub token: ::prost::alloc::vec::Vec<u8>,
    /// On a successful response to a token_ack request, the number of permits
    /// that were deducted from the user's rate-limit in order to process the
    /// request
    #[prost(int32, tag = "4")]
    pub debug_permits_used: i32,
}
