// This file is @generated by prost-build.
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ClientHandshakeStart {
    /// Remote-attestation evidence associated with the public key
    #[prost(bytes = "vec", tag = "2")]
    pub evidence: ::prost::alloc::vec::Vec<u8>,
    /// Endorsements of remote-attestation evidence.
    #[prost(bytes = "vec", tag = "3")]
    pub endorsement: ::prost::alloc::vec::Vec<u8>,
}
/// RaftGroupConfig is a configuration shared by members of a Raft group.
/// It's created only once, on creation of the Raft group.  From that
/// point forward, it's shared between replicas as they're added to the
/// group, and it's not possible to modify it externally.
///
/// An attested RaftGroupConfig will be returned as part of the evidence.
/// Clients must validate that the attested configuration matches their
/// expected configuration.
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct RaftGroupConfig {
    /// The unique group id for the raft group
    #[prost(fixed64, tag = "1")]
    pub group_id: u64,
    /// This raft group will refuse to serve client request with
    /// <min_voting_replicas, and will refuse to add new voting members
    /// when max_voting_replicas has been reached.
    #[prost(uint32, tag = "2")]
    pub min_voting_replicas: u32,
    #[prost(uint32, tag = "3")]
    pub max_voting_replicas: u32,
    /// Anything which, in normal Raft, would require quorum() participants
    /// to push forward will instead require quorum() + super_majority.  Should
    /// there be fewer than quorum() + super_majority total nodes in the Raft,
    /// all Raft nodes will be required.
    #[prost(uint32, tag = "4")]
    pub super_majority: u32,
    /// The database version.
    #[prost(enumeration = "DatabaseVersion", tag = "5")]
    pub db_version: i32,
    /// Attestation timeout, in seconds
    #[prost(uint32, tag = "6")]
    pub attestation_timeout: u32,
    /// Whether this is a real SGX or simulated SGX environment.
    #[prost(bool, tag = "7")]
    pub simulated: bool,
}
/// Does not belong in SVR2 module, but put here to reuse RaftGroupConfig message
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct AttestationData {
    #[prost(bytes = "vec", tag = "1")]
    pub public_key: ::prost::alloc::vec::Vec<u8>,
    #[prost(message, optional, tag = "2")]
    pub group_config: ::core::option::Option<RaftGroupConfig>,
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum DatabaseVersion {
    Unknown = 0,
    Svr2 = 2,
    Svr3 = 3,
    Svr4 = 4,
}
impl DatabaseVersion {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unknown => "DATABASE_VERSION_UNKNOWN",
            Self::Svr2 => "DATABASE_VERSION_SVR2",
            Self::Svr3 => "DATABASE_VERSION_SVR3",
            Self::Svr4 => "DATABASE_VERSION_SVR4",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "DATABASE_VERSION_UNKNOWN" => Some(Self::Unknown),
            "DATABASE_VERSION_SVR2" => Some(Self::Svr2),
            "DATABASE_VERSION_SVR3" => Some(Self::Svr3),
            "DATABASE_VERSION_SVR4" => Some(Self::Svr4),
            _ => None,
        }
    }
}
