// This file is @generated by prost-build.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PrefixProof {
    #[prost(bytes = "vec", repeated, tag = "1")]
    pub proof: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
    #[prost(uint32, tag = "2")]
    pub counter: u32,
}
/// AuditorTreeHead contains an auditor's signature on its most recent view of the log.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AuditorTreeHead {
    #[prost(uint64, tag = "1")]
    pub tree_size: u64,
    #[prost(int64, tag = "2")]
    pub timestamp: i64,
    #[prost(bytes = "vec", tag = "3")]
    pub signature: ::prost::alloc::vec::Vec<u8>,
}
/// TreeHead contains the key transparency service operator's signature on the most recent version of the
/// log.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TreeHead {
    #[prost(uint64, tag = "1")]
    pub tree_size: u64,
    #[prost(int64, tag = "2")]
    pub timestamp: i64,
    /// The key transparency service operator provides one Signature object per auditor.
    #[prost(message, repeated, tag = "3")]
    pub signatures: ::prost::alloc::vec::Vec<Signature>,
}
/// The signature incorporates the auditor public key so the service provides one signature per auditor.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Signature {
    #[prost(bytes = "vec", tag = "1")]
    pub auditor_public_key: ::prost::alloc::vec::Vec<u8>,
    #[prost(bytes = "vec", tag = "2")]
    pub signature: ::prost::alloc::vec::Vec<u8>,
}
/// FullAuditorTreeHead is provided to end-users when third-party auditing is used,
/// as evidence that the log is behaving honestly.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FullAuditorTreeHead {
    #[prost(message, optional, tag = "1")]
    pub tree_head: ::core::option::Option<AuditorTreeHead>,
    #[prost(bytes = "vec", optional, tag = "2")]
    pub root_value: ::core::option::Option<::prost::alloc::vec::Vec<u8>>,
    #[prost(bytes = "vec", repeated, tag = "3")]
    pub consistency: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
    #[prost(bytes = "vec", tag = "4")]
    pub public_key: ::prost::alloc::vec::Vec<u8>,
}
/// FullTreeHead wraps a basic TreeHead with additional information that may be
/// needed for validation.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FullTreeHead {
    #[prost(message, optional, tag = "1")]
    pub tree_head: ::core::option::Option<TreeHead>,
    #[prost(bytes = "vec", repeated, tag = "2")]
    pub last: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
    #[prost(bytes = "vec", repeated, tag = "3")]
    pub distinguished: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
    #[prost(message, repeated, tag = "4")]
    pub full_auditor_tree_heads: ::prost::alloc::vec::Vec<FullAuditorTreeHead>,
}
/// ProofStep is the output of one step of a binary search through the log.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ProofStep {
    #[prost(message, optional, tag = "1")]
    pub prefix: ::core::option::Option<PrefixProof>,
    #[prost(bytes = "vec", tag = "2")]
    pub commitment: ::prost::alloc::vec::Vec<u8>,
}
/// SearchProof contains the output of a binary search through the log.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SearchProof {
    #[prost(uint64, tag = "1")]
    pub pos: u64,
    #[prost(message, repeated, tag = "2")]
    pub steps: ::prost::alloc::vec::Vec<ProofStep>,
    #[prost(bytes = "vec", repeated, tag = "3")]
    pub inclusion: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
}
/// UpdateValue wraps the new value for a key with an optional signature from the
/// service provider.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UpdateValue {
    #[prost(bytes = "vec", tag = "1")]
    pub value: ::prost::alloc::vec::Vec<u8>,
}
/// Consistency specifies the parameters of the consistency proof(s) that should
/// be returned.
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Consistency {
    #[prost(uint64, optional, tag = "1")]
    pub last: ::core::option::Option<u64>,
    #[prost(uint64, optional, tag = "2")]
    pub distinguished: ::core::option::Option<u64>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CondensedTreeSearchResponse {
    /// *
    /// A proof that is combined with the original requested identifier and the VRF public key
    /// and outputs whether the proof is valid, and if so, the commitment index.
    #[prost(bytes = "vec", tag = "1")]
    pub vrf_proof: ::prost::alloc::vec::Vec<u8>,
    /// *
    /// A proof that the binary search for the given identifier was done correctly.
    #[prost(message, optional, tag = "2")]
    pub search: ::core::option::Option<SearchProof>,
    /// *
    /// A 32-byte value computed based on the log position of the identifier
    /// and a random 32 byte key that is only known by the key transparency service.
    /// It is provided so that clients can recompute and verify the commitment.
    #[prost(bytes = "vec", tag = "3")]
    pub opening: ::prost::alloc::vec::Vec<u8>,
    /// *
    /// The new or updated value that the identifier maps to.
    #[prost(message, optional, tag = "4")]
    pub value: ::core::option::Option<UpdateValue>,
}
/// UpdateRequest comes from a user that wishes to update a key.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UpdateRequest {
    #[prost(bytes = "vec", tag = "1")]
    pub search_key: ::prost::alloc::vec::Vec<u8>,
    #[prost(bytes = "vec", tag = "2")]
    pub value: ::prost::alloc::vec::Vec<u8>,
    #[prost(message, optional, tag = "3")]
    pub consistency: ::core::option::Option<Consistency>,
}
/// UpdateResponse is the output of executing an update on the tree.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UpdateResponse {
    #[prost(message, optional, tag = "1")]
    pub tree_head: ::core::option::Option<FullTreeHead>,
    #[prost(bytes = "vec", tag = "2")]
    pub vrf_proof: ::prost::alloc::vec::Vec<u8>,
    #[prost(message, optional, tag = "3")]
    pub search: ::core::option::Option<SearchProof>,
    /// optional bytes signature = 5; TODO
    #[prost(bytes = "vec", tag = "4")]
    pub opening: ::prost::alloc::vec::Vec<u8>,
}
/// MonitorKey is a single key that the user would like to monitor.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MonitorKey {
    #[prost(bytes = "vec", tag = "1")]
    pub search_key: ::prost::alloc::vec::Vec<u8>,
    /// The position of the last log entry verified by the client
    /// to be in the direct path to the identifier
    #[prost(uint64, tag = "2")]
    pub entry_position: u64,
    /// the commitment index for the search key
    #[prost(bytes = "vec", tag = "3")]
    pub commitment_index: ::prost::alloc::vec::Vec<u8>,
}
/// MonitorRequest comes from a user that wishes to monitor a set of keys.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MonitorRequest {
    #[prost(message, repeated, tag = "1")]
    pub keys: ::prost::alloc::vec::Vec<MonitorKey>,
    #[prost(message, optional, tag = "2")]
    pub consistency: ::core::option::Option<Consistency>,
}
/// MonitorProof proves that a single key has been correctly managed in the log.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MonitorProof {
    #[prost(message, repeated, tag = "1")]
    pub steps: ::prost::alloc::vec::Vec<ProofStep>,
}
/// MonitorResponse is the output of a monitoring operation.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MonitorResponse {
    #[prost(message, optional, tag = "1")]
    pub tree_head: ::core::option::Option<FullTreeHead>,
    #[prost(message, repeated, tag = "2")]
    pub proofs: ::prost::alloc::vec::Vec<MonitorProof>,
    #[prost(bytes = "vec", repeated, tag = "4")]
    pub inclusion: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
}
/// StoredTreeHead is an encoded tree head stored on-disk.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StoredTreeHead {
    #[prost(message, optional, tag = "1")]
    pub tree_head: ::core::option::Option<TreeHead>,
    #[prost(bytes = "vec", tag = "2")]
    pub root: ::prost::alloc::vec::Vec<u8>,
}
/// StoredMonitoringData is encoded monitoring data stored on-disk.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StoredMonitoringData {
    #[prost(bytes = "vec", tag = "1")]
    pub index: ::prost::alloc::vec::Vec<u8>,
    #[prost(uint64, tag = "2")]
    pub pos: u64,
    #[prost(map = "uint64, uint32", tag = "3")]
    pub ptrs: ::std::collections::HashMap<u64, u32>,
    #[prost(bool, tag = "4")]
    pub owned: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StoredAccountData {
    #[prost(message, optional, tag = "1")]
    pub aci: ::core::option::Option<StoredMonitoringData>,
    #[prost(message, optional, tag = "2")]
    pub e164: ::core::option::Option<StoredMonitoringData>,
    #[prost(message, optional, tag = "3")]
    pub username_hash: ::core::option::Option<StoredMonitoringData>,
    #[prost(message, optional, tag = "4")]
    pub last_tree_head: ::core::option::Option<StoredTreeHead>,
}
/// This message is not used in the crate, but is simply reexported for convenience.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SearchResponse {
    /// *
    /// A signed representation of the log tree's current state along with some
    /// additional information necessary for validation such as a consistency proof and an auditor-signed tree head.
    #[prost(message, optional, tag = "1")]
    pub tree_head: ::core::option::Option<FullTreeHead>,
    /// *
    /// The ACI search response is always provided.
    #[prost(message, optional, tag = "2")]
    pub aci: ::core::option::Option<CondensedTreeSearchResponse>,
    /// *
    /// This response is only provided if all of the conditions are met:
    /// - the E164 exists in the log
    /// - its mapped ACI matches the one provided in the request
    /// - the account associated with the ACI is discoverable
    /// - the unidentified access key provided in E164SearchRequest matches the one on the account
    #[prost(message, optional, tag = "3")]
    pub e164: ::core::option::Option<CondensedTreeSearchResponse>,
    /// *
    /// This response is only provided if the username hash exists in the log and
    /// its mapped ACI matches the one provided in the request.
    #[prost(message, optional, tag = "4")]
    pub username_hash: ::core::option::Option<CondensedTreeSearchResponse>,
}
/// *
/// DistinguishedResponse contains the tree head and search proof for the most
/// recent `distinguished` key in the log.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DistinguishedResponse {
    /// *
    /// A signed representation of the log tree's current state along with some
    /// additional information necessary for validation such as a consistency proof and an auditor-signed tree head.
    #[prost(message, optional, tag = "1")]
    pub tree_head: ::core::option::Option<FullTreeHead>,
    /// *
    /// This search response is always provided.
    #[prost(message, optional, tag = "2")]
    pub distinguished: ::core::option::Option<CondensedTreeSearchResponse>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ChatMonitorResponse {
    /// *
    /// A signed representation of the log tree's current state along with some
    /// additional information necessary for validation such as a consistency proof and an auditor-signed tree head.
    #[prost(message, optional, tag = "1")]
    pub tree_head: ::core::option::Option<FullTreeHead>,
    /// *
    /// A proof that the MonitorRequest's ACI continues to be constructed correctly in later entries of the log tree.
    #[prost(message, optional, tag = "2")]
    pub aci: ::core::option::Option<MonitorProof>,
    /// *
    /// A proof that the username hash continues to be constructed correctly in later entries of the log tree.
    /// Will be absent if the request did not include a UsernameHashMonitorRequest.
    #[prost(message, optional, tag = "3")]
    pub username_hash: ::core::option::Option<MonitorProof>,
    /// *
    /// A proof that the e164 continues to be constructed correctly in later entries of the log tree.
    /// Will be absent if the request did not include a E164MonitorRequest.
    #[prost(message, optional, tag = "4")]
    pub e164: ::core::option::Option<MonitorProof>,
    /// *
    /// A batch inclusion proof that the log entries involved in the binary search for each of the entries
    /// being monitored in the request are included in the current log tree.
    #[prost(bytes = "vec", repeated, tag = "5")]
    pub inclusion: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
}
