/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.signal.libsignal.internal.AsyncKt;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.net.BadRequestError;
import org.signal.libsignal.net.MultiRecipientMessageResponse;
import org.signal.libsignal.net.MultiRecipientSendAuthorization;
import org.signal.libsignal.net.MultiRecipientSendFailure;
import org.signal.libsignal.net.RequestResult;
import org.signal.libsignal.net.RequestResultKt;
import org.signal.libsignal.net.UnauthMessagesServiceKt;
import org.signal.libsignal.net.UnauthenticatedChatConnection;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J@\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/signal/libsignal/net/UnauthMessagesService;", "", "connection", "Lorg/signal/libsignal/net/UnauthenticatedChatConnection;", "<init>", "(Lorg/signal/libsignal/net/UnauthenticatedChatConnection;)V", "sendMultiRecipientMessage", "Lorg/signal/libsignal/internal/CompletableFuture;", "Lorg/signal/libsignal/net/RequestResult;", "Lorg/signal/libsignal/net/MultiRecipientMessageResponse;", "Lorg/signal/libsignal/net/MultiRecipientSendFailure;", "payload", "", "timestamp", "", "auth", "Lorg/signal/libsignal/net/MultiRecipientSendAuthorization;", "onlineOnly", "", "urgent", "libsignal-client"})
@SourceDebugExtension(value={"SMAP\nUnauthMessagesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnauthMessagesService.kt\norg/signal/libsignal/net/UnauthMessagesService\n+ 2 RequestResult.kt\norg/signal/libsignal/net/RequestResultKt\n*L\n1#1,96:1\n105#2,4:97\n*S KotlinDebug\n*F\n+ 1 UnauthMessagesService.kt\norg/signal/libsignal/net/UnauthMessagesService\n*L\n58#1:97,4\n*E\n"})
public final class UnauthMessagesService {
    @NotNull
    private final UnauthenticatedChatConnection connection;

    public UnauthMessagesService(@NotNull UnauthenticatedChatConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.connection = connection;
    }

    @NotNull
    public final CompletableFuture<RequestResult<MultiRecipientMessageResponse, MultiRecipientSendFailure>> sendMultiRecipientMessage(@NotNull byte[] payload, long timestamp, @NotNull MultiRecipientSendAuthorization auth, boolean onlineOnly, boolean urgent) {
        CompletableFuture<RequestResult<MultiRecipientMessageResponse, MultiRecipientSendFailure>> completableFuture;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        try {
            CompletableFuture completableFuture2 = this.connection.runWithContextAndConnectionHandles((arg_0, arg_1) -> UnauthMessagesService.sendMultiRecipientMessage$lambda$0(payload, timestamp, auth, onlineOnly, urgent, arg_0, arg_1));
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture2, (String)"runWithContextAndConnectionHandles(...)");
            completableFuture = AsyncKt.mapWithCancellation(completableFuture2, UnauthMessagesService::sendMultiRecipientMessage$lambda$1, UnauthMessagesService::sendMultiRecipientMessage$lambda$2);
        }
        catch (Throwable e) {
            CompletableFuture<RequestResult<MultiRecipientMessageResponse, MultiRecipientSendFailure>> completableFuture3 = CompletableFuture.completedFuture(new RequestResult.ApplicationError(e));
            Intrinsics.checkNotNull(completableFuture3);
            completableFuture = completableFuture3;
        }
        return completableFuture;
    }

    private static final CompletableFuture sendMultiRecipientMessage$lambda$0(byte[] $payload, long $timestamp, MultiRecipientSendAuthorization $auth, boolean $onlineOnly, boolean $urgent, Long asyncCtx, Long conn) {
        Intrinsics.checkNotNull((Object)asyncCtx);
        long l = asyncCtx;
        Intrinsics.checkNotNull((Object)conn);
        return Native.UnauthenticatedChatConnection_send_multi_recipient_message(l, conn, $payload, $timestamp, UnauthMessagesServiceKt.access$groupSendTokenBytesOrNull($auth), $onlineOnly, $urgent);
    }

    private static final RequestResult sendMultiRecipientMessage$lambda$1(Object[] rawUnregisteredIds) {
        Intrinsics.checkNotNullParameter((Object)rawUnregisteredIds, (String)"rawUnregisteredIds");
        return new RequestResult.Success<MultiRecipientMessageResponse>(new MultiRecipientMessageResponse((byte[][])rawUnregisteredIds));
    }

    private static final RequestResult sendMultiRecipientMessage$lambda$2(Throwable err) {
        RequestResult requestResult;
        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
        Throwable $this$toRequestResult$iv = err;
        boolean $i$f$toRequestResultTyped = false;
        if ($this$toRequestResult$iv instanceof MultiRecipientSendFailure) {
            requestResult = new RequestResult.NonSuccess<BadRequestError>((BadRequestError)((Object)$this$toRequestResult$iv));
        } else {
            RequestResult requestResult2 = RequestResultKt.toRequestResult($this$toRequestResult$iv);
            requestResult = requestResult2;
            Intrinsics.checkNotNull((Object)requestResult2, (String)"null cannot be cast to non-null type org.signal.libsignal.net.RequestResult<kotlin.Nothing, kotlin.Nothing>");
        }
        return requestResult;
    }
}

