/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.io.IOException;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.net.BadRequestError;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u0001*\n\b\u0001\u0010\u0002 \u0001*\u00020\u00032\u00020\u0004:\u0004\t\n\u000b\fJ.\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00028\u00010\u0000\"\u0004\b\u0002\u0010\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00060\bH\u0016\u0082\u0001\u0004\r\u000e\u000f\u0010\u00a8\u0006\u0011\u00c0\u0006\u0003"}, d2={"Lorg/signal/libsignal/net/RequestResult;", "T", "E", "Lorg/signal/libsignal/net/BadRequestError;", "", "map", "R", "transform", "Lkotlin/Function1;", "Success", "NonSuccess", "RetryableNetworkError", "ApplicationError", "Lorg/signal/libsignal/net/RequestResult$ApplicationError;", "Lorg/signal/libsignal/net/RequestResult$NonSuccess;", "Lorg/signal/libsignal/net/RequestResult$RetryableNetworkError;", "Lorg/signal/libsignal/net/RequestResult$Success;", "libsignal-client"})
public interface RequestResult<T, E extends BadRequestError> {
    @NotNull
    default public <R> RequestResult<R, E> map(@NotNull Function1<? super T, ? extends R> transform) {
        RequestResult requestResult;
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        RequestResult requestResult2 = this;
        if (requestResult2 instanceof Success) {
            requestResult = new Success<Object>(transform.invoke(((Success)this).getResult()));
        } else if (requestResult2 instanceof NonSuccess) {
            requestResult = this;
        } else if (requestResult2 instanceof RetryableNetworkError) {
            requestResult = this;
        } else if (requestResult2 instanceof ApplicationError) {
            requestResult = this;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return requestResult;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\t\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/signal/libsignal/net/RequestResult$ApplicationError;", "Lorg/signal/libsignal/net/RequestResult;", "", "cause", "", "<init>", "(Ljava/lang/Throwable;)V", "getCause", "()Ljava/lang/Throwable;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "libsignal-client"})
    public static final class ApplicationError
    implements RequestResult {
        @NotNull
        private final Throwable cause;

        public ApplicationError(@NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            this.cause = cause;
        }

        @NotNull
        public final Throwable getCause() {
            return this.cause;
        }

        @NotNull
        public final Throwable component1() {
            return this.cause;
        }

        @NotNull
        public final ApplicationError copy(@NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            return new ApplicationError(cause);
        }

        public static /* synthetic */ ApplicationError copy$default(ApplicationError applicationError, Throwable throwable, int n, Object object) {
            if ((n & 1) != 0) {
                throwable = applicationError.cause;
            }
            return applicationError.copy(throwable);
        }

        @NotNull
        public String toString() {
            return "ApplicationError(cause=" + this.cause + ")";
        }

        public int hashCode() {
            return this.cause.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ApplicationError)) {
                return false;
            }
            ApplicationError applicationError = (ApplicationError)other;
            return Intrinsics.areEqual((Object)this.cause, (Object)applicationError.cause);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static <T, E extends BadRequestError, R> RequestResult<R, E> map(@NotNull RequestResult<? extends T, ? extends E> $this, @NotNull Function1<? super T, ? extends R> transform) {
            Intrinsics.checkNotNullParameter(transform, (String)"transform");
            return ((RequestResult)$this).map(transform);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000b\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00028\u0002H\u00c6\u0001\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0005\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/signal/libsignal/net/RequestResult$NonSuccess;", "E", "Lorg/signal/libsignal/net/BadRequestError;", "Lorg/signal/libsignal/net/RequestResult;", "", "error", "<init>", "(Lorg/signal/libsignal/net/BadRequestError;)V", "getError", "()Lorg/signal/libsignal/net/BadRequestError;", "Lorg/signal/libsignal/net/BadRequestError;", "component1", "copy", "(Lorg/signal/libsignal/net/BadRequestError;)Lorg/signal/libsignal/net/RequestResult$NonSuccess;", "equals", "", "other", "", "hashCode", "", "toString", "", "libsignal-client"})
    public static final class NonSuccess<E extends BadRequestError>
    implements RequestResult {
        @NotNull
        private final E error;

        public NonSuccess(@NotNull E error) {
            Intrinsics.checkNotNullParameter(error, (String)"error");
            this.error = error;
        }

        @NotNull
        public final E getError() {
            return this.error;
        }

        @NotNull
        public final E component1() {
            return this.error;
        }

        @NotNull
        public final NonSuccess<E> copy(@NotNull E error) {
            Intrinsics.checkNotNullParameter(error, (String)"error");
            return new NonSuccess<E>(error);
        }

        public static /* synthetic */ NonSuccess copy$default(NonSuccess nonSuccess, BadRequestError badRequestError, int n, Object object) {
            if ((n & 1) != 0) {
                badRequestError = nonSuccess.error;
            }
            return nonSuccess.copy(badRequestError);
        }

        @NotNull
        public String toString() {
            return "NonSuccess(error=" + this.error + ")";
        }

        public int hashCode() {
            return this.error.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NonSuccess)) {
                return false;
            }
            NonSuccess nonSuccess = (NonSuccess)other;
            return Intrinsics.areEqual(this.error, nonSuccess.error);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u001f\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/signal/libsignal/net/RequestResult$RetryableNetworkError;", "Lorg/signal/libsignal/net/RequestResult;", "", "networkError", "Ljava/io/IOException;", "retryAfter", "Ljava/time/Duration;", "<init>", "(Ljava/io/IOException;Ljava/time/Duration;)V", "getNetworkError", "()Ljava/io/IOException;", "getRetryAfter", "()Ljava/time/Duration;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "libsignal-client"})
    public static final class RetryableNetworkError
    implements RequestResult {
        @NotNull
        private final IOException networkError;
        @Nullable
        private final Duration retryAfter;

        public RetryableNetworkError(@NotNull IOException networkError, @Nullable Duration retryAfter) {
            Intrinsics.checkNotNullParameter((Object)networkError, (String)"networkError");
            this.networkError = networkError;
            this.retryAfter = retryAfter;
        }

        public /* synthetic */ RetryableNetworkError(IOException iOException, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                duration = null;
            }
            this(iOException, duration);
        }

        @NotNull
        public final IOException getNetworkError() {
            return this.networkError;
        }

        @Nullable
        public final Duration getRetryAfter() {
            return this.retryAfter;
        }

        @NotNull
        public final IOException component1() {
            return this.networkError;
        }

        @Nullable
        public final Duration component2() {
            return this.retryAfter;
        }

        @NotNull
        public final RetryableNetworkError copy(@NotNull IOException networkError, @Nullable Duration retryAfter) {
            Intrinsics.checkNotNullParameter((Object)networkError, (String)"networkError");
            return new RetryableNetworkError(networkError, retryAfter);
        }

        public static /* synthetic */ RetryableNetworkError copy$default(RetryableNetworkError retryableNetworkError, IOException iOException, Duration duration, int n, Object object) {
            if ((n & 1) != 0) {
                iOException = retryableNetworkError.networkError;
            }
            if ((n & 2) != 0) {
                duration = retryableNetworkError.retryAfter;
            }
            return retryableNetworkError.copy(iOException, duration);
        }

        @NotNull
        public String toString() {
            return "RetryableNetworkError(networkError=" + this.networkError + ", retryAfter=" + this.retryAfter + ")";
        }

        public int hashCode() {
            int result = this.networkError.hashCode();
            result = result * 31 + (this.retryAfter == null ? 0 : this.retryAfter.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RetryableNetworkError)) {
                return false;
            }
            RetryableNetworkError retryableNetworkError = (RetryableNetworkError)other;
            if (!Intrinsics.areEqual((Object)this.networkError, (Object)retryableNetworkError.networkError)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.retryAfter, (Object)retryableNetworkError.retryAfter);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00028\u0002H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u0002H\u00c6\u0001\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/signal/libsignal/net/RequestResult$Success;", "T", "Lorg/signal/libsignal/net/RequestResult;", "", "result", "<init>", "(Ljava/lang/Object;)V", "getResult", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lorg/signal/libsignal/net/RequestResult$Success;", "equals", "", "other", "", "hashCode", "", "toString", "", "libsignal-client"})
    public static final class Success<T>
    implements RequestResult {
        private final T result;

        public Success(T result) {
            this.result = result;
        }

        public final T getResult() {
            return this.result;
        }

        public final T component1() {
            return this.result;
        }

        @NotNull
        public final Success<T> copy(T result) {
            return new Success<T>(result);
        }

        public static /* synthetic */ Success copy$default(Success success, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = success.result;
            }
            return success.copy(object);
        }

        @NotNull
        public String toString() {
            return "Success(result=" + this.result + ")";
        }

        public int hashCode() {
            return this.result == null ? 0 : this.result.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Success)) {
                return false;
            }
            Success success = (Success)other;
            return Intrinsics.areEqual(this.result, success.result);
        }
    }
}

