/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.lang.ref.WeakReference;
import kotlin.Pair;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.internal.NativeTesting;
import org.signal.libsignal.internal.TokioAsyncContext;
import org.signal.libsignal.net.ChatConnectionListener;
import org.signal.libsignal.net.ChatServiceException;
import org.signal.libsignal.net.FakeChatRemote;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.net.ProvisioningConnectionListener;
import org.signal.libsignal.net.internal.BridgeProvisioningListener;

public class ProvisioningConnection
extends NativeHandleGuard.SimpleOwner {
    private final TokioAsyncContext tokioAsyncContext;
    private final ProvisioningConnectionListener listener;

    protected ProvisioningConnection(TokioAsyncContext tokioAsyncContext, long nativeHandle, ProvisioningConnectionListener listener) {
        super(nativeHandle);
        this.tokioAsyncContext = tokioAsyncContext;
        this.listener = listener;
    }

    static CompletableFuture<ProvisioningConnection> connect(TokioAsyncContext tokioAsyncContext, Network.ConnectionManager connectionManager, ProvisioningConnectionListener listener) {
        return tokioAsyncContext.guardedMap(asyncContextHandle -> connectionManager.guardedMap(connectionManagerHandle -> Native.ProvisioningChatConnection_connect(asyncContextHandle, connectionManagerHandle).makeCancelable(tokioAsyncContext).thenApply(nativeHandle -> new ProvisioningConnection(tokioAsyncContext, (long)nativeHandle, listener))));
    }

    public static Pair<ProvisioningConnection, FakeChatRemote> fakeConnect(TokioAsyncContext tokioAsyncContext, ProvisioningConnectionListener listener) {
        return tokioAsyncContext.guardedMap(asyncContextHandle -> {
            SetChatLaterListenerBridge bridgeListener = new SetChatLaterListenerBridge();
            long fakeChatConnection = NativeTesting.TESTING_FakeChatConnection_CreateProvisioning(asyncContextHandle, bridgeListener);
            ProvisioningConnection chat = new ProvisioningConnection(tokioAsyncContext, NativeTesting.TESTING_FakeChatConnection_TakeProvisioningChat(fakeChatConnection), listener);
            bridgeListener.setChat(chat);
            FakeChatRemote fakeRemote = new FakeChatRemote(tokioAsyncContext, NativeTesting.TESTING_FakeChatConnection_TakeRemote(fakeChatConnection));
            NativeTesting.FakeChatConnection_Destroy(fakeChatConnection);
            return new Pair((Object)chat, (Object)fakeRemote);
        });
    }

    public void start() {
        ListenerBridge bridgedListener = new ListenerBridge(this);
        this.guardedRun(nativeChatConnectionHandle -> Native.ProvisioningChatConnection_init_listener(nativeChatConnectionHandle, bridgedListener));
    }

    public CompletableFuture<Void> disconnect() {
        return this.tokioAsyncContext.guardedMap(asyncContextHandle -> this.guardedMap(chatConnectionHandle -> Native.ProvisioningChatConnection_disconnect(asyncContextHandle, chatConnectionHandle)));
    }

    @Override
    protected void release(long nativeChatConnectionHandle) {
        Native.ProvisioningChatConnection_Destroy(nativeChatConnectionHandle);
    }

    protected static class ListenerBridge
    implements BridgeProvisioningListener {
        protected WeakReference<ProvisioningConnection> connection;

        protected ListenerBridge(ProvisioningConnection connection) {
            this.connection = new WeakReference<ProvisioningConnection>(connection);
        }

        @Override
        public void receivedAddress(String address, long sendAckHandle) {
            ChatConnectionListener.ServerMessageAck ack = new ChatConnectionListener.ServerMessageAck(sendAckHandle);
            ProvisioningConnection connection = (ProvisioningConnection)this.connection.get();
            if (connection == null) {
                return;
            }
            if (connection.listener == null) {
                return;
            }
            connection.listener.onReceivedAddress(connection, address, ack);
        }

        @Override
        public void receivedEnvelope(byte[] envelope, long sendAckHandle) {
            ChatConnectionListener.ServerMessageAck ack = new ChatConnectionListener.ServerMessageAck(sendAckHandle);
            ProvisioningConnection connection = (ProvisioningConnection)this.connection.get();
            if (connection == null) {
                return;
            }
            if (connection.listener == null) {
                return;
            }
            connection.listener.onReceivedEnvelope(connection, envelope, ack);
        }

        @Override
        public void connectionInterrupted(Throwable disconnectReason) {
            ProvisioningConnection connection = (ProvisioningConnection)this.connection.get();
            if (connection == null) {
                return;
            }
            if (connection.listener == null) {
                return;
            }
            ChatServiceException disconnectReasonChatServiceException = disconnectReason == null ? null : (disconnectReason instanceof ChatServiceException ? (ChatServiceException)disconnectReason : new ChatServiceException("OtherDisconnectReason", disconnectReason));
            connection.listener.onConnectionInterrupted(connection, disconnectReasonChatServiceException);
        }
    }

    protected static final class SetChatLaterListenerBridge
    extends ListenerBridge {
        SetChatLaterListenerBridge() {
            super(null);
        }

        void setChat(ProvisioningConnection connection) {
            this.connection = new WeakReference<ProvisioningConnection>(connection);
        }
    }
}

