/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.signal.libsignal.internal.BridgedStringMap;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.internal.TokioAsyncContext;
import org.signal.libsignal.net.AuthenticatedChatConnection;
import org.signal.libsignal.net.CdsiLookup;
import org.signal.libsignal.net.CdsiLookupRequest;
import org.signal.libsignal.net.CdsiLookupResponse;
import org.signal.libsignal.net.ChatConnectionListener;
import org.signal.libsignal.net.ProvisioningConnection;
import org.signal.libsignal.net.ProvisioningConnectionListener;
import org.signal.libsignal.net.SvrB;
import org.signal.libsignal.net.UnauthenticatedChatConnection;
import org.signal.libsignal.net.internal.ConnectChatBridge;

public class Network {
    public static final String SIGNAL_TLS_PROXY_SCHEME = "org.signal.tls";
    private final TokioAsyncContext tokioAsyncContext = new TokioAsyncContext();
    private final ConnectionManager connectionManager;

    @Deprecated
    public Network(Environment env, String userAgent) {
        this(env, userAgent, Collections.emptyMap(), BuildVariant.PRODUCTION);
    }

    @Deprecated
    public Network(Environment env, String userAgent, Map<String, String> remoteConfig) {
        this(env, userAgent, remoteConfig, BuildVariant.PRODUCTION);
    }

    public Network(Environment env, String userAgent, Map<String, String> remoteConfig, BuildVariant buildVariant) {
        this.connectionManager = new ConnectionManager(env, userAgent, remoteConfig, buildVariant);
    }

    public SvrB svrB(String username, String password) {
        return new SvrB(this, username, password);
    }

    public void setProxy(String scheme, String host, Integer port, String username, String password) throws IOException {
        this.connectionManager.setProxy(scheme, host, port, username, password);
    }

    public void setProxy(String host, int port) throws IOException {
        int atIndex = host.indexOf(64);
        String username = null;
        if (atIndex != -1) {
            username = host.substring(0, atIndex);
            host = host.substring(atIndex + 1);
        }
        this.connectionManager.setProxy(SIGNAL_TLS_PROXY_SCHEME, host, port, username, null);
    }

    public void setInvalidProxy() {
        this.connectionManager.setInvalidProxy();
    }

    public void clearProxy() {
        this.connectionManager.clearProxy();
    }

    public void setCensorshipCircumventionEnabled(boolean enabled) {
        this.connectionManager.setCensorshipCircumventionEnabled(enabled);
    }

    public void setRemoteConfig(Map<String, String> remoteConfig, BuildVariant buildVariant) {
        this.connectionManager.setRemoteConfig(remoteConfig, buildVariant);
    }

    @Deprecated
    public void setRemoteConfig(Map<String, String> remoteConfig) {
        this.setRemoteConfig(remoteConfig, BuildVariant.PRODUCTION);
    }

    public void onNetworkChange() {
        this.connectionManager.guardedRun(Native::ConnectionManager_on_network_change);
    }

    public CompletableFuture<CdsiLookupResponse> cdsiLookup(String username, String password, CdsiLookupRequest request, Consumer<byte[]> tokenConsumer) throws IOException, InterruptedException, ExecutionException {
        return CdsiLookup.start(this, username, password, request).thenCompose(lookup -> {
            tokenConsumer.accept(lookup.getToken());
            return lookup.complete();
        });
    }

    public static void checkClassesCanBeLoadedAsyncForTest() {
        String[] classesToLoad = new String[]{"org.signal.libsignal.net.CdsiLookupResponse$Entry", "org.signal.libsignal.net.NetworkException", "org.signal.libsignal.net.ChatServiceException", "org.signal.libsignal.protocol.ServiceId"};
        TokioAsyncContext context = new TokioAsyncContext();
        for (String className : classesToLoad) {
            try {
                context.loadClassAsync(className).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    TokioAsyncContext getAsyncContext() {
        return this.tokioAsyncContext;
    }

    ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public CompletableFuture<Void> preconnectChat() {
        return this.tokioAsyncContext.guardedMap(asyncContext -> this.connectionManager.guardedMap(connectionManager -> Native.AuthenticatedChatConnection_preconnect(asyncContext, connectionManager)));
    }

    public CompletableFuture<UnauthenticatedChatConnection> connectUnauthChat(Locale locale, ChatConnectionListener listener) {
        return UnauthenticatedChatConnection.connect(this.tokioAsyncContext, this.connectionManager, locale, listener);
    }

    public CompletableFuture<UnauthenticatedChatConnection> connectUnauthChat(ChatConnectionListener listener) {
        return this.connectUnauthChat(null, listener);
    }

    public CompletableFuture<AuthenticatedChatConnection> connectAuthChat(String username, String password, boolean receiveStories, Locale locale, ChatConnectionListener listener) {
        return AuthenticatedChatConnection.connect(this.tokioAsyncContext, this.connectionManager, username, password, receiveStories, locale, listener);
    }

    public CompletableFuture<AuthenticatedChatConnection> connectAuthChat(String username, String password, boolean receiveStories, ChatConnectionListener listener) {
        return this.connectAuthChat(username, password, receiveStories, null, listener);
    }

    static String[] languageCodesForLocale(Locale locale) {
        String[] stringArray;
        if (locale == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = locale.getLanguage() + "-" + locale.getCountry();
        }
        return stringArray;
    }

    public CompletableFuture<ProvisioningConnection> connectProvisioning(ProvisioningConnectionListener listener) {
        return ProvisioningConnection.connect(this.tokioAsyncContext, this.connectionManager, listener);
    }

    public static enum BuildVariant {
        PRODUCTION(0),
        BETA(1);

        final int value;

        private BuildVariant(int value) {
            this.value = value;
        }
    }

    public static enum Environment {
        STAGING(0),
        PRODUCTION(1);

        final int value;

        private Environment(int value) {
            this.value = value;
        }
    }

    static class ConnectionManager
    extends NativeHandleGuard.SimpleOwner
    implements ConnectChatBridge {
        private final Environment environment;

        private ConnectionManager(Environment env, String userAgent, Map<String, String> remoteConfig, BuildVariant buildVariant) {
            super(new BridgedStringMap(remoteConfig).guardedMap(map -> Native.ConnectionManager_new(env.value, userAgent, map, buildVariant.value)));
            this.environment = env;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setProxy(String scheme, String host, Integer port, String username, String password) throws IOException {
            long rawProxyConfig;
            try {
                rawProxyConfig = FilterExceptions.filterExceptions(IOException.class, () -> Native.ConnectionProxyConfig_new(scheme, host, port != null ? port : Integer.MIN_VALUE, username, password));
            }
            catch (IOException | Error | RuntimeException e) {
                this.setInvalidProxy();
                throw e;
            }
            try {
                this.guardedRun(h -> Native.ConnectionManager_set_proxy(h, rawProxyConfig));
            }
            finally {
                Native.ConnectionProxyConfig_Destroy(rawProxyConfig);
            }
        }

        private void setInvalidProxy() {
            this.guardedRun(Native::ConnectionManager_set_invalid_proxy);
        }

        private void clearProxy() {
            this.guardedRun(Native::ConnectionManager_clear_proxy);
        }

        public Environment environment() {
            return this.environment;
        }

        private void setCensorshipCircumventionEnabled(boolean enabled) {
            this.guardedRun(h -> Native.ConnectionManager_set_censorship_circumvention_enabled(h, enabled));
        }

        private void setRemoteConfig(Map<String, String> remoteConfig, BuildVariant buildVariant) {
            new BridgedStringMap(remoteConfig).guardedRun(map -> this.guardedRun(h -> Native.ConnectionManager_set_remote_config(h, map, buildVariant.value)));
        }

        @Override
        public long getConnectionManagerUnsafeNativeHandle() {
            return this.unsafeNativeHandleWithoutGuard();
        }

        @Override
        protected void release(long nativeHandle) {
            Native.ConnectionManager_Destroy(nativeHandle);
        }
    }
}

